/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.resource;

import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.common.IIterationPlanRecordHandle;
import com.ibm.team.apt.common.IPlanReferences;
import com.ibm.team.apt.internal.client.IPlanReferenceListener;
import com.ibm.team.apt.internal.client.IterationPlanDataListener;
import com.ibm.team.links.client.ILinkManager;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.ILinkCollection;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.factory.IReferenceFactory;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.links.common.registry.ILinkTypeRegistry;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;

public class PlanReferences
implements IPlanReferences {
    private final IIterationPlanRecordHandle fPlan;
    private final ILinkManager fLinkManager;
    private Collection<ILinkType> fLinkTypes;
    private Map<ILinkType, List<IReference>> fLoadedReferences;
    private Map<ILinkType, List<IReference>> fAddedReferences;
    private Map<ILinkType, List<IReference>> fRemovedReferences;
    private final ListenerList fPlanReferenceListeners;
    private IterationPlanDataListener fPlanDataListener;
    private boolean fDirty = false;

    public PlanReferences(IIterationPlanRecordHandle plan, ILinkCollection existingLinks, ILinkManager linkManager) {
        this.fPlan = plan;
        this.fLinkManager = linkManager;
        this.fLoadedReferences = new HashMap<ILinkType, List<IReference>>();
        this.fAddedReferences = new HashMap<ILinkType, List<IReference>>();
        this.fRemovedReferences = new HashMap<ILinkType, List<IReference>>();
        this.fPlanReferenceListeners = new ListenerList();
        this.resolveReferences(existingLinks);
    }

    public Collection<ILinkType> getLinkTypes() {
        if (this.fLinkTypes == null) {
            this.loadLinkTypes();
        }
        return Collections.unmodifiableCollection(this.fLinkTypes);
    }

    public Collection<IReference> getReferences(ILinkType linkType) {
        if (this.hasReferences(linkType)) {
            List<Object> returnedReferences = new ArrayList();
            List<IReference> references = this.fLoadedReferences.get(linkType);
            if (references == null) {
                returnedReferences = this.fAddedReferences.get(linkType);
            } else {
                for (IReference reference : references) {
                    if (this.hasReferenceInMap(this.fRemovedReferences, linkType, reference)) continue;
                    returnedReferences.add(reference);
                }
                List<IReference> addedReferences = this.fAddedReferences.get(linkType);
                if (addedReferences != null) {
                    returnedReferences.addAll(addedReferences);
                }
            }
            return Collections.unmodifiableCollection(returnedReferences);
        }
        return Collections.emptyList();
    }

    public boolean hasReferences(ILinkType linkType) {
        boolean hasReferences = this.fAddedReferences.containsKey(linkType);
        if (!hasReferences && this.fLoadedReferences.containsKey(linkType)) {
            hasReferences = this.fRemovedReferences.containsKey(linkType) ? this.fLoadedReferences.get(linkType).size() > this.fRemovedReferences.get(linkType).size() : true;
        }
        return hasReferences;
    }

    public void addReference(ILinkType linkType, IReference reference) throws TeamRepositoryException {
        if (this.hasReferenceInMap(this.fLoadedReferences, linkType, reference)) {
            if (this.hasReferenceInMap(this.fRemovedReferences, linkType, reference)) {
                List<IReference> references = this.fRemovedReferences.get(linkType);
                for (IReference existingRef : references) {
                    if (!this.isEqualReference(existingRef, reference)) continue;
                    reference = existingRef;
                    break;
                }
                this.removeReferenceFromMap(this.fRemovedReferences, linkType, reference);
                this.firePlanReferenceListeners(true, linkType, reference);
                this.invokeStateChange();
            }
        } else {
            IItemReference sourceReference = IReferenceFactory.INSTANCE.createReferenceToItem((IItemHandle)this.fPlan);
            ILink link = this.fLinkManager.createLink(linkType.getLinkTypeId(), (IReference)sourceReference, reference);
            reference = link.getTargetRef();
            this.addReferenceToMap(this.fAddedReferences, linkType, reference);
            this.firePlanReferenceListeners(true, linkType, reference);
            this.invokeStateChange();
        }
    }

    public boolean removeReference(ILinkType linkType, IReference reference) {
        boolean hasReference = this.hasReferenceInMap(this.fLoadedReferences, linkType, reference);
        if (hasReference) {
            this.addReferenceToMap(this.fRemovedReferences, linkType, reference);
            this.firePlanReferenceListeners(false, linkType, reference);
            this.invokeStateChange();
        } else if (this.removeReferenceFromMap(this.fAddedReferences, linkType, reference)) {
            this.firePlanReferenceListeners(false, linkType, reference);
            this.invokeStateChange();
        }
        return hasReference;
    }

    public Collection<IReference> getAddedReferences() {
        if (!this.fAddedReferences.isEmpty()) {
            ArrayList addedReferences = new ArrayList();
            for (Map.Entry<ILinkType, List<IReference>> entry : this.fAddedReferences.entrySet()) {
                addedReferences.addAll(entry.getValue());
            }
            return Collections.unmodifiableCollection(addedReferences);
        }
        return Collections.emptyList();
    }

    public Collection<IReference> getRemovedReferences() {
        if (!this.fRemovedReferences.isEmpty()) {
            ArrayList removedReferences = new ArrayList();
            for (Map.Entry<ILinkType, List<IReference>> entry : this.fRemovedReferences.entrySet()) {
                removedReferences.addAll(entry.getValue());
            }
            return Collections.unmodifiableCollection(removedReferences);
        }
        return Collections.emptyList();
    }

    public Collection<ILink> getAddedLinks() {
        return this.getLinksFrom(this.getAddedReferences());
    }

    public Collection<ILink> getRemovedLinks() {
        return this.getLinksFrom(this.getRemovedReferences());
    }

    public void addListener(Object listener) {
        if (listener instanceof IterationPlanDataListener) {
            this.fPlanDataListener = (IterationPlanDataListener)listener;
        } else {
            this.fPlanReferenceListeners.add(listener);
        }
    }

    public boolean isDirty() {
        this.fDirty = !this.fAddedReferences.isEmpty() || !this.fRemovedReferences.isEmpty();
        return this.fDirty;
    }

    public void revert() {
        List references;
        ILinkType linkType;
        HashMap<ILinkType, List<IReference>> tempAddedRefMap = new HashMap<ILinkType, List<IReference>>();
        HashMap<ILinkType, List<IReference>> tempRemovedRefMap = new HashMap<ILinkType, List<IReference>>();
        tempAddedRefMap.putAll(this.fAddedReferences);
        tempRemovedRefMap.putAll(this.fRemovedReferences);
        this.fAddedReferences.clear();
        this.fRemovedReferences.clear();
        for (Map.Entry entry : tempAddedRefMap.entrySet()) {
            linkType = (ILinkType)entry.getKey();
            references = (List)entry.getValue();
            this.firePlanReferenceListeners(false, linkType, references.toArray(new IReference[references.size()]));
        }
        for (Map.Entry entry : tempRemovedRefMap.entrySet()) {
            linkType = (ILinkType)entry.getKey();
            references = (List)entry.getValue();
            this.firePlanReferenceListeners(true, linkType, references.toArray(new IReference[references.size()]));
        }
        this.invokeStateChange();
    }

    public void update() {
        for (Map.Entry<ILinkType, List<IReference>> entry : this.fRemovedReferences.entrySet()) {
            ILinkType linkType = entry.getKey();
            List<IReference> references = entry.getValue();
            for (IReference reference : references) {
                this.removeReferenceFromMap(this.fLoadedReferences, linkType, reference);
            }
        }
        this.fLoadedReferences.putAll(this.fAddedReferences);
        this.fAddedReferences.clear();
        this.fRemovedReferences.clear();
        this.invokeStateChange();
    }

    private void resolveReferences(ILinkCollection links) {
        for (ILink link : links) {
            if (!ILinkTypeRegistry.INSTANCE.isRegistered(link.getLinkTypeId())) continue;
            ILinkType linkType = link.getLinkType();
            List<IReference> references = this.fLoadedReferences.get(linkType);
            if (references == null) {
                references = new ArrayList<IReference>();
                this.fLoadedReferences.put(linkType, references);
            }
            references.add(link.getTargetRef());
        }
    }

    private void loadLinkTypes() {
        Collection linkTypes = ILinkTypeRegistry.INSTANCE.allEntries();
        this.fLinkTypes = new ArrayList<ILinkType>();
        for (ILinkType linkType : linkTypes) {
            IEndPointDescriptor source = linkType.getSourceEndPointDescriptor();
            if (!IIterationPlanRecord.ITEM_TYPE.equals(source.getReferencedItemType())) continue;
            this.fLinkTypes.add(linkType);
        }
    }

    private void addReferenceToMap(Map<ILinkType, List<IReference>> map, ILinkType linkType, IReference reference) {
        List<IReference> referenceList = map.get(linkType);
        if (referenceList == null) {
            referenceList = new ArrayList<IReference>();
            map.put(linkType, referenceList);
        }
        referenceList.add(reference);
    }

    private boolean hasReferenceInMap(Map<ILinkType, List<IReference>> map, ILinkType linkType, IReference reference) {
        List<IReference> referenceList = map.get(linkType);
        if (referenceList != null) {
            for (IReference curReference : referenceList) {
                if (!this.isEqualReference(curReference, reference)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean removeReferenceFromMap(Map<ILinkType, List<IReference>> map, ILinkType linkType, IReference reference) {
        if (this.hasReferenceInMap(map, linkType, reference)) {
            List<IReference> referenceList = map.get(linkType);
            referenceList.remove(reference);
            if (referenceList.isEmpty()) {
                map.remove(linkType);
            }
            return true;
        }
        return false;
    }

    private boolean isEqualReference(IReference reference1, IReference reference2) {
        return reference1.sameDetailsExcludingCommentAs(reference2) && this.safeEquals(reference1.getComment(), reference2.getComment());
    }

    private boolean safeEquals(String left, String right) {
        if (left == right) {
            return true;
        }
        return left != null && right != null && left.equals(right);
    }

    private Collection<ILink> getLinksFrom(Collection<IReference> references) {
        if (!references.isEmpty()) {
            ArrayList<ILink> links = new ArrayList<ILink>();
            Iterator<IReference> iterator = references.iterator();
            while (iterator.hasNext()) {
                links.add(iterator.next().getLink());
            }
            return Collections.unmodifiableCollection(links);
        }
        return Collections.emptyList();
    }

    private void firePlanReferenceListeners(boolean isAdd, ILinkType linkType, IReference ... targetReference) {
        Object[] objectArray = this.fPlanReferenceListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            if (isAdd) {
                ((IPlanReferenceListener)listener).referencesAdded(linkType, targetReference);
            } else {
                ((IPlanReferenceListener)listener).referencesRemoved(linkType, targetReference);
            }
            ++n2;
        }
    }

    private void invokeStateChange() {
        boolean oldValue = this.fDirty;
        boolean bl = this.fDirty = !this.fAddedReferences.isEmpty() || !this.fRemovedReferences.isEmpty();
        if (this.fPlanDataListener != null) {
            this.fPlanDataListener.dirtyStateChanged(oldValue, this.fDirty);
        }
    }
}

