/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.progress;

import com.ibm.team.apt.api.common.planning.IProgressInformation;
import com.ibm.team.apt.internal.common.rcp.dto.DTO_IterationPlanProgress2;
import com.ibm.team.apt.internal.common.rcp.dto.DTO_WorkItemProgress;
import com.ibm.team.rtc.common.scriptengine.IScriptEnvironment;
import com.ibm.team.rtc.common.scriptengine.ScriptUtilities;

public final class ProgressClient {
    public static IProgressInformation convert(DTO_IterationPlanProgress2 from, IScriptEnvironment environment) {
        IProgressInformation to = (IProgressInformation)ScriptUtilities.newInstance((IScriptEnvironment)environment, IProgressInformation.class, (String)"com.ibm.team.apt.shared.client.internal.progress.ProgressInformation", (Object[])new Object[0]);
        to.deltaCloseCount(from.getCloseCount());
        to.deltaOpenCount(from.getOpenCount());
        to.deltaEstimateCount(IProgressInformation.Unit.TIME, from.getEstimatedCount());
        to.deltaStepsDone(IProgressInformation.Unit.TIME, from.getWorkHoursDone());
        to.deltaStepsLeft(IProgressInformation.Unit.TIME, from.getWorkHoursLeft());
        to.deltaEstimateCount(IProgressInformation.Unit.COMPLEXITY, from.getComplexityUnitsEstimatedCount());
        to.deltaStepsDone(IProgressInformation.Unit.COMPLEXITY, from.getComplexityUnitsDone());
        to.deltaStepsLeft(IProgressInformation.Unit.COMPLEXITY, from.getComplexityUnitsLeft());
        to.deltaRealTimeDone(from.getRealTimeDone());
        to.deltaRealTimeLeft(from.getRealTimeLeft());
        return to;
    }

    public static IProgressInformation convert(DTO_WorkItemProgress from, IScriptEnvironment environment) {
        IProgressInformation to = (IProgressInformation)ScriptUtilities.newInstance((IScriptEnvironment)environment, IProgressInformation.class, (String)"com.ibm.team.apt.shared.client.internal.progress.ProgressInformation", (Object[])new Object[0]);
        to.deltaCloseCount(from.getCloseCount());
        to.deltaOpenCount(from.getOpenCount());
        to.deltaEstimateCount(IProgressInformation.Unit.TIME, from.getEstimatedCount());
        to.deltaStepsDone(IProgressInformation.Unit.TIME, from.getWorkHoursDone());
        to.deltaStepsLeft(IProgressInformation.Unit.TIME, from.getWorkHoursLeft());
        to.deltaEstimateCount(IProgressInformation.Unit.COMPLEXITY, from.getComplexityUnitsEstimatedCount());
        to.deltaStepsDone(IProgressInformation.Unit.COMPLEXITY, from.getComplexityUnitsDone());
        to.deltaStepsLeft(IProgressInformation.Unit.COMPLEXITY, from.getComplexityUnitsLeft());
        return to;
    }

    public static void delta(IProgressInformation receiver, IProgressInformation delta) {
        ProgressClient.addSubract(true, receiver, delta);
    }

    public static void add(IProgressInformation receiver, IProgressInformation delta) {
        ProgressClient.addSubract(true, receiver, delta);
    }

    public static void subtract(IProgressInformation receiver, IProgressInformation delta) {
        ProgressClient.addSubract(false, receiver, delta);
    }

    private static void addSubract(boolean add, IProgressInformation receiver, IProgressInformation delta) {
        receiver.deltaOpenCount(delta.getOpenCount() * (add ? 1 : -1));
        receiver.deltaCloseCount(delta.getCloseCount() * (add ? 1 : -1));
        receiver.deltaEstimateCount(IProgressInformation.Unit.TIME, delta.getEstimatedCount(IProgressInformation.Unit.TIME) * (add ? 1 : -1));
        receiver.deltaStepsDone(IProgressInformation.Unit.TIME, delta.getStepsDone(IProgressInformation.Unit.TIME) * (long)(add ? 1 : -1));
        receiver.deltaStepsLeft(IProgressInformation.Unit.TIME, delta.getStepsLeft(IProgressInformation.Unit.TIME) * (long)(add ? 1 : -1));
        receiver.deltaEstimateCount(IProgressInformation.Unit.COMPLEXITY, delta.getEstimatedCount(IProgressInformation.Unit.COMPLEXITY) * (add ? 1 : -1));
        receiver.deltaStepsDone(IProgressInformation.Unit.COMPLEXITY, delta.getStepsDone(IProgressInformation.Unit.COMPLEXITY) * (long)(add ? 1 : -1));
        receiver.deltaStepsLeft(IProgressInformation.Unit.COMPLEXITY, delta.getStepsLeft(IProgressInformation.Unit.COMPLEXITY) * (long)(add ? 1 : -1));
        receiver.deltaRealTimeLeft(delta.getRealTimeLeft() * (long)(add || delta.getRealTimeLeft() == -1L ? 1 : -1));
        receiver.deltaRealTimeDone(delta.getRealTimeDone() * (long)(add || delta.getRealTimeDone() == -1L ? 1 : -1));
    }
}

