/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.planchecker;

import com.ibm.team.apt.internal.client.IPlanElementDelta;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.client.planchecker.Messages;
import com.ibm.team.apt.internal.client.planchecker.PlanCheck;
import com.ibm.team.apt.internal.client.planchecker.PlanCheckReport;
import com.ibm.team.apt.internal.client.planchecker.PlanItemPlanCheckReport;
import com.ibm.team.apt.internal.client.planchecker.Problem;
import com.ibm.team.apt.internal.common.JSUtils;
import com.ibm.team.apt.internal.common.plantype.IPlanCheckDescription;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.common.scriptengine.IScriptEnvironment;
import com.ibm.team.rtc.common.scriptengine.IScriptRunnable;
import com.ibm.team.rtc.common.scriptengine.environment.WrappedScriptEnvironment;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class ScriptablePlanCheck
extends PlanCheck {
    private static final String CONTINUE_REQUEST = "__continue";
    private final IScriptEnvironment fScriptEnvironment;
    private Scriptable fTarget;
    private ResolvedPlan fPlan;

    public ScriptablePlanCheck(IPlanCheckDescription planCheckDescription, IScriptEnvironment scriptEnvironment) {
        super(planCheckDescription);
        this.fScriptEnvironment = new WrappedScriptEnvironment(scriptEnvironment);
    }

    @Override
    public void initialize(final ResolvedPlan plan, IProgressMonitor monitor) {
        this.fPlan = plan;
        try {
            this.fTarget = (Scriptable)this.fScriptEnvironment.execute((IScriptRunnable)new IScriptRunnable<Scriptable, RuntimeException>(){

                public Scriptable run(Context cx, Scriptable scope) throws RuntimeException {
                    IPlanCheckDescription checkDescription = ScriptablePlanCheck.this.getCheckDescription();
                    Scriptable result = JSUtils.create((IScriptEnvironment)ScriptablePlanCheck.this.fScriptEnvironment, (String)checkDescription.getImplementationName(), (Object[])new Object[]{checkDescription, plan});
                    JSUtils.callMethod((IScriptEnvironment)ScriptablePlanCheck.this.fScriptEnvironment, (Context)cx, (Scriptable)result, (String)"initialize", (Object[])new Object[]{plan});
                    return result;
                }
            });
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void dispose() {
        this.fScriptEnvironment.execute((IScriptRunnable)new IScriptRunnable<Void, RuntimeException>(){

            public Void run(Context cx, Scriptable scope) throws RuntimeException {
                JSUtils.callMethod((IScriptEnvironment)ScriptablePlanCheck.this.fScriptEnvironment, (Context)cx, (Scriptable)ScriptablePlanCheck.this.fTarget, (String)"dispose", (Object[])new Object[0]);
                return null;
            }
        });
    }

    @Override
    public void runFullCheck(final PlanCheckReport report, final IProgressMonitor monitor) throws TeamRepositoryException {
        this.fScriptEnvironment.execute((IScriptRunnable)new IScriptRunnable<Void, RuntimeException>(){

            public Void run(Context cx, Scriptable scope) throws RuntimeException {
                try {
                    Object[] toCheck = (Object[])JSUtils.callMethod((IScriptEnvironment)ScriptablePlanCheck.this.fScriptEnvironment, (Context)cx, (Scriptable)ScriptablePlanCheck.this.fTarget, Object[].class, (String)"getFullCheckElements", (Object[])new Object[0]);
                    ScriptablePlanCheck.this.runCheck(cx, scope, report, toCheck, monitor);
                    return null;
                }
                finally {
                    monitor.done();
                }
            }
        });
    }

    @Override
    public void runDeltaCheck(final PlanCheckReport report, final IPlanElementDelta delta, final IProgressMonitor monitor) throws TeamRepositoryException {
        this.fScriptEnvironment.execute((IScriptRunnable)new IScriptRunnable<Void, RuntimeException>(){

            public Void run(Context cx, Scriptable scope) throws RuntimeException {
                try {
                    Object[] toCheck = (Object[])JSUtils.callMethod((IScriptEnvironment)ScriptablePlanCheck.this.fScriptEnvironment, (Context)cx, (Scriptable)ScriptablePlanCheck.this.fTarget, Object[].class, (String)"getDeltaCheckElements", (Object[])new Object[]{delta});
                    ScriptablePlanCheck.this.runCheck(cx, scope, report, toCheck, monitor);
                    return null;
                }
                finally {
                    monitor.done();
                }
            }
        });
    }

    @Override
    public void runElementCheck(final PlanCheckReport report, final Collection<? extends PlanElement> elementsToCheck, final IProgressMonitor monitor) throws TeamRepositoryException {
        this.fScriptEnvironment.execute((IScriptRunnable)new IScriptRunnable<Void, RuntimeException>(){

            public Void run(Context cx, Scriptable scope) throws RuntimeException {
                try {
                    Object[] toCheck = (Object[])JSUtils.callMethod((IScriptEnvironment)ScriptablePlanCheck.this.fScriptEnvironment, (Context)cx, (Scriptable)ScriptablePlanCheck.this.fTarget, Object[].class, (String)"getCheckElements", (Object[])new Object[]{elementsToCheck.toArray(new PlanElement[elementsToCheck.size()])});
                    ScriptablePlanCheck.this.runCheck(cx, scope, report, toCheck, monitor);
                    return null;
                }
                finally {
                    monitor.done();
                }
            }
        });
    }

    private void runCheck(Context cx, Scriptable scope, PlanCheckReport report, Object[] toCheck, IProgressMonitor monitor) {
        if (!this.isEnabled()) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ScriptablePlanCheck_CHECKING_WORKITEM, (int)toCheck.length);
        this.fireStateChange(this, PlanCheck.State.Running);
        try {
            Object[] objectArray = toCheck;
            int n = toCheck.length;
            int n2 = 0;
            while (n2 < n) {
                Object runner;
                PlanItemPlanCheckReport itemReport;
                Object checkElement = objectArray[n2];
                if (monitor.isCanceled()) {
                    break;
                }
                if (checkElement instanceof PlanItem && (itemReport = report.getReport((PlanItem)checkElement)) != null) {
                    itemReport.clearProblems(this.getProblemIds());
                }
                if ((runner = JSUtils.callMethod((IScriptEnvironment)this.fScriptEnvironment, (Context)cx, (Scriptable)this.fTarget, Scriptable.class, (String)"checkElement", (Object[])new Object[]{checkElement, subMonitor.newChild(1)})) instanceof Scriptable) {
                    Problem[] problems;
                    while (CONTINUE_REQUEST.equals(JSUtils.callMethod((IScriptEnvironment)this.fScriptEnvironment, (Context)cx, (Scriptable)((Scriptable)runner), String.class, (String)"execute", (Object[])new Object[0]))) {
                        if (monitor.isCanceled()) break;
                    }
                    if ((problems = (Problem[])JSUtils.callMethod((IScriptEnvironment)this.fScriptEnvironment, (Context)cx, (Scriptable)((Scriptable)runner), Problem[].class, (String)"getResult", (Object[])new Object[0])) != null) {
                        Problem[] problemArray = problems;
                        int n3 = problems.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Problem problem = problemArray[n4];
                            Assert.isTrue((checkElement == problem.getPlanElement() ? 1 : 0) != 0, (String)"PlanChecker generated problems for different element");
                            if (checkElement instanceof PlanItem) {
                                PlanItemPlanCheckReport itemReport2 = report.createReport((PlanItem)checkElement);
                                itemReport2.addProblem(problem);
                            }
                            ++n4;
                        }
                    }
                }
                ++n2;
            }
        }
        finally {
            this.fireStateChange(this, PlanCheck.State.Done);
        }
    }
}

