/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.planchecker;

import com.ibm.team.apt.internal.client.IPlanningAttribute;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.planchecker.AttributeProblem;
import com.ibm.team.apt.internal.client.planchecker.CheckerReport;
import com.ibm.team.apt.internal.client.planchecker.Problem;
import com.ibm.team.apt.internal.common.Severity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class PlanItemPlanCheckReport
extends CheckerReport {
    private final PlanItem fPlanItem;
    private Map<String, Problem> fProblems;
    private Problem fMostSevereProblem;

    public PlanItemPlanCheckReport(PlanItem planItem) {
        this.fPlanItem = planItem;
    }

    public PlanItemPlanCheckReport(PlanItemPlanCheckReport report) {
        this.fPlanItem = report.fPlanItem;
        if (report.fProblems != null) {
            this.fProblems = new HashMap<String, Problem>(report.fProblems);
        }
        this.fMostSevereProblem = report.fMostSevereProblem;
    }

    @Override
    public PlanItem getPlanElement() {
        return this.fPlanItem;
    }

    public Collection<Problem> getProblems() {
        if (this.fProblems == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Problem>(this.fProblems.values());
    }

    public boolean hasProblems() {
        return this.fProblems != null && !this.fProblems.isEmpty();
    }

    public Problem getMostSevereProblem() {
        return this.fMostSevereProblem;
    }

    public boolean isSeverity(Severity severity) {
        if (this.fProblems == null) {
            return false;
        }
        for (Problem problem : this.fProblems.values()) {
            if (!problem.isSeverity(severity)) continue;
            return true;
        }
        return false;
    }

    public Problem getProblem(String id) {
        return this.fProblems != null ? this.fProblems.get(id) : null;
    }

    public AttributeProblem getAttributeProblem(IPlanningAttribute attribute) {
        if (this.fProblems == null) {
            return null;
        }
        for (Problem problem : this.fProblems.values()) {
            if (!(problem instanceof AttributeProblem) || !((AttributeProblem)problem).getAttribute().equals(attribute)) continue;
            return (AttributeProblem)problem;
        }
        return null;
    }

    public void addProblem(Problem problem) {
        if (this.fProblems == null) {
            this.fProblems = new HashMap<String, Problem>();
        }
        this.fProblems.put(problem.getProblemId(), problem);
        this.updateMostSevereProblem(problem);
    }

    public void clearProblems() {
        if (this.fProblems == null) {
            return;
        }
        this.fProblems.clear();
        this.fMostSevereProblem = null;
    }

    public void clearProblems(Collection<String> problemIds) {
        if (this.fProblems == null) {
            return;
        }
        for (String problemId : problemIds) {
            Problem removed = this.fProblems.remove(problemId);
            if (removed == null || !removed.equals(this.fMostSevereProblem)) continue;
            this.fMostSevereProblem = null;
        }
        if (this.fMostSevereProblem == null) {
            this.computeMostSevereProblem();
        }
    }

    private void updateMostSevereProblem(Problem problem) {
        if (this.fMostSevereProblem == null) {
            this.fMostSevereProblem = problem;
        } else if (this.fMostSevereProblem.getSeverity().compareTo((Enum)problem.getSeverity()) < 0) {
            this.fMostSevereProblem = problem;
        }
    }

    private void computeMostSevereProblem() {
        for (Problem problem : this.fProblems.values()) {
            this.updateMostSevereProblem(problem);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fPlanItem.hashCode();
        if (this.fProblems != null) {
            result = 31 * result + this.fProblems.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlanItemPlanCheckReport other = (PlanItemPlanCheckReport)obj;
        if (!this.fPlanItem.getWorkItemId().equals((Object)other.fPlanItem.getWorkItemId())) {
            return false;
        }
        if (this.fProblems != null) {
            return this.fProblems.equals(other.fProblems);
        }
        return other.fProblems == null || other.fProblems.isEmpty();
    }
}

