/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.planchecker;

import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.client.planchecker.CheckerReport;
import com.ibm.team.apt.internal.client.planchecker.PlanItemPlanCheckReport;
import com.ibm.team.apt.internal.common.Severity;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PlanCheckReport
extends CheckerReport {
    private ResolvedPlan fPlan;
    private Map<PlanItem, PlanItemPlanCheckReport> fCheckerReports;

    public PlanCheckReport(ResolvedPlan plan) {
        this.fPlan = plan;
        this.fCheckerReports = new HashMap<PlanItem, PlanItemPlanCheckReport>();
    }

    public PlanCheckReport(PlanCheckReport report) {
        this.fPlan = report.fPlan;
        this.fCheckerReports = new HashMap<PlanItem, PlanItemPlanCheckReport>();
        for (PlanItemPlanCheckReport planItemReport : report.fCheckerReports.values()) {
            this.fCheckerReports.put(planItemReport.getPlanElement(), new PlanItemPlanCheckReport(planItemReport));
        }
    }

    @Override
    public PlanElement getPlanElement() {
        return this.fPlan;
    }

    public ResolvedPlan getPlan() {
        return this.fPlan;
    }

    public PlanItemPlanCheckReport getReport(PlanItem planItem) {
        return this.fCheckerReports.get(planItem);
    }

    public PlanItemPlanCheckReport removeReport(PlanItem planItem) {
        return this.fCheckerReports.remove(planItem);
    }

    public PlanItemPlanCheckReport createReport(PlanItem planItem) {
        PlanItemPlanCheckReport result = this.fCheckerReports.get(planItem);
        if (result != null) {
            return result;
        }
        result = new PlanItemPlanCheckReport(planItem);
        this.fCheckerReports.put(planItem, result);
        return result;
    }

    public PlanItemPlanCheckReport[] getPlanItemCheckReports() {
        Collection<PlanItemPlanCheckReport> values = this.fCheckerReports.values();
        return values.toArray(new PlanItemPlanCheckReport[values.size()]);
    }

    public void merge(PlanCheckReport other) {
        PlanItemPlanCheckReport[] others = other.getPlanItemCheckReports();
        int i = 0;
        while (i < others.length) {
            PlanItemPlanCheckReport report = others[i];
            if (!this.fCheckerReports.containsKey(report.getPlanElement())) {
                this.fCheckerReports.put(report.getPlanElement(), report);
            }
            ++i;
        }
    }

    public boolean isSeverity(Severity severity) {
        for (PlanItemPlanCheckReport report : this.fCheckerReports.values()) {
            if (!report.isSeverity(severity)) continue;
            return true;
        }
        return false;
    }

    public void removeEmptyReports() {
        Iterator<Map.Entry<PlanItem, PlanItemPlanCheckReport>> iterator = this.fCheckerReports.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<PlanItem, PlanItemPlanCheckReport> entry = iterator.next();
            if (entry.getValue().hasProblems()) continue;
            iterator.remove();
        }
    }
}

