/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.planchecker;

import com.ibm.team.apt.internal.client.IPlanElementDelta;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.client.planchecker.IPlanCheckListener;
import com.ibm.team.apt.internal.client.planchecker.PlanCheckReport;
import com.ibm.team.apt.internal.common.plantype.IPlanCheckDescription;
import com.ibm.team.apt.internal.common.plantype.IProblemDescription;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;

public abstract class PlanCheck {
    private ListenerList fPlanCheckListeners = new ListenerList();
    private final Map<String, IProblemDescription> fProblemDefinitios;
    private final IPlanCheckDescription fCheckDescriptor;
    private boolean fEnabled = true;

    public PlanCheck(IPlanCheckDescription checkDescriptor) {
        this.fCheckDescriptor = checkDescriptor;
        IProblemDescription[] problemDefinitions = this.fCheckDescriptor.getProblemDefinitions();
        this.fProblemDefinitios = new HashMap<String, IProblemDescription>();
        IProblemDescription[] iProblemDescriptionArray = problemDefinitions;
        int n = problemDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            IProblemDescription problemDefinition = iProblemDescriptionArray[n2];
            this.fProblemDefinitios.put(problemDefinition.getId(), problemDefinition);
            ++n2;
        }
    }

    public void addListener(IPlanCheckListener listener) {
        this.fPlanCheckListeners.add((Object)listener);
    }

    public void removeListener(IPlanCheckListener listener) {
        this.fPlanCheckListeners.remove((Object)listener);
    }

    public IPlanCheckDescription getCheckDescription() {
        return this.fCheckDescriptor;
    }

    public Collection<String> getProblemIds() {
        return this.fProblemDefinitios.keySet();
    }

    public IProblemDescription getProblemDefinition(String problemId) {
        return this.fProblemDefinitios.get(problemId);
    }

    public void initialize(ResolvedPlan plan, IProgressMonitor monitor) {
    }

    public void setEnabled(boolean enabled) {
        this.fEnabled = enabled;
    }

    public boolean isEnabled() {
        return this.fEnabled;
    }

    public void dispose() {
    }

    public abstract void runFullCheck(PlanCheckReport var1, IProgressMonitor var2) throws TeamRepositoryException;

    public abstract void runDeltaCheck(PlanCheckReport var1, IPlanElementDelta var2, IProgressMonitor var3) throws TeamRepositoryException;

    public abstract void runElementCheck(PlanCheckReport var1, Collection<? extends PlanElement> var2, IProgressMonitor var3) throws TeamRepositoryException;

    protected void fireStateChange(PlanCheck check, State state) {
        Object[] listeners;
        Object[] objectArray = listeners = this.fPlanCheckListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IPlanCheckListener)listener).stateChange(check, state);
            ++n2;
        }
    }

    public static enum State {
        Running,
        Done;

    }
}

