/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.model;

import com.ibm.team.apt.internal.client.IPlanningAttribute;
import com.ibm.team.apt.internal.client.IPlanningAttributeIdentifier;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ReferenceAttribute;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.IReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public interface IPlanItemIterator
extends Iterator<PlanItem> {
    public static final Factory FACTORY = new Factory();

    public IPlanItemIterator ascent();

    public IPlanItemIterator descent();

    public static class Factory {
        private static final IPlanItemIterator EMPTY = new IPlanItemIterator(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public PlanItem next() {
                return null;
            }

            @Override
            public IPlanItemIterator descent() {
                return this;
            }

            @Override
            public IPlanItemIterator ascent() {
                return this;
            }

            @Override
            public void remove() {
            }
        };

        private Factory() {
        }

        public IPlanItemIterator newInstance(PlanElement planElement, IPlanningAttributeIdentifier identifier) {
            IPlanningAttribute attribute = planElement.getPlan().getAttributeRegistry().getAttribute(identifier);
            if (attribute != null && attribute instanceof ReferenceAttribute) {
                return new PlanIterator(planElement, (ReferenceAttribute)attribute, null);
            }
            return EMPTY;
        }
    }

    public static class PlanIterator
    extends ReadOnlyIterator<PlanItem>
    implements IPlanItemIterator {
        private Iterator<PlanItem> fDelegate;
        private PlanItem fCurrent;
        private ReferenceAttribute fAttribute;
        private PlanIterator fParent;

        private PlanIterator(final PlanElement root, ReferenceAttribute attribute, PlanIterator parent) {
            List<Object> list;
            this.fAttribute = attribute;
            this.fParent = parent;
            if (root instanceof PlanItem) {
                list = attribute.getValue((PlanItem)root);
            } else {
                list = new ArrayList();
                Collection<PlanItem> allItems = root.getPlan().getAllPlanItems();
                for (PlanItem item : allItems) {
                    list.addAll(attribute.getValue(item));
                }
            }
            final Iterator<Object> iter = list.iterator();
            this.fDelegate = new ReadOnlyIterator<PlanItem>(){
                private PlanItem fNext;

                @Override
                public boolean hasNext() {
                    this.computeNext();
                    return this.fNext != null;
                }

                @Override
                public PlanItem next() {
                    this.computeNext();
                    PlanItem result = this.fNext;
                    this.fNext = null;
                    return result;
                }

                private void computeNext() {
                    if (this.fNext != null) {
                        return;
                    }
                    if (!iter.hasNext()) {
                        return;
                    }
                    IReference next = (IReference)iter.next();
                    if (next.isItemReference()) {
                        this.fNext = root.getPlan().getPlanItem(((IItemReference)next).getReferencedItem().getItemId());
                        fCurrent = this.fNext;
                    }
                }
            };
        }

        @Override
        public boolean hasNext() {
            return this.fDelegate != null && this.fDelegate.hasNext();
        }

        @Override
        public PlanItem next() {
            return this.fDelegate != null ? this.fDelegate.next() : null;
        }

        @Override
        public IPlanItemIterator descent() {
            return this.fCurrent != null ? new PlanIterator(this.fCurrent, this.fAttribute, this) : Factory.EMPTY;
        }

        @Override
        public IPlanItemIterator ascent() {
            return this.fParent != null ? this.fParent : Factory.EMPTY;
        }
    }

    public static abstract class ReadOnlyIterator<T>
    implements Iterator<T> {
        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

