/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.model;

import com.ibm.team.apt.api.client.IPlanElement;
import com.ibm.team.apt.api.client.IPlanModel;
import com.ibm.team.apt.api.client.IPlanningAttribute;
import com.ibm.team.apt.api.client.IPlanningAttributeIdentifier;
import com.ibm.team.apt.api.client.IPlanningAttributeValueSet;
import com.ibm.team.apt.api.client.internal.IFuture;
import com.ibm.team.apt.api.client.util.Flag;
import com.ibm.team.apt.api.common.planning.IPlanningAttributeDescription;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public abstract class AbstractPlanningAttribute<T>
implements IPlanningAttribute<T> {
    public IPlanningAttributeDescription fDescription;

    public AbstractPlanningAttribute(IPlanningAttributeDescription description) {
        this.fDescription = description;
    }

    public void initialize(IPlanModel planModel, IPlanElement[] planElements, IFuture<Void, Object> future, Flag ... flags) {
        try {
            this.doInitialize(planModel, planElements, (IProgressMonitor)new NullProgressMonitor());
            future.callback(null);
        }
        catch (TeamRepositoryException e) {
            future.errback((Object)e);
        }
    }

    protected void doInitialize(IPlanModel planModel, IPlanElement[] planElements, IProgressMonitor monitor) throws TeamRepositoryException {
    }

    public void unInitialize(IPlanModel planModel, IPlanElement[] planElements) {
    }

    public T getValue(IPlanElement receiver) {
        return (T)receiver.defined((IPlanningAttributeIdentifier)this);
    }

    public void setValue(IPlanElement receiver, T value) {
        receiver.define((IPlanningAttributeIdentifier)this, value);
    }

    public IPlanningAttributeValueSet getValueSet(IPlanElement planElement) {
        return IPlanningAttributeValueSet.EMPTY;
    }

    public IPlanningAttributeDescription getDescription() {
        return this.fDescription;
    }

    public final String getId() {
        return this.fDescription.getId();
    }

    protected void defineWithDefault(IPlanElement[] planElements) {
        IPlanElement[] iPlanElementArray = planElements;
        int n = planElements.length;
        int n2 = 0;
        while (n2 < n) {
            IPlanElement planElement = iPlanElementArray[n2];
            planElement.define((IPlanningAttributeIdentifier)this, null);
            ++n2;
        }
    }

    public <A> A getAdapter(Class<A> interfaceType) {
        return null;
    }
}

