/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client;

import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.common.resource.IWorkResourceDetails;
import com.ibm.team.apt.internal.client.DurationSupport;
import com.ibm.team.apt.internal.client.IItemResolveService;
import com.ibm.team.apt.internal.client.IIterationPlanClient;
import com.ibm.team.apt.internal.client.IPersonalPlanSaveAccessor;
import com.ibm.team.apt.internal.client.IPersonalPlanSaveManager;
import com.ibm.team.apt.internal.client.IPlanningAttribute;
import com.ibm.team.apt.internal.client.IPlanningAttributeIdentifier;
import com.ibm.team.apt.internal.client.IScheduleItem;
import com.ibm.team.apt.internal.client.ItemSequenceManager;
import com.ibm.team.apt.internal.client.IterationPlanClient;
import com.ibm.team.apt.internal.client.Messages;
import com.ibm.team.apt.internal.client.MissingFutureExecutorServiceException;
import com.ibm.team.apt.internal.client.MyWorkLoadInformation;
import com.ibm.team.apt.internal.client.OutOfOfficeItem;
import com.ibm.team.apt.internal.client.PersonalPlanItem;
import com.ibm.team.apt.internal.client.PersonalPlanSequenceManager;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.PlanSaveResult;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.ReferenceAttribute;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.client.ScriptableAttribute;
import com.ibm.team.apt.internal.client.planchecker.PlanCheck;
import com.ibm.team.apt.internal.client.resource.IContributorInfo;
import com.ibm.team.apt.internal.client.resource.IResourcePlanningInfo;
import com.ibm.team.apt.internal.client.resource.ResourcePlanningEvent;
import com.ibm.team.apt.internal.client.teamload.LoadInformation;
import com.ibm.team.apt.internal.client.util.IDeferredResolveListener;
import com.ibm.team.apt.internal.client.util.IDeferredResolver;
import com.ibm.team.apt.internal.common.IWorkHoursDefinition;
import com.ibm.team.apt.internal.common.plantype.IAttributeDefinitionDescriptor;
import com.ibm.team.apt.internal.common.util.CMode;
import com.ibm.team.apt.internal.common.util.ItemCollection;
import com.ibm.team.apt.internal.common.util.ItemCollections;
import com.ibm.team.apt.internal.common.util.ItemHashMap;
import com.ibm.team.apt.internal.common.util.ItemHashSet;
import com.ibm.team.apt.internal.common.util.ItemMap;
import com.ibm.team.apt.internal.common.util.ItemSet;
import com.ibm.team.apt.internal.common.util.IterationHierarchy;
import com.ibm.team.apt.internal.common.util.PlanRunnable;
import com.ibm.team.feed.core.FeedManager;
import com.ibm.team.feed.core.INewsListener;
import com.ibm.team.feed.core.NewsEvent;
import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.feed.core.model.NewsItem;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.WorkingCopyEvent;
import com.ibm.team.workitem.client.internal.WorkItemWorkingCopyImpl;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemFeedConstants;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class ResolvedPersonalPlan
extends ResolvedPlan {
    private final Date fPlanCreation = new Date(System.currentTimeMillis());
    private final IProjectAreaHandle fProjectAreaHandle;
    private final IContributor fContributor;
    private final ItemCollection<IProcessArea> fTeamMemberAreas;
    private final ItemCollection<IDevelopmentLine> fDevelopmentLines;
    private final ItemCollection<IIterationPlanRecord> fRelatedPlans;
    private final ItemSet<IIteration> fPlannedIntervals = new ItemHashSet();
    private final ItemSet<IIteration> fPastIterations = new ItemHashSet(CMode.CURRENT_HANDLEONLY);
    private Collection<OutOfOfficeItem> fAbsences;
    private IPersonalPlanSaveManager fSaveManager;
    private IProjectArea fProjectArea;
    private PersonalPlanSequenceManager fSequenceManager;
    private final ItemMap<IIterationHandle, LoadInformation> fLoadInformations = new ItemHashMap(CMode.CURRENT);
    private FeedManager fFeedManager;
    private INewsListener fWorkItemNewsListener;
    private Channel fMyWorkItemNewsChannel;
    private List<IWorkItemHandle> fAdditionalWorkItemHandles;
    private final boolean fIsMemberOfProjectArea;
    private ItemMap<ICategoryHandle, IProcessArea> fCategories2ProcessArea = new ItemHashMap(CMode.CURRENT_HANDLEONLY);
    private ItemMap<IProcessAreaHandle, ICategory> fProcessAreas2PrimaryCategory = new ItemHashMap(CMode.CURRENT_HANDLEONLY);

    public ResolvedPersonalPlan(IProjectAreaHandle projectAreaHandle, Collection<IAttributeDefinitionDescriptor> attributeDescriptors, Collection<IPlanningAttribute<?, ?>> customAttributes, Collection<PlanCheck> planChecks, IContributor owner, boolean isMemberOfProjectArea, List<IProcessArea> myTeamMemberAreas, Collection<IDevelopmentLine> developmentLines, Collection<ICategory> categories, Collection<IIteration> intervals, List<IWorkItem> currentWorkItems, List<IWorkItemHandle> otherWorkItems, Collection<? extends IContributor> creators, Collection<IIterationPlanRecord> relatedPlans, DurationSupport durationSupport, Set<String> topLevelWorkItemTypes) {
        super(currentWorkItems, attributeDescriptors, customAttributes, planChecks, Collections.singleton(owner), creators, developmentLines, categories, intervals, durationSupport, topLevelWorkItemTypes);
        this.fProjectAreaHandle = projectAreaHandle;
        this.fContributor = owner;
        this.fIsMemberOfProjectArea = isMemberOfProjectArea;
        this.fTeamMemberAreas = new ItemHashSet(myTeamMemberAreas);
        this.fDevelopmentLines = new ItemHashSet(developmentLines);
        this.fRelatedPlans = new ItemHashSet(relatedPlans);
        this.fAdditionalWorkItemHandles = otherWorkItems;
        for (IProcessArea area : myTeamMemberAreas) {
            this.addResolvedProcessArea(area);
        }
        ItemHashMap map = new ItemHashMap(CMode.CURRENT_HANDLEONLY);
        for (ICategory category : categories) {
            List teamAreas = category.getAssociatedTeamAreas();
            for (ITeamAreaHandle teamAreaHandle : teamAreas) {
                if (!this.fTeamMemberAreas.contains((Object)teamAreaHandle)) continue;
                this.add((ItemMap<IProcessAreaHandle, List<ICategory>>)map, (IProcessAreaHandle)teamAreaHandle, category);
            }
            if (!teamAreas.isEmpty() || !this.fTeamMemberAreas.contains((Object)category.getProjectArea())) continue;
            this.add((ItemMap<IProcessAreaHandle, List<ICategory>>)map, (IProcessAreaHandle)category.getProjectArea(), category);
        }
        for (Map.Entry entry : map.entrySet()) {
            IProcessAreaHandle handle = (IProcessAreaHandle)entry.getKey();
            ICategory primaryCategory = null;
            for (ICategory category : (List)entry.getValue()) {
                this.fCategories2ProcessArea.put((IItemHandle)((ICategoryHandle)category.getItemHandle()), (Object)this.getResolvedProcessArea(handle));
                if (primaryCategory == null || primaryCategory.isUnassigned()) {
                    primaryCategory = category;
                    continue;
                }
                if (category.getCategoryId().compareTo(primaryCategory.getCategoryId()) >= 0) continue;
                primaryCategory = category;
            }
            if (primaryCategory == null) continue;
            this.fProcessAreas2PrimaryCategory.put((IItemHandle)handle, primaryCategory);
        }
    }

    private void add(ItemMap<IProcessAreaHandle, List<ICategory>> map, IProcessAreaHandle key, ICategory value) {
        ArrayList<ICategory> list = (ArrayList<ICategory>)map.get((IItemHandle)key);
        if (list == null) {
            list = new ArrayList<ICategory>(2);
            map.put((IItemHandle)key, list);
        }
        list.add(value);
    }

    public IPersonalPlanSaveAccessor setSaveManager(final IPersonalPlanSaveManager saveManager) {
        this.fSaveManager = saveManager;
        return new IPersonalPlanSaveAccessor(){

            @Override
            public PlanSaveResult save(List<PlanItem> items, IProgressMonitor monitor) throws TeamRepositoryException {
                Assert.isTrue((ResolvedPersonalPlan.this.fSaveManager == saveManager ? 1 : 0) != 0);
                return ResolvedPersonalPlan.this.save(items, monitor);
            }

            @Override
            public boolean hasDirtyPlanItems() {
                return ResolvedPersonalPlan.this.hasDirtyWorkingCopies();
            }

            @Override
            public List<PlanItem> getDirtyPlanItems() {
                Assert.isTrue((ResolvedPersonalPlan.this.fSaveManager == saveManager ? 1 : 0) != 0);
                WorkItemWorkingCopy[] dirtyWorkingCopies = ResolvedPersonalPlan.this.getDirtyWorkingCopies(true);
                ArrayList<PlanItem> result = new ArrayList<PlanItem>(dirtyWorkingCopies.length);
                WorkItemWorkingCopy[] workItemWorkingCopyArray = dirtyWorkingCopies;
                int n = dirtyWorkingCopies.length;
                int n2 = 0;
                while (n2 < n) {
                    WorkItemWorkingCopy workingCopy = workItemWorkingCopyArray[n2];
                    PersonalPlanItem planItem = ResolvedPersonalPlan.this.getPlanItem((IWorkItemHandle)workingCopy.getWorkItem());
                    if (planItem != null) {
                        result.add(planItem);
                    }
                    ++n2;
                }
                return result;
            }

            @Override
            public boolean isOnlyEditor(PlanItem planItem) {
                Assert.isTrue((ResolvedPersonalPlan.this.fSaveManager == saveManager ? 1 : 0) != 0);
                return planItem.isWriteable() && !((WorkItemWorkingCopyImpl)planItem.getWorkItemWorkingCopy(false)).hasOtherWriteConnection(ResolvedPersonalPlan.this.getWorkingCopyManager(false));
            }

            @Override
            public boolean isWriteable(PlanItem planItem) {
                Assert.isTrue((ResolvedPersonalPlan.this.fSaveManager == saveManager ? 1 : 0) != 0);
                return planItem.isWriteable();
            }
        };
    }

    @Override
    public boolean isDirty() {
        return this.fSaveManager != null ? this.fSaveManager.isDirty() : false;
    }

    @Override
    public void markAsDirty() {
        if (this.fSaveManager != null) {
            this.fSaveManager.markAsDirty(true);
        }
    }

    @Override
    protected void doRecomputeWorkItemDirtyState() {
        if (this.fSaveManager != null) {
            this.fSaveManager.updateDirtyState();
        }
    }

    IPersonalPlanSaveManager getSaveManager() {
        return this.fSaveManager;
    }

    @Override
    public void setItemResolveService(IItemResolveService service) {
        super.setItemResolveService(service);
        IItemResolveService resolveService = this.getResolveService();
        if (this.isConnected() && resolveService != null && this.fAdditionalWorkItemHandles != null && this.fAdditionalWorkItemHandles.size() > 0) {
            try {
                this.doResolvePlanItems(this.fAdditionalWorkItemHandles, null, false);
            }
            catch (MissingFutureExecutorServiceException e) {
                PlanningClientPlugin.log((IStatus)new Status(4, PlanningClientPlugin.getPluginId(), 4, "No resolver service available", null));
            }
        }
    }

    public boolean isMemberOfProjectArea() {
        return this.fIsMemberOfProjectArea;
    }

    @Override
    public ItemCollection<IProcessArea> getTeamMemberAreas() {
        return ItemCollections.unmodifiableItemCollection(this.fTeamMemberAreas);
    }

    @Override
    public IProcessArea getTeamMemberArea(ICategoryHandle category) {
        return (IProcessArea)this.fCategories2ProcessArea.get((IItemHandle)category);
    }

    @Override
    public ICategory getPrimaryCategoryFor(IProcessArea area) {
        return (ICategory)this.fProcessAreas2PrimaryCategory.get((IItemHandle)area);
    }

    @Override
    public PersonalPlanItem getPlanItem(IWorkItemHandle handle) {
        return (PersonalPlanItem)super.getPlanItem(handle);
    }

    public IWorkHoursDefinition getWorkHourDefinitions() {
        return this.fSequenceManager.getWorkHourDefinition();
    }

    public PersonalPlanSequenceManager getItemSequenceManager() {
        return this.fSequenceManager;
    }

    @Override
    public ItemSequenceManager getItemSequenceManager(IScheduleItem scheduleItem) {
        return this.fSequenceManager;
    }

    public IContributor getPlanOwner() {
        return this.fContributor;
    }

    public ItemCollection<IIterationPlanRecord> getRelatedPlans() {
        return ItemCollections.unmodifiableItemCollection(this.fRelatedPlans);
    }

    @Override
    public ItemSet<IIteration> getPlannedIterations() {
        return new ItemHashSet(this.fPlannedIntervals);
    }

    @Override
    public Collection<OutOfOfficeItem> getAbsences() {
        return this.fAbsences;
    }

    @Override
    public IIteration suggestCurrentIteration(PlanItem planItem, IProgressMonitor monitor) throws TeamRepositoryException {
        IIterationHandle currentIteration = planItem.getWorkItem(false).getTarget();
        if (currentIteration == null || !this.fPlannedIntervals.contains((Object)currentIteration)) {
            IterationHierarchy iterationHierarchy;
            IWorkItemClient workItemClient = PlanningClientPlugin.getWorkItemClient(this.getTeamRepository());
            IAuditableCommon auditableCommon = workItemClient.getAuditableCommon();
            IDevelopmentLine devLine = null;
            if (currentIteration != null) {
                IIteration iteration = this.getResolvedIteration(currentIteration);
                if (iteration == null) {
                    IItemManager itemManager = PlanningClientPlugin.getTeamRepository((IItemHandle)currentIteration).itemManager();
                    iteration = (IIteration)itemManager.fetchCompleteItem((IItemHandle)currentIteration, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                if (iteration != null) {
                    devLine = this.getResolvedDevelopmentLine(iteration.getDevelopmentLine());
                }
            }
            if (devLine == null) {
                IProcessAreaHandle processArea = workItemClient.findProcessArea((IWorkItemHandle)planItem.getWorkItem(false), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (processArea instanceof ITeamAreaHandle) {
                    devLine = auditableCommon.getDevelopmentLine((ITeamAreaHandle)processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else if (processArea instanceof IProjectAreaHandle) {
                    devLine = auditableCommon.findDefaultDevelopmentLine((IProjectAreaHandle)processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
            }
            if (devLine != null && (iterationHierarchy = this.getDevelopmentLineIterationHierarchy((IDevelopmentLineHandle)devLine)) != null) {
                currentIteration = iterationHierarchy.getCurrentIteration();
            }
            if (!(currentIteration != null && this.fPlannedIntervals.contains((Object)currentIteration) || this.fPlannedIntervals.isEmpty())) {
                currentIteration = (IIterationHandle)this.fPlannedIntervals.iterator().next();
            }
        }
        return currentIteration != null ? this.getResolvedIteration(currentIteration) : null;
    }

    @Override
    public LoadInformation getLoadInformation(IIterationHandle iteration) {
        return (LoadInformation)this.fLoadInformations.get((IItemHandle)iteration);
    }

    @Override
    public ITeamRepository getTeamRepository() {
        return (ITeamRepository)this.fContributor.getOrigin();
    }

    @Override
    public IProjectArea getProjectArea() {
        return this.fProjectArea;
    }

    @Override
    public IProjectAreaHandle getProjectAreaHandle() {
        return this.fProjectAreaHandle;
    }

    @Override
    public String getName() {
        return Messages.ResolvedPersonalPlan_MY_WORK_LABEL;
    }

    @Override
    public Date getStartDate() {
        Date result = this.fPlanCreation;
        for (IIteration interval : this.fPlannedIntervals) {
            Date startDate = interval.getStartDate();
            if (startDate == null || result != this.fPlanCreation && !startDate.before(result)) continue;
            result = startDate;
        }
        return result;
    }

    @Override
    public Date getEndDate() {
        Date result = this.fPlanCreation;
        for (IIteration interval : this.fPlannedIntervals) {
            Date endDate = interval.getEndDate();
            if (endDate == null || result != this.fPlanCreation && !endDate.after(result)) continue;
            result = endDate;
        }
        return result;
    }

    @Override
    protected void doConnect(IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask("", 4);
        try {
            ArrayList attributes = new ArrayList(this.getAllAttributes());
            Iterator<IPlanningAttribute<?, ?>> iter = attributes.iterator();
            block3: while (iter.hasNext()) {
                IPlanningAttribute<?, ?> attribute = iter.next();
                if (attribute instanceof ReferenceAttribute) {
                    iter.remove();
                    continue;
                }
                if (!(attribute instanceof ScriptableAttribute)) continue;
                Collection<IPlanningAttributeIdentifier> dependantAttributes = ((ScriptableAttribute)attribute).getDependantAttributes();
                Iterator<IPlanningAttributeIdentifier> iter2 = dependantAttributes.iterator();
                while (iter2.hasNext()) {
                    IPlanningAttributeIdentifier identifier = iter2.next();
                    if (!(this.getAttributeRegistry().getAttribute(identifier) instanceof ReferenceAttribute)) continue;
                    iter.remove();
                    continue block3;
                }
            }
            this.prepare(this, attributes, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.fProjectArea = (IProjectArea)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)this.fProjectAreaHandle, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IWorkItemClient workItemClient = PlanningClientPlugin.getWorkItemClient(this.getTeamRepository());
            workItemClient.findWorkItemTypes((IProjectAreaHandle)this.fProjectArea, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            for (IDevelopmentLine developmentLine : this.fDevelopmentLines) {
                IterationHierarchy iterationHierarchy = this.getDevelopmentLineIterationHierarchy((IDevelopmentLineHandle)developmentLine);
                if (iterationHierarchy == null) continue;
                IIteration currentIteration = iterationHierarchy.getCurrentIteration();
                if (currentIteration != null) {
                    this.fPlannedIntervals.add((Object)currentIteration);
                }
                this.fPastIterations.addAll((ItemCollection)iterationHierarchy.getPastIterations());
            }
            IContributorInfo contributorInfo = this.fetchContributorInfo((ItemCollection<? extends IContributorHandle>)ItemCollections.singleton((Object)this.getPlanOwner()), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.fAbsences = this.doCreateAbsences(contributorInfo.getAbsences((IContributorHandle)this.getPlanOwner()));
            this.fSequenceManager = new PersonalPlanSequenceManager(this);
            this.fSequenceManager.initialize(contributorInfo.getWorkLocation((IContributorHandle)this.getPlanOwner()), this.calculateAssignment(contributorInfo), this.getWorkAssignments(contributorInfo.getWorkDetails((IContributorHandle)this.getPlanOwner())), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.fFeedManager = FeedManager.getDefault();
            String myChangesFeedKey = IWorkItemFeedConstants.UTILITY.getMyChangesFeedKey(this.getTeamRepository().getRepositoryURI());
            this.fMyWorkItemNewsChannel = this.fFeedManager.getPredefinedChannel(myChangesFeedKey);
            if (this.fMyWorkItemNewsChannel != null) {
                this.fWorkItemNewsListener = new PlanItemNewsListener();
                this.fFeedManager.addNewsListener(this.fMyWorkItemNewsChannel, this.fWorkItemNewsListener);
            }
            for (IIteration iteration : this.getPlannedIterations()) {
                MyWorkLoadInformation information = new MyWorkLoadInformation(this, iteration);
                information.connect(monitor);
                this.fLoadInformations.put((IItemHandle)iteration, (Object)information);
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    protected IWorkItem doConnectWorkItem(IWorkItemWorkingCopyManager workingCopyManager, Object workItemTransportObject, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItem resolvedWorkItem = (IWorkItem)workItemTransportObject;
        ItemProfile profile = ItemProfile.computeProfile((IAuditable)resolvedWorkItem);
        workingCopyManager.connect((IWorkItemHandle)resolvedWorkItem, profile, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        return resolvedWorkItem;
    }

    @Override
    protected void doDisconnect() {
        if (this.fSaveManager != null) {
            this.fSaveManager.onDisconnect();
        }
        if (this.fMyWorkItemNewsChannel != null) {
            this.fFeedManager.removeNewsListener(this.fMyWorkItemNewsChannel, this.fWorkItemNewsListener);
            this.fWorkItemNewsListener = null;
            this.fMyWorkItemNewsChannel = null;
        }
        this.fFeedManager = null;
        this.fSequenceManager.dispose();
        Iterator iter = this.fLoadInformations.values().iterator();
        while (iter.hasNext()) {
            ((LoadInformation)iter.next()).dispose();
        }
        this.fLoadInformations.clear();
    }

    @Override
    protected void handleDirtyStateChanged(WorkingCopyEvent event) {
        super.handleDirtyStateChanged(event);
        if (this.fSaveManager != null) {
            PersonalPlanItem planItem = this.getPlanItem((IWorkItemHandle)event.getSource().getWorkItem());
            this.fSaveManager.onDirtyStateChange(planItem, event.getSource().isDirty());
        }
    }

    @Override
    public void setReferenceTime(Date referenceTime) {
        super.setReferenceTime(referenceTime);
        if (this.fSequenceManager != null) {
            this.fSequenceManager.updateReferenceTime();
        }
    }

    @Override
    public void adopt(IWorkItem item, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.ResolvedPersonalPlan_MONITOR_ADOPTING_WORK_ITEM, 3);
        try {
            item.setOwner((IContributorHandle)this.fContributor);
        }
        finally {
            monitor.done();
        }
    }

    @Override
    protected void initializeNewPlanItem(PlanItem item, IProgressMonitor monitor) throws TeamRepositoryException {
    }

    @Override
    public boolean matchesPlanQuery(PlanItem item) {
        return this.isRelevantForPlan(item.getWorkItem(false));
    }

    @Override
    protected boolean isRelevantForPlan(IWorkItem workItem) {
        IIterationHandle target;
        if (!workItem.getProjectArea().sameItemId((IItemHandle)this.getProjectAreaHandle())) {
            return false;
        }
        if (!this.fContributor.sameItemId((IItemHandle)workItem.getOwner())) {
            return false;
        }
        if (!workItem.isPropertySet(IWorkItem.STATE_PROPERTY) || !workItem.isPropertySet(IWorkItem.TARGET_PROPERTY)) {
            return false;
        }
        return 2 != this.getCombinedWorkflowInfos().getStateGroup(workItem.getState2()) || (target = workItem.getTarget()) != null && !this.fPastIterations.contains((Object)target);
    }

    @Override
    public List<String> getUnrelevantWorkItemReasons(IWorkItem workItem, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask("", 1);
        try {
            if (!this.fContributor.sameItemId((IItemHandle)workItem.getOwner())) {
                IContributor owner = (IContributor)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)workItem.getOwner(), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                List<String> list = Collections.singletonList(NLS.bind((String)Messages.ResolvedPersonalPlan_BELONGS_TO_OTHER_OWNER, (Object)owner.getName(), (Object[])new Object[0]));
                return list;
            }
            monitor.worked(1);
            List list = Collections.EMPTY_LIST;
            return list;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    protected void processItems(List workItemTransportObjects) {
        for (IWorkItem item : workItemTransportObjects) {
            if (this.getPlanItem((IWorkItemHandle)item) != null) continue;
            this.processItem(item);
        }
    }

    protected List<PersonalPlanItem> processItem(IWorkItem item) {
        PersonalPlanItem planItem = this.getPlanItem((IWorkItemHandle)item);
        if (planItem != null) {
            return Collections.EMPTY_LIST;
        }
        WorkItemWorkingCopy wc = this.getWorkingCopyManager(true).getWorkingCopy((IWorkItemHandle)item);
        planItem = new PersonalPlanItem(this, (PlanElement)this, wc);
        return Collections.singletonList(planItem);
    }

    @Override
    protected void itemsAdded(List<? extends PlanItem> items) {
        if (this.fSequenceManager != null) {
            for (PlanItem planItem : items) {
                this.fSequenceManager.itemAdded(planItem);
            }
        }
        ArrayList<PlanItem> arrayList = new ArrayList<PlanItem>();
        ItemSet<IIteration> plannedIterations = this.getPlannedIterations();
        for (PlanItem planItem : items) {
            if (planItem.getTarget() == null || !plannedIterations.contains((Object)planItem.getTarget())) continue;
            arrayList.add(planItem);
        }
        super.itemsAdded(arrayList);
    }

    @Override
    protected boolean isResolvingRequired(WorkItemWorkingCopy workingCopy) {
        IIteration iteration;
        IIterationHandle iterationHandle;
        IWorkItem workItem = workingCopy.getWorkItem();
        IItemManager manager = this.getTeamRepository().itemManager();
        ICategoryHandle categoryHandle = workItem.getCategory();
        ICategory category = this.getResolvedCategory(categoryHandle);
        if (category == null) {
            category = (ICategory)manager.getSharedItemIfKnown((IItemHandle)categoryHandle);
            if (category == null) {
                return true;
            }
            this.addResolvedCategory(category);
        }
        if ((iterationHandle = workItem.getTarget()) != null && (iteration = this.getResolvedIteration(iterationHandle)) == null) {
            iteration = (IIteration)manager.getSharedItemIfKnown((IItemHandle)iterationHandle);
            if (iteration == null) {
                return true;
            }
            this.addResolvedIteration(iteration);
        }
        return false;
    }

    @Override
    protected void doResolvePlanItems(final List<IWorkItemHandle> workItemHandles, final IDeferredResolveListener<List<Object>> listener, boolean isBlocking) throws MissingFutureExecutorServiceException {
        IItemResolveService resolveService = this.getResolveService();
        if (resolveService == null) {
            throw new MissingFutureExecutorServiceException();
        }
        for (IWorkItemHandle workItemHandle : workItemHandles) {
            this.setWorkItemIgnored(workItemHandle, true);
        }
        IDeferredResolver<List<Object>> resolver = new IDeferredResolver<List<Object>>(){
            final int BATCH_SIZE = 50;

            @Override
            public List<Object> resolve(final IProgressMonitor monitor) throws TeamRepositoryException {
                try {
                    monitor.beginTask(Messages.ResolvedPersonalPlan_MONITOR_RESOLVING_ADDTIONAL_ITEMS, Math.max(1, workItemHandles.size() / 50) + workItemHandles.size() + 2);
                    ITeamRepository teamRepository = ResolvedPersonalPlan.this.getTeamRepository();
                    IItemManager itemManager = teamRepository.itemManager();
                    Collection requiredProperties = ResolvedPersonalPlan.this.getWorkItemProfile().getProperties();
                    final ArrayList<Object> result = new ArrayList<Object>();
                    int i = 0;
                    while (i < workItemHandles.size()) {
                        if (!ResolvedPersonalPlan.this.isConnected()) break;
                        List batch = workItemHandles.subList(i, i + Math.min(workItemHandles.size() - i, 50));
                        result.addAll(itemManager.fetchPartialItems(batch, 0, requiredProperties, (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
                        i += 50;
                    }
                    SubProgressMonitor additionalResolveMonitor = new SubProgressMonitor(monitor, 2 * result.size() + 1);
                    try {
                        ItemHashSet additionalCreators = new ItemHashSet();
                        Iterator iterator = result.iterator();
                        while (iterator.hasNext()) {
                            IContributorHandle creatorHandle;
                            ICategoryHandle categoryHandle;
                            if (!ResolvedPersonalPlan.this.isConnected()) break;
                            IWorkItem workItem = (IWorkItem)iterator.next();
                            IIterationHandle iterationHandle = workItem.getTarget();
                            if (iterationHandle != null && ResolvedPersonalPlan.this.getResolvedIteration(iterationHandle) == null) {
                                ResolvedPersonalPlan.this.addResolvedIteration((IIteration)this.findItem(itemManager, (IItemHandle)iterationHandle, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)additionalResolveMonitor, 1)));
                            }
                            if (ResolvedPersonalPlan.this.getResolvedCategory(categoryHandle = workItem.getCategory()) == null) {
                                ResolvedPersonalPlan.this.addResolvedCategory((ICategory)this.findItem(itemManager, (IItemHandle)categoryHandle, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)additionalResolveMonitor, 1)));
                            }
                            if (ResolvedPersonalPlan.this.getResolvedContributor(creatorHandle = workItem.getCreator()) != null) continue;
                            additionalCreators.add((Object)creatorHandle);
                        }
                        ArrayList toResolve = new ArrayList(additionalCreators.toCollection());
                        List creators = itemManager.fetchCompleteItems(toResolve, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        for (IContributor creator : creators) {
                            ResolvedPersonalPlan.this.addResolvedContributor(creator);
                        }
                    }
                    finally {
                        additionalResolveMonitor.done();
                    }
                    ResolvedPersonalPlan.this.runConnected(new PlanRunnable<TeamRepositoryException>(){

                        public void run() throws TeamRepositoryException {
                            for (Object workItemTransportObject : result) {
                                ResolvedPersonalPlan.this.doConnectWorkItem(ResolvedPersonalPlan.this.getWorkingCopyManager(true), workItemTransportObject, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            }
                        }
                    });
                    ArrayList<Object> arrayList = result;
                    return arrayList;
                }
                finally {
                    monitor.done();
                }
            }

            private IItem findItem(IItemManager itemManager, IItemHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
                IItem result = itemManager.getSharedItemIfKnown(handle);
                if (result == null) {
                    result = itemManager.fetchCompleteItem(handle, 0, monitor);
                }
                return result;
            }
        };
        resolveService.deferredResolve(resolver, new IDeferredResolveListener<List<Object>>(){

            @Override
            public void resolved(final List<Object> result) {
                ResolvedPersonalPlan.this.runConnected(new PlanRunnable<RuntimeException>(){

                    public void run() throws RuntimeException {
                        for (IWorkItem workItem : result) {
                            Assert.isNotNull((Object)workItem);
                            ResolvedPersonalPlan.this.addResolvedWorkItem(workItem);
                            Runnable listenerCall = null;
                            if (listener != null) {
                                listenerCall = new Runnable(){

                                    @Override
                                    public void run() {
                                        listener.resolved(result);
                                    }
                                };
                            }
                            ResolvedPersonalPlan.this.doProcessAdd(workItem, listenerCall);
                            ResolvedPersonalPlan.this.setWorkItemIgnored((IWorkItemHandle)workItem, false);
                        }
                    }
                });
            }

            @Override
            public void canceled() {
            }

            @Override
            public void failed(IStatus state) {
                PlanningClientPlugin.log(state);
            }
        }, isBlocking);
    }

    private void processNewsReceivedEvent(NewsEvent event) {
        NewsItem[] addedNews;
        IItemResolveService resolveService = this.getResolveService();
        if (resolveService == null || System.getProperty("com.ibm.team.apt.mywork.disableAutoRefresh") != null) {
            return;
        }
        String repositoryURI = this.getTeamRepository().getRepositoryURI();
        String publicRepositoryURI = this.getTeamRepository().publicUriRoot();
        IItemManager itemManager = this.getTeamRepository().itemManager();
        ItemHashSet itemsToRefresh = new ItemHashSet();
        NewsItem[] newsItemArray = addedNews = event.getAddedNews();
        int n = addedNews.length;
        int n2 = 0;
        while (n2 < n) {
            NewsItem newsItem = newsItemArray[n2];
            String itemRepositoryUrl = newsItem.getCustomAttribute("http://www.ibm.com/jazz/0.1.0/syndication", "repositoryURL");
            String publicItemRepositoryUrl = newsItem.getCustomAttribute("http://www.ibm.com/jazz/0.1.0/syndication", "publicUri");
            if (repositoryURI.equals(itemRepositoryUrl) || repositoryURI.equals(publicItemRepositoryUrl) || publicRepositoryURI != null && publicRepositoryURI.equals(publicItemRepositoryUrl)) {
                IWorkItemHandle workItemHandle;
                IItem currentItem;
                String itemIdString = newsItem.getCustomAttribute("http://www.ibm.com/jazz/0.1.0/syndication", "itemId");
                String stateIdString = newsItem.getCustomAttribute("http://www.ibm.com/jazz/0.1.0/syndication", "stateId");
                if (!(itemIdString == null || (currentItem = itemManager.getSharedItemIfKnown((IItemHandle)(workItemHandle = (IWorkItemHandle)IWorkItem.ITEM_TYPE.createItemHandle((Object)this.getTeamRepository(), UUID.valueOf((String)itemIdString), null)))) != null && stateIdString != null && currentItem.hasStateId() && UUID.valueOf((String)stateIdString).equals((Object)currentItem.getStateId()))) {
                    itemsToRefresh.add((Object)workItemHandle);
                }
            }
            ++n2;
        }
        if (!itemsToRefresh.isEmpty()) {
            IDeferredResolver<Void> resolver = new IDeferredResolver<Void>((ItemSet)itemsToRefresh){
                private final /* synthetic */ ItemSet val$itemsToRefresh;
                {
                    this.val$itemsToRefresh = itemSet;
                }

                @Override
                public Void resolve(IProgressMonitor monitor) throws TeamRepositoryException {
                    try {
                        monitor.beginTask(Messages.ResolvedPersonalPlan_MONITOR_REFRESHING_WORK_ITEMS, -1);
                        IIterationPlanClient iterationPlanClient = PlanningClientPlugin.getIterationPlanClient(ResolvedPersonalPlan.this.getTeamRepository());
                        ItemSet<IWorkItem> refreshed = ((IterationPlanClient)iterationPlanClient).refreshWorkItems((ItemSet<IWorkItemHandle>)this.val$itemsToRefresh, ResolvedPersonalPlan.this.getWorkItemProfile(), monitor);
                        IWorkItemWorkingCopyManager workingCopyManager = ResolvedPersonalPlan.this.getWorkingCopyManager(true);
                        ResolvedPersonalPlan.this.connectDeltaBuilder();
                        try {
                            for (IWorkItem workItem : refreshed) {
                                PersonalPlanItem planItem = ResolvedPersonalPlan.this.getPlanItem((IWorkItemHandle)workItem);
                                if (planItem == null || planItem.isDirty()) continue;
                                workingCopyManager.refresh((IWorkItemHandle)workItem);
                            }
                        }
                        finally {
                            ResolvedPersonalPlan.this.disconnectDeltaBuilder();
                        }
                        return null;
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            resolveService.deferredResolve(resolver, new IDeferredResolveListener<Void>(){

                @Override
                public void resolved(Void result) {
                }

                @Override
                public void canceled() {
                }

                @Override
                public void failed(IStatus state) {
                    PlanningClientPlugin.log(state);
                }
            }, false);
        }
    }

    @Override
    protected PlanItem doCreateNewPlanItem(PlanElement parent, WorkItemWorkingCopy workingCopy) {
        return new PersonalPlanItem(this, parent, workingCopy);
    }

    @Override
    protected void doProcessResourcePlanningUpdate(ResourcePlanningEvent event) {
        if (this.getPlanOwner().sameItemId((IItemHandle)event.getAuditable())) {
            IResourcePlanningInfo planningInfo = event.getInfo();
            if (planningInfo instanceof IContributorInfo) {
                this.updateWorkTime(planningInfo);
            } else {
                FoundationJob updateJob = new FoundationJob(Messages.ResolvedPersonalPlan_JOB_UPDATE_RESOURCEPLANNINGDATA){

                    protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                        ResolvedPersonalPlan.this.updateWorkTime(ResolvedPersonalPlan.this.fetchContributorInfo((ItemCollection<? extends IContributorHandle>)ItemCollections.singleton((Object)ResolvedPersonalPlan.this.getPlanOwner()), monitor));
                        return Status.OK_STATUS;
                    }
                };
                updateJob.setUser(false);
                updateJob.setSystem(true);
                updateJob.schedule();
            }
        }
    }

    private void updateWorkTime(final IResourcePlanningInfo planningInfo) {
        this.runConnected(new PlanRunnable<RuntimeException>(){

            public void run() throws RuntimeException {
                ResolvedPersonalPlan.this.connectDeltaBuilder();
                try {
                    IContributorInfo contributorInfo = (IContributorInfo)planningInfo;
                    ResolvedPersonalPlan.this.fSequenceManager.updateWorkTime(contributorInfo.getWorkLocation((IContributorHandle)ResolvedPersonalPlan.this.getPlanOwner()), ResolvedPersonalPlan.this.calculateAssignment(contributorInfo), ResolvedPersonalPlan.this.getWorkAssignments((ItemCollection<IWorkResourceDetails>)contributorInfo.getWorkDetails((IContributorHandle)ResolvedPersonalPlan.this.getPlanOwner())));
                    ResolvedPersonalPlan.this.addAttributeChange(RESOURCE_PLANNING, null, null);
                }
                finally {
                    ResolvedPersonalPlan.this.disconnectDeltaBuilder();
                }
            }
        });
    }

    private int calculateAssignment(IContributorInfo contributorInfo) {
        int assignment = 0;
        for (IDevelopmentLineHandle developmentLine : this.fDevelopmentLines) {
            assignment += contributorInfo.getWorkAssignment((IContributorHandle)this.getPlanOwner(), null, developmentLine);
        }
        assignment = Math.max(Math.min(assignment, 100), 0);
        return assignment;
    }

    private IWorkResourceDetails[] getWorkAssignments(ItemCollection<IWorkResourceDetails> workDetails) {
        ArrayList<IWorkResourceDetails> assignments = new ArrayList<IWorkResourceDetails>();
        for (IDevelopmentLineHandle developmentLine : this.fDevelopmentLines) {
            for (IWorkResourceDetails detail : workDetails) {
                if (!developmentLine.sameItemId((IItemHandle)detail.getDevelopmentLine())) continue;
                assignments.add(detail);
            }
        }
        return assignments.toArray(new IWorkResourceDetails[assignments.size()]);
    }

    /*
     * Unable to fully structure code
     */
    protected PlanSaveResult save(List<PlanItem> items, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.ResolvedPersonalPlan_MONITOR_SAVE, 2);
        try {
            oldDirty = this.isDirty();
            deltaBuilder = this.connectDeltaBuilder();
            try {
                this.writeSequenceValues(items, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            finally {
                this.disconnectDeltaBuilder();
            }
            client = (IterationPlanClient)PlanningClientPlugin.getIterationPlanClient(this.getTeamRepository());
            dirtyWorkingCopies = new ArrayList<WorkItemWorkingCopy>(items.size());
            workingCopyManager = this.getWorkingCopyManager(false);
            profile = this.getWorkItemProfile();
            try {
                for (PlanItem planItem : items) {
                    workItemHandle = planItem.getWorkItemHandle();
                    if (!planItem.isDirty() || !workingCopyManager.connectLocal(workItemHandle, profile)) continue;
                    dirtyWorkingCopies.add(workingCopyManager.getWorkingCopy(workItemHandle));
                }
                result = client.save(this.getWorkingCopyManager(false), dirtyWorkingCopies.toArray(new WorkItemWorkingCopy[dirtyWorkingCopies.size()]), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            finally {
                ** for (toDisconnect : dirtyWorkingCopies)
            }
lbl-1000:
            // 1 sources

            {
                workingCopyManager.disconnect((IWorkItemHandle)toDisconnect.getWorkItem());
                continue;
            }
lbl29:
            // 1 sources

            deltaBuilder = this.connectDeltaBuilder();
            try {
                for (WorkItemWorkingCopy workItemWorkingCopy : dirtyWorkingCopies) {
                    planItem = this.getPlanItem((IWorkItemHandle)workItemWorkingCopy.getWorkItem());
                    if (planItem == null) continue;
                    planItem.markRead();
                }
                if (!result.getStatus().matches(4)) {
                    this.disconnectRemovedPlanItems();
                }
                if (oldDirty != this.isDirty()) {
                    deltaBuilder.changed(this, ResolvedPersonalPlan.DIRTY, new Boolean(oldDirty), new Boolean(this.isDirty()));
                }
                var14_19 = result;
            }
            catch (Throwable var13_15) {
                this.disconnectDeltaBuilder();
                throw var13_15;
            }
            this.disconnectDeltaBuilder();
            return var14_19;
        }
        finally {
            monitor.done();
        }
    }

    private class PlanItemNewsListener
    implements INewsListener {
        private PlanItemNewsListener() {
        }

        public void newsReceived(NewsEvent event) {
            ResolvedPersonalPlan.this.processNewsReceivedEvent(event);
        }

        public void newsRemoved(NewsEvent event) {
        }

        public void newsStateChanged(NewsEvent event) {
        }
    }
}

