/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client;

import com.ibm.team.apt.internal.client.AbstractPlanningAttribute;
import com.ibm.team.apt.internal.client.AttributeNotAvailableException;
import com.ibm.team.apt.internal.client.GetterKind;
import com.ibm.team.apt.internal.client.IPlanningAttributeValueSet;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.SetterKind;
import com.ibm.team.apt.internal.common.plantype.IAttributeDefinitionDescriptor;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

public class ReflectiveAttribute<R, V>
extends AbstractPlanningAttribute<R, V> {
    private final Class<R> fReceiverType;
    private final Method fGetter;
    private final Method fSetter;
    private final IPlanningAttributeValueSet<V> fValueSet;

    public ReflectiveAttribute(IAttributeDefinitionDescriptor attributeDescriptor, String name, Class<R> receiverType, Class<V> valueType, IPlanningAttributeValueSet<V> valueSet) {
        this(attributeDescriptor, name, receiverType, valueType, GetterKind.GET, SetterKind.SET, valueSet);
    }

    public ReflectiveAttribute(IAttributeDefinitionDescriptor attributeDescriptor, String name, Class<R> receiverType, Class<V> valueType, GetterKind getter, SetterKind setter, IPlanningAttributeValueSet<V> valueSet) {
        super(attributeDescriptor);
        this.fReceiverType = receiverType;
        this.fGetter = getter.resolveAccessor(this.fReceiverType, name, valueType);
        this.fSetter = setter.resolveAccessor(this.fReceiverType, name, valueType);
        this.fValueSet = valueSet != null ? valueSet : new IPlanningAttributeValueSet.EmptyValueSet();
    }

    @Override
    public void initialize(PlanElement planElement, IProgressMonitor monitor) throws TeamRepositoryException {
    }

    @Override
    public IPlanningAttributeValueSet<V> getValueSet() {
        return this.fValueSet;
    }

    @Override
    public V getValue(R receiver) {
        if (this.fGetter == null) {
            throw new UnsupportedOperationException();
        }
        try {
            return (V)this.fGetter.invoke(receiver, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            PlanningClientPlugin.log(e);
        }
        catch (IllegalAccessException e) {
            PlanningClientPlugin.log(e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof AttributeNotAvailableException) {
                throw (AttributeNotAvailableException)e.getTargetException();
            }
            PlanningClientPlugin.log(e);
        }
        Assert.isTrue((boolean)false, (String)"Should never happen");
        return null;
    }

    @Override
    public void setValue(R receiver, V value) {
        if (this.fSetter == null) {
            throw new UnsupportedOperationException();
        }
        try {
            this.fSetter.invoke(receiver, value);
            return;
        }
        catch (IllegalArgumentException e) {
            PlanningClientPlugin.log(e);
        }
        catch (IllegalAccessException e) {
            PlanningClientPlugin.log(e);
        }
        catch (InvocationTargetException e) {
            PlanningClientPlugin.log(e);
        }
        Assert.isTrue((boolean)false, (String)"Should never happen");
    }

    public String toString() {
        return this.getId();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof ReflectiveAttribute) {
            ReflectiveAttribute other = (ReflectiveAttribute)obj;
            Assert.isTrue((boolean)this.fReceiverType.equals(other.fReceiverType));
            Assert.isTrue((boolean)(this.fGetter == null ? other.fGetter == null : this.fGetter.equals(other.fGetter)));
            Assert.isTrue((boolean)(this.fSetter == null ? other.fSetter == null : this.fSetter.equals(other.fSetter)));
        }
        return true;
    }

    @Override
    public boolean isSupported(Class<?> receiverType) {
        return this.fReceiverType.isAssignableFrom(receiverType);
    }

    @Override
    public boolean isDefined(R receiver) {
        return true;
    }
}

