/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client;

import com.ibm.team.apt.api.common.planning.Cardinality;
import com.ibm.team.apt.internal.client.AbstractPlanningAttribute;
import com.ibm.team.apt.internal.client.IPlanningAttributeValueSet;
import com.ibm.team.apt.internal.client.IWorkItemChangeHandler;
import com.ibm.team.apt.internal.client.PlanDeltaBuilder;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.UnsupportedReceiverTypeException;
import com.ibm.team.apt.internal.common.plantype.IAttributeDefinitionDescriptor;
import com.ibm.team.apt.internal.common.util.Collections2;
import com.ibm.team.apt.internal.common.util.UnionIterator;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.internal.registry.LinkTypeRegistry;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemReferences;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.model.ReferencesChangeDetails;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;

public class ReferenceAttribute
extends AbstractPlanningAttribute<PlanItem, List<IReference>>
implements IWorkItemChangeHandler {
    public static final String LINK_TYPE = "linkType";
    public static final String IS_SOURCE = "isSource";
    private static final IPlanningAttributeValueSet<List<IReference>> EMPTY = new IPlanningAttributeValueSet.EmptyValueSet<List<IReference>>();
    private String fLinkType = this.getParameter("linkType");
    private boolean fIsSource;

    public ReferenceAttribute(IAttributeDefinitionDescriptor attributeDescriptor) {
        super(attributeDescriptor);
        Assert.isNotNull((Object)this.fLinkType);
        String isSource = this.getParameter(IS_SOURCE);
        this.fIsSource = isSource == null || Boolean.valueOf(isSource) != false;
    }

    @Override
    public void initialize(PlanElement planElement, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemClient workItemClient = PlanningClientPlugin.getWorkItemClient(planElement.getPlan().getTeamRepository());
        List<PlanElement> planElements = PlanElement.collect(planElement);
        List workItems = Collections2.map(planElements, (Collections2.IMapping)new Collections2.IMapping<PlanElement, IWorkItem>(){

            public IWorkItem map(PlanElement element) {
                WorkItemWorkingCopy workingCopy;
                if (!(!(element instanceof PlanItem) || (workingCopy = ((PlanItem)element).getWorkItemWorkingCopy(false)).isReferencesSet() && workingCopy.getReferences().hasReferences(ReferenceAttribute.this.getEndPointDescriptor()))) {
                    return ((PlanItem)element).getWorkItem(false);
                }
                return null;
            }
        }, (boolean)true);
        if (!workItems.isEmpty()) {
            IWorkItemWorkingCopyManager manager = workItemClient.getWorkItemWorkingCopyManager();
            ItemProfile profile = ItemProfile.createProfile((IItemType)IWorkItem.ITEM_TYPE, Collections.emptyList(), Arrays.asList(this.fLinkType));
            manager.connectCurrent(workItems, profile, monitor);
            for (IWorkItem workItem : workItems) {
                manager.disconnect((IWorkItemHandle)workItem);
            }
        }
    }

    @Override
    public void setValue(PlanItem receiver, List<IReference> value) throws UnsupportedReceiverTypeException {
        IWorkItemReferences references = receiver.getWorkItemWorkingCopy(true).getReferences();
        IEndPointDescriptor otherEndPointDescriptor = this.getOtherEndPointDescriptor();
        for (IReference reference : value) {
            if (otherEndPointDescriptor.isMultiValued()) {
                references.add(otherEndPointDescriptor, reference);
                continue;
            }
            references.set(otherEndPointDescriptor, reference);
        }
    }

    @Override
    public List<IReference> getValue(PlanItem receiver) throws UnsupportedReceiverTypeException {
        WorkItemWorkingCopy workingCopy = receiver.getWorkItemWorkingCopy(false);
        if (workingCopy.isReferencesSet()) {
            IWorkItemReferences references = workingCopy.getReferences();
            return references.getReferences(this.getEndPointDescriptor());
        }
        return Collections.emptyList();
    }

    @Override
    public IPlanningAttributeValueSet<List<IReference>> getValueSet() {
        return EMPTY;
    }

    @Override
    public boolean acceptWorkItemChangeEvent(PlanElement planElement, WorkItemChangeEvent event) {
        return planElement instanceof PlanItem && event.affects("references");
    }

    @Override
    public void handleWorkItemChangeEvent(PlanElement planElement, PlanDeltaBuilder builder, WorkItemChangeEvent event) {
        PlanItem planItem = (PlanItem)planElement;
        IAdaptable adaptable = event.getAttributeChangeDetails("references");
        if (adaptable == null) {
            return;
        }
        ReferencesChangeDetails change = (ReferencesChangeDetails)adaptable.getAdapter(ReferencesChangeDetails.class);
        boolean affected = false;
        UnionIterator unionIter = new UnionIterator(change.getAdded().iterator(), new Iterator[]{change.getRemoved().iterator()});
        while (!affected && unionIter.hasNext()) {
            IReference reference = (IReference)unionIter.next();
            affected |= reference.getLink().getLinkTypeId().equals(this.getLinkType());
        }
        if (affected) {
            List<IReference> newValue = this.getValue(planItem);
            ArrayList<IReference> oldValue = new ArrayList<IReference>(newValue);
            oldValue.removeAll(change.getAdded());
            oldValue.addAll(change.getRemoved());
            builder.changed(planItem, this, oldValue, newValue);
        }
    }

    public String getLinkType() {
        return this.fLinkType;
    }

    public boolean isSource() {
        return this.fIsSource;
    }

    public IEndPointDescriptor getOtherEndPointDescriptor() {
        ILinkType linkType = LinkTypeRegistry.INSTANCE.getLinkType(this.getLinkType());
        IEndPointDescriptor otherEndPointDescriptor = this.isSource() ? linkType.getSourceEndPointDescriptor() : linkType.getTargetEndPointDescriptor();
        return otherEndPointDescriptor;
    }

    public IEndPointDescriptor getEndPointDescriptor() {
        ILinkType linkType = LinkTypeRegistry.INSTANCE.getLinkType(this.getLinkType());
        IEndPointDescriptor endPointDescriptor = this.isSource() ? linkType.getTargetEndPointDescriptor() : linkType.getSourceEndPointDescriptor();
        return endPointDescriptor;
    }

    @Override
    public Cardinality getCardinality() {
        return Cardinality.Many;
    }

    @Override
    public boolean isDefined(PlanItem receiver) {
        return true;
    }

    @Override
    public boolean isSupported(Class<?> receiverType) {
        return PlanItem.class.isAssignableFrom(receiverType);
    }
}

