/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client;

import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.internal.client.Messages;
import com.ibm.team.apt.internal.common.wiki.IWikiPage;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.fulltext.client.IInformationArtifactFactory;
import com.ibm.team.fulltext.common.model.IInformationArtifact;
import com.ibm.team.fulltext.common.model.InformationArtifactAdapter;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.util.NLS;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.core.runtime.IProgressMonitor;

public class PlanningInformationArtifactFactory
implements IInformationArtifactFactory {
    private static final String PLAN_TYPE = String.valueOf(IIterationPlanRecord.ITEM_TYPE.getNamespaceURI()) + "." + IIterationPlanRecord.ITEM_TYPE.getName();
    private static final String WIKI_TYPE = String.valueOf(IWikiPage.ITEM_TYPE.getNamespaceURI()) + "." + IWikiPage.ITEM_TYPE.getName();

    public IInformationArtifact create(IItem item, boolean isDelete, IProgressMonitor monitor) {
        if (item instanceof IIterationPlanRecord && this.shouldIndex((IIterationPlanRecord)item)) {
            return this.handlePlan((IIterationPlanRecord)item);
        }
        if (item instanceof IWikiPage && this.shouldIndex((IWikiPage)item)) {
            return this.handleWikiPage((IWikiPage)item);
        }
        return null;
    }

    private IInformationArtifact handlePlan(IIterationPlanRecord plan) {
        Location location = Location.itemLocation((IItemHandle)plan, (String)((ITeamRepository)plan.getOrigin()).getRepositoryURI());
        String iterationLabel = null;
        String ownerLabel = null;
        if (plan.getOrigin() instanceof ITeamRepository) {
            IItem owner;
            IProcessAreaHandle ownerHandle;
            IItem iteration;
            IIterationHandle iterationHandle;
            ITeamRepository repository = (ITeamRepository)plan.getOrigin();
            if (plan.isPropertySet(IIterationPlanRecord.ITERATION_PROPERTY) && (iterationHandle = plan.getIteration()) != null && (iteration = repository.itemManager().getSharedItemIfKnown((IItemHandle)iterationHandle)) instanceof IIteration && iteration.isPropertySet("name") && ((iterationLabel = ((IIteration)iteration).getName()) == null || iterationLabel.length() == 0) && iteration.isPropertySet("id")) {
                iterationLabel = ((IIteration)iteration).getId();
            }
            if (plan.isPropertySet(IIterationPlanRecord.OWNER_PROPERTY) && (ownerHandle = plan.getOwner()) != null && (owner = repository.itemManager().getSharedItemIfKnown((IItemHandle)ownerHandle)) instanceof IProcessArea && owner.isPropertySet("name")) {
                ownerLabel = ((IProcessArea)owner).getName();
            }
        }
        String name = iterationLabel != null && iterationLabel.length() > 0 ? NLS.bind((String)Messages.PlanningInformationArtifactFactory_PLAN_ITERATION, (Object)plan.getName(), (Object[])new Object[]{iterationLabel}) : plan.getName();
        URIReference reference = new URIReference(name, "", PLAN_TYPE, location.toAbsoluteUri());
        InformationArtifactAdapter artifact = ownerLabel != null ? new InformationArtifactAdapter(reference, name, (Reader)new StringReader(ownerLabel)) : new InformationArtifactAdapter(reference, name);
        artifact.setContext(plan.getContextId());
        if (plan.isPropertySet(IIterationPlanRecord.OWNER_PROPERTY) && plan.getOwner() != null) {
            artifact.setOwner(plan.getOwner().getItemId());
        }
        return artifact;
    }

    private boolean shouldIndex(IIterationPlanRecord plan) {
        return plan.isPropertySet(IIterationPlanRecord.NAME_PROPERTY) && plan.getName() != null && plan.getName().length() > 0 && plan.getOrigin() != null;
    }

    private IInformationArtifact handleWikiPage(IWikiPage page) {
        Location location = Location.itemLocation((IItemHandle)page, (String)((ITeamRepository)page.getOrigin()).getRepositoryURI());
        URIReference reference = new URIReference(page.getName(), "", WIKI_TYPE, location.toAbsoluteUri());
        InformationArtifactAdapter artifact = new InformationArtifactAdapter(reference, page.getName());
        artifact.setContext(page.getContextId());
        if (page.isPropertySet(IWikiPage.OWNER_PROPERTY) && page.getOwner() != null) {
            artifact.setOwner(page.getOwner().getItemId());
        }
        return artifact;
    }

    private boolean shouldIndex(IWikiPage page) {
        return page.isPropertySet(IWikiPage.NAME_PROPERTY) && page.getName() != null && page.getName().length() > 0 && page.getOrigin() != null;
    }
}

