/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client;

import com.ibm.team.apt.internal.client.AbstractPlanningAttribute;
import com.ibm.team.apt.internal.client.AttributeNotAvailableException;
import com.ibm.team.apt.internal.client.IPlanningAttributeValueSet;
import com.ibm.team.apt.internal.client.IWorkItemChangeHandler;
import com.ibm.team.apt.internal.client.Messages;
import com.ibm.team.apt.internal.client.PlanDeltaBuilder;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.common.plantype.IAttributeDefinitionDescriptor;
import com.ibm.team.apt.internal.common.util.Collections2;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.common.internal.model.ConfigurationItem;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.ChangeDetails;
import com.ibm.team.workitem.common.model.Duration;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IAttributeHandle;
import com.ibm.team.workitem.common.model.IEnumeration;
import com.ibm.team.workitem.common.model.ILiteral;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.osgi.framework.Bundle;

public class PlanItemWorkItemAttribute
extends AbstractPlanningAttribute<PlanItem, Object>
implements IWorkItemChangeHandler {
    private final Identifier<IAttribute> fWorkItemAttributeId;
    private IAttribute fAttribute;
    private IPlanningAttributeValueSet<Object> fValueSet;
    private final boolean fAddCustomAttribute;
    private IEnumeration<? extends ILiteral> fEnumeration;
    private Map<Identifier<ILiteral>, ILiteral> fUnknownLiterals;

    public PlanItemWorkItemAttribute(IAttributeDefinitionDescriptor attributeDescriptor, Identifier<IAttribute> workItemAttributeId, boolean addCustomAttribute) {
        this(attributeDescriptor, workItemAttributeId, addCustomAttribute, new IPlanningAttributeValueSet.EmptyValueSet<Object>());
    }

    public PlanItemWorkItemAttribute(IAttributeDefinitionDescriptor attributeDescriptor, Identifier<IAttribute> workItemAttributeId, boolean addCustomAttribute, IPlanningAttributeValueSet<Object> valueSet) {
        super(attributeDescriptor);
        this.fWorkItemAttributeId = workItemAttributeId;
        this.fAddCustomAttribute = addCustomAttribute;
        this.fValueSet = valueSet;
    }

    public IAttribute getAttribute() {
        return this.fAttribute;
    }

    @Override
    public IPlanningAttributeValueSet<Object> getValueSet() {
        return this.fValueSet;
    }

    @Override
    public boolean acceptWorkItemChangeEvent(PlanElement planElement, WorkItemChangeEvent event) {
        return this.getAttribute() != null && (ChangeDetails)event.getAttributeChangeDetails(this.getAttribute().getIdentifier()) != null;
    }

    @Override
    public void handleWorkItemChangeEvent(PlanElement planElement, PlanDeltaBuilder builder, WorkItemChangeEvent event) {
        ChangeDetails changeDetails = (ChangeDetails)event.getAttributeChangeDetails(this.getAttribute().getIdentifier());
        builder.changed(planElement, this, this.convertToPlanItem(changeDetails.getOldValue()), this.convertToPlanItem(changeDetails.getNewValue()));
    }

    @Override
    public void initialize(PlanElement planElement, IProgressMonitor monitor) throws TeamRepositoryException {
        List<PlanElement> planElements;
        List workItems;
        IWorkItemClient workItemClient = PlanningClientPlugin.getWorkItemClient(planElement.getPlan().getTeamRepository());
        this.fAttribute = workItemClient.findAttribute(planElement.getPlan().getProjectAreaHandle(), this.fWorkItemAttributeId.getStringIdentifier(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        if (this.fAttribute != null) {
            if (AttributeTypes.isEnumerationAttributeType((String)this.fAttribute.getAttributeType())) {
                this.fEnumeration = workItemClient.resolveEnumeration((IAttributeHandle)this.fAttribute, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.fEnumeration = workItemClient.resolveEnumeration((IAttributeHandle)this.fAttribute, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (this.fEnumeration != null) {
                    this.fValueSet = new IPlanningAttributeValueSet<Object>(){

                        @Override
                        public List<Object> getValues() {
                            return PlanItemWorkItemAttribute.this.fEnumeration.getEnumerationLiterals(false);
                        }

                        @Override
                        public Object getValue(String valueId) {
                            List literals = PlanItemWorkItemAttribute.this.fEnumeration.getEnumerationLiterals();
                            for (ILiteral literal : literals) {
                                if (!literal.getIdentifier2().getStringIdentifier().equals(valueId)) continue;
                                return literal;
                            }
                            return null;
                        }

                        @Override
                        public Object getNullValue() {
                            return PlanItemWorkItemAttribute.this.fEnumeration.findNullEnumerationLiteral();
                        }

                        @Override
                        public Collection<Object> getAllValues() {
                            return this.getValues();
                        }
                    };
                }
            }
        } else {
            PlanningClientPlugin.log((IStatus)new Status(4, PlanningClientPlugin.getPluginId(), NLS.bind((String)Messages.PlanItemWorkItemAttribute_UNKNOWN_WORKITEM_ATTRIBUTE, (Object)this.getId(), (Object[])new Object[]{this.fWorkItemAttributeId.getStringIdentifier()})));
        }
        if (this.fValueSet == null) {
            this.fValueSet = new IPlanningAttributeValueSet.EmptyValueSet<Object>();
        }
        if (!(workItems = Collections2.map(planElements = PlanElement.collect(planElement), (Collections2.IMapping)new Collections2.IMapping<PlanElement, IWorkItem>(){

            public IWorkItem map(PlanElement element) {
                IWorkItem workItem;
                if (element instanceof PlanItem && (workItem = ((PlanItem)element).getWorkItem(false)).hasAttribute(PlanItemWorkItemAttribute.this.getAttribute()) && !workItem.isAttributeSet(PlanItemWorkItemAttribute.this.getAttribute())) {
                    return workItem;
                }
                return null;
            }
        }, (boolean)true)).isEmpty()) {
            IWorkItemWorkingCopyManager manager = workItemClient.getWorkItemWorkingCopyManager();
            ItemProfile profile = ItemProfile.createProfile((IItemType)IWorkItem.ITEM_TYPE, Collections.singleton(this.getAttribute().getIdentifier()));
            manager.connectCurrent(workItems, profile, monitor);
            for (IWorkItem workItem : workItems) {
                manager.disconnect((IWorkItemHandle)workItem);
            }
        }
    }

    @Override
    public Object getValue(PlanItem receiver) {
        if (this.fAttribute == null || !receiver.getWorkItem(false).hasAttribute(this.fAttribute)) {
            throw new AttributeNotAvailableException(this);
        }
        return this.convertToPlanItem(receiver.getWorkItem(false).getValue(this.fAttribute));
    }

    @Override
    public void setValue(PlanItem receiver, Object value) {
        if (this.fAttribute != null) {
            if (!receiver.getWorkItem(false).hasAttribute(this.fAttribute)) {
                if (!this.fAddCustomAttribute) {
                    return;
                }
                receiver.getWorkItem(true).addCustomAttribute(this.fAttribute);
            }
            receiver.getWorkItem(true).setValue(this.fAttribute, this.convertToWorkItem(value));
        }
    }

    @Override
    public boolean isSupported(Class<?> receiverType) {
        return PlanItem.class.isAssignableFrom(receiverType);
    }

    @Override
    public boolean isDefined(PlanItem receiver) {
        return this.fAttribute != null && receiver.getWorkItem(false).isAttributeSet(this.fAttribute);
    }

    private Object convertToPlanItem(Object value) {
        switch (this.getAttributeType()) {
            case ENUMERATION: {
                if (value != null) {
                    Identifier identifier = (Identifier)value;
                    ILiteral literal = this.fEnumeration.findEnumerationLiteral(identifier);
                    if (literal == null) {
                        if (this.fUnknownLiterals == null) {
                            this.fUnknownLiterals = new HashMap<Identifier<ILiteral>, ILiteral>();
                        }
                        if ((literal = this.fUnknownLiterals.get(identifier)) == null) {
                            URL unknownLiteralUrl = FileLocator.find((Bundle)Platform.getBundle((String)"com.ibm.team.apt.common"), (IPath)new Path("icons/obj16/unknown.png"), null);
                            literal = new ConfigurationItem(null, identifier.getStringIdentifier(), identifier.getStringIdentifier(), unknownLiteralUrl, Integer.MAX_VALUE - this.fUnknownLiterals.size());
                            this.fUnknownLiterals.put((Identifier<ILiteral>)identifier, literal);
                        }
                    }
                    return literal;
                }
                return null;
            }
            case DURATION: {
                return value != null ? new Duration(((Long)value).longValue()) : Duration.UNSPECIFIED;
            }
        }
        return value;
    }

    private Object convertToWorkItem(Object value) {
        switch (this.getAttributeType()) {
            case TAGS: {
                if (value != null && value.getClass().isArray()) {
                    ArrayList<String> result = new ArrayList<String>();
                    int i = 0;
                    while (i < Array.getLength(value)) {
                        Object element = Array.get(value, i);
                        if (element instanceof String) {
                            result.add((String)element);
                        }
                        ++i;
                    }
                    return result;
                }
                return value;
            }
            case ENUMERATION: {
                return value != null ? ((ILiteral)value).getIdentifier2() : null;
            }
            case DURATION: {
                return value != null ? Long.valueOf(((Duration)value).longValue()) : null;
            }
            case INTEGER: {
                if (!(value instanceof Number)) {
                    return value;
                }
                String workItemType = this.fAttribute.getAttributeType();
                if ("integer".equals(workItemType)) {
                    return new Integer(((Number)value).intValue());
                }
                if (!"long".equals(workItemType)) break;
                return new Long(((Number)value).longValue());
            }
        }
        return value;
    }
}

