/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client;

import com.ibm.team.apt.api.common.workitem.IDuration;
import com.ibm.team.apt.internal.client.EstimateMode;
import com.ibm.team.apt.internal.client.IPlanningAttribute;
import com.ibm.team.apt.internal.client.IPlanningAttributeIdentifier;
import com.ibm.team.apt.internal.client.IScheduleItem;
import com.ibm.team.apt.internal.client.IWorkItemChangeHandler;
import com.ibm.team.apt.internal.client.ItemSequenceManager;
import com.ibm.team.apt.internal.client.PlanDeltaBuilder;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanningAttributeIdentifier;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.client.planchecker.PlanCheckReport;
import com.ibm.team.apt.internal.client.planchecker.PlanItemPlanCheckReport;
import com.ibm.team.apt.internal.client.testing.IPlanItemTestAccess;
import com.ibm.team.apt.internal.client.util.Tags;
import com.ibm.team.apt.internal.client.util.WorkItems;
import com.ibm.team.apt.internal.common.Timespan;
import com.ibm.team.apt.internal.common.duration.PlanDuration;
import com.ibm.team.apt.internal.common.util.Dates;
import com.ibm.team.apt.internal.common.util.ItemList;
import com.ibm.team.feed.core.FeedManager;
import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.feed.core.model.NewsItem;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.foundation.rcp.core.IReadStateTracker;
import com.ibm.team.foundation.rcp.core.readstate.ReadStateChangeEvent;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.Auditable;
import com.ibm.team.repository.common.util.CollatorCache;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.WorkflowUtilities;
import com.ibm.team.workitem.client.internal.WorkItemWorkingCopyImpl;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import com.ibm.team.workitem.common.internal.util.SequenceValue;
import com.ibm.team.workitem.common.model.ChangeDetails;
import com.ibm.team.workitem.common.model.Duration;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.IPriority;
import com.ibm.team.workitem.common.model.ISeverity;
import com.ibm.team.workitem.common.model.IState;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.workflow.IWorkflowAction;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class PlanItem
extends PlanElement
implements IScheduleItem {
    public static final IPlanningAttributeIdentifier ID = PlanningAttributeIdentifier.create("com.ibm.team.apt.attribute.planitem.id");
    public static final IPlanningAttributeIdentifier ITEM_TYPE = PlanningAttributeIdentifier.create("com.ibm.team.apt.attribute.planitem.itemType");
    public static final IPlanningAttributeIdentifier DESCRIPTION = PlanningAttributeIdentifier.create("com.ibm.team.apt.attribute.planitem.description");
    public static final IPlanningAttributeIdentifier CREATOR = PlanningAttributeIdentifier.create("com.ibm.team.apt.attribute.planitem.creator");
    public static final IPlanningAttributeIdentifier CATEGORY = PlanningAttributeIdentifier.create("com.ibm.team.apt.attribute.planitem.filedAgainst");
    public static final IPlanningAttributeIdentifier TARGET = PlanningAttributeIdentifier.create("com.ibm.team.apt.attribute.planitem.plannedFor");
    public static final IPlanningAttributeIdentifier TIMELINE = PlanningAttributeIdentifier.create("com.ibm.team.apt.attribute.planitem.timeline");
    public static final IPlanningAttributeIdentifier PRIMARY_TAG = PlanningAttributeIdentifier.create("com.ibm.team.apt.attribute.planitem.primaryTag");
    public static final IPlanningAttributeIdentifier TAGS = PlanningAttributeIdentifier.create("com.ibm.team.apt.attribute.planitem.tags");
    public static final IPlanningAttributeIdentifier STATE = PlanningAttributeIdentifier.create("com.ibm.team.apt.attribute.planitem.state");
    public static final IPlanningAttributeIdentifier WORKFLOW_ACTION = PlanningAttributeIdentifier.create("com.ibm.team.apt.attribute.planitem.workflowAction");
    public static final IPlanningAttributeIdentifier PRIORITY = PlanningAttributeIdentifier.create("com.ibm.team.apt.attribute.planitem.priority");
    public static final IPlanningAttributeIdentifier SEVERITY = PlanningAttributeIdentifier.create("com.ibm.team.apt.attribute.planitem.severity");
    public static final IPlanningAttributeIdentifier COMPLEXITY = PlanningAttributeIdentifier.create("com.ibm.team.apt.attribute.planitem.complexity");
    public static final IPlanningAttributeIdentifier ESTIMATE = PlanningAttributeIdentifier.create("com.ibm.team.apt.attribute.planitem.estimate");
    public static final IPlanningAttributeIdentifier EFFORT = PlanningAttributeIdentifier.create("com.ibm.team.apt.attribute.planitem.effort");
    public static final IPlanningAttributeIdentifier MINIMAL_ESTIMATE = PlanningAttributeIdentifier.create("com.ibm.team.apt.attribute.planitem.minimalEstimate");
    public static final IPlanningAttributeIdentifier MAXIMAL_ESTIMATE = PlanningAttributeIdentifier.create("com.ibm.team.apt.attribute.planitem.maximalEstimate");
    public static final IPlanningAttributeIdentifier ORIGINAL_ESTIMATE = PlanningAttributeIdentifier.create("com.ibm.team.apt.attribute.planitem.originalEstimate");
    public static final IPlanningAttributeIdentifier CORRECTED_ESTIMATE = PlanningAttributeIdentifier.create("com.ibm.team.apt.attribute.planitem.correctedEstimate");
    public static final IPlanningAttributeIdentifier TIMESPENT = PlanningAttributeIdentifier.create("com.ibm.team.apt.attribute.planitem.timeSpent");
    @Deprecated
    public static final IPlanningAttributeIdentifier DURATION = PlanningAttributeIdentifier.create("com.ibm.team.apt.attribute.planitem.duration");
    public static final IPlanningAttributeIdentifier DUE_DATE = PlanningAttributeIdentifier.create("com.ibm.team.apt.attribute.planitem.dueDate");
    public static final IPlanningAttributeIdentifier RESOLUTION_DATE = PlanningAttributeIdentifier.create("com.ibm.team.apt.attribute.planitem.resolutionDate");
    public static final IPlanningAttributeIdentifier CREATION_DATE = PlanningAttributeIdentifier.create("com.ibm.team.apt.attribute.planitem.creationDate");
    public static final IPlanningAttributeIdentifier DRAFT_ITEM = PlanningAttributeIdentifier.create("com.ibm.team.apt.attribute.planitem.draftItem");
    public static final IPlanningAttributeIdentifier AUXILIARY_ITEM = PlanningAttributeIdentifier.create("com.ibm.team.apt.attribute.planitem.auxiliaryItem");
    public static final IPlanningAttributeIdentifier PARENT = PlanningAttributeIdentifier.create("com.ibm.team.apt.attribute.planitem.parent");
    public static final IPlanningAttributeIdentifier MARKED_READ = PlanningAttributeIdentifier.create("com.ibm.team.apt.attribute.planitem.markedRead");
    public static final IPlanningAttributeIdentifier NEW_ITEM = PlanningAttributeIdentifier.create("com.ibm.team.apt.attribute.planitem.newItem");
    public static final IPlanningAttributeIdentifier NEW_RANKING = PlanningAttributeIdentifier.create("com.ibm.team.apt.attribute.planitem.newRanking");
    public static final IPlanningAttributeIdentifier TEAM_MEMBER_AREA = PlanningAttributeIdentifier.create("com.ibm.team.apt.attribute.planitem.teamMemberArea");
    public static final IPlanningAttributeIdentifier CONSTRAINT_DATE = PlanningAttributeIdentifier.create("com.ibm.team.apt.attribute.planitem.constraintDate");
    public static final IPlanningAttributeIdentifier CONSTRAINT_TYPE = PlanningAttributeIdentifier.create("com.ibm.team.apt.attribute.planitem.constraintType");
    private final Object fWriteableLock = new Object();
    private volatile boolean fIsWriteable;
    private final AtomicInteger fWriteTrackingCount = new AtomicInteger();
    protected ResolvedPlan fPlan;
    protected PlanElement fParent;
    protected SequenceValue fSequenceValue;
    private final WorkItemWorkingCopy fWorkingCopy;
    protected final UUID fWorkItemId;
    protected PlanDuration fDuration;
    protected Boolean fIsOpen;
    protected Boolean fIsInProgress;
    protected Boolean fIsResolved;
    protected Object fTagsLock = new Object();
    protected List<String> fParsedTags;
    protected IPriority fPriority;
    protected ISeverity fSeverity;
    protected final Set<IPlanningAttributeIdentifier> fChangedAttributes;
    private Identifier<IWorkflowAction> fWorkflowAction;

    public PlanItem(WorkItemWorkingCopy wc, ResolvedPlan plan, PlanElement parent) {
        Assert.isNotNull((Object)((Object)plan));
        this.fPlan = plan;
        this.fParent = parent;
        this.fWorkingCopy = wc;
        this.fWorkItemId = wc.getWorkItem().getItemId();
        WorkItem workItem = (WorkItem)this.fWorkingCopy.getWorkItem();
        this.fDuration = new PlanDuration(workItem.getDuration(), workItem.getCorrectedEstimate(), workItem.getTimeSpent(), this.isResolved());
        this.fChangedAttributes = new HashSet<IPlanningAttributeIdentifier>();
        this.fWorkflowAction = wc.getWorkflowAction() == null ? null : Identifier.create(IWorkflowAction.class, (String)wc.getWorkflowAction());
        this.readSequenceValue();
    }

    public boolean isConnected() {
        return this.getWorkItem(false) != null;
    }

    public IWorkItemHandle getWorkItemHandle() {
        IWorkItem workItem = this.getWorkItem(false);
        return (IWorkItemHandle)(workItem != null ? workItem.getItemHandle() : null);
    }

    public IWorkItem getWorkItem(boolean writeable) {
        return this.getWorkItemWorkingCopy(writeable).getWorkItem();
    }

    WorkItemWorkingCopy getWorkItemWorkingCopy(boolean writeable) {
        if (writeable) {
            this.ensureWriteable();
        }
        return this.fWorkingCopy;
    }

    boolean isWriteable() {
        return this.fIsWriteable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureWriteable() {
        Object object = this.fWriteableLock;
        synchronized (object) {
            if (!this.isWriteable()) {
                IWorkItemWorkingCopyManager workingCopyManager = this.fPlan.getWorkingCopyManager(false);
                boolean success = workingCopyManager.connectLocal(this.getWorkItemHandle(), this.getPlan().getWorkItemProfile());
                Assert.isTrue((boolean)success);
                this.fIsWriteable = true;
                this.handleWriteableStateChanged(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeWriteAbility(boolean forceRevert) {
        Object object = this.fWriteableLock;
        synchronized (object) {
            IWorkItemHandle workItemHandle;
            if (this.isWriteable() && this.fWriteTrackingCount.get() == 0 && (workItemHandle = this.getWorkItemHandle()) != null) {
                IWorkItemWorkingCopyManager workingCopyManager = this.fPlan.getWorkingCopyManager(false);
                WorkItemWorkingCopyImpl workingCopy = (WorkItemWorkingCopyImpl)this.getWorkItemWorkingCopy(false);
                this.fIsWriteable = false;
                if (workingCopy.isDirty() && (forceRevert || !workingCopy.hasOtherWriteConnection(workingCopyManager))) {
                    workingCopyManager.revert(workItemHandle);
                }
                workingCopyManager.disconnect(workItemHandle);
                this.handleWriteableStateChanged(false);
            }
        }
    }

    public void modified() {
        if (this.isWriteable()) {
            return;
        }
        this.ensureWriteable();
        if (this.isDirty()) {
            try {
                PlanDeltaBuilder deltaBuilder = this.getPlan().connectDeltaBuilder();
                deltaBuilder.changed(this, DIRTY, false, true);
            }
            finally {
                this.getPlan().disconnectDeltaBuilder();
            }
        }
    }

    public void startWriteTracking() {
        this.fWriteTrackingCount.incrementAndGet();
        if (this.fPlan.isConnected()) {
            this.ensureWriteable();
        }
    }

    public void endWriteTracking() {
        if (this.fWriteTrackingCount.decrementAndGet() == 0 && this.fPlan.isConnected() && !this.isDirty()) {
            this.removeWriteAbility(false);
        }
    }

    protected void handleWriteableStateChanged(boolean isWriteable) {
    }

    public UUID getWorkItemId() {
        return this.fWorkItemId;
    }

    public int getId() {
        return this.getWorkItem(false).getId();
    }

    @Override
    public boolean isDirty() {
        return this.isWriteable() && this.getWorkItemWorkingCopy(false).isDirty();
    }

    public boolean isDraftItem() {
        return ((Auditable)this.getWorkItem(false)).getWorkingCopyPredecessor() == null;
    }

    public IWorkflowInfo getWorkflowInfo() {
        return WorkflowUtilities.findCachedWorkflowInfo((IWorkItem)this.getWorkItem(false));
    }

    public void setItemType(String type) {
        this.getWorkItem(true).setWorkItemType(type);
    }

    public IWorkItemType getItemType() {
        return this.fPlan.getResolvedWorkItemType(this.getWorkItem(false).getWorkItemType());
    }

    @Override
    public String getSummary() {
        return this.getHTMLSummary().getXMLText();
    }

    @Override
    public XMLString getHTMLSummary() {
        return this.getWorkItem(false).getHTMLSummary();
    }

    @Override
    public void setSummary(String summary) {
        this.setHTMLSummary(XMLString.createFromXMLText((String)summary));
    }

    @Override
    public void setHTMLSummary(XMLString summary) {
        this.getWorkItem(true).setHTMLSummary(summary);
    }

    public String getDescription() {
        return this.getHTMLDescription().getXMLText();
    }

    public XMLString getHTMLDescription() {
        return this.getWorkItem(false).getHTMLDescription();
    }

    public void setDescription(String description) {
        this.setHTMLDescription(XMLString.createFromXMLText((String)description));
    }

    public void setHTMLDescription(XMLString description) {
        this.getWorkItem(true).setHTMLDescription(description);
    }

    @Override
    public IContributor getOwner() {
        IContributorHandle handle = this.getWorkItem(false).getOwner();
        return this.fPlan.getResolvedContributor(handle);
    }

    public IContributorHandle getOwnerHandle() {
        return this.getWorkItem(false).getOwner();
    }

    public IContributor getCreator() {
        IContributorHandle handle = this.getWorkItem(false).getCreator();
        return this.fPlan.getResolvedContributor(handle);
    }

    public Date getModificationDate() {
        Date result = null;
        WorkItemWorkingCopyImpl workigCopy = (WorkItemWorkingCopyImpl)this.getWorkItemWorkingCopy(false);
        if (workigCopy != null) {
            if (!this.isDraftItem() && workigCopy.getBaseState() != null) {
                result = workigCopy.getBaseState().modified();
            }
            if (result == null) {
                result = workigCopy.getWorkItem().modified();
            }
        }
        return result;
    }

    public Timestamp getResolutionDate() {
        return this.getWorkItem(false).getResolutionDate();
    }

    public Timestamp getCreationDate() {
        return this.getWorkItem(false).getCreationDate();
    }

    @Override
    public void setOwner(IContributor owner) {
        this.fPlan.addResolvedOwner(owner);
        this.getWorkItem(true).setOwner((IContributorHandle)owner.getItemHandle());
    }

    public void setWorkflowAction(Identifier<IWorkflowAction> action) {
        WorkItemWorkingCopy workItem = this.getWorkItemWorkingCopy(true);
        if (action == null) {
            workItem.setWorkflowAction(null);
        } else {
            workItem.setWorkflowAction(action.getStringIdentifier());
        }
    }

    void internalSetWorkflowAction(Identifier<IWorkflowAction> action) {
        this.fWorkflowAction = action;
    }

    public Identifier<IWorkflowAction> getWorkflowAction() {
        return this.fWorkflowAction;
    }

    public ICategory getCategory() {
        ICategoryHandle handle = this.getWorkItem(false).getCategory();
        return this.fPlan.getResolvedCategory(handle);
    }

    public ICategoryHandle getCategoryHandle() {
        return this.getWorkItem(false).getCategory();
    }

    public void setCategory(ICategory category) {
        this.fPlan.addResolvedCategory(category);
        this.getWorkItem(true).setCategory((ICategoryHandle)category);
    }

    public IIteration getTarget() {
        IIterationHandle handle = this.getWorkItem(false).getTarget();
        if (handle == null) {
            return null;
        }
        return this.fPlan.getResolvedIteration(handle);
    }

    public IDevelopmentLine getTimeline() {
        IIteration target = this.getTarget();
        if (target == null) {
            return null;
        }
        return this.fPlan.getResolvedDevelopmentLine(target.getDevelopmentLine());
    }

    public IIterationHandle getTargetHandle() {
        return this.getWorkItem(false).getTarget();
    }

    public void setTarget(IIteration target) {
        if (target != null) {
            this.fPlan.addResolvedIteration(target);
        }
        this.getWorkItem(true).setTarget((IIterationHandle)target);
    }

    public abstract ItemList<IIteration> getRelatedIterations();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTags() {
        Object object = this.fTagsLock;
        synchronized (object) {
            this.ensureTagsParsed();
            return this.fParsedTags.toArray(new String[this.fParsedTags.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTags(String[] tags) {
        Object object = this.fTagsLock;
        synchronized (object) {
            this.getWorkItem(true).setTags(Tags.printTags(Arrays.asList(tags)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasTag(String tag) {
        Object object = this.fTagsLock;
        synchronized (object) {
            this.ensureTagsParsed();
            return this.fParsedTags.contains(tag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toggleTag(String tag) {
        Object object = this.fTagsLock;
        synchronized (object) {
            this.ensureTagsParsed();
            ArrayList<String> newTags = new ArrayList<String>(this.fParsedTags);
            if (this.fParsedTags.contains(tag)) {
                newTags.remove(tag);
            } else {
                newTags.add(tag);
            }
            this.setTags(newTags.toArray(new String[newTags.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPrimaryTag() {
        Object object = this.fTagsLock;
        synchronized (object) {
            this.ensureTagsParsed();
            return this.fParsedTags.size() > 0 ? this.fParsedTags.get(0) : Tags.NO_TAGS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrimaryTag(String tag) {
        Object object = this.fTagsLock;
        synchronized (object) {
            boolean isNoTag = CollatorCache.getInstance().equals(Tags.NO_TAGS, tag);
            this.ensureTagsParsed();
            ArrayList<String> newTags = new ArrayList<String>(this.fParsedTags);
            if (newTags.size() > 0) {
                if (isNoTag) {
                    newTags.remove(0);
                } else {
                    newTags.set(0, tag);
                }
            } else if (!isNoTag) {
                newTags.add(tag);
            }
            this.setTags(newTags.toArray(new String[newTags.size()]));
        }
    }

    @Override
    public ItemSequenceManager getSequenceManager() {
        return this.fPlan.getItemSequenceManager(this);
    }

    @Override
    public Timespan getScheduledTime() {
        ItemSequenceManager sequenceManager = this.getSequenceManager();
        return sequenceManager != null ? sequenceManager.getScheduledTime(this) : null;
    }

    public void schedule(PlanItem before, PlanItem after) {
        ItemSequenceManager sequenceManager = this.getSequenceManager();
        if (sequenceManager != null) {
            sequenceManager.schedule(this, before, after);
        }
    }

    public void schedule(Date when) {
        ItemSequenceManager sequenceManager = this.getSequenceManager();
        if (sequenceManager != null) {
            sequenceManager.schedule(this, when);
        }
    }

    public PlanDuration getDuration() {
        return this.fDuration;
    }

    public void setDuration(Duration duration) {
        if (this.isResolved()) {
            this.setTimeSpent(duration);
        } else {
            this.setEstimate(duration);
        }
    }

    public Duration getEstimate() {
        return this.isEstimateCorrected() ? this.getCorrectedEstimate() : this.getOriginalEstimate();
    }

    public Duration getEffort() {
        if (this.getPlan().getDurationSupport().getEstimateMode() == EstimateMode.TimeRemaining) {
            return new Duration(this.getDuration().getTimeRemainingDuration());
        }
        return new Duration(this.getDuration().getTimeSpentDuration());
    }

    public boolean isEstimateCorrected() {
        return this.fDuration.isOriginalEstimateFixed();
    }

    public void setEstimate(Duration duration) {
        WorkItem workItem = (WorkItem)this.getWorkItem(true);
        if (!duration.isSpecified()) {
            workItem.setDuration(Duration.UNSPECIFIED.longValue());
            workItem.setCorrectedEstimate(Duration.UNSPECIFIED.longValue());
        } else {
            IDuration originalEstimate = this.fDuration.getOriginalEstimate();
            if (originalEstimate == null || !originalEstimate.isSpecified()) {
                workItem.setDuration(duration.longValue());
            } else {
                workItem.setCorrectedEstimate(duration.longValue());
            }
        }
    }

    public void setEffort(Duration effort) {
        this.getPlan().getDurationSupport().setCurrentDuration(this.getWorkItem(true), this.isResolved(), effort.longValue());
    }

    public Duration getOriginalEstimate() {
        return new Duration(this.getWorkItem(false).getDuration());
    }

    public void setOriginalEstimate(Duration duration) {
        if (this.isEstimateCorrected()) {
            throw new IllegalStateException("Can't change original estimate anymore");
        }
        this.getWorkItem(true).setDuration(duration.longValue());
    }

    public Duration getCorrectedEstimate() {
        return new Duration(((WorkItem)this.getWorkItem(false)).getCorrectedEstimate());
    }

    public void setCorrectedEstimate(Duration duration) {
        WorkItem workItem = (WorkItem)this.getWorkItem(true);
        workItem.setCorrectedEstimate(duration.longValue());
    }

    public Duration getTimeSpent() {
        return new Duration(((WorkItem)this.getWorkItem(false)).getTimeSpent());
    }

    public void setTimeSpent(Duration duration) {
        ((WorkItem)this.getWorkItem(true)).setTimeSpent(duration.longValue());
    }

    public Timestamp getDueDate() {
        return this.getWorkItem(false).getDueDate();
    }

    public void setDueDate(Timestamp dueDate) {
        this.getWorkItem(true).setDueDate(dueDate);
    }

    public boolean isMarkedRead() {
        IReadStateTracker readStateTracker = this.getReadStateTracker();
        return readStateTracker != null ? readStateTracker.isMarkedRead() : true;
    }

    public void markRead() {
        IReadStateTracker readStateTracker = this.getReadStateTracker();
        if (readStateTracker != null) {
            readStateTracker.markRead();
        }
    }

    public void markUnread() {
        IReadStateTracker readStateTracker = this.getReadStateTracker();
        if (readStateTracker != null) {
            readStateTracker.markUnread();
        }
    }

    public boolean isNewItem() {
        return (!this.isResolved() || this.isDraftItem()) && this.getSequenceValue().isNew();
    }

    public void markAsNewItem(boolean isNew) {
        ItemSequenceManager sequenceManager = this.getSequenceManager();
        if (sequenceManager != null) {
            sequenceManager.unschedule(this, !isNew);
        }
    }

    @Override
    public boolean isOpen() {
        if (this.fIsOpen == null) {
            this.fIsOpen = this.fPlan.isOpen(this) ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.fIsOpen;
    }

    @Override
    public boolean isInProgress() {
        if (this.fIsInProgress == null) {
            this.fIsInProgress = this.fPlan.isInProgress(this) ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.fIsInProgress;
    }

    @Override
    public boolean isResolved() {
        if (this.fIsResolved == null) {
            this.fIsResolved = this.fPlan.isClosed(this) ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.fIsResolved;
    }

    public boolean countAsOpen() {
        if (this.isAuxiliaryPlanItem()) {
            return false;
        }
        return this.isOpen() || this.isInProgress();
    }

    public boolean countAsResolved() {
        if (this.isAuxiliaryPlanItem()) {
            return false;
        }
        return this.isResolved();
    }

    public Identifier<IState> getState() {
        return this.getWorkItem(false).getState2();
    }

    public void resolve() {
        Identifier resolveActionId;
        String resolveAction = null;
        IWorkflowInfo workflowInfo = this.getWorkflowInfo();
        if (workflowInfo != null && (resolveActionId = workflowInfo.getResolveActionId()) != null) {
            resolveAction = resolveActionId.getStringIdentifier();
        }
        this.getWorkItemWorkingCopy(true).setWorkflowAction(resolveAction);
        this.resetCachedState();
    }

    public void reopen() {
        Identifier reopenActionId2;
        String reopenAction = null;
        IWorkflowInfo workflowInfo = this.getWorkflowInfo();
        if (workflowInfo != null && (reopenActionId2 = workflowInfo.getReopenActionId()) != null) {
            reopenAction = reopenActionId2.getStringIdentifier();
        }
        this.getWorkItemWorkingCopy(true).setWorkflowAction(reopenAction);
        this.resetCachedState();
    }

    public boolean isGroupItem() {
        return this.hasChildren();
    }

    public abstract boolean canHaveChildren();

    public abstract boolean isAuxiliaryPlanItem();

    @Override
    public abstract boolean isPrimaryPlanItem();

    public List<String> getAuxiliaryPlanItemReasons(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getPlan().getUnrelevantWorkItemReasons(this.getWorkItem(false), monitor);
    }

    public abstract boolean isProgressPlanItem();

    public abstract boolean isTopLevelPlanItem();

    public void revert() {
        this.removeWriteAbility(true);
    }

    @Override
    public ResolvedPlan getPlan() {
        return this.fPlan;
    }

    @Override
    public PlanItemPlanCheckReport getPlanCheckReport() {
        PlanCheckReport checkerReport = this.fPlan.getPlanCheckReport();
        return checkerReport != null ? checkerReport.getReport(this) : null;
    }

    @Override
    public PlanElement getParent() {
        return this.fParent;
    }

    @Override
    protected void doChildAdded(PlanElement parent, PlanElement child) {
        this.fPlan.doChildAdded(parent, child);
    }

    @Override
    protected void doChildRemoved(PlanElement parent, PlanElement child) {
        this.fPlan.doChildRemoved(parent, child);
    }

    @Override
    public void moveTo(PlanElement newParent) {
        PlanElement parent = this.getParent();
        if (parent == null) {
            throw new IllegalStateException();
        }
        if (newParent != this.fParent) {
            PlanDeltaBuilder builder = this.fPlan.connectDeltaBuilder();
            try {
                builder.aboutToMove(parent, newParent);
                parent.removeChild(this);
                this.fParent = newParent;
                newParent.addChild(this);
                builder.moved();
            }
            finally {
                this.fPlan.disconnectDeltaBuilder();
            }
        }
    }

    public Object getAdapter(Class adapter) {
        if (IWorkItem.class.equals((Object)adapter)) {
            return this.getWorkItem(false);
        }
        if (WorkItemWorkingCopy.class.equals((Object)adapter)) {
            return this.getWorkItemWorkingCopy(false);
        }
        return super.getAdapter(adapter);
    }

    @Deprecated
    public IPlanningAttribute getPlanningAttribute(String workItemAttributeId) {
        return this.getPlan().findAttribute(this.getRelevantAttributes().get(workItemAttributeId));
    }

    protected abstract void doProcessWorkItemChangeEvent(PlanDeltaBuilder var1, WorkItemChangeEvent var2);

    protected abstract void doHandleWorkItemBecomesIrrelevant(PlanDeltaBuilder var1, WorkItemChangeEvent var2);

    protected abstract Map<String, IPlanningAttributeIdentifier> getRelevantAttributes();

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        return this.fWorkItemId.equals((Object)((PlanItem)obj).fWorkItemId);
    }

    public int hashCode() {
        return this.fWorkItemId.hashCode();
    }

    protected IReadStateTracker getReadStateTracker() {
        IWorkItem workItem = null;
        if (!this.isDraftItem()) {
            workItem = ((WorkItemWorkingCopyImpl)this.getWorkItemWorkingCopy(false)).getBaseState();
        }
        if (workItem == null) {
            workItem = this.getWorkItem(false);
        }
        return (IReadStateTracker)Adapters.getAdapter(workItem, IReadStateTracker.class);
    }

    public Collection<NewsItem> getNewsItems() {
        TreeSet<NewsItem> result = new TreeSet<NewsItem>(new Comparator<NewsItem>(){

            @Override
            public int compare(NewsItem o1, NewsItem o2) {
                if (o1.equals((Object)o2)) {
                    return 0;
                }
                int result = Dates.compareTo((Date)o1.getPublishDate(), (Date)o2.getPublishDate());
                if (result == 0) {
                    result = CollatorCache.getInstance().compare(o1.getTitle(), o2.getTitle());
                }
                return result;
            }
        });
        Channel[] channelArray = FeedManager.getDefault().getChannels();
        int n = channelArray.length;
        int n2 = 0;
        while (n2 < n) {
            Channel channel = channelArray[n2];
            NewsItem[] newsItemArray = channel.getAllItems();
            int n3 = newsItemArray.length;
            int n4 = 0;
            while (n4 < n3) {
                NewsItem newsItem = newsItemArray[n4];
                String newsWorkItemId = newsItem.getCustomAttribute("http://www.ibm.com/jazz/0.1.0/syndication", "itemId");
                if (this.getWorkItemId().getUuidValue().equals(newsWorkItemId)) {
                    result.add(newsItem);
                }
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    protected void resetCachedState() {
        this.fIsOpen = null;
        this.fIsInProgress = null;
        this.fIsResolved = null;
    }

    @Override
    public SequenceValue getSequenceValue() {
        return this.fSequenceValue != null ? this.fSequenceValue : SequenceValue.NEW;
    }

    void setSequenceValue(SequenceValue sequenceValue, boolean saveSequenceValue) {
        this.fSequenceValue = sequenceValue;
        if (saveSequenceValue) {
            PlanDeltaBuilder builder = this.getPlan().connectDeltaBuilder();
            try {
                builder.changed(this, SEQUENCE_VALUE, null, null);
                this.writeSequenceValue();
                this.getPlan().markAsDirty();
            }
            finally {
                this.getPlan().disconnectDeltaBuilder();
            }
        }
    }

    void writeSequenceValue() {
        ((WorkItem)this.getWorkItem(true)).setInternalSequenceValue(this.getSequenceValue().serializeSequenceValue((IItemHandle)this.getOwner()));
    }

    void readSequenceValue() {
        this.fSequenceValue = SequenceValue.FACTORY.valueOf(((WorkItem)this.getWorkItem(false)).getInternalSequenceValue(), (IItemHandle)this.getOwnerHandle());
    }

    protected void processWorkItemChangeEvent(WorkItemChangeEvent event) {
        ResolvedPlan resolvedPlan = this.getPlan();
        try {
            boolean newIsResolved;
            long newTimeSpentEstimate;
            long newCorrectedEstimate;
            long newOriginalEstimate;
            PlanDuration newValue;
            PlanDuration oldValue;
            PlanDeltaBuilder builder = resolvedPlan.connectDeltaBuilder();
            if (!resolvedPlan.isRelevantForPlan(event.getWorkItem())) {
                this.doHandleWorkItemBecomesIrrelevant(builder, event);
                ItemSequenceManager sequenceManager = this.getSequenceManager();
                if (sequenceManager != null) {
                    sequenceManager.itemRemoved(this);
                }
            }
            if (resolvedPlan.getPlanItem(this.getWorkItemHandle()) == null) {
                return;
            }
            Map<String, IPlanningAttributeIdentifier> attributes = this.getRelevantAttributes();
            for (String attribute : attributes.keySet()) {
                IAdaptable details = event.getAttributeChangeDetails(attribute);
                if (!(details instanceof ChangeDetails)) continue;
                ChangeDetails changeDetails = (ChangeDetails)details;
                IPlanningAttributeIdentifier planAttribute = attributes.get(attribute);
                if (ORIGINAL_ESTIMATE.equals(planAttribute) || CORRECTED_ESTIMATE.equals(planAttribute) || TIMESPENT.equals(planAttribute)) {
                    Duration oldValue2 = new Duration(((Long)changeDetails.getOldValue()).longValue());
                    Duration newValue2 = new Duration(((Long)changeDetails.getNewValue()).longValue());
                    builder.changed(this, planAttribute, oldValue2, newValue2);
                    if (ORIGINAL_ESTIMATE.equals(planAttribute) && !this.getCorrectedEstimate().isSpecified() || CORRECTED_ESTIMATE.equals(planAttribute)) {
                        builder.changed(this, ESTIMATE, oldValue2, newValue2);
                    }
                } else if (OWNER.equals(planAttribute)) {
                    IContributor oldOwner = this.getPlan().getResolvedContributor((IContributorHandle)changeDetails.getOldValue());
                    IContributor newOwner = this.getPlan().getResolvedContributor((IContributorHandle)changeDetails.getNewValue());
                    builder.changed(this, planAttribute, oldOwner, newOwner);
                } else if (CATEGORY.equals(planAttribute)) {
                    ICategory oldCategory = this.getPlan().getResolvedCategory((ICategoryHandle)changeDetails.getOldValue());
                    ICategory newCategory = this.getPlan().getResolvedCategory((ICategoryHandle)changeDetails.getNewValue());
                    builder.changed(this, planAttribute, oldCategory, newCategory);
                } else if (TARGET.equals(planAttribute)) {
                    IIteration oldTarget = this.getPlan().getResolvedIteration((IIterationHandle)changeDetails.getOldValue());
                    IIteration newTarget = this.getPlan().getResolvedIteration((IIterationHandle)changeDetails.getNewValue());
                    builder.changed(this, planAttribute, oldTarget, newTarget);
                } else if (STATE.equals(planAttribute)) {
                    builder.changed(this, planAttribute, WorkItems.createState((String)changeDetails.getOldValue()), WorkItems.createState((String)changeDetails.getNewValue()));
                } else {
                    builder.changed(this, planAttribute, changeDetails.getOldValue(), changeDetails.getNewValue());
                }
                this.fChangedAttributes.add(planAttribute);
            }
            List<IWorkItemChangeHandler> handlers = this.getPlan().getAttributeRegistry().getAttributes(IWorkItemChangeHandler.class);
            for (IWorkItemChangeHandler handler : handlers) {
                if (!handler.acceptWorkItemChangeEvent(this, event)) continue;
                handler.handleWorkItemChangeEvent(this, builder, event);
            }
            ChangeDetails changeDetails = null;
            changeDetails = (ChangeDetails)event.getAttributeChangeDetails(IWorkItem.ID_PROPERTY);
            if (changeDetails != null && (Integer)changeDetails.getOldValue() == -1 && (Integer)changeDetails.getNewValue() != -1) {
                builder.changed(this, DRAFT_ITEM, Boolean.TRUE, Boolean.FALSE);
            }
            if ((changeDetails = (ChangeDetails)event.getAttributeChangeDetails(IWorkItem.TAGS_PROPERTY)) != null) {
                String oldValue3 = this.getPrimaryTag();
                this.parseTags();
                String newValue3 = this.getPrimaryTag();
                if (!oldValue3.equals(newValue3)) {
                    builder.changed(this, PRIMARY_TAG, oldValue3, this.getPrimaryTag());
                    this.fChangedAttributes.add(PRIMARY_TAG);
                }
            }
            boolean isResolvedStateChange = false;
            changeDetails = (ChangeDetails)event.getAttributeChangeDetails(IWorkItem.STATE_PROPERTY);
            if (changeDetails != null) {
                this.resetCachedState();
                IWorkflowInfo wfInfo = this.getWorkflowInfo();
                if (wfInfo != null) {
                    boolean isResolved;
                    boolean wasResolved;
                    Identifier<IState> oldState = WorkItems.createState((String)changeDetails.getOldValue());
                    Identifier<IState> newState = WorkItems.createState((String)changeDetails.getNewValue());
                    if (oldState != null && newState != null && (wasResolved = wfInfo.stateGroupContains(2, oldState)) != (isResolved = wfInfo.stateGroupContains(2, newState))) {
                        builder.changed(this, IScheduleItem.RESOLVED, wasResolved, isResolved);
                        isResolvedStateChange = true;
                    }
                }
            }
            if ((event.affects(WorkItem.DURATION_PROPERTY) || event.affects(WorkItem.CORRECTED_ESTIMATE_PROPERTY) || event.affects(WorkItem.TIME_SPENT_PROPERTY) || isResolvedStateChange) && !(oldValue = this.fDuration).equals((Object)(newValue = new PlanDuration(newOriginalEstimate = ((WorkItem)this.getWorkItem(false)).getDuration(), newCorrectedEstimate = ((WorkItem)this.getWorkItem(false)).getCorrectedEstimate(), newTimeSpentEstimate = ((WorkItem)this.getWorkItem(false)).getTimeSpent(), newIsResolved = this.isResolved())))) {
                this.fDuration = newValue;
                builder.changed(this, DURATION, oldValue, newValue);
            }
            if (event.affects(IWorkItem.OWNER_PROPERTY) && this.fSequenceValue != null) {
                oldValue = this.fSequenceValue;
                this.fSequenceValue = SequenceValue.NEW;
                builder.changed(this, SEQUENCE_VALUE, oldValue, SequenceValue.NEW);
            }
            if (event.affects(WorkItem.SEQUENCE_VALUE_PROPERTY)) {
                SequenceValue newValue4;
                ChangeDetails valueChange = (ChangeDetails)event.getAttributeChangeDetails(WorkItem.SEQUENCE_VALUE_PROPERTY);
                SequenceValue oldValue4 = SequenceValue.FACTORY.valueOf((String)valueChange.getOldValue(), (IItemHandle)this.getOwner());
                if (!oldValue4.equals((Object)(newValue4 = SequenceValue.FACTORY.valueOf((String)valueChange.getNewValue(), (IItemHandle)this.getOwner())))) {
                    builder.changed(this, SEQUENCE_VALUE, oldValue4, newValue4);
                }
                if (oldValue4.isNew() ^ newValue4.isNew()) {
                    builder.changed(this, NEW_ITEM, oldValue4.isNew(), newValue4.isNew());
                }
                this.fSequenceValue = newValue4;
            }
            this.doProcessWorkItemChangeEvent(builder, event);
            ItemSequenceManager sequenceManager = this.getSequenceManager();
            if (sequenceManager != null) {
                sequenceManager.processWorkItemChangeEvent(this, event);
            }
        }
        finally {
            resolvedPlan.disconnectDeltaBuilder();
        }
    }

    protected void processReadStateChangeEvent(ReadStateChangeEvent event) {
        ResolvedPlan resolvedPlan = this.getPlan();
        try {
            PlanDeltaBuilder builder = resolvedPlan.connectDeltaBuilder();
            builder.changed(this, MARKED_READ, !event.isRead(), event.isRead());
        }
        finally {
            resolvedPlan.disconnectDeltaBuilder();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseTags() {
        Object object = this.fTagsLock;
        synchronized (object) {
            this.fParsedTags = null;
            this.ensureTagsParsed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureTagsParsed() {
        Object object = this.fTagsLock;
        synchronized (object) {
            if (this.fParsedTags == null) {
                this.fParsedTags = Tags.parseTags(this.getWorkItem(false).getTags());
            }
        }
    }

    public IPlanItemTestAccess getTestingAccessor() {
        return new IPlanItemTestAccess(){

            @Override
            public IWorkItem getWorkItem() {
                return PlanItem.this.getWorkItem(true);
            }

            @Override
            public WorkItemWorkingCopy getWorkingCopy() {
                return PlanItem.this.getWorkItemWorkingCopy(true);
            }
        };
    }
}

