/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client;

import com.ibm.team.apt.internal.client.IPersonalPlanSaveManager;
import com.ibm.team.apt.internal.client.IPlanningAttributeIdentifier;
import com.ibm.team.apt.internal.client.PlanDeltaBuilder;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.ResolvedPersonalPlan;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.common.util.CMode;
import com.ibm.team.apt.internal.common.util.ItemArrayList;
import com.ibm.team.apt.internal.common.util.ItemList;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import com.ibm.team.workitem.common.model.ChangeDetails;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;

public class PersonalPlanItem
extends PlanItem {
    private static final Map<String, IPlanningAttributeIdentifier> ATTRIBUTE_MAP = new HashMap<String, IPlanningAttributeIdentifier>();

    static {
        ATTRIBUTE_MAP.put(IWorkItem.ID_PROPERTY, ID);
        ATTRIBUTE_MAP.put(IWorkItem.TYPE_PROPERTY, ITEM_TYPE);
        ATTRIBUTE_MAP.put(IWorkItem.SUMMARY_PROPERTY, SUMMARY);
        ATTRIBUTE_MAP.put(IWorkItem.DESCRIPTION_PROPERTY, DESCRIPTION);
        ATTRIBUTE_MAP.put(IWorkItem.TARGET_PROPERTY, TARGET);
        ATTRIBUTE_MAP.put(IWorkItem.CATEGORY_PROPERTY, CATEGORY);
        ATTRIBUTE_MAP.put(IWorkItem.STATE_PROPERTY, STATE);
        ATTRIBUTE_MAP.put(IWorkItem.DURATION_PROPERTY, ORIGINAL_ESTIMATE);
        ATTRIBUTE_MAP.put(WorkItem.CORRECTED_ESTIMATE_PROPERTY, CORRECTED_ESTIMATE);
        ATTRIBUTE_MAP.put(WorkItem.TIME_SPENT_PROPERTY, TIMESPENT);
        ATTRIBUTE_MAP.put(IWorkItem.DUE_DATE_PROPERTY, DUE_DATE);
        ATTRIBUTE_MAP.put(IWorkItem.TAGS_PROPERTY, TAGS);
    }

    public PersonalPlanItem(ResolvedPlan plan, PlanElement parent, WorkItemWorkingCopy wc) {
        super(wc, plan, parent);
        this.getParent().addChild(this);
    }

    @Override
    public ResolvedPersonalPlan getPlan() {
        return (ResolvedPersonalPlan)super.getPlan();
    }

    @Override
    protected Map<String, IPlanningAttributeIdentifier> getRelevantAttributes() {
        return ATTRIBUTE_MAP;
    }

    @Override
    protected void doProcessWorkItemChangeEvent(PlanDeltaBuilder builder, WorkItemChangeEvent event) {
        IPersonalPlanSaveManager saveManager;
        if (event.affects(IWorkItem.OWNER_PROPERTY)) {
            ChangeDetails changeDetails = (ChangeDetails)event.getAttributeChangeDetails(IWorkItem.OWNER_PROPERTY);
            IContributorHandle oldValue = (IContributorHandle)changeDetails.getOldValue();
            IContributorHandle newValue = (IContributorHandle)changeDetails.getNewValue();
            IContributor planOwner = this.getPlan().getPlanOwner();
            if (planOwner.sameItemId((IItemHandle)oldValue) ^ planOwner.sameItemId((IItemHandle)newValue)) {
                boolean current = this.isAuxiliaryPlanItem();
                builder.changed(this, AUXILIARY_ITEM, !current, current);
                builder.changed(this, PRIMARY_ITEM, current, !current);
            }
        }
        if (event.affects(IWorkItem.TARGET_PROPERTY)) {
            ChangeDetails targetChange = (ChangeDetails)event.getAttributeChangeDetails(IWorkItem.TARGET_PROPERTY);
            IIteration oldInterval = this.getInterval((IIterationHandle)targetChange.getOldValue());
            IIteration newInterval = this.getInterval((IIterationHandle)targetChange.getNewValue());
            builder.changed(this, TARGET, oldInterval, newInterval);
        }
        if ((saveManager = this.getPlan().getSaveManager()) != null) {
            saveManager.onWorkItemChange(this, event);
        }
    }

    @Override
    protected void doHandleWorkItemBecomesIrrelevant(PlanDeltaBuilder deltaBuilder, WorkItemChangeEvent event) {
        this.getParent().removeChild(this);
    }

    @Override
    protected void handleWriteableStateChanged(boolean isWriteable) {
        IPersonalPlanSaveManager saveManager = this.getPlan().getSaveManager();
        if (saveManager != null) {
            saveManager.onWriteableStateChange(this, isWriteable);
        }
    }

    @Override
    public boolean canHaveChildren() {
        return false;
    }

    @Override
    public boolean isAuxiliaryPlanItem() {
        return !this.getPlan().getPlanOwner().sameItemId((IItemHandle)this.getOwnerHandle());
    }

    @Override
    public boolean isPrimaryPlanItem() {
        return !this.isAuxiliaryPlanItem();
    }

    @Override
    public boolean isProgressPlanItem() {
        return false;
    }

    @Override
    public boolean isTopLevelPlanItem() {
        return this.getPlan().isTopLevelItem(this);
    }

    @Override
    public ItemList<IIteration> getRelatedIterations() {
        ItemArrayList result = new ItemArrayList(CMode.CURRENT_HANDLEONLY);
        IIteration currentTarget = this.getTarget();
        if (currentTarget != null) {
            result.addAll(this.fPlan.getRelatedIterations(currentTarget.getDevelopmentLine()));
            if (!result.contains((Object)currentTarget)) {
                result.add((Object)currentTarget);
            }
        } else {
            IDevelopmentLineHandle[] iDevelopmentLineHandleArray = this.fPlan.getProjectArea().getDevelopmentLines();
            int n = iDevelopmentLineHandleArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDevelopmentLineHandle developmentLineHandle = iDevelopmentLineHandleArray[n2];
                result.addAll(this.fPlan.getRelatedIterations(developmentLineHandle));
                ++n2;
            }
        }
        return result;
    }

    private IIteration getInterval(IIterationHandle handle) {
        if (handle == null) {
            return null;
        }
        if (handle instanceof IIteration) {
            IIteration iteration = (IIteration)handle;
            this.getPlan().addResolvedIteration(iteration);
            return iteration;
        }
        if (handle instanceof IIterationHandle) {
            IIteration iteration = this.getPlan().getResolvedIteration(handle);
            if (iteration != null) {
                return iteration;
            }
            IItemManager manager = this.getPlan().getTeamRepository().itemManager();
            iteration = (IIteration)manager.getSharedItemIfKnown((IItemHandle)handle);
            if (iteration == null) {
                try {
                    iteration = (IIteration)manager.fetchCompleteItem((IItemHandle)handle, 0, null);
                }
                catch (TeamRepositoryException e) {
                    PlanningClientPlugin.log(e);
                    Assert.isTrue((boolean)false, (String)"Should not happen");
                }
            }
            this.getPlan().addResolvedIteration(iteration);
            return iteration;
        }
        throw new IllegalArgumentException("Argument must be an interval or interval handle");
    }
}

