/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client;

import com.ibm.team.apt.common.resource.IContributorAbsence;
import com.ibm.team.apt.common.resource.IContributorAbsenceHandle;
import com.ibm.team.apt.internal.client.IScheduleItem;
import com.ibm.team.apt.internal.client.ItemSequenceManager;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.client.planchecker.CheckerReport;
import com.ibm.team.apt.internal.common.BookedTimeType;
import com.ibm.team.apt.internal.common.IBookedTime;
import com.ibm.team.apt.internal.common.Timespan;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.workitem.common.internal.util.SequenceValue;
import java.util.Date;

public class OutOfOfficeItem
extends PlanElement
implements IScheduleItem,
IBookedTime {
    private IContributorAbsence fAbsence;
    private final ResolvedPlan fPlan;

    public OutOfOfficeItem(ResolvedPlan plan, IContributorAbsence absence) {
        this.fPlan = plan;
        this.fAbsence = absence;
    }

    public IContributorAbsenceHandle getAbsenceHandle() {
        return (IContributorAbsenceHandle)this.fAbsence.getItemHandle();
    }

    public Date getStart() {
        return this.fAbsence.getStartDate();
    }

    public Date getEnd() {
        return this.fAbsence.getEndDate();
    }

    public BookedTimeType getType() {
        return BookedTimeType.OUT_OF_OFFICE;
    }

    @Override
    public String getSummary() {
        return this.fAbsence.getSummary();
    }

    @Override
    public XMLString getHTMLSummary() {
        return XMLString.createFromXMLText((String)this.fAbsence.getSummary());
    }

    @Override
    public void setSummary(String summary) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHTMLSummary(XMLString summary) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IContributor getOwner() {
        return this.fPlan.getResolvedContributor(this.fAbsence.getContributor());
    }

    @Override
    public void setOwner(IContributor owner) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ItemSequenceManager getSequenceManager() {
        return this.fPlan.getItemSequenceManager(this);
    }

    @Override
    public SequenceValue getSequenceValue() {
        return SequenceValue.NEW;
    }

    @Override
    public Timespan getScheduledTime() {
        ItemSequenceManager sequenceManager = this.getSequenceManager();
        return sequenceManager != null ? sequenceManager.getScheduledTime(this) : null;
    }

    @Override
    public boolean isOpen() {
        return this.fPlan.getReferenceTime().before(this.fAbsence.getStartDate());
    }

    @Override
    public boolean isInProgress() {
        return !this.isOpen() && !this.isResolved();
    }

    @Override
    public boolean isResolved() {
        return !this.fAbsence.getEndDate().after(this.fPlan.getReferenceTime());
    }

    @Override
    public boolean isPrimaryPlanItem() {
        return true;
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public ResolvedPlan getPlan() {
        return this.fPlan;
    }

    @Override
    public CheckerReport getPlanCheckReport() {
        return null;
    }

    @Override
    public PlanElement getParent() {
        return null;
    }

    @Override
    public void moveTo(PlanElement newParent) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addChild(PlanElement element) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void doChildAdded(PlanElement parent, PlanElement child) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void doChildRemoved(PlanElement parent, PlanElement child) {
        throw new UnsupportedOperationException();
    }
}

