/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client;

import com.ibm.team.apt.common.resource.IWorkResourceDetails;
import com.ibm.team.apt.internal.client.IPlanElementVisitor;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.PlanLoadInformation;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.ResolvedPersonalPlan;
import com.ibm.team.apt.internal.client.resource.IContributorInfo;
import com.ibm.team.apt.internal.client.resource.ResourcePlanningManager;
import com.ibm.team.apt.internal.client.teamload.ILoadItemCreator;
import com.ibm.team.apt.internal.client.teamload.LoadInformation;
import com.ibm.team.apt.internal.client.teamload.LoadItem;
import com.ibm.team.apt.internal.common.util.ItemCollection;
import com.ibm.team.apt.internal.common.util.ItemCollections;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import com.ibm.team.workitem.common.internal.util.SequenceValue;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class MyWorkLoadInformation
extends PlanLoadInformation<ResolvedPersonalPlan> {
    private ILoadItemCreator fItemCreator = new ILoadItemCreator(){

        @Override
        public List<LoadItem> createItems(IProgressMonitor monitor) throws TeamRepositoryException {
            IContributor planOwner = ((ResolvedPersonalPlan)MyWorkLoadInformation.this.fPlan).getPlanOwner();
            ResourcePlanningManager manager = PlanningClientPlugin.getResourcePlanningClient(((ResolvedPersonalPlan)MyWorkLoadInformation.this.fPlan).getTeamRepository()).getResourcePlanningManager();
            Timestamp start = new Timestamp(0L);
            Timestamp end = null;
            if (MyWorkLoadInformation.this.fIteration.getStartDate() != null) {
                start = new Timestamp(MyWorkLoadInformation.this.fIteration.getStartDate().getTime());
            }
            if (MyWorkLoadInformation.this.fIteration.getEndDate() != null) {
                end = new Timestamp(MyWorkLoadInformation.this.fIteration.getEndDate().getTime());
            }
            IContributorInfo info = manager.getContributorInfo((IContributorHandle)planOwner, start, end, monitor);
            boolean defaultAssignment = false;
            int minAssignment = -1;
            int maxAssignment = -1;
            ItemCollection<IProcessArea> ownerTeamAreas = ((ResolvedPersonalPlan)MyWorkLoadInformation.this.fPlan).getTeamMemberAreas();
            ItemCollection<IWorkResourceDetails> details = info.getWorkDetails((IContributorHandle)((ResolvedPersonalPlan)MyWorkLoadInformation.this.fPlan).getPlanOwner());
            ArrayList<IWorkResourceDetails> assignments = new ArrayList<IWorkResourceDetails>();
            int workAssignment = 0;
            for (IWorkResourceDetails detail : details) {
                if (!ownerTeamAreas.contains((Object)detail.getOwner()) || !detail.getDevelopmentLine().sameItemId((IItemHandle)MyWorkLoadInformation.this.fIteration.getDevelopmentLine())) continue;
                assignments.add(detail);
                workAssignment += detail.getAssignment();
                defaultAssignment |= !detail.isCustomized();
                if (minAssignment == -1 || minAssignment > detail.getAssignment()) {
                    minAssignment = detail.getAssignment();
                }
                if (maxAssignment != -1 && maxAssignment >= detail.getAssignment()) continue;
                maxAssignment = detail.getAssignment();
            }
            Math.max(Math.min(workAssignment, 100), 0);
            ((ResolvedPersonalPlan)MyWorkLoadInformation.this.fPlan).getItemSequenceManager().updateWorkTime(info.getWorkLocation((IContributorHandle)planOwner), workAssignment, assignments.toArray(new IWorkResourceDetails[assignments.size()]));
            long workTimeLeft = ((ResolvedPersonalPlan)MyWorkLoadInformation.this.fPlan).getItemSequenceManager().calculateRemainingWorkTime(MyWorkLoadInformation.this.fIteration.getEndDate());
            boolean defaultWorkLocation = !info.getWorkLocation((IContributorHandle)planOwner).isCustomized();
            final HashSet<UUID> open = new HashSet<UUID>();
            final HashSet<UUID> estimated = new HashSet<UUID>();
            final HashSet<UUID> closed = new HashSet<UUID>();
            final long[] sumOfEstimate = new long[1];
            ((ResolvedPersonalPlan)MyWorkLoadInformation.this.fPlan).accept(new IPlanElementVisitor(){

                @Override
                public boolean visit(PlanElement element) {
                    PlanItem planItem;
                    IIteration plannedFor;
                    if (element instanceof PlanItem && (plannedFor = (planItem = (PlanItem)element).getTarget()) != null && plannedFor.sameItemId((IItemHandle)MyWorkLoadInformation.this.fIteration) && !planItem.isNewItem()) {
                        UUID workItemId = planItem.getWorkItemId();
                        if (planItem.isResolved()) {
                            closed.add(workItemId);
                        } else {
                            open.add(workItemId);
                            if (planItem.isTopLevelPlanItem()) {
                                estimated.add(workItemId);
                            } else if (planItem.getDuration().isSpecified()) {
                                estimated.add(workItemId);
                                sumOfEstimate[0] = sumOfEstimate[0] + planItem.getDuration().getDuration();
                            }
                        }
                    }
                    return true;
                }
            });
            LoadItem item = new LoadItem(MyWorkLoadInformation.this, planOwner, info.getAbsences((IContributorHandle)planOwner), workTimeLeft, minAssignment, maxAssignment, defaultAssignment, defaultWorkLocation, sumOfEstimate[0], open, estimated, closed);
            return Collections.singletonList(item);
        }
    };
    private final IIteration fIteration;
    private Collection<String> fRequiredProperties;

    public MyWorkLoadInformation(ResolvedPersonalPlan plan, IIteration iteration) {
        super(plan, (ItemCollection<? extends IIteration>)ItemCollections.singleton((Object)iteration), (ItemCollection<? extends ICategory>)ItemCollections.emptyList());
        this.fIteration = iteration;
        this.setMode(LoadInformation.Mode.TIME);
    }

    public ResolvedPersonalPlan getPlan() {
        return (ResolvedPersonalPlan)this.fPlan;
    }

    @Override
    public ILoadItemCreator getItemCreator() {
        return this.fItemCreator;
    }

    @Override
    protected boolean matches(IWorkItem workItem, IWorkflowInfo info) {
        if (!super.matches(workItem, info)) {
            return false;
        }
        return !SequenceValue.NEW.equals((Object)SequenceValue.FACTORY.valueOf(((WorkItem)workItem).getInternalSequenceValue(), (IItemHandle)workItem.getOwner()));
    }

    @Override
    public Collection<String> getRequiredProperties() {
        if (this.fRequiredProperties == null) {
            ArrayList<String> list = new ArrayList<String>();
            list.addAll(super.getRequiredProperties());
            list.add(WorkItem.SEQUENCE_VALUE_PROPERTY);
            this.fRequiredProperties = Collections.unmodifiableCollection(list);
        }
        return this.fRequiredProperties;
    }
}

