/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client;

import com.ibm.team.apt.common.IIterationPlanRecordHandle;
import com.ibm.team.apt.internal.common.IStore;
import com.ibm.team.apt.internal.common.PlanConfigurationStore;
import com.ibm.team.apt.internal.common.plantype.IPlanType;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import java.util.LinkedList;
import java.util.List;

public class IterationPlanWizardContext {
    private List<IProjectAreaHandle> fProjectAreas = new LinkedList<IProjectAreaHandle>();
    private IProjectAreaHandle fProjectArea;
    private ITeamRepository fTeamRepository;
    private String fName;
    private IProcessAreaHandle fTeamMemberArea;
    private IDevelopmentLineHandle fDevelopmentLineHandle;
    private IIterationHandle fIteration;
    private List<IPlanType> fPlanTypes;
    private String fSelectedPlanType;
    private IStore fAuxiliaryData;
    private PlanConfigurationStore fPlanConfigurationStore;
    private IIterationPlanRecordHandle fIterationPlanHandle;

    public IterationPlanWizardContext(List<IProjectAreaHandle> projectAreas) {
        this.setProjectAreas(projectAreas);
        if (projectAreas.size() > 0) {
            this.setProjectArea(projectAreas.get(0));
        }
    }

    public boolean isValid() {
        return this.fTeamMemberArea != null;
    }

    public void clear() {
        this.fProjectArea = null;
        this.fName = null;
        this.fSelectedPlanType = null;
        this.fIteration = null;
        this.fTeamMemberArea = null;
        this.fTeamRepository = null;
        this.fIterationPlanHandle = null;
    }

    public void setPlanTypes(List<IPlanType> planTypes) {
        this.fPlanTypes = planTypes;
    }

    public void setProjectAreas(List<IProjectAreaHandle> projectAreas) {
        this.fProjectAreas = projectAreas;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public void setSelectedPlanType(String identifier) {
        this.fSelectedPlanType = identifier;
    }

    public void setIteration(IIterationHandle iteration) {
        this.fIteration = iteration;
        this.updateTeamRepository((IItemHandle)iteration);
    }

    public void setProjectArea(IProjectAreaHandle projectArea) {
        this.fProjectArea = projectArea;
        this.updateTeamRepository((IItemHandle)projectArea);
    }

    public void setTeamMemberArea(IProcessAreaHandle teamMemberArea) {
        this.fTeamMemberArea = teamMemberArea;
        this.updateTeamRepository((IItemHandle)teamMemberArea);
    }

    public void setIterationPlanHandle(IIterationPlanRecordHandle iterationPlanHandle) {
        this.fIterationPlanHandle = iterationPlanHandle;
        this.updateTeamRepository((IItemHandle)iterationPlanHandle);
    }

    public void setDevelopmentLineHandle(IDevelopmentLineHandle developmentLineHandle) {
        this.fDevelopmentLineHandle = developmentLineHandle;
        this.updateTeamRepository((IItemHandle)developmentLineHandle);
    }

    public void setTeamRepository(ITeamRepository teamRepository) {
        this.fTeamRepository = teamRepository;
    }

    public void setAuxiliaryDataStore(IStore auxiliaryData) {
        this.fAuxiliaryData = auxiliaryData;
        this.fPlanConfigurationStore = new PlanConfigurationStore(this.fAuxiliaryData);
    }

    public void setAlwaysLoadAllExecutionItems(boolean value) {
        if (this.fPlanConfigurationStore == null) {
            this.fAuxiliaryData = IStore.FACTORY.createEmptyStore();
            this.fPlanConfigurationStore = new PlanConfigurationStore(this.fAuxiliaryData);
        }
        this.fPlanConfigurationStore.setAlwaysLoadExecutionItems(value);
    }

    private void updateTeamRepository(IItemHandle handle) {
        if (handle != null) {
            this.setTeamRepository((ITeamRepository)handle.getOrigin());
        }
    }

    public String getName() {
        return this.fName;
    }

    public List<IPlanType> getPlanTypes() {
        return this.fPlanTypes;
    }

    public String getSelectedPlanType() {
        return this.fSelectedPlanType;
    }

    public List<IProjectAreaHandle> getProjectAreas() {
        return this.fProjectAreas;
    }

    public IProjectAreaHandle getProjectArea() {
        return this.fProjectArea;
    }

    public IIterationHandle getIteration() {
        return this.fIteration;
    }

    public IProcessAreaHandle getTeamMemberArea() {
        return this.fTeamMemberArea;
    }

    public IIterationPlanRecordHandle getIterationPlanHandle() {
        return this.fIterationPlanHandle;
    }

    public IDevelopmentLineHandle getDevelopmentLineHandle() {
        return this.fDevelopmentLineHandle;
    }

    public IStore getAuxiliaryDataStore() {
        return this.fAuxiliaryData;
    }

    public boolean getAlwaysLoadAllExecutionItems() {
        if (this.fPlanConfigurationStore == null) {
            return false;
        }
        return this.fPlanConfigurationStore.getAlwaysLoadExecutionItems();
    }

    public ITeamRepository getTeamRepository() {
        return this.fTeamRepository;
    }
}

