/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client;

import com.ibm.team.apt.api.common.planning.IProgressInformation;
import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.internal.client.ICorePlanItemFilter;
import com.ibm.team.apt.internal.client.IItemResolveService;
import com.ibm.team.apt.internal.client.IPlanAttributeDelta;
import com.ibm.team.apt.internal.client.IPlanElementChangeEvent;
import com.ibm.team.apt.internal.client.IPlanElementDelta;
import com.ibm.team.apt.internal.client.IPlanElementListener;
import com.ibm.team.apt.internal.client.IPlanReferenceListener;
import com.ibm.team.apt.internal.client.IterationPlanClient;
import com.ibm.team.apt.internal.client.IterationPlanDataListener;
import com.ibm.team.apt.internal.client.Messages;
import com.ibm.team.apt.internal.client.PlanSaveResult;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.ResolvedIterationPlan;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.client.resource.PlanReferences;
import com.ibm.team.apt.internal.client.wiki.IWikiPageSafeRunnable;
import com.ibm.team.apt.internal.client.wiki.ResolvedWikiPage;
import com.ibm.team.apt.internal.client.wiki.ResolvedWikiPageAdapter;
import com.ibm.team.apt.internal.client.wiki.WikiClient;
import com.ibm.team.apt.internal.client.wiki.WikiManager;
import com.ibm.team.apt.internal.common.IStore;
import com.ibm.team.apt.internal.common.PlanConfigurationStore;
import com.ibm.team.apt.internal.common.ProcessAreaInfo;
import com.ibm.team.apt.internal.common.duration.IComplexityAttribute;
import com.ibm.team.apt.internal.common.plantype.IFilterDescription;
import com.ibm.team.apt.internal.common.plantype.IParameter;
import com.ibm.team.apt.internal.common.plantype.IPlanType;
import com.ibm.team.apt.internal.common.plantype.ISortModeDescription;
import com.ibm.team.apt.internal.common.plantype.ResolvedPlanMode;
import com.ibm.team.apt.internal.common.util.ItemArrayList;
import com.ibm.team.apt.internal.common.util.ItemCollections;
import com.ibm.team.apt.internal.common.util.ItemList;
import com.ibm.team.apt.internal.common.util.Node;
import com.ibm.team.apt.internal.common.wiki.IWikiPage;
import com.ibm.team.apt.internal.common.wiki.IWikiPageHandle;
import com.ibm.team.apt.internal.common.wiki.model.WikiPage;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IReconcileReport;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IAuditableCommonProcess;
import com.ibm.team.workitem.common.model.ICategory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class IterationPlanData {
    public static final String OVERVIEW_PAGE_ID = "overview";
    public static final String OVERVIEW_PAGE_NAME = Messages.IterationPlanData_OVERVIEW_PAGE_NAME;
    private IIterationPlanRecord fRecord;
    private final IPlanType fPlanType;
    private List<ResolvedPlanMode> fPlanModes;
    private List<IFilterDescription> fAllFilters;
    private final Node<IIteration> fIterationHierarchy;
    private final IComplexityAttribute fComplexityAttribute;
    private final IDevelopmentLine fDevelopmentLine;
    private final IProjectArea fProjectArea;
    private final IProcessArea fOwner;
    private final List<ProcessAreaInfo> fProcessAreas;
    private final IIteration fIteration;
    private final ItemList<ICategory> fCategories;
    private final ItemList<IIteration> fRelatedIterations;
    private final IProgressInformation fProgressInformation;
    private final boolean fCanSave;
    private final boolean fCanSavePages;
    private final boolean fShowChartPage;
    private ResolvedIterationPlan fPlan;
    private IPlanElementListener fPlanListener;
    private ICorePlanItemFilter[] fFilters;
    private IItemResolveService fItemResolveService;
    private ListenerList fPlanListeners;
    private final ItemList<IWikiPage> fWikiPages;
    private final List<ResolvedWikiPage> fResolvedWikiPages;
    private PlanReferences fPlanReferences;
    private final ListenerList fListeners;
    private String fRankingMode;
    private IParameter[] fExplicitRankParams;

    public IterationPlanData(IIterationPlanRecord record, IPlanType planType, List<ResolvedPlanMode> planModes, List<IFilterDescription> allFilters, Node<IIteration> iterationHierarchy, IComplexityAttribute complexityAttribute, IDevelopmentLine developmentLine, IProjectArea projectArea, IProcessArea owner, IIteration interval, ItemList<ICategory> categories, ItemList<IIteration> relatedIntervals, List<ProcessAreaInfo> processAreas, IProgressInformation progressInformation, ItemList<IWikiPage> wikiPages, boolean canSave, boolean canSavePages, boolean showChartPage, PlanReferences planReferences) throws TeamRepositoryException {
        this.fRecord = record;
        this.fPlanType = planType;
        this.fPlanModes = planModes;
        this.fAllFilters = IterationPlanData.excludeWebOnlyFilters(allFilters);
        this.fIterationHierarchy = iterationHierarchy;
        this.fComplexityAttribute = complexityAttribute;
        this.fDevelopmentLine = developmentLine;
        this.fProjectArea = projectArea;
        this.fProcessAreas = processAreas;
        this.fOwner = owner;
        this.fIteration = interval;
        this.fCategories = categories;
        this.fRelatedIterations = relatedIntervals;
        this.fProgressInformation = progressInformation;
        this.fWikiPages = wikiPages;
        this.fResolvedWikiPages = new ArrayList<ResolvedWikiPage>(this.fWikiPages.size());
        this.fCanSave = canSave;
        this.fCanSavePages = canSavePages;
        this.fShowChartPage = showChartPage;
        this.fPlanListeners = new ListenerList(1);
        this.fListeners = new ListenerList(1);
        this.fPlanListener = new IPlanElementListener(){

            @Override
            public void planElementChanged(IPlanElementChangeEvent event) {
                IPlanAttributeDelta dirtyDelta;
                IPlanElementDelta delta = event.getDelta();
                if (delta.getPlanElement() == IterationPlanData.this.fPlan && (dirtyDelta = delta.getAttributeDelta(ResolvedPlan.DIRTY)) != null) {
                    boolean oldDirty;
                    boolean bl = oldDirty = IterationPlanData.this.isWikiPageDirty(null) || (Boolean)dirtyDelta.getOldValue() != false;
                    if (oldDirty != (Boolean)dirtyDelta.getNewValue()) {
                        IterationPlanData.this.fireDirtyStateChanged(oldDirty, !oldDirty);
                    }
                }
            }
        };
        this.fPlanReferences = planReferences;
        this.fPlanReferences.addListener(new IterationPlanDataListener(){

            @Override
            public void dirtyStateChanged(boolean oldValue, boolean newValue) {
                IterationPlanData.this.fireDirtyStateChanged(oldValue, newValue);
            }
        });
        IAuditableClient auditableClient = PlanningClientPlugin.getAuditableClient(this.getTeamRepository());
        IStore store = IStore.FACTORY.createStore(this.fRecord.getAuxiliaryData(), (IAuditableCommon)auditableClient, null);
        PlanConfigurationStore planConfigurationStore = new PlanConfigurationStore(store);
        this.fRankingMode = planConfigurationStore.getRankingMode();
        IterationPlanClient planClient = (IterationPlanClient)PlanningClientPlugin.getIterationPlanClient((IItemHandle)this.getProjectArea());
        IAuditableCommonProcess commonProcess = auditableClient.getProcess((IProcessAreaHandle)this.getProjectArea(), (IProgressMonitor)new NullProgressMonitor());
        ISortModeDescription sortMode = planClient.findConfigurationElement(ISortModeDescription.class, "com.ibm.team.apt.sortmode.newRanking", commonProcess, (IProgressMonitor)new NullProgressMonitor());
        this.fExplicitRankParams = sortMode.getParameters();
    }

    public boolean waitForDisconnect(IProgressMonitor monitor) {
        try {
            boolean bl = this.fPlan != null ? this.fPlan.waitForDisconnect(monitor) : true;
            return bl;
        }
        finally {
            monitor.done();
        }
    }

    public synchronized void disconnect() {
        if (this.fPlan != null) {
            if (this.fPlanListener != null) {
                this.fPlan.removeListener(this.fPlanListener);
            }
            this.fPlan.disconnect();
        }
    }

    public ITeamRepository getTeamRepository() {
        return PlanningClientPlugin.getTeamRepository((IItemHandle)this.fRecord);
    }

    public IIterationPlanRecord getPlanRecord() {
        return this.fRecord;
    }

    public IPlanType getPlanType() {
        return this.fPlanType;
    }

    public List<ResolvedPlanMode> getPlanModes() {
        return new ArrayList<ResolvedPlanMode>(this.fPlanModes);
    }

    public List<IFilterDescription> getAllFilters() {
        return this.fAllFilters;
    }

    public Node<IIteration> getIterationHierarchy() {
        return this.fIterationHierarchy;
    }

    public IComplexityAttribute getComplexityAttribute() {
        return this.fComplexityAttribute;
    }

    public String getName() {
        return this.fRecord.getName();
    }

    public IDevelopmentLine getDevelopmentLine() {
        return this.fDevelopmentLine;
    }

    public IProjectArea getProjectArea() {
        return this.fProjectArea;
    }

    public IProcessArea getOwner() {
        return this.fOwner;
    }

    public IIteration getIteration() {
        return this.fIteration;
    }

    public ItemList<IIteration> getRelatedIterations() {
        return this.fRelatedIterations;
    }

    public ItemList<IIteration> getFutureIterations() {
        if (this.fRelatedIterations.isEmpty()) {
            return ItemCollections.emptyList();
        }
        ItemArrayList result = new ItemArrayList(this.fRelatedIterations);
        result.remove((Object)this.fIteration);
        return result;
    }

    public ItemList<ICategory> getCategories() {
        return this.fCategories;
    }

    public IProgressInformation getProgressInformation() {
        return this.fProgressInformation;
    }

    public boolean canSavePlan() {
        return true;
    }

    public boolean canSavePages() {
        return true;
    }

    public boolean showChartPage() {
        return this.fShowChartPage;
    }

    public List<ProcessAreaInfo> getProcessAreaInfos() {
        return this.fProcessAreas;
    }

    public synchronized boolean isDirty() {
        boolean result = false;
        if (this.fPlan != null) {
            result = this.fPlan.isDirty();
        }
        for (ResolvedWikiPage page : this.fResolvedWikiPages) {
            boolean bl = result = result || page.isDirty();
            if (!result) continue;
            return result;
        }
        result = result || this.fPlanReferences.isDirty();
        return result;
    }

    public synchronized boolean isPlanDirty() {
        if (this.fPlan != null) {
            return this.fPlan.isDirty();
        }
        return false;
    }

    public synchronized boolean isWikiPageDirty(ResolvedWikiPage exclude) {
        boolean result = false;
        for (ResolvedWikiPage page : this.fResolvedWikiPages) {
            if (page == exclude) continue;
            boolean bl = result = result || page.isDirty();
            if (!result) continue;
            return result;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlanSaveResult save(boolean ignoreBackLinksProblem, IProgressMonitor monitor) throws TeamRepositoryException, IOException {
        try {
            PlanSaveResult saveResult;
            monitor.beginTask(Messages.IterationPlanData_MONITOR_SAVING_PLAN, this.fResolvedWikiPages.size() + 1);
            WikiManager wikiManager = WikiClient.getWikiManager(this.getTeamRepository());
            ArrayList<IWikiPageSafeRunnable> pagesToSave = new ArrayList<IWikiPageSafeRunnable>(this.fResolvedWikiPages.size());
            for (ResolvedWikiPage page : this.fResolvedWikiPages) {
                if (!page.isDirty()) continue;
                pagesToSave.add(wikiManager.createWikiPageSafeRunnable(page, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
            }
            IWikiPageSafeRunnable[] wikiSafeRunnables = pagesToSave.toArray(new IWikiPageSafeRunnable[pagesToSave.size()]);
            ResolvedIterationPlan plan = null;
            IterationPlanData iterationPlanData = this;
            synchronized (iterationPlanData) {
                plan = this.fPlan;
            }
            if (plan != null) {
                saveResult = this.fPlan.save(wikiSafeRunnables, this.fPlanReferences, ignoreBackLinksProblem, monitor);
            } else {
                IterationPlanClient client = (IterationPlanClient)PlanningClientPlugin.getIterationPlanClient(this.getTeamRepository());
                saveResult = client.save(this.canSavePlan(), this.getPlanRecord(), null, new WorkItemWorkingCopy[0], null, wikiSafeRunnables, this.fPlanReferences, ignoreBackLinksProblem, monitor);
            }
            this.fPlanReferences.update();
            PlanSaveResult planSaveResult = saveResult;
            return planSaveResult;
        }
        finally {
            monitor.done();
        }
    }

    public synchronized ItemList<IWikiPage> getWikiPages() {
        return ItemCollections.unmodifiableItemList(this.fWikiPages);
    }

    public synchronized void addResolvedWikiPage(final ResolvedWikiPage page) {
        this.fResolvedWikiPages.add(page);
        if (!this.fWikiPages.contains((Object)page.getWikiPage().getItemHandle())) {
            this.fWikiPages.add((Object)page.getWikiPage());
        }
        page.addListener(new ResolvedWikiPageAdapter(){

            @Override
            public void dirtyStateChanged(boolean oldValue, boolean newValue) {
                boolean oldDirty;
                boolean bl = oldDirty = IterationPlanData.this.isPlanDirty() || IterationPlanData.this.isWikiPageDirty(page);
                if (oldDirty != newValue) {
                    IterationPlanData.this.fireDirtyStateChanged(oldValue, newValue);
                }
            }
        });
    }

    public void addPlanReferenceListener(IPlanReferenceListener planReferenceListener) {
        this.fPlanReferences.addListener(planReferenceListener);
    }

    public void deleteAttachedPage(IWikiPage page, IProgressMonitor monitor) throws TeamRepositoryException {
        IterationPlanClient client = (IterationPlanClient)PlanningClientPlugin.getIterationPlanClient((IItemHandle)page);
        client.deleteAttachedPage((IWikiPageHandle)page, monitor);
        Iterator iter = this.fWikiPages.iterator();
        while (iter.hasNext()) {
            IWikiPage attachedPage = (IWikiPage)iter.next();
            if (!attachedPage.sameItemId((IItemHandle)page)) continue;
            iter.remove();
        }
        Iterator<ResolvedWikiPage> iterResolved = this.fResolvedWikiPages.iterator();
        while (iterResolved.hasNext()) {
            IWikiPage resolvedPage = iterResolved.next().getWikiPage();
            if (!resolvedPage.sameItemId((IItemHandle)page)) continue;
            iterResolved.remove();
        }
    }

    public void renameAttachedPage(ResolvedWikiPage page, String name, IProgressMonitor monitor) throws TeamRepositoryException, IOException {
        this.fWikiPages.remove((Object)page.getWikiPage());
        IterationPlanClient client = (IterationPlanClient)PlanningClientPlugin.getIterationPlanClient((IItemHandle)page.getWikiPage());
        IWikiPageSafeRunnable runnable = WikiClient.getWikiManager((IItem)page.getWikiPage()).createWikiPageSafeRunnable(page, true, monitor);
        client.renameAttachedPage(this.getPlanRecord(), runnable, name, monitor);
        this.fWikiPages.add((Object)runnable.getWikiPage());
    }

    public void upgradeAttachedPage(ResolvedWikiPage resolvedPage, IProgressMonitor monitor) throws TeamRepositoryException, IOException {
        IWikiPage page = resolvedPage.getWikiPage();
        IterationPlanClient client = (IterationPlanClient)PlanningClientPlugin.getIterationPlanClient((IItemHandle)page);
        IWikiPageSafeRunnable safeRunnable = WikiClient.getWikiManager((IItem)page).createWikiPageSafeRunnable(resolvedPage, false, monitor);
        ((WikiPage)safeRunnable.getWikiPage()).setVersion("2.0");
        client.save(this.canSavePlan(), this.getPlanRecord(), null, new WorkItemWorkingCopy[0], null, new IWikiPageSafeRunnable[]{safeRunnable}, monitor);
        this.fWikiPages.remove((Object)page);
        this.fWikiPages.add((Object)safeRunnable.getWikiPage());
    }

    public static List<IFilterDescription> excludeWebOnlyFilters(List<IFilterDescription> descriptions) {
        ArrayList<IFilterDescription> result = new ArrayList<IFilterDescription>(descriptions.size());
        for (IFilterDescription description : descriptions) {
            if ("com.ibm.team.apt.filter.ownedByMe".equals(description.getId()) || "com.ibm.team.apt.filter.ownedByOthers".equals(description.getId()) || "com.ibm.team.apt.filter.archivedGroups".equals(description.getId())) continue;
            result.add(description);
        }
        return result;
    }

    public synchronized ResolvedIterationPlan getIterationPlan() {
        return this.fPlan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIterationPlan(ResolvedIterationPlan plan) {
        IterationPlanData iterationPlanData = this;
        synchronized (iterationPlanData) {
            Object listener;
            int n;
            int n2;
            Object[] objectArray;
            Object[] listeners;
            if (this.fPlan != null) {
                this.fPlan.setItemResolveService(null);
                objectArray = listeners = this.fPlanListeners.getListeners();
                n2 = listeners.length;
                n = 0;
                while (n < n2) {
                    listener = objectArray[n];
                    this.fPlan.removeListener((IPlanElementListener)listener);
                    ++n;
                }
                this.fPlan.removeListener(this.fPlanListener);
            }
            this.fPlan = plan;
            if (this.fPlan != null) {
                if (this.fFilters != null) {
                    this.fPlan.setCoreElementCriteria(this.fFilters);
                }
                if (this.fItemResolveService != null) {
                    this.fPlan.setItemResolveService(this.fItemResolveService);
                }
                objectArray = listeners = this.fPlanListeners.getListeners();
                n2 = listeners.length;
                n = 0;
                while (n < n2) {
                    listener = objectArray[n];
                    this.fPlan.addListener((IPlanElementListener)listener);
                    ++n;
                }
                this.fPlan.addListener(this.fPlanListener);
                this.fireIterationPlanResolved(plan);
            }
        }
    }

    public synchronized void setCoreElementCriteria(ICorePlanItemFilter[] filters) {
        this.fFilters = filters;
        if (this.fPlan != null) {
            this.fPlan.setCoreElementCriteria(filters);
        }
    }

    public synchronized void setItemResolveService(IItemResolveService itemResolveService) {
        this.fItemResolveService = itemResolveService;
        if (this.fPlan != null) {
            this.fPlan.setItemResolveService(itemResolveService);
        }
    }

    public synchronized void addPlanListener(IPlanElementListener listener) {
        this.fPlanListeners.add((Object)listener);
        if (this.fPlan != null) {
            this.fPlan.addListener(listener);
        }
    }

    public synchronized void removePlanListener(IPlanElementListener listener) {
        this.fPlanListeners.remove((Object)listener);
        if (this.fPlan != null) {
            this.fPlan.removeListener(listener);
        }
    }

    public synchronized void autoMerge(IReconcileReport[] reports) {
        if (this.fPlan != null) {
            this.fPlan.autoMerge(reports);
        }
    }

    public synchronized void revert(IReconcileReport[] reports) {
        if (this.fPlan != null) {
            this.fPlan.revert(reports);
        }
    }

    public synchronized void refresh(IReconcileReport[] reports) {
        if (this.fPlan != null) {
            this.fPlan.refresh(reports);
        }
    }

    public synchronized void overwriteRecord(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fPlan != null) {
            this.fRecord = this.fPlan.overwriteRecord(monitor);
        }
    }

    public PlanReferences getReferences() {
        return this.fPlanReferences;
    }

    public String getRankingMode() {
        return this.fRankingMode;
    }

    public IParameter[] getExplicitRankParams() {
        IParameter[] params = this.fExplicitRankParams;
        return params;
    }

    public void addListener(IterationPlanDataListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removeListener(IterationPlanDataListener listener) {
        this.fListeners.remove((Object)listener);
    }

    private void fireIterationPlanResolved(ResolvedIterationPlan plan) {
        Object[] listeners;
        Object[] objectArray = listeners = this.fListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IterationPlanDataListener)listener).iterationPlanResolved(plan);
            ++n2;
        }
    }

    private void fireDirtyStateChanged(boolean oldValue, boolean newValue) {
        Object[] listeners;
        Object[] objectArray = listeners = this.fListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IterationPlanDataListener)listener).dirtyStateChanged(oldValue, newValue);
            ++n2;
        }
    }
}

