/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client;

import com.ibm.team.apt.internal.client.EstimateMode;
import com.ibm.team.apt.internal.client.IterationPlanClient;
import com.ibm.team.apt.internal.client.Messages;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.common.duration.PlanDuration;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class DurationSupport {
    public static final DurationSupportFactory FACTORY = new DurationSupportFactory();
    public static final IStatus TIME_REMAINING_EXCEEDS_ESTIMATE = new Status(4, PlanningClientPlugin.getPluginId(), Messages.DurationAdjuster_TIME_REMAINING_EXCEEDS_ESTIMATE);
    private final EstimateMode fEstimateMode;

    private DurationSupport(EstimateMode estimateMode) {
        this.fEstimateMode = estimateMode;
    }

    public EstimateMode getEstimateMode() {
        return this.fEstimateMode;
    }

    public IStatus setCurrentDuration(IWorkItem item, boolean isResolved, long value) {
        return this.setCurrentDuration(item, null, isResolved, value);
    }

    public IStatus setCurrentDuration(IWorkItem item, IAttribute attribute, boolean isResolved, long newDuration) {
        IStatus status = Status.OK_STATUS;
        WorkItem workItem = (WorkItem)item;
        PlanDuration duration = new PlanDuration(workItem.getDuration(), workItem.getCorrectedEstimate(), workItem.getTimeSpent(), isResolved);
        IWorkItemWorkingCopyManager manager = PlanningClientPlugin.getWorkItemClient((IItemHandle)workItem).getWorkItemWorkingCopyManager();
        manager.beginCompoundWorkItemChange((IWorkItemHandle)workItem);
        try {
            boolean isValidTimeRemaining;
            boolean bl = isValidTimeRemaining = newDuration >= 0L;
            if (this.isMode(EstimateMode.TimeRemaining) && isValidTimeRemaining && duration.hasEstimate()) {
                if (duration.getCurrentEstimateDuration() < newDuration) {
                    newDuration = PlanDuration.encodeTimeRemaining2TimeSpent((long)newDuration);
                    status = TIME_REMAINING_EXCEEDS_ESTIMATE;
                } else {
                    newDuration = duration.getCurrentEstimateDuration() - newDuration;
                }
            }
            this.setTimespentValue(workItem, attribute, newDuration);
        }
        finally {
            manager.endCompoundWorkItemChange((IWorkItemHandle)workItem);
        }
        return status;
    }

    private void setTimespentValue(WorkItem workItem, IAttribute attribute, long value) {
        if (attribute != null) {
            workItem.setValue(attribute, (Object)value);
        } else {
            workItem.setTimeSpent(value);
        }
    }

    public IStatus setCurrentEstimate(IWorkItem item, boolean editingCorrectedEstimate, boolean isResolved, long newEstimate) {
        IStatus status = Status.OK_STATUS;
        WorkItem workItem = (WorkItem)item;
        PlanDuration duration = new PlanDuration(workItem.getDuration(), workItem.getCorrectedEstimate(), workItem.getTimeSpent(), isResolved);
        long delta = newEstimate - workItem.getDuration();
        IWorkItemWorkingCopyManager manager = PlanningClientPlugin.getWorkItemClient((IItemHandle)workItem).getWorkItemWorkingCopyManager();
        manager.beginCompoundWorkItemChange((IWorkItemHandle)workItem);
        try {
            if (duration.hasCorrectedEstimate() || editingCorrectedEstimate) {
                workItem.setCorrectedEstimate(newEstimate);
                if (newEstimate < 0L) {
                    newEstimate = duration.getOriginalEstimateDuration();
                }
            } else {
                workItem.setDuration(newEstimate);
            }
            if (this.isMode(EstimateMode.TimeRemaining)) {
                long timeSpent = duration.getTimeSpentDuration();
                if (PlanDuration.isEncodedTimeRemaining((long)timeSpent)) {
                    long timeRemaining = PlanDuration.decodeTimeSpent2TimeRemaining((long)timeSpent);
                    long adjustedTimeRemaining = timeRemaining + delta;
                    if (newEstimate < timeRemaining) {
                        status = TIME_REMAINING_EXCEEDS_ESTIMATE;
                    } else if (newEstimate < adjustedTimeRemaining) {
                        workItem.setTimeSpent(newEstimate - timeRemaining);
                    } else {
                        workItem.setTimeSpent(newEstimate - adjustedTimeRemaining);
                    }
                } else {
                    long timeRemaining = newEstimate - timeSpent;
                    if (timeRemaining < -1L && timeSpent > -1L) {
                        status = TIME_REMAINING_EXCEEDS_ESTIMATE;
                    } else if (timeRemaining >= 0L) {
                        workItem.setTimeSpent(newEstimate - timeRemaining);
                    }
                }
            }
        }
        finally {
            manager.endCompoundWorkItemChange((IWorkItemHandle)workItem);
        }
        return status;
    }

    private boolean isMode(EstimateMode mode) {
        return this.fEstimateMode == mode;
    }

    /* synthetic */ DurationSupport(EstimateMode estimateMode, DurationSupport durationSupport) {
        this(estimateMode);
    }

    public static class DurationSupportFactory {
        private DurationSupportFactory() {
        }

        public DurationSupport getInstance(IProcessAreaHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
            IterationPlanClient client = (IterationPlanClient)PlanningClientPlugin.getIterationPlanClient((IItemHandle)handle);
            DurationSupport support = this.getInstance(handle);
            if (support != null) {
                return support;
            }
            EstimateMode mode = client.fetchEstimationMode(handle, monitor);
            return new DurationSupport(mode, null);
        }

        public DurationSupport getInstance(IProcessAreaHandle handle) {
            IterationPlanClient client = (IterationPlanClient)PlanningClientPlugin.getIterationPlanClient((IItemHandle)handle);
            EstimateMode mode = client.findCachedEstimationMode(handle);
            if (mode != null) {
                return new DurationSupport(mode, null);
            }
            return null;
        }
    }
}

