/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.client.datagen.build.impl;

import com.ibm.team.apt.client.datagen.ITestSetup;
import com.ibm.team.apt.client.datagen.build.IAttributeGenerator;
import com.ibm.team.apt.client.datagen.build.IWorkItemGenerationStrategy;
import com.ibm.team.apt.client.datagen.build.StaticAttributeGenerator;
import com.ibm.team.apt.client.datagen.build.hierarchy.AbstractNodeGenerator;
import com.ibm.team.apt.client.datagen.build.hierarchy.IHierarchy;
import com.ibm.team.apt.client.datagen.build.hierarchy.INodeGenerator;
import com.ibm.team.apt.client.datagen.build.impl.AbstractDataGenerationStrategy;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.common.internal.setup.builders.IArtifactBuilder;
import com.ibm.team.workitem.common.internal.setup.builders.WorkItemBuilder;
import com.ibm.team.workitem.common.model.IPriority;
import com.ibm.team.workitem.common.model.Identifier;
import java.util.ArrayList;

public class WorkItemGenerationStrategy
extends AbstractDataGenerationStrategy
implements IWorkItemGenerationStrategy {
    private IProjectArea fProjectArea;
    private int fGenerationCount;
    private IHierarchy fHierarchyStrategy;
    private IEndPointDescriptor fLinkType;
    private ArrayList<WorkItemBuilder> rootChildren = new ArrayList();
    private ArrayList<IAttributeGenerator> fAttributeGenerators = new ArrayList();

    public WorkItemGenerationStrategy(AbstractDataGenerationStrategy.StrategyParams params) {
        super(params);
    }

    @Override
    public IWorkItemGenerationStrategy addAttributeGenerator(IAttributeGenerator generator) {
        this.fAttributeGenerators.add(generator);
        return this;
    }

    @Override
    protected void doGenerate() {
        this.fHierarchyStrategy.nodeGenerator(this.getNodeGenerator());
        this.fHierarchyStrategy.generate();
        for (WorkItemBuilder rootChild : this.rootChildren) {
            try {
                rootChild.save();
            }
            catch (TeamRepositoryException e) {
                e.printStackTrace();
            }
        }
        this.fGenerationCount = 0;
    }

    private WorkItemBuilder doGenerateWorkItem() {
        String name = String.format(this.fNameFormat, this.fGenerationCount++);
        WorkItemBuilder generatedItem = this.$.workItem(name).summary(name).projectArea(this.fProjectArea);
        for (IAttributeGenerator attributeGenerator : this.fAttributeGenerators) {
            attributeGenerator.setAttribute(generatedItem);
        }
        return generatedItem;
    }

    @Override
    public IWorkItemGenerationStrategy projectArea(IProjectArea projectArea) {
        this.fProjectArea = projectArea;
        return this;
    }

    @Override
    protected String getDefaultNameFormat() {
        return "Item %d";
    }

    @Override
    public IWorkItemGenerationStrategy heirarchy(IHierarchy hierarchy) {
        this.fHierarchyStrategy = hierarchy;
        return this;
    }

    public INodeGenerator<WorkItemBuilder, ITestSetup> getNodeGenerator() {
        return new AbstractNodeGenerator<WorkItemBuilder, ITestSetup>(this.$){

            @Override
            public WorkItemBuilder doCreateNode() {
                return WorkItemGenerationStrategy.this.doGenerateWorkItem();
            }

            @Override
            public void addChildToRoot(WorkItemBuilder child) {
                WorkItemGenerationStrategy.this.rootChildren.add(child);
            }

            @Override
            public void addChildToNode(WorkItemBuilder child, WorkItemBuilder parent) {
                parent.addChildBuilder(new IArtifactBuilder[]{child});
                parent.addWorkItemLink(child, WorkItemGenerationStrategy.this.fLinkType);
            }
        };
    }

    @Override
    public IWorkItemGenerationStrategy linkType(IEndPointDescriptor linkType) {
        this.fLinkType = linkType;
        return this;
    }

    @Override
    public IWorkItemGenerationStrategy type(String typeString) {
        this.addAttributeGenerator(new StaticAttributeGenerator<String>(WorkItemBuilder.TYPE, typeString));
        return this;
    }

    public IWorkItemGenerationStrategy priority(Identifier<IPriority> priority) {
        this.addAttributeGenerator(new StaticAttributeGenerator<Identifier<IPriority>>(WorkItemBuilder.PRIORITY, priority));
        return this;
    }
}

