/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.client.datagen.build.impl;

import com.ibm.team.apt.client.datagen.build.IMemberGenerationStrategy;
import com.ibm.team.apt.client.datagen.build.ITeamAreaGenerationStrategy;
import com.ibm.team.apt.client.datagen.build.hierarchy.AbstractNodeGenerator;
import com.ibm.team.apt.client.datagen.build.hierarchy.IHierarchy;
import com.ibm.team.apt.client.datagen.build.hierarchy.INodeGenerator;
import com.ibm.team.apt.client.datagen.build.impl.AbstractDataGenerationStrategy;
import com.ibm.team.process.common.IRole;
import com.ibm.team.process.common.internal.setup.builders.ProjectAreaBuilder;
import com.ibm.team.process.common.internal.setup.builders.TeamAreaBuilder;
import com.ibm.team.repository.common.IContributorHandle;
import java.util.HashSet;
import java.util.Set;

public class TeamAreaGenerationStrategy
extends AbstractDataGenerationStrategy
implements ITeamAreaGenerationStrategy {
    private IHierarchy fHierarchyStrategy;
    private Set<IMemberGenerationStrategy> fMemberStrategies = new HashSet<IMemberGenerationStrategy>();
    private int fGeneratedCount = 0;

    public TeamAreaGenerationStrategy(AbstractDataGenerationStrategy.StrategyParams params) {
        super(params);
    }

    @Override
    protected void doGenerate() {
        this.fHierarchyStrategy.nodeGenerator(this.getNodeGenerator());
        this.fHierarchyStrategy.generate();
        this.fGeneratedCount = 0;
    }

    private TeamAreaBuilder doGenerateTeamArea() {
        String name = String.format(this.fNameFormat, this.fGeneratedCount++);
        return this.doGenerateTeamAreaMembers(this.$.teamArea(name).name(name));
    }

    private TeamAreaBuilder doGenerateTeamAreaMembers(TeamAreaBuilder teamArea) {
        for (IMemberGenerationStrategy strategy : this.fMemberStrategies) {
            strategy.memberCollector(this.doGetTeamAreaMemberCollector(teamArea));
            strategy.generate();
        }
        return teamArea;
    }

    private IMemberGenerationStrategy.IMemberCollector doGetTeamAreaMemberCollector(final TeamAreaBuilder teamArea) {
        return new IMemberGenerationStrategy.IMemberCollector(){

            @Override
            public void add(IContributorHandle contributor) {
                teamArea.member(contributor, new IRole[0]);
            }
        };
    }

    @Override
    public INodeGenerator<TeamAreaBuilder, ProjectAreaBuilder> getNodeGenerator() {
        return new AbstractNodeGenerator<TeamAreaBuilder, ProjectAreaBuilder>(this.fBuilder){

            @Override
            public TeamAreaBuilder doCreateNode() {
                return TeamAreaGenerationStrategy.this.doGenerateTeamArea();
            }

            @Override
            public void addChildToRoot(TeamAreaBuilder child) {
                ((ProjectAreaBuilder)this.root()).teamArea(child);
            }

            @Override
            public void addChildToNode(TeamAreaBuilder child, TeamAreaBuilder parent) {
                parent.teamArea(child);
            }
        };
    }

    @Override
    public ITeamAreaGenerationStrategy hierarchy(IHierarchy hierarchyStrategy) {
        this.fHierarchyStrategy = hierarchyStrategy;
        return this;
    }

    @Override
    public ITeamAreaGenerationStrategy memberGenerator(IMemberGenerationStrategy memberStrategy) {
        this.fMemberStrategies.add(memberStrategy);
        memberStrategy.builder(this.fBuilder);
        return this;
    }

    @Override
    protected String getDefaultNameFormat() {
        return "Team %d";
    }
}

