/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.client.datagen.build.impl;

import com.ibm.team.apt.client.datagen.build.IMemberGenerationStrategy;
import com.ibm.team.apt.client.datagen.build.impl.AbstractDataGenerationStrategy;
import com.ibm.team.apt.common.resource.IContributorAbsence;
import com.ibm.team.apt.common.resource.IWorkResourceDetails;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.resource.IResourcePlanningClient;
import com.ibm.team.apt.internal.common.resource.model.ContributorAbsence;
import com.ibm.team.apt.internal.common.resource.model.ResourceFactory;
import com.ibm.team.apt.internal.common.resource.model.WorkResourceDetails;
import com.ibm.team.process.common.internal.setup.builders.ProjectAreaBuilder;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class MemberGenerationStrategy
extends AbstractDataGenerationStrategy
implements IMemberGenerationStrategy {
    private final IResourcePlanningClient fPlanningClient;
    private final List<ContributorAbsence> fReferenceAbsences;
    private final List<WorkResourceDetails> fReferenceDetails;
    private int fCount;
    private IMemberGenerationStrategy.IMemberCollector fMemberCollector;
    private boolean fRecycle;

    public MemberGenerationStrategy(AbstractDataGenerationStrategy.StrategyParams params) {
        super(params);
        this.fPlanningClient = PlanningClientPlugin.getResourcePlanningClient(params.teamRepository);
        this.fReferenceAbsences = new ArrayList<ContributorAbsence>();
        this.fReferenceDetails = new ArrayList<WorkResourceDetails>();
    }

    @Override
    public MemberGenerationStrategy absence(ContributorAbsence absence) {
        this.fReferenceAbsences.add(absence);
        return this;
    }

    @Override
    public MemberGenerationStrategy count(int count) {
        this.fCount = count;
        return this;
    }

    private int doAddExistingContributors(ProjectAreaBuilder builder, int numContributors) throws TeamRepositoryException {
        List contributors = this.getTeamRepository().contributorManager().fetchAllContributors(null);
        int contributorsToAdd = Math.min(contributors.size(), numContributors);
        int i = 0;
        while (i < contributorsToAdd) {
            IContributor contributor = (IContributor)contributors.get(i);
            this.doAddToCollector(contributor);
            this.doGenerateAbsences(contributor);
            this.doGenerateWorkResourceDetails(contributor);
            ++i;
        }
        return contributorsToAdd;
    }

    private void doAddToCollector(IContributor contributor) {
        if (this.fMemberCollector != null) {
            this.fMemberCollector.add((IContributorHandle)contributor);
        }
    }

    @Override
    protected void doGenerate() {
        int numAdded = 0;
        try {
            if (this.fRecycle) {
                numAdded = this.doAddExistingContributors(this.fBuilder, this.fCount);
            }
            this.doGenerateContributors(this.fBuilder, numAdded + 1, this.fCount);
        }
        catch (TeamRepositoryException e) {
            e.printStackTrace();
        }
    }

    private void doGenerateAbsences(IContributor contributor) throws TeamRepositoryException {
        ContributorAbsence[] absences = new ContributorAbsence[this.fReferenceAbsences.size()];
        int i = 0;
        while (i < this.fReferenceAbsences.size()) {
            ContributorAbsence reference = this.fReferenceAbsences.get(i);
            absences[i] = this.doCreateAbsenceFromReference(contributor, reference);
            ++i;
        }
        this.fPlanningClient.saveAbsences((IContributorAbsence[])absences, (IProgressMonitor)new NullProgressMonitor());
    }

    private ContributorAbsence doCreateAbsenceFromReference(IContributor contributor, ContributorAbsence reference) {
        ContributorAbsence absence = (ContributorAbsence)IContributorAbsence.ITEM_TYPE.createItem();
        absence.setContributor((IContributorHandle)contributor);
        absence.setSummary(reference.getSummary());
        absence.setStartDate(reference.getStartDate());
        absence.setEndDate(reference.getEndDate());
        return absence;
    }

    private void doGenerateContributors(ProjectAreaBuilder builder, int start, int numContributors) throws TeamRepositoryException {
        int i = start;
        while (i < numContributors) {
            String name = this.getContributorName(i);
            this.doAddToCollector(this.doGenerateContributor(name));
            ++i;
        }
    }

    private IContributor doGenerateContributor(String name) throws TeamRepositoryException {
        IContributor contributor = (IContributor)this.$.contributor(name).name(name).save();
        this.doGenerateAbsences(contributor);
        this.doGenerateWorkResourceDetails(contributor);
        return contributor;
    }

    private void doGenerateWorkResourceDetails(IContributor contributor) throws TeamRepositoryException {
        WorkResourceDetails[] workDetails = new WorkResourceDetails[this.fReferenceDetails.size()];
        int i = 0;
        while (i < this.fReferenceDetails.size()) {
            WorkResourceDetails reference = this.fReferenceDetails.get(i);
            workDetails[i] = this.doCreateWorkDetailsFromReference(contributor, reference);
            ++i;
        }
        this.fPlanningClient.saveWorkDetails((IWorkResourceDetails[])workDetails, (IProgressMonitor)new NullProgressMonitor());
    }

    private WorkResourceDetails doCreateWorkDetailsFromReference(IContributor contributor, WorkResourceDetails reference) {
        WorkResourceDetails workDetails = ResourceFactory.eINSTANCE.createWorkResourceDetails();
        workDetails.setAssignment(reference.getAssignment());
        workDetails.setStartDate(reference.getStartDate());
        workDetails.setEndDate(reference.getEndDate());
        workDetails.setOwner(reference.getOwner());
        workDetails.setDevelopmentLine(reference.getDevelopmentLine());
        workDetails.setContributor((IContributorHandle)contributor);
        return workDetails;
    }

    private String getContributorName(int thisContributor) {
        return String.format(this.fNameFormat, thisContributor);
    }

    @Override
    public MemberGenerationStrategy memberCollector(IMemberGenerationStrategy.IMemberCollector collector) {
        this.fMemberCollector = collector;
        return this;
    }

    @Override
    public MemberGenerationStrategy recycle(boolean recycle) {
        this.fRecycle = recycle;
        return this;
    }

    @Override
    public MemberGenerationStrategy workResource(WorkResourceDetails detail) {
        this.fReferenceDetails.add(detail);
        return this;
    }

    @Override
    protected String getDefaultNameFormat() {
        return "User %d";
    }
}

