/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.client.datagen.build.impl;

import com.ibm.team.apt.client.datagen.build.IIterationGenerationStrategy;
import com.ibm.team.apt.client.datagen.build.hierarchy.AbstractNodeGenerator;
import com.ibm.team.apt.client.datagen.build.hierarchy.IHierarchy;
import com.ibm.team.apt.client.datagen.build.hierarchy.INodeGenerator;
import com.ibm.team.apt.client.datagen.build.impl.AbstractDataGenerationStrategy;
import com.ibm.team.process.common.internal.setup.builders.DevelopmentLineBuilder;
import com.ibm.team.process.common.internal.setup.builders.IterationBuilder;

public class IterationGenerationStrategy
extends AbstractDataGenerationStrategy
implements IIterationGenerationStrategy {
    private static final String CURRENT_ITER = "Current Iteration";
    private DevelopmentLineBuilder fDevLine;
    private IHierarchy fHierarchyStrategy;
    private int fGenerationCount;

    public IterationGenerationStrategy(AbstractDataGenerationStrategy.StrategyParams params) {
        super(params);
    }

    @Override
    public IterationGenerationStrategy devline(DevelopmentLineBuilder devline) {
        this.fDevLine = devline;
        return this;
    }

    @Override
    protected void doGenerate() {
        this.fHierarchyStrategy.nodeGenerator(this.getNodeGenerator());
        this.fHierarchyStrategy.generate();
        this.fGenerationCount = 0;
    }

    @Override
    public INodeGenerator<IterationBuilder, DevelopmentLineBuilder> getNodeGenerator() {
        return new AbstractNodeGenerator<IterationBuilder, DevelopmentLineBuilder>(this.fDevLine){

            @Override
            public IterationBuilder doCreateNode() {
                IterationBuilder iterationBuilder = IterationGenerationStrategy.this.$.iteration();
                String string = IterationGenerationStrategy.this.fNameFormat;
                Object[] objectArray = new Object[1];
                IterationGenerationStrategy iterationGenerationStrategy = IterationGenerationStrategy.this;
                int n = iterationGenerationStrategy.fGenerationCount;
                iterationGenerationStrategy.fGenerationCount = n + 1;
                objectArray[0] = n;
                IterationBuilder iter = iterationBuilder.name(String.format(string, objectArray));
                if (IterationGenerationStrategy.this.fGenerationCount == 0) {
                    iter.currentIteration(IterationGenerationStrategy.this.$.iteration(IterationGenerationStrategy.CURRENT_ITER).name(IterationGenerationStrategy.CURRENT_ITER));
                }
                return iter;
            }

            @Override
            public void addChildToRoot(IterationBuilder child) {
                ((DevelopmentLineBuilder)this.root()).iteration(new IterationBuilder[]{child});
            }

            @Override
            public void addChildToNode(IterationBuilder child, IterationBuilder parent) {
                parent.child(new IterationBuilder[]{child});
            }
        };
    }

    @Override
    public IterationGenerationStrategy hierarchy(IHierarchy hierarchyStrategy) {
        this.fHierarchyStrategy = hierarchyStrategy;
        return this;
    }

    @Override
    protected String getDefaultNameFormat() {
        return "Iteration %d";
    }
}

