/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.client.datagen.build.impl;

import com.ibm.team.apt.client.datagen.ITestSetup;
import com.ibm.team.apt.client.datagen.build.IDataGenerationStrategy;
import com.ibm.team.process.common.internal.setup.builders.ProjectAreaBuilder;
import com.ibm.team.repository.client.ITeamRepository;

public abstract class AbstractDataGenerationStrategy
implements IDataGenerationStrategy {
    protected final ITeamRepository fTeamRepository;
    protected final ITestSetup $;
    protected ProjectAreaBuilder fBuilder;
    protected String fNameFormat = "User %d";

    public AbstractDataGenerationStrategy(StrategyParams params) {
        this.fTeamRepository = params.teamRepository;
        this.$ = params.testSetup;
        this.fNameFormat = this.getDefaultNameFormat();
    }

    @Override
    public AbstractDataGenerationStrategy builder(ProjectAreaBuilder builder) {
        this.fBuilder = builder;
        return this;
    }

    protected void checkIsValid() {
        assert (this.fBuilder != null);
    }

    protected abstract void doGenerate();

    @Override
    public void generate() {
        this.checkIsValid();
        this.doGenerate();
    }

    protected ITeamRepository getTeamRepository() {
        return this.fTeamRepository;
    }

    @Override
    public AbstractDataGenerationStrategy nameFormat(String format) {
        this.fNameFormat = format;
        return this;
    }

    protected abstract String getDefaultNameFormat();

    public static class StrategyParams {
        public ITeamRepository teamRepository;
        public ITestSetup testSetup;

        public StrategyParams teamRepository(ITeamRepository teamRepository) {
            this.teamRepository = teamRepository;
            return this;
        }

        public StrategyParams testSetup(ITestSetup testSetup) {
            this.testSetup = testSetup;
            return this;
        }
    }
}

