/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.client.datagen.build.hierarchy.impl;

import com.ibm.team.apt.client.datagen.build.hierarchy.impl.AbstractHierarchy;

public class KTreeHierarchy
extends AbstractHierarchy {
    private int fCount;
    private int fDepth;
    private int fKValue = 2;

    public KTreeHierarchy children(int children) {
        this.fKValue = children;
        return this;
    }

    public KTreeHierarchy count(int count) {
        this.fCount = count;
        this.fDepth = this.getDepthForKTree(this.fKValue, this.fCount);
        return this;
    }

    public KTreeHierarchy depth(int depth) {
        this.fDepth = depth;
        this.fCount = this.getNodeCountForPerfectKTree(this.fKValue, this.fDepth);
        return this;
    }

    @Override
    public void generate() {
        this.fNodeGenerator.child();
        this.doGenerate(1, 1);
    }

    private int doGenerate(int depth, int totalNodes) {
        int i = 0;
        while (i < this.fKValue) {
            if (totalNodes == this.fCount) break;
            ++totalNodes;
            this.fNodeGenerator.child();
            if (depth < this.fDepth) {
                totalNodes = this.doGenerate(depth + 1, totalNodes);
            }
            if (this.fNodeGenerator.parent() != null) {
                this.fNodeGenerator.up();
            }
            ++i;
        }
        return totalNodes;
    }

    private int getNodeCountForPerfectKTree(int k, int depth) {
        return (int)(Math.pow(k, depth + 1) - 1.0) / (k - 1);
    }

    private int getDepthForKTree(int k, int nodeCount) {
        int innerExpr = (k - 1) * nodeCount + 1;
        return (int)Math.ceil(this.logBaseK(innerExpr, k) - 1.0);
    }

    private double logBaseK(int operand, int k) {
        return Math.log(operand) / Math.log(k);
    }
}

