/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.client.datagen.build.hierarchy;

import com.ibm.team.apt.client.datagen.build.hierarchy.INodeGenerator;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractNodeGenerator<Type, Root>
implements INodeGenerator<Type, Root> {
    private final Root fRoot;
    private final List<Type> fPath = new LinkedList<Type>();
    private Type fCurrent;

    public AbstractNodeGenerator(Root root) {
        this.fRoot = root;
    }

    protected abstract void addChildToRoot(Type var1);

    protected abstract void addChildToNode(Type var1, Type var2);

    protected abstract Type doCreateNode();

    @Override
    public void child() {
        if (this.current() == null) {
            this.createFromRoot();
        } else {
            this.createFromCurrent();
        }
    }

    @Override
    public Type current() {
        return this.fCurrent;
    }

    @Override
    public Type parent() {
        if (this.fPath.isEmpty()) {
            return null;
        }
        return this.fPath.get(this.fPath.size() - 1);
    }

    @Override
    public Root root() {
        return this.fRoot;
    }

    @Override
    public void sibling() {
        if (this.parent() == null) {
            this.createFromRoot();
        } else {
            this.createFromParent();
        }
    }

    @Override
    public void up() {
        if (this.fPath.isEmpty()) {
            throw new IllegalStateException();
        }
        this.fCurrent = this.fPath.remove(this.fPath.size() - 1);
    }

    private void createFromRoot() {
        Type child = this.doCreateNode();
        this.addChildToRoot(child);
        this.fCurrent = child;
    }

    private void createFromCurrent() {
        Type child = this.doCreateNode();
        this.addChildToNode(child, this.fCurrent);
        this.fPath.add(this.fCurrent);
        this.fCurrent = child;
    }

    private void createFromParent() {
        Type child = this.doCreateNode();
        this.addChildToNode(child, this.parent());
        this.fCurrent = child;
    }
}

