/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.client.datagen.build;

import com.ibm.team.apt.client.datagen.ITestSetup;
import com.ibm.team.apt.client.datagen.build.IDataGenerationStrategy;
import com.ibm.team.apt.client.datagen.build.IIterationGenerationStrategy;
import com.ibm.team.apt.client.datagen.build.IMemberGenerationStrategy;
import com.ibm.team.apt.client.datagen.build.ITeamAreaGenerationStrategy;
import com.ibm.team.apt.client.datagen.build.IWorkItemGenerationStrategy;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IRole;
import com.ibm.team.process.common.internal.setup.builders.DevelopmentLineBuilder;
import com.ibm.team.process.common.internal.setup.builders.ProjectAreaBuilder;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.HashSet;
import java.util.Set;

public class ProjectAreaGenerationStrategy {
    private final ProjectAreaBuilder fBuilder;
    private final DevelopmentLineBuilder fDevLine;
    private final Set<IMemberGenerationStrategy> fMemberStrategies = new HashSet<IMemberGenerationStrategy>();
    private final Set<ITeamAreaGenerationStrategy> fTeamStrategies = new HashSet<ITeamAreaGenerationStrategy>();
    private final Set<IIterationGenerationStrategy> fIterationStrategies = new HashSet<IIterationGenerationStrategy>();
    private final Set<IWorkItemGenerationStrategy> fWorkItemStrategies = new HashSet<IWorkItemGenerationStrategy>();

    public ProjectAreaGenerationStrategy(ITestSetup setup, String name) {
        this.fBuilder = setup.projectArea().name(name);
        this.fDevLine = setup.developmentLine().name("Main Development Line");
        this.fBuilder.developmentLine(this.fDevLine);
    }

    public ProjectAreaGenerationStrategy iterationGenerator(IIterationGenerationStrategy strategy) {
        strategy.devline(this.fDevLine);
        this.addStrategy(strategy, this.fIterationStrategies);
        return this;
    }

    public ProjectAreaGenerationStrategy memberGenerator(IMemberGenerationStrategy strategy) {
        strategy.memberCollector(new IMemberGenerationStrategy.IMemberCollector(){

            @Override
            public void add(IContributorHandle contributor) {
                ProjectAreaGenerationStrategy.this.fBuilder.member(contributor, new IRole[0]);
            }
        });
        this.addStrategy(strategy, this.fMemberStrategies);
        return this;
    }

    public IProjectArea save() throws TeamRepositoryException {
        this.generateIterations();
        this.generateMembers();
        this.generateTeamAreas();
        IProjectArea projectArea = (IProjectArea)this.fBuilder.save();
        this.generateWorkItems(projectArea);
        return projectArea;
    }

    public ProjectAreaGenerationStrategy teamGenerator(ITeamAreaGenerationStrategy strategy) {
        this.addStrategy(strategy, this.fTeamStrategies);
        return this;
    }

    public ProjectAreaGenerationStrategy workItemGenerator(IWorkItemGenerationStrategy strategy) {
        this.addStrategy(strategy, this.fWorkItemStrategies);
        return this;
    }

    private <T extends IDataGenerationStrategy> void addStrategy(T strategy, Set<T> set) {
        strategy.builder(this.fBuilder);
        set.add(strategy);
    }

    private void generateIterations() {
        for (IIterationGenerationStrategy strategy : this.fIterationStrategies) {
            strategy.generate();
        }
    }

    private void generateMembers() {
        for (IMemberGenerationStrategy strategy : this.fMemberStrategies) {
            strategy.generate();
        }
    }

    private void generateTeamAreas() {
        for (ITeamAreaGenerationStrategy strategy : this.fTeamStrategies) {
            strategy.generate();
        }
    }

    private void generateWorkItems(IProjectArea projectArea) {
        for (IWorkItemGenerationStrategy strategy : this.fWorkItemStrategies) {
            strategy.projectArea(projectArea).generate();
        }
    }
}

