/*******************************************************************************
 * Licensed Materials - Property of IBM
 * © Copyright IBM Corporation 2007, 2017. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:  Use,
 * duplication or disclosure restricted by GSA ADP Schedule 
 * Contract with IBM Corp.
 *******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.apt.api.common.internal.CombinedIdentifier");


(function() {
/**
 * The CombinedIdentifier will soon be deprecated. In Java Script use the more
 * efficient CombinedId instead. Similar class should be added for Java side
 * code.
 */
var CombinedIdentifier= dojo.declare("com.ibm.team.apt.api.common.internal.CombinedIdentifier", null, {
	"-chains-": { constructor: "manual" },

	//fTokens: null,

	constructor: function(input) {
		var tokenCount= 0;
		var len= input.length;
		for (var i= 0; i < len; i++){
			var ch= input.charAt(i);
			if (ch === CombinedIdentifier.DELIM) {
				tokenCount+= 1;
			}
		}
		tokenCount+= 1;
		this.fTokens= new Array(tokenCount);
		for (var i= 0; i < tokenCount; i++){
			this.fTokens[i]= "";
		}
		var index= 0;
		for (var i= 0; i < len; i++){
			var ch= input.charAt(i);
			if (ch === CombinedIdentifier.DELIM) {
				index+= 1;
			} else {
				this.fTokens[index]+= ch;
			}
		}
	},

	length: function() {
		return this.fTokens.length;
	},

	nth: function(index) {
		return this.fTokens[index];
	},

	first: function() {
		return this.nth(0);
	},

	second: function() {
		return this.nth(1);
	},

	third: function() {
		return this.nth(2);
	},

	forth: function() {
		return this.nth(3);
	},

	newFrom: function(idx) {
		var len= this.fTokens.length - idx;
		var segments= new Array(len);
		for (var i= 0; i < len; i++){
			segments[i]= this.fTokens[idx + i];
		}
		return CombinedIdentifier.ofArray(segments);
	}
});

CombinedIdentifier.DELIM= "/";
CombinedIdentifier.of= function( /*, segments... */ ) {
	var segments= Array.prototype.slice.call(arguments, 0);
	return CombinedIdentifier.ofArray(segments);
};
CombinedIdentifier.ofArray= function(segments) {
	var result= "";
	var len= segments.length;
	for (var i= 0; i < len; i++){
		result+= String(segments[i]);
		if (i + 1 < len) {
			result+= CombinedIdentifier.DELIM;
		}
	}
	return result;
};

})();
