/*******************************************************************************
 * Licensed Materials - Property of IBM
 * © Copyright IBM Corporation 2009, 2017. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:  Use,
 * duplication or disclosure restricted by GSA ADP Schedule 
 * Contract with IBM Corp.
 *******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.apt.api.common.UIItemHandle");

dojo.require("com.ibm.jdojo.util.Assert");
dojo.require("com.ibm.team.apt.api.common.ItemType");

(function() {
var Assert= com.ibm.jdojo.util.Assert;
var ItemType= com.ibm.team.apt.api.common.ItemType;

var UIItemHandle= dojo.declare("com.ibm.team.apt.api.common.UIItemHandle", null, {
	"-chains-": { constructor: "manual" },

	//fType: null,

	//fUuid: null,

	//fStateId: null,

	//fHandleValue: null,

	constructor: function(type, uuid, stateId, value) {
		this.fIndex1= -1;
		this.fIndex2= -1;
		if (!((type != null && uuid != null) || value != null)) Assert.fail("(type != null && uuid != null) || value != null", "UIItemHandle:79");
		this.fType= type;
		this.fUuid= uuid;
		this.fStateId= stateId;
		this.fHandleValue= value;
	},

	getType: function() {
		if (this.fType == null) {
			var to= this.indexFirstSemiColon();
			var str= this.fHandleValue.substring(0, to);
			this.fType= ItemType.fromString(str);
		}
		return this.fType;
	},

	getItemId: function() {
		if (this.fUuid == null) {
			var from= this.indexFirstSemiColon();
			var to= this.indexSecondSemiColon();
			to= to < 0 ? this.fHandleValue.length : to;
			this.fUuid= this.decodeSeparatorChar(this.fHandleValue.substring(from + 1, to));
		}
		return this.fUuid;
	},

	/**
	 * @deprecated Still referenced by the plan java script legacy
	 */
	getUuid: function() {
		return this.getItemId();
	},

	getStateId: function() {
		if (this.fStateId == null) {
			if (this.fHandleValue == null) 
				return null;
			var from= this.indexSecondSemiColon();
			if (from < 0) 
				return null;
			this.fStateId= this.decodeSeparatorChar(this.fHandleValue.substring(from + 1));
		}
		return this.fStateId;
	},

	getHandleValue: function() {
		return this.getHandleValue1(false);
	},

	toString: function() {
		return this.getHandleValue1(true);
	},

	getHandleValue1: function(verbose) {
		if (this.fHandleValue == null) {
			var type= verbose ? this.getType().getQualifiedName() : String(this.getType().ordinal);
			this.fHandleValue= type + String(UIItemHandle.fgSeparatorChar) + this.encodeSeparatorChar(this.getItemId());
			if (this.getStateId() != null) {
				this.fHandleValue+= UIItemHandle.fgSeparatorChar + this.encodeSeparatorChar(this.getStateId());
			}
		}
		return this.fHandleValue;
	},

	//fIndex1: null,

	indexFirstSemiColon: function() {
		if (this.fIndex1 === -1) {
			this.fIndex1= this.indexOfSeparatorChar(0);
		}
		return this.fIndex1;
	},

	//fIndex2: null,

	indexSecondSemiColon: function() {
		if (this.fIndex2 === -1) {
			var index1= this.indexFirstSemiColon();
			var index2= this.indexOfSeparatorChar(index1 + 1);
			if (index2 < 0) {
				this.fIndex2= -2;
			} else {
				this.fIndex2= index2;
			}
		}
		return this.fIndex2;
	},

	indexOfSeparatorChar: function(startIndex) {
		var index= this.fHandleValue.indexOf(UIItemHandle.fgSeparatorChar, startIndex);
		if (index >= 0) {
			if (this.isOverrideChar(index + 1)) {
				return this.indexOfSeparatorChar(index + 2);
			}
		}
		return index;
	},

	isOverrideChar: function(index) {
		var len= this.fHandleValue.length;
		var overridersCount= 0;
		for (var i= index; i < len; i++){
			if (this.fHandleValue.charAt(i) === UIItemHandle.fgSeparatorOverrideChar) {
				overridersCount++;
			} else {
				break;
			}
		}
		return overridersCount % 2 !== 0;
	},

	encodeSeparatorChar: function(str) {
		if (str == null) {
			return null;
		}
		var buffer= "";
		for (var i= 0; i < str.length; i++){
			var c= str.charAt(i);
			buffer+= c;
			if (c === UIItemHandle.fgSeparatorChar || c === UIItemHandle.fgSeparatorOverrideChar) {
				buffer+= UIItemHandle.fgSeparatorOverrideChar;
			}
		}
		return buffer;
	},

	decodeSeparatorChar: function(str) {
		var buffer= "";
		var len= str.length;
		for (var i= 0; i < len; i++){
			var c= str.charAt(i);
			if (c === UIItemHandle.fgSeparatorChar || c === UIItemHandle.fgSeparatorOverrideChar && i + 1 < len && str.charAt(i + 1) === UIItemHandle.fgSeparatorOverrideChar) {
				i++;
			}
			buffer+= c;
		}
		return buffer;
	},

	$interfaces: {
		'com.ibm.team.apt.api.common.IUIItemHandle': true
	}
});

UIItemHandle.fgSeparatorChar= ";";
UIItemHandle.fgSeparatorOverrideChar= "~";
UIItemHandle.itemHandleFrom= function(type, itemId) {
	return new UIItemHandle(type, itemId, null, null);
};
UIItemHandle.stateHandleFrom= function(type, itemId, stateId) {
	return new UIItemHandle(type, itemId, stateId, null);
};
UIItemHandle.itemHandleFor= function(item) {
	return new UIItemHandle(item.getItemType(), item.getItemId(), null, null);
};
UIItemHandle.stateHandleFor= function(item) {
	return new UIItemHandle(item.getItemType(), item.getItemId(), item.getStateId(), null);
};
UIItemHandle.fromHandle= function(value) {
	if (value == null) {
		return null;
	} else {
		return new UIItemHandle(null, null, null, value);
	}
};

})();
