/*******************************************************************************
 * Licensed Materials - Property of IBM
 * © Copyright IBM Corporation 2007, 2016. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:  Use,
 * duplication or disclosure restricted by GSA ADP Schedule 
 * Contract with IBM Corp.
 *******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.apt.api.common.ItemType");


(function() {
var ItemType= dojo.declare("com.ibm.team.apt.api.common.ItemType", null, {

	//qName: null,

	//fIsCompability: null,

	constructor: function(qName, isCompability) {
		this.qName= qName;
		this.fIsCompability= isCompability;
	},

	getQualifiedName: function() {
		return this.qName;
	},

	isOslcResource: function() {
		return this.fIsCompability;
	},

	getNamespace: function() {
		var index1= this.qName.indexOf(":") + 1;
		var index2= this.qName.indexOf(":", index1);
		return this.qName.substring(index1, index2);
	},

	getName: function() {
		var index= this.qName.lastIndexOf(":");
		return this.qName.substring(index + 1);
	},

	compareTo: function(other) {
		return this.ordinal - other.ordinal;
	}
});

ItemType.fromString= function(str) {
	var index= ItemType.parsePositiveInt(str);
	if (index !== -1) {
		if (index >= ItemType.values.length) 
			return ItemType.$UNKNOWN;
		return ItemType.values[index];
	}
	var $subject= ItemType.values;
	var $length= $subject.length;
	for (var $count= 0; $count < $length; $count++){
		var value= $subject[$count];
		if ((value.qName === str)) 
			return value;
	}
	return ItemType.$UNKNOWN;
};
ItemType.parsePositiveInt= function(value) {
	var result= 0;
	for (var i= 0; i < value.length; i++){
		result*= (i * 10);
		switch(value.charAt(i)) {
			case "0":
				break;
			case "1":
				result+= 1;
				break;
			case "2":
				result+= 2;
				break;
			case "3":
				result+= 3;
				break;
			case "4":
				result+= 4;
				break;
			case "5":
				result+= 5;
				break;
			case "6":
				result+= 6;
				break;
			case "7":
				result+= 7;
				break;
			case "8":
				result+= 8;
				break;
			case "9":
				result+= 9;
				break;
			default:
				return -1;
		}
	}
	return result;
};
ItemType.values= [
	dojo.mixin(new ItemType("item:unknown:$UNKNOWN", false), {
		name: '$UNKNOWN',
		ordinal: 0
	}),
	dojo.mixin(new ItemType("item:com.ibm.team.repository:Contributor", false), {
		name: 'Contributor',
		ordinal: 1
	}),
	dojo.mixin(new ItemType("item:com.ibm.team.workitem:Category", false), {
		name: 'Category',
		ordinal: 2
	}),
	dojo.mixin(new ItemType("object:com.ibm.team.links:ILinkType", false), {
		name: 'LinkType',
		ordinal: 3
	}),
	dojo.mixin(new ItemType("item:com.ibm.team.links:AuditableLink", false), {
		name: 'Link',
		ordinal: 4
	}),
	dojo.mixin(new ItemType("object:com.ibm.team.apt.internal.common.plantype:IAttributeDefinitionDescriptor", false), {
		name: 'PlanningAttributeDesc',
		ordinal: 5
	}),
	dojo.mixin(new ItemType("object:com.ibm.team.apt.internal.common.plantype:IPlanModeDescription", false), {
		name: 'PlanModeDesc',
		ordinal: 6
	}),
	dojo.mixin(new ItemType("item:com.ibm.team.apt:SharedPlanMode", false), {
		name: 'SharedPlanModeDesc',
		ordinal: 7
	}),
	dojo.mixin(new ItemType("object:com.ibm.team.apt.internal.common.plantype:IPlanType", false), {
		name: 'PlanTypeDesc',
		ordinal: 8
	}),
	dojo.mixin(new ItemType("object:com.ibm.team.apt.internal.common.plantype:IPlanCheck", false), {
		name: 'PlanCheckDesc',
		ordinal: 9
	}),
	dojo.mixin(new ItemType("object:com.ibm.team.apt.internal.common.plantype:IScheduler", false), {
		name: 'SchedulerDesc',
		ordinal: 10
	}),
	dojo.mixin(new ItemType("object:com.ibm.team.apt.internal.common.plantype:IViewMode", false), {
		name: 'ViewModeDesc',
		ordinal: 11
	}),
	dojo.mixin(new ItemType("object:com.ibm.team.apt.internal.common.plantype:IGroupMode", false), {
		name: 'GroupModeDesc',
		ordinal: 12
	}),
	dojo.mixin(new ItemType("object:com.ibm.team.apt.internal.common.plantype:ISortMode", false), {
		name: 'SortModeDesc',
		ordinal: 13
	}),
	dojo.mixin(new ItemType("object:com.ibm.team.apt.internal.common.plantype:IFilter", false), {
		name: 'FilterDesc',
		ordinal: 14
	}),
	dojo.mixin(new ItemType("object:com.ibm.team.apt.internal.common.extension:PlanEditorTabContribution", false), {
		name: 'PlanEditorTabContribution',
		ordinal: 15
	}),
	dojo.mixin(new ItemType("item:com.ibm.team.apt:IterationPlanRecord", false), {
		name: 'PlanRecord',
		ordinal: 16
	}),
	dojo.mixin(new ItemType("item:com.ibm.team.foundation.wiki:WikiPage", false), {
		name: 'WikiPage',
		ordinal: 17
	}),
	dojo.mixin(new ItemType("item:com.ibm.team.apt.resource:ContributorAbsence", false), {
		name: 'ContributorAbsence',
		ordinal: 18
	}),
	dojo.mixin(new ItemType("item:com.ibm.team.apt.resource:ContributorWorkEnvironment", false), {
		name: 'ContributorWorkEnvironment',
		ordinal: 19
	}),
	dojo.mixin(new ItemType("item:com.ibm.team.apt.resource:WorkResourceDetails", false), {
		name: 'WorkResourceDetails',
		ordinal: 20
	}),
	dojo.mixin(new ItemType("item:com.ibm.team.apt.resource:CALMServiceProvider", false), {
		name: 'CALMServiceProvider',
		ordinal: 21
	}),
	dojo.mixin(new ItemType("object:com.ibm.team.apt.internal.common.plantype:IProcessNature", false), {
		name: 'ProcessNature',
		ordinal: 22
	}),
	dojo.mixin(new ItemType("object:com.ibm.team.apt.internal.common.plantype:ISnapshotType", false), {
		name: 'SnapshotType',
		ordinal: 23
	}),
	dojo.mixin(new ItemType("object:com.ibm.team.apt.internal.service.rest.helper:GeneralConfiguration", false), {
		name: 'GeneralConfiguration',
		ordinal: 24
	}),
	dojo.mixin(new ItemType("item:com.ibm.team.workitem:WorkItem", false), {
		name: 'WorkItem',
		ordinal: 25
	}),
	dojo.mixin(new ItemType("object:com.ibm.team.workitem:type", false), {
		name: 'WorkItemType',
		ordinal: 26
	}),
	dojo.mixin(new ItemType("item:com.ibm.team.workitem:Attribute", false), {
		name: 'WorkItemAttribute',
		ordinal: 27
	}),
	dojo.mixin(new ItemType("object:com.ibm.team.workitem:workflow", false), {
		name: 'WorkflowInfo',
		ordinal: 28
	}),
	dojo.mixin(new ItemType("object:com.ibm.team.workitem:state", false), {
		name: 'WorkflowState',
		ordinal: 29
	}),
	dojo.mixin(new ItemType("object:com.ibm.team.workitem:action", false), {
		name: 'WorkflowAction',
		ordinal: 30
	}),
	dojo.mixin(new ItemType("object:com.ibm.team.workitem:resolution", false), {
		name: 'WorkflowResolution',
		ordinal: 31
	}),
	dojo.mixin(new ItemType("object:com.ibm.team.workitem:stateGroup", false), {
		name: 'WorkflowStateGroup',
		ordinal: 32
	}),
	dojo.mixin(new ItemType("object:com.ibm.team.workitem.enumeration:literal", false), {
		name: 'EnumerationElement',
		ordinal: 33
	}),
	dojo.mixin(new ItemType("object:com.ibm.team.workitem:stateTransition", false), {
		name: 'StateTransition',
		ordinal: 34
	}),
	dojo.mixin(new ItemType("item:com.ibm.team.process:Iteration", false), {
		name: 'Iteration',
		ordinal: 35
	}),
	dojo.mixin(new ItemType("item:com.ibm.team.process:IterationType", false), {
		name: 'IterationType',
		ordinal: 36
	}),
	dojo.mixin(new ItemType("item:com.ibm.team.process:DevelopmentLine", false), {
		name: 'Timeline',
		ordinal: 37
	}),
	dojo.mixin(new ItemType("item:com.ibm.team.process:ProcessArea", false), {
		name: 'ProcessArea',
		ordinal: 38
	}),
	dojo.mixin(new ItemType("item:com.ibm.team.process:TeamArea", false), {
		name: 'TeamArea',
		ordinal: 39
	}),
	dojo.mixin(new ItemType("item:com.ibm.team.process:ProjectArea", false), {
		name: 'ProjectArea',
		ordinal: 40
	}),
	dojo.mixin(new ItemType("meta:com.ibm.team.types:ItemHierarchy", false), {
		name: 'ItemHierarchy',
		ordinal: 41
	}),
	dojo.mixin(new ItemType("meta:com.ibm.team.types.ItemMapping", false), {
		name: 'ItemMapping',
		ordinal: 42
	}),
	dojo.mixin(new ItemType("meta:com.ibm.team.types.ItemCollection", false), {
		name: 'ItemCollection',
		ordinal: 43
	}),
	dojo.mixin(new ItemType("cmChangeRequest", true), {
		name: 'CmChangeRequest',
		ordinal: 44
	}),
	dojo.mixin(new ItemType("cmPlan", true), {
		name: 'CmPlan',
		ordinal: 45
	}),
	dojo.mixin(new ItemType("rmRequirement", true), {
		name: 'RmRequirement',
		ordinal: 46
	}),
	dojo.mixin(new ItemType("rmRequirementCollection", true), {
		name: 'RmRequirementCollection',
		ordinal: 47
	}),
	dojo.mixin(new ItemType("qmTestCase", true), {
		name: 'QmTestCase',
		ordinal: 48
	}),
	dojo.mixin(new ItemType("qmTestScript", true), {
		name: 'QmTestScript',
		ordinal: 49
	}),
	dojo.mixin(new ItemType("qmTestSuite", true), {
		name: 'QmTestSuite',
		ordinal: 50
	}),
	dojo.mixin(new ItemType("qmTestPlan", true), {
		name: 'QmTestPlan',
		ordinal: 51
	}),
	dojo.mixin(new ItemType("qmTestExecutionRecord", true), {
		name: 'QmTestExecutionRecord',
		ordinal: 52
	}),
	dojo.mixin(new ItemType("qmTestExecutionResult", true), {
		name: 'QmTestExecutionResult',
		ordinal: 53
	}),
	dojo.mixin(new ItemType("amArchitectureElement", true), {
		name: 'AmArchitectureElement',
		ordinal: 54
	}),
	dojo.mixin(new ItemType("scmChangeSet", true), {
		name: 'ScmChangeSet',
		ordinal: 55
	}),
	dojo.mixin(new ItemType("object:com.ibm.team.apt.internal.common.extension:LeanPlanView", false), {
		name: 'LeanPlanView',
		ordinal: 56
	}),
	dojo.mixin(new ItemType("object:com.ibm.team.apt.internal.common.extension:TeamAreaPath", false), {
		name: 'TeamAreaPath',
		ordinal: 57
	}),
	dojo.mixin(new ItemType("item:com.ibm.team.workitem:Deliverable", false), {
		name: 'Deliverable',
		ordinal: 58
	}),
	dojo.mixin(new ItemType("object:com.ibm.team.workitem:contributesToRelease", false), {
		name: 'ContributesToRelease',
		ordinal: 59
	}),
	dojo.mixin(new ItemType("object:com.ibm.team.apt.internal.common.plantype:IPlanItemsDescription", false), {
		name: 'PlanItemDesc',
		ordinal: 60
	})
];
ItemType.$UNKNOWN= ItemType.values[0];
ItemType.Contributor= ItemType.values[1];
ItemType.Category= ItemType.values[2];
ItemType.LinkType= ItemType.values[3];
ItemType.Link= ItemType.values[4];
ItemType.PlanningAttributeDesc= ItemType.values[5];
ItemType.PlanModeDesc= ItemType.values[6];
ItemType.SharedPlanModeDesc= ItemType.values[7];
ItemType.PlanTypeDesc= ItemType.values[8];
ItemType.PlanCheckDesc= ItemType.values[9];
ItemType.SchedulerDesc= ItemType.values[10];
ItemType.ViewModeDesc= ItemType.values[11];
ItemType.GroupModeDesc= ItemType.values[12];
ItemType.SortModeDesc= ItemType.values[13];
ItemType.FilterDesc= ItemType.values[14];
ItemType.PlanEditorTabContribution= ItemType.values[15];
ItemType.PlanRecord= ItemType.values[16];
ItemType.WikiPage= ItemType.values[17];
ItemType.ContributorAbsence= ItemType.values[18];
ItemType.ContributorWorkEnvironment= ItemType.values[19];
ItemType.WorkResourceDetails= ItemType.values[20];
ItemType.CALMServiceProvider= ItemType.values[21];
ItemType.ProcessNature= ItemType.values[22];
ItemType.SnapshotType= ItemType.values[23];
ItemType.GeneralConfiguration= ItemType.values[24];
ItemType.WorkItem= ItemType.values[25];
ItemType.WorkItemType= ItemType.values[26];
ItemType.WorkItemAttribute= ItemType.values[27];
ItemType.WorkflowInfo= ItemType.values[28];
ItemType.WorkflowState= ItemType.values[29];
ItemType.WorkflowAction= ItemType.values[30];
ItemType.WorkflowResolution= ItemType.values[31];
ItemType.WorkflowStateGroup= ItemType.values[32];
ItemType.EnumerationElement= ItemType.values[33];
ItemType.StateTransition= ItemType.values[34];
ItemType.Iteration= ItemType.values[35];
ItemType.IterationType= ItemType.values[36];
ItemType.Timeline= ItemType.values[37];
ItemType.ProcessArea= ItemType.values[38];
ItemType.TeamArea= ItemType.values[39];
ItemType.ProjectArea= ItemType.values[40];
ItemType.ItemHierarchy= ItemType.values[41];
ItemType.ItemMapping= ItemType.values[42];
ItemType.ItemCollection= ItemType.values[43];
ItemType.CmChangeRequest= ItemType.values[44];
ItemType.CmPlan= ItemType.values[45];
ItemType.RmRequirement= ItemType.values[46];
ItemType.RmRequirementCollection= ItemType.values[47];
ItemType.QmTestCase= ItemType.values[48];
ItemType.QmTestScript= ItemType.values[49];
ItemType.QmTestSuite= ItemType.values[50];
ItemType.QmTestPlan= ItemType.values[51];
ItemType.QmTestExecutionRecord= ItemType.values[52];
ItemType.QmTestExecutionResult= ItemType.values[53];
ItemType.AmArchitectureElement= ItemType.values[54];
ItemType.ScmChangeSet= ItemType.values[55];
ItemType.LeanPlanView= ItemType.values[56];
ItemType.TeamAreaPath= ItemType.values[57];
ItemType.Deliverable= ItemType.values[58];
ItemType.ContributesToRelease= ItemType.values[59];
ItemType.PlanItemDesc= ItemType.values[60];

})();
