/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.api.common;

import com.ibm.jdojo.lang.DojoObject;
import com.ibm.team.apt.api.common.IUIItem;
import com.ibm.team.apt.api.common.IUIItemHandle;
import com.ibm.team.apt.api.common.ItemType;

public final class UIItemHandle<T extends IUIItem>
extends DojoObject
implements IUIItemHandle<T> {
    private static final char fgSeparatorChar = ';';
    private static final char fgSeparatorOverrideChar = '~';
    private ItemType fType;
    private String fUuid;
    private String fStateId;
    private String fHandleValue;
    private int fIndex1 = -1;
    private int fIndex2 = -1;

    public static <T extends IUIItem> IUIItemHandle<T> itemHandleFrom(ItemType type, String itemId) {
        return new UIItemHandle<T>(type, itemId, null, null);
    }

    public static <T extends IUIItem> IUIItemHandle<T> stateHandleFrom(ItemType type, String itemId, String stateId) {
        return new UIItemHandle<T>(type, itemId, stateId, null);
    }

    public static <T extends IUIItem> IUIItemHandle<T> itemHandleFor(T item) {
        return new UIItemHandle<T>(item.getItemType(), item.getItemId(), null, null);
    }

    public static <T extends IUIItem> IUIItemHandle<T> stateHandleFor(T item) {
        return new UIItemHandle<T>(item.getItemType(), item.getItemId(), item.getStateId(), null);
    }

    public static <T extends IUIItem> IUIItemHandle<T> fromHandle(String value) {
        if (value == null) {
            return null;
        }
        return new UIItemHandle<T>(null, null, null, value);
    }

    private UIItemHandle(ItemType type, String uuid, String stateId, String value) {
        assert (type != null && uuid != null || value != null);
        this.fType = type;
        this.fUuid = uuid;
        this.fStateId = stateId;
        this.fHandleValue = value;
    }

    @Override
    public ItemType getType() {
        if (this.fType == null) {
            int to = this.indexFirstSemiColon();
            String str = this.fHandleValue.substring(0, to);
            this.fType = ItemType.fromString(str);
        }
        return this.fType;
    }

    @Override
    public String getItemId() {
        if (this.fUuid == null) {
            int from = this.indexFirstSemiColon();
            int to = this.indexSecondSemiColon();
            to = to < 0 ? this.fHandleValue.length() : to;
            this.fUuid = this.decodeSeparatorChar(this.fHandleValue.substring(from + 1, to));
        }
        return this.fUuid;
    }

    @Deprecated
    public String getUuid() {
        return this.getItemId();
    }

    @Override
    public String getStateId() {
        if (this.fStateId == null) {
            if (this.fHandleValue == null) {
                return null;
            }
            int from = this.indexSecondSemiColon();
            if (from < 0) {
                return null;
            }
            this.fStateId = this.decodeSeparatorChar(this.fHandleValue.substring(from + 1));
        }
        return this.fStateId;
    }

    @Override
    public String getHandleValue() {
        return this.getHandleValue1(false);
    }

    public String toString() {
        return this.getHandleValue1(true);
    }

    private String getHandleValue1(boolean verbose) {
        if (this.fHandleValue == null) {
            String type = verbose ? this.getType().getQualifiedName() : String.valueOf(this.getType().ordinal());
            this.fHandleValue = String.valueOf(type) + String.valueOf(';') + this.encodeSeparatorChar(this.getItemId());
            if (this.getStateId() != null) {
                this.fHandleValue = String.valueOf(this.fHandleValue) + ';' + this.encodeSeparatorChar(this.getStateId());
            }
        }
        return this.fHandleValue;
    }

    private int indexFirstSemiColon() {
        if (this.fIndex1 == -1) {
            this.fIndex1 = this.indexOfSeparatorChar(0);
        }
        return this.fIndex1;
    }

    private int indexSecondSemiColon() {
        if (this.fIndex2 == -1) {
            int index1 = this.indexFirstSemiColon();
            int index2 = this.indexOfSeparatorChar(index1 + 1);
            this.fIndex2 = index2 < 0 ? -2 : index2;
        }
        return this.fIndex2;
    }

    private int indexOfSeparatorChar(int startIndex) {
        int index = this.fHandleValue.indexOf(59, startIndex);
        if (index >= 0 && this.isOverrideChar(index + 1)) {
            return this.indexOfSeparatorChar(index + 2);
        }
        return index;
    }

    private boolean isOverrideChar(int index) {
        int len = this.fHandleValue.length();
        int overridersCount = 0;
        int i = index;
        while (i < len) {
            if (this.fHandleValue.charAt(i) != '~') break;
            ++overridersCount;
            ++i;
        }
        return overridersCount % 2 != 0;
    }

    private String encodeSeparatorChar(String str) {
        if (str == null) {
            return null;
        }
        String buffer = "";
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            buffer = String.valueOf(buffer) + c;
            if (c == ';' || c == '~') {
                buffer = String.valueOf(buffer) + '~';
            }
            ++i;
        }
        return buffer;
    }

    private String decodeSeparatorChar(String str) {
        String buffer = "";
        int len = str.length();
        int i = 0;
        while (i < len) {
            char c = str.charAt(i);
            if (c == ';' || c == '~' && i + 1 < len && str.charAt(i + 1) == '~') {
                ++i;
            }
            buffer = String.valueOf(buffer) + c;
            ++i;
        }
        return buffer;
    }
}

