/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.api.common;

public enum ItemType {
    $UNKNOWN("item:unknown:$UNKNOWN", false),
    Contributor("item:com.ibm.team.repository:Contributor", false),
    Category("item:com.ibm.team.workitem:Category", false),
    LinkType("object:com.ibm.team.links:ILinkType", false),
    Link("item:com.ibm.team.links:AuditableLink", false),
    PlanningAttributeDesc("object:com.ibm.team.apt.internal.common.plantype:IAttributeDefinitionDescriptor", false),
    PlanModeDesc("object:com.ibm.team.apt.internal.common.plantype:IPlanModeDescription", false),
    SharedPlanModeDesc("item:com.ibm.team.apt:SharedPlanMode", false),
    PlanTypeDesc("object:com.ibm.team.apt.internal.common.plantype:IPlanType", false),
    PlanCheckDesc("object:com.ibm.team.apt.internal.common.plantype:IPlanCheck", false),
    SchedulerDesc("object:com.ibm.team.apt.internal.common.plantype:IScheduler", false),
    ViewModeDesc("object:com.ibm.team.apt.internal.common.plantype:IViewMode", false),
    GroupModeDesc("object:com.ibm.team.apt.internal.common.plantype:IGroupMode", false),
    SortModeDesc("object:com.ibm.team.apt.internal.common.plantype:ISortMode", false),
    FilterDesc("object:com.ibm.team.apt.internal.common.plantype:IFilter", false),
    PlanEditorTabContribution("object:com.ibm.team.apt.internal.common.extension:PlanEditorTabContribution", false),
    PlanRecord("item:com.ibm.team.apt:IterationPlanRecord", false),
    WikiPage("item:com.ibm.team.foundation.wiki:WikiPage", false),
    ContributorAbsence("item:com.ibm.team.apt.resource:ContributorAbsence", false),
    ContributorWorkEnvironment("item:com.ibm.team.apt.resource:ContributorWorkEnvironment", false),
    WorkResourceDetails("item:com.ibm.team.apt.resource:WorkResourceDetails", false),
    CALMServiceProvider("item:com.ibm.team.apt.resource:CALMServiceProvider", false),
    ProcessNature("object:com.ibm.team.apt.internal.common.plantype:IProcessNature", false),
    SnapshotType("object:com.ibm.team.apt.internal.common.plantype:ISnapshotType", false),
    GeneralConfiguration("object:com.ibm.team.apt.internal.service.rest.helper:GeneralConfiguration", false),
    WorkItem("item:com.ibm.team.workitem:WorkItem", false),
    WorkItemType("object:com.ibm.team.workitem:type", false),
    WorkItemAttribute("item:com.ibm.team.workitem:Attribute", false),
    WorkflowInfo("object:com.ibm.team.workitem:workflow", false),
    WorkflowState("object:com.ibm.team.workitem:state", false),
    WorkflowAction("object:com.ibm.team.workitem:action", false),
    WorkflowResolution("object:com.ibm.team.workitem:resolution", false),
    WorkflowStateGroup("object:com.ibm.team.workitem:stateGroup", false),
    EnumerationElement("object:com.ibm.team.workitem.enumeration:literal", false),
    StateTransition("object:com.ibm.team.workitem:stateTransition", false),
    Iteration("item:com.ibm.team.process:Iteration", false),
    IterationType("item:com.ibm.team.process:IterationType", false),
    Timeline("item:com.ibm.team.process:DevelopmentLine", false),
    ProcessArea("item:com.ibm.team.process:ProcessArea", false),
    TeamArea("item:com.ibm.team.process:TeamArea", false),
    ProjectArea("item:com.ibm.team.process:ProjectArea", false),
    ItemHierarchy("meta:com.ibm.team.types:ItemHierarchy", false),
    ItemMapping("meta:com.ibm.team.types.ItemMapping", false),
    ItemCollection("meta:com.ibm.team.types.ItemCollection", false),
    CmChangeRequest("cmChangeRequest", true),
    CmPlan("cmPlan", true),
    RmRequirement("rmRequirement", true),
    RmRequirementCollection("rmRequirementCollection", true),
    QmTestCase("qmTestCase", true),
    QmTestScript("qmTestScript", true),
    QmTestSuite("qmTestSuite", true),
    QmTestPlan("qmTestPlan", true),
    QmTestExecutionRecord("qmTestExecutionRecord", true),
    QmTestExecutionResult("qmTestExecutionResult", true),
    AmArchitectureElement("amArchitectureElement", true),
    ScmChangeSet("scmChangeSet", true),
    LeanPlanView("object:com.ibm.team.apt.internal.common.extension:LeanPlanView", false),
    TeamAreaPath("object:com.ibm.team.apt.internal.common.extension:TeamAreaPath", false),
    Deliverable("item:com.ibm.team.workitem:Deliverable", false),
    ContributesToRelease("object:com.ibm.team.workitem:contributesToRelease", false),
    PlanItemDesc("object:com.ibm.team.apt.internal.common.plantype:IPlanItemsDescription", false);

    private final String qName;
    private final boolean fIsCompability;

    public static ItemType fromString(String str) {
        int index = ItemType.parsePositiveInt(str);
        if (index != -1) {
            if (index >= ItemType.values().length) {
                return $UNKNOWN;
            }
            return ItemType.values()[index];
        }
        ItemType[] itemTypeArray = ItemType.values();
        int n = itemTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemType value = itemTypeArray[n2];
            if (value.qName.equals(str)) {
                return value;
            }
            ++n2;
        }
        return $UNKNOWN;
    }

    private ItemType(String qName, boolean isCompability) {
        this.qName = qName;
        this.fIsCompability = isCompability;
    }

    public String getQualifiedName() {
        return this.qName;
    }

    public boolean isOslcResource() {
        return this.fIsCompability;
    }

    public String getNamespace() {
        int index1 = this.qName.indexOf(58) + 1;
        int index2 = this.qName.indexOf(58, index1);
        return this.qName.substring(index1, index2);
    }

    public String getName() {
        int index = this.qName.lastIndexOf(58);
        return this.qName.substring(index + 1);
    }

    private static int parsePositiveInt(String value) {
        int result = 0;
        int i = 0;
        while (i < value.length()) {
            result *= i * 10;
            switch (value.charAt(i)) {
                case '0': {
                    break;
                }
                case '1': {
                    ++result;
                    break;
                }
                case '2': {
                    result += 2;
                    break;
                }
                case '3': {
                    result += 3;
                    break;
                }
                case '4': {
                    result += 4;
                    break;
                }
                case '5': {
                    result += 5;
                    break;
                }
                case '6': {
                    result += 6;
                    break;
                }
                case '7': {
                    result += 7;
                    break;
                }
                case '8': {
                    result += 8;
                    break;
                }
                case '9': {
                    result += 9;
                    break;
                }
                default: {
                    return -1;
                }
            }
            ++i;
        }
        return result;
    }
}

