/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ri.repo;

import com.ibm.rational.wvcm.ri.srvc.SrvcLocation;
import javax.wvcm.Location;
import javax.wvcm.WvcmException;

public class RiLocation
extends SrvcLocation {
    public RiLocation(String string) throws WvcmException {
        super(string);
        if (string == null) {
            throw new WvcmException("SrvcLocation must not be null", WvcmException.ReasonCode.ILLEGAL_LOCATION_SYNTAX);
        }
        if (!string.startsWith("/")) {
            throw new WvcmException("SrvcLocation must start with /", WvcmException.ReasonCode.ILLEGAL_LOCATION_SYNTAX);
        }
    }

    private RiLocation newLocation(String string) {
        RiLocation loc;
        try {
            loc = new RiLocation(string);
        }
        catch (WvcmException e) {
            throw new RuntimeException("Could not create location", e);
        }
        return loc;
    }

    @Override
    public Location parent() {
        String[] segments = this._string.split("/");
        if (segments.length < 5) {
            return null;
        }
        String parentString = this._string.substring(0, this._string.lastIndexOf("/"));
        return this.newLocation(parentString);
    }

    @Override
    public Location child(String bindingName) throws WvcmException {
        if (bindingName.indexOf(47) != -1) {
            throw new WvcmException("Child cannot contain / as part of its name: " + bindingName, WvcmException.ReasonCode.ILLEGAL_LOCATION_SYNTAX);
        }
        return this.newLocation(String.valueOf(this._string) + "/" + bindingName);
    }

    @Override
    public String lastSegment() {
        if (this.parent() == null) {
            return null;
        }
        return this._string.substring(this._string.lastIndexOf("/") + 1);
    }
}

