/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ri.impl;

import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.impl.ResourceImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcProvider;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wvcm.Activity;
import javax.wvcm.Baseline;
import javax.wvcm.ControllableResource;
import javax.wvcm.Feedback;
import javax.wvcm.Folder;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.PropertyRequestItem;
import javax.wvcm.Resource;
import javax.wvcm.ResourceList;
import javax.wvcm.Version;
import javax.wvcm.VersionSet;
import javax.wvcm.Workspace;
import javax.wvcm.WvcmException;

public class WvcmServiceConverter {
    private static PropValue convertToRemotable(PropValue pValue) throws WvcmException {
        if (!pValue.is_updated()) {
            return pValue;
        }
        PropertyNameList.PropertyName<?> pName = pValue.get_propertyName();
        Object value = pValue.get_value();
        if (value instanceof Resource) {
            PropValue newPV = new PropValue(pName, ((Resource)value).location());
            newPV.set_updated(true);
            return newPV;
        }
        if (value instanceof List) {
            List list = (List)value;
            if (list.size() == 0 || !(list.get(0) instanceof Resource)) {
                return pValue;
            }
            ArrayList<Location> newList = new ArrayList<Location>(list.size());
            int i = 0;
            while (i < list.size()) {
                Resource r = (Resource)list.get(i);
                newList.add(r.location());
                ++i;
            }
            PropValue newPV = new PropValue(pName, newList);
            newPV.set_updated(true);
            return newPV;
        }
        return pValue;
    }

    private static void validateCompareReport(List<Object> list, PropertyRequestItem.PropertyRequest propertyRequest) throws WvcmException {
        for (Object object : list) {
            if (object instanceof VersionSet.AddedVersion) {
                ResourceImpl.validateProxy(((VersionSet.AddedVersion)object).getVersion(), propertyRequest);
                continue;
            }
            if (object instanceof VersionSet.ChangedVersion) {
                ResourceImpl.validateProxy(((VersionSet.ChangedVersion)object).getOldVersion(), propertyRequest);
                ResourceImpl.validateProxy(((VersionSet.ChangedVersion)object).getNewVersion(), propertyRequest);
                continue;
            }
            if (object instanceof VersionSet.DeletedVersion) {
                ResourceImpl.validateProxy(((VersionSet.DeletedVersion)object).getVersion(), propertyRequest);
                continue;
            }
            if (object instanceof VersionSet.AddedActivity) {
                ResourceImpl.validateProxy(((VersionSet.AddedActivity)object).getActivity(), propertyRequest);
                continue;
            }
            if (object instanceof VersionSet.PartiallyAddedActivity) {
                ResourceImpl.validateProxy(((VersionSet.PartiallyAddedActivity)object).getActivity(), propertyRequest);
                continue;
            }
            if (object instanceof VersionSet.DeletedActivity) {
                ResourceImpl.validateProxy(((VersionSet.DeletedActivity)object).getActivity(), propertyRequest);
                continue;
            }
            if (object instanceof VersionSet.PartiallyDeletedActivity) {
                ResourceImpl.validateProxy(((VersionSet.PartiallyDeletedActivity)object).getActivity(), propertyRequest);
                continue;
            }
            if (object instanceof VersionSet.ChangedActivity) {
                ResourceImpl.validateProxy(((VersionSet.ChangedActivity)object).getActivity(), propertyRequest);
                continue;
            }
            throw new RuntimeException("Unexpected CompareReport entry");
        }
    }

    private static void validateMergePreviewReport(List<Object> list, PropertyRequestItem.PropertyRequest propertyRequest) throws WvcmException {
        for (Object object : list) {
            ResourceImpl.validateProxy(((Workspace.MergePreviewReport)object).getCommonAncestor(), propertyRequest);
            ResourceImpl.validateProxy(((Workspace.MergePreviewReport)object).getTarget(), propertyRequest);
            ResourceImpl.validateProxy(((Workspace.MergePreviewReport)object).getVersionList(), propertyRequest);
        }
    }

    private static Map<PropertyNameList.PropertyName<?>, PropValue> collectUpdates(Map<PropertyNameList.PropertyName<?>, PropValue> propMap) throws WvcmException {
        HashMap updates = new HashMap();
        for (PropertyNameList.PropertyName<?> pName : propMap.keySet()) {
            PropValue pValue = propMap.get(pName);
            if (!pValue.is_updated() && !pValue.is_removed()) continue;
            PropValue newPValue = WvcmServiceConverter.convertToRemotable(pValue);
            updates.put(pName, newPValue);
        }
        return updates;
    }

    private static List<Map<PropertyNameList.PropertyName<?>, PropValue>> collectUpdates(ResourceList<?> resourceList) throws WvcmException {
        ArrayList updatesList = new ArrayList();
        int i = 0;
        while (i < resourceList.size()) {
            ResourceImpl resource = (ResourceImpl)resourceList.get(i);
            updatesList.add(WvcmServiceConverter.collectUpdates(resource.getPropMap()));
            ++i;
        }
        return updatesList;
    }

    private static void processPropertyUpdates(ResourceImpl thisResource, List<PropertyNameList.PropertyName<?>> updated) {
        HashMap<PropertyNameList.PropertyName<?>, PropValue> resourcePropMap = thisResource.getPropMap();
        for (PropertyNameList.PropertyName<?> pNameUpdated : updated) {
            PropValue pValueInResource = (PropValue)resourcePropMap.get(pNameUpdated);
            if (pValueInResource == null) {
                String message = String.format("unexpected property (%s) update on resource at: %s", pNameUpdated.toString(), thisResource.location().string());
                throw new RuntimeException(message);
            }
            if (pValueInResource.is_removed()) {
                resourcePropMap.remove(pNameUpdated);
                continue;
            }
            if (pValueInResource.is_updated()) {
                pValueInResource.set_updated(false);
                continue;
            }
            String message = String.format("unexpected property (%s) update on resource at: %s", pNameUpdated.toString(), thisResource.location().string());
            throw new RuntimeException(message);
        }
    }

    private static void processFeedback(SrvcProvider provider, ResourceImpl resource, SrvcFeedback sfb, Feedback feedback) {
        provider.logCompletion(resource, sfb);
        if (feedback != null) {
            PropertyRequestItem.PropertyRequest mpr = feedback.getPropertyRequestForModified();
            if (mpr != null) {
                for (SrvcResource modifiedResource : sfb.get_modifiedResources()) {
                    try {
                        feedback.notifyIsModified((Resource)modifiedResource.buildProxy(mpr, sfb));
                    }
                    catch (WvcmException wvcmException) {
                        // empty catch block
                    }
                }
            }
            feedback.notifyPercentComplete(100);
        }
    }

    private static void processResults(ResourceImpl thisResource, List<PropertyNameList.PropertyName<?>> updated, Feedback feedback, SrvcProvider provider, SrvcFeedback sfb) {
        WvcmServiceConverter.processPropertyUpdates(thisResource, updated);
        WvcmServiceConverter.processFeedback(provider, thisResource, sfb, feedback);
    }

    private static void processResults(ResourceList<?> resourceList, List<List<PropertyNameList.PropertyName<?>>> updatedList, Feedback feedback, SrvcProvider provider, SrvcFeedback sfb) {
        if (resourceList.size() == 0) {
            provider.logCompletion(null, sfb);
            return;
        }
        int i = 0;
        while (i < resourceList.size()) {
            ResourceImpl resource = (ResourceImpl)resourceList.get(i);
            WvcmServiceConverter.processPropertyUpdates(resource, updatedList.get(i));
            ++i;
        }
        WvcmServiceConverter.processFeedback(provider, (ResourceImpl)resourceList.get(0), sfb, feedback);
    }

    private static PropertyRequestItem.PropertyRequest getPR(Feedback feedback) {
        if (feedback == null) {
            return null;
        }
        return feedback.getPropertyRequestForResult();
    }

    public static Resource doCreateControllableResource(ResourceImpl thisResource, Feedback feedback) throws WvcmException {
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        Resource result = null;
        provider.logStart("doCreateControllableResource", WvcmServiceConverter.getPR(feedback), updates);
        try {
            try {
                SrvcResource srvcResource = provider.doCreateControllableResource(location, updates, updated, sfb);
                result = provider.createProxy(srvcResource, location, sfb);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
        }
        return result;
    }

    public static Resource doCreateVersionControlledResource(ResourceImpl thisResource, Version version, Feedback feedback) throws WvcmException {
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        Resource result = null;
        provider.logStart("doCreateVersionControlledResource", WvcmServiceConverter.getPR(feedback), updates);
        try {
            try {
                SrvcResource srvcResource = provider.doCreateVersionControlledResource(location, version.location(), updates, updated, sfb);
                result = provider.createProxy(srvcResource, location, sfb);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
        }
        return result;
    }

    public static Resource doCreateControllableSymbolicLink(ResourceImpl thisResource, Feedback feedback) throws WvcmException {
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        Resource result = null;
        provider.logStart("doCreateControllableSymbolicLink", WvcmServiceConverter.getPR(feedback), updates);
        try {
            try {
                SrvcResource srvcResource = provider.doCreateControllableSymbolicLink(location, updates, updated, sfb);
                result = provider.createProxy(srvcResource, location, sfb);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
        }
        return result;
    }

    public static Resource doCreateControllableFolder(ResourceImpl thisResource, Feedback feedback) throws WvcmException {
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        Resource result = null;
        provider.logStart("doCreateControllableFolder", WvcmServiceConverter.getPR(feedback), updates);
        try {
            try {
                SrvcResource srvcResource = provider.doCreateControllableFolder(location, updates, updated, sfb);
                result = provider.createProxy(srvcResource, location, sfb);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
        }
        return result;
    }

    public static Resource doCreateBaselineControlledFolder(ResourceImpl thisResource, Baseline baseline, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        Resource result = null;
        provider.logStart("doCreateBaselineControlledFolder", WvcmServiceConverter.getPR(feedback), updates);
        try {
            try {
                SrvcResource srvcResource = provider.doCreateBaselineControlledFolder(location, baseline.location(), updates, updated, sfb);
                result = provider.createProxy(srvcResource, location, sfb);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
        }
        return result;
    }

    public static Resource doCreateWorkspace(ResourceImpl thisResource, Feedback feedback) throws WvcmException {
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        Resource result = null;
        provider.logStart("doCreateWorkspace", WvcmServiceConverter.getPR(feedback), updates);
        try {
            try {
                SrvcResource srvcResource = provider.doCreateWorkspace(location, updates, updated, sfb);
                result = provider.createProxy(srvcResource, location, sfb);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
        }
        return result;
    }

    public static Resource doCreateGeneratedWorkspace(ResourceImpl thisResource, Feedback feedback) throws WvcmException {
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        Resource result = null;
        provider.logStart("doCreateGeneratedWorkspace", WvcmServiceConverter.getPR(feedback), updates);
        try {
            try {
                SrvcResource srvcResource = provider.doCreateGeneratedWorkspace(location, updates, updated, sfb);
                result = provider.createProxy(srvcResource, srvcResource.location(), sfb);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
        }
        return result;
    }

    public static Resource doCreateActivity(ResourceImpl thisResource, boolean isStream, Feedback feedback) throws WvcmException {
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        Resource result = null;
        provider.logStart("doCreateActivity", WvcmServiceConverter.getPR(feedback), updates);
        try {
            try {
                SrvcResource srvcResource = provider.doCreateActivity(location, isStream, updates, updated, sfb);
                result = provider.createProxy(srvcResource, location, sfb);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
        }
        return result;
    }

    public static Resource doCreateGeneratedActivity(ResourceImpl thisResource, boolean isStream, Feedback feedback) throws WvcmException {
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        Resource result = null;
        provider.logStart("doCreateGeneratedResource", WvcmServiceConverter.getPR(feedback), updates);
        try {
            try {
                SrvcResource srvcResource = provider.doCreateGeneratedActivity(location, isStream, updates, updated, sfb);
                result = provider.createProxy(srvcResource, srvcResource.location(), sfb);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
        }
        return result;
    }

    public static Resource doCreateGeneratedTask(ResourceImpl thisResource, Feedback feedback) throws WvcmException {
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        Resource result = null;
        provider.logStart("doCreateGeneratedTask", WvcmServiceConverter.getPR(feedback), updates);
        try {
            try {
                SrvcResource srvcResource = provider.doCreateGeneratedTask(location, updates, updated, sfb);
                result = provider.createProxy(srvcResource, srvcResource.location(), sfb);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
        }
        return result;
    }

    public static Resource doFind(ResourceImpl query, Feedback feedback) throws WvcmException {
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(query.getPropMap());
        SrvcProvider provider = (SrvcProvider)query.provider();
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        Resource result = null;
        provider.logStart("doFind", WvcmServiceConverter.getPR(feedback), updates);
        try {
            try {
                SrvcResource srvcResource = provider.doFind(query, sfb);
                if (srvcResource != null) {
                    result = provider.createProxy(srvcResource, srvcResource.location(), sfb);
                }
            }
            catch (WvcmException ex) {
                query.wrapEx(ex);
                WvcmServiceConverter.processFeedback(provider, query, sfb, feedback);
            }
        }
        finally {
            WvcmServiceConverter.processFeedback(provider, query, sfb, feedback);
        }
        return result;
    }

    public static Resource doFindOne(ResourceImpl query, Feedback feedback) throws WvcmException {
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(query.getPropMap());
        SrvcProvider provider = (SrvcProvider)query.provider();
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        Resource result = null;
        provider.logStart("doFindOne", WvcmServiceConverter.getPR(feedback), updates);
        try {
            try {
                SrvcResource srvcResource = provider.doFindOne(query, sfb);
                if (srvcResource != null) {
                    result = provider.createProxy(srvcResource, srvcResource.location(), sfb);
                }
            }
            catch (WvcmException ex) {
                query.wrapEx(ex);
                WvcmServiceConverter.processFeedback(provider, query, sfb, feedback);
            }
        }
        finally {
            WvcmServiceConverter.processFeedback(provider, query, sfb, feedback);
        }
        return result;
    }

    public static List<Object> doFindAll(ResourceImpl query, Feedback feedback) throws WvcmException {
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(query.getPropMap());
        SrvcProvider provider = (SrvcProvider)query.provider();
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        ArrayList<Object> result = new ArrayList<Object>();
        provider.logStart("doFindAll", WvcmServiceConverter.getPR(feedback), updates);
        try {
            try {
                List<SrvcResource> srvcResources = provider.doFindAll(query, sfb);
                int size = srvcResources.size();
                int count = 0;
                for (SrvcResource r : srvcResources) {
                    Resource resource = provider.createProxy(r, r.location(), sfb.nest(50 + 100 * ++count / size));
                    result.add(resource);
                }
            }
            catch (WvcmException ex) {
                query.wrapEx(ex);
                WvcmServiceConverter.processFeedback(provider, query, sfb, feedback);
            }
        }
        finally {
            WvcmServiceConverter.processFeedback(provider, query, sfb, feedback);
        }
        return result;
    }

    public static boolean doExists(ResourceImpl thisResource, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        boolean result = false;
        provider.logStart("doExists", WvcmServiceConverter.getPR(feedback), updates);
        try {
            try {
                provider.getSrvcRes(location, sfb);
                result = true;
            }
            catch (WvcmException ex) {
                if (ex.getReasonCode() != WvcmException.ReasonCode.NOT_FOUND) {
                    thisResource.wrapEx(ex);
                }
                WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
        }
        return result;
    }

    public static PropertyNameList doGetPropertyNameList(ResourceImpl thisResource, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        PropertyNameList result = null;
        provider.logStart("doGetPropertyNameList", WvcmServiceConverter.getPR(feedback), updates);
        try {
            try {
                SrvcResource srvcResource = provider.getSrvcRes(location, sfb);
                result = srvcResource.doGetPropertyNameList(updates, updated, sfb);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
        }
        return result;
    }

    public static PropertyNameList doGetPropertyNameList(ResourceImpl thisResource, String namespace, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        PropertyNameList result = null;
        provider.logStart("doGetPropertyNameList", WvcmServiceConverter.getPR(feedback), updates);
        try {
            try {
                SrvcResource srvcResource = provider.getSrvcRes(location, sfb);
                result = srvcResource.doGetPropertyNameList(namespace, updates, updated, sfb);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
        }
        return result;
    }

    public static Resource doUpdateProperties(ResourceImpl thisResource, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        Resource result = null;
        provider.logStart("doUpdateProperties", WvcmServiceConverter.getPR(feedback), updates);
        try {
            try {
                SrvcResource srvcResource = provider.getSrvcRes(location, sfb);
                srvcResource.doUpdateProperties(updates, updated, sfb);
                result = provider.createProxy(srvcResource, location, sfb);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
        }
        return result;
    }

    public static Resource doReadContent(ResourceImpl thisResource, OutputStream content, Resource accept, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        Resource result = null;
        provider.logStart("doReadContent", WvcmServiceConverter.getPR(feedback), updates);
        try {
            try {
                SrvcResource srvcResource = provider.getSrvcRes(location, sfb);
                srvcResource.doReadContent(content, accept, updates, updated, sfb);
                result = provider.createProxy(srvcResource, location, sfb);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
        }
        return result;
    }

    public static Resource doWriteContent(ResourceImpl thisResource, InputStream content, String contentIdentifier, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        Resource result = null;
        provider.logStart("doWriteContent", WvcmServiceConverter.getPR(feedback), updates);
        try {
            try {
                SrvcResource srvcResource = provider.doWriteContent(location, content, contentIdentifier, updates, updated, sfb);
                result = provider.createProxy(srvcResource, location, sfb);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
        }
        return result;
    }

    public static Resource doCopy(ResourceImpl thisResource, Location destination, Resource.CopyFlag[] flags, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        Resource result = null;
        provider.logStart("doCopy", WvcmServiceConverter.getPR(feedback), updates);
        try {
            SrvcResource srvcResource = provider.getSrvcRes(location, sfb);
            srvcResource.doCopy(destination, flags, updates, updated, sfb);
            result = provider.createProxy(srvcResource, location, sfb);
        }
        catch (WvcmException ex) {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
            thisResource.wrapEx(ex);
        }
        WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
        return result;
    }

    public static void doUnbindAll(ResourceImpl thisResource, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        provider.logStart("doUnbindAll", WvcmServiceConverter.getPR(feedback), updates);
        try {
            SrvcResource srvcResource = provider.getSrvcRes(location, sfb);
            srvcResource.doUnbindAll(updates, updated, sfb);
        }
        catch (WvcmException ex) {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
            thisResource.wrapEx(ex);
        }
        WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
    }

    public static Resource doBindChild(ResourceImpl thisResource, String bindingName, Resource child, Folder.BindFlag[] flags, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        Resource result = null;
        provider.logStart("doBindChild", WvcmServiceConverter.getPR(feedback), updates);
        try {
            try {
                SrvcResource srvcResource = provider.getSrvcRes(location, sfb);
                srvcResource.doBindChild(bindingName, child.location(), flags, updates, updated, sfb);
                result = provider.createProxy(srvcResource, location, sfb);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
        }
        return result;
    }

    public static Resource doRebindChild(ResourceImpl thisResource, String bindingName, Folder sourceFolder, String sourceBindingName, Folder.RebindFlag[] flags, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        Resource result = null;
        provider.logStart("doRebindChild", WvcmServiceConverter.getPR(feedback), updates);
        try {
            try {
                SrvcResource srvcResource = provider.getSrvcRes(location, sfb);
                srvcResource.doRebindChild(bindingName, sourceFolder.location(), sourceBindingName, flags, updates, updated, sfb);
                result = provider.createProxy(srvcResource, location, sfb);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
        }
        return result;
    }

    public static Resource doRebindAll(ResourceImpl thisResource, String bindingName, Resource source, Folder.RebindFlag[] flags, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        Resource result = null;
        provider.logStart("doRebindAll", WvcmServiceConverter.getPR(feedback), updates);
        try {
            try {
                SrvcResource srvcResource = provider.getSrvcRes(location, sfb);
                srvcResource.doRebindAll(bindingName, source.location(), flags, updates, updated, sfb);
                result = provider.createProxy(srvcResource, location, sfb);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
        }
        return result;
    }

    public static Resource doUnbindChild(ResourceImpl thisResource, String bindingName, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        Resource result = null;
        provider.logStart("doUnbindChild", WvcmServiceConverter.getPR(feedback), updates);
        try {
            try {
                SrvcResource srvcResource = provider.getSrvcRes(location, sfb);
                srvcResource.doUnbindChild(bindingName, updates, updated, sfb);
                result = provider.createProxy(srvcResource, location, sfb);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
        }
        return result;
    }

    public static List<Object> doReadMemberList(ResourceImpl thisResource, boolean deep, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        ArrayList<Object> result = new ArrayList<Object>();
        provider.logStart("doReadMemberList", WvcmServiceConverter.getPR(feedback), updates);
        try {
            try {
                SrvcResource root = provider.getSrvcRes(location, sfb);
                List<SrvcResource> srvcResources = root.doReadMemberList(location, deep, updates, updated, sfb.nest(20));
                int size = srvcResources.size();
                int count = 0;
                for (SrvcResource sr : srvcResources) {
                    Resource r = provider.createContextProxy(sr, sr.location(), root, sfb.nest(20 + 80 * ++count / size));
                    result.add(r);
                }
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
        }
        return result;
    }

    public static Resource doVersionControl(ResourceImpl thisResource, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        Resource result = null;
        provider.logStart("doVersionControl", WvcmServiceConverter.getPR(feedback), updates);
        try {
            try {
                SrvcResource srvcResource = provider.getSrvcRes(location, sfb);
                srvcResource.doVersionControl(updates, updated, sfb);
                result = provider.createProxy(srvcResource, location, sfb);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
        }
        return result;
    }

    public static Resource doCheckin(ResourceImpl thisResource, ControllableResource.CheckinFlag[] flags, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        Resource result = null;
        provider.logStart("doCheckin", WvcmServiceConverter.getPR(feedback), updates);
        try {
            try {
                SrvcResource srvcResource = provider.getSrvcRes(location, sfb);
                srvcResource.doCheckin(flags, updates, updated, sfb);
                result = provider.createProxy(srvcResource, location, sfb);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
        }
        return result;
    }

    public static Resource doCheckout(ResourceImpl thisResource, ControllableResource.CheckoutFlag[] flags, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        Resource result = null;
        provider.logStart("doCheckout", WvcmServiceConverter.getPR(feedback), updates);
        try {
            try {
                SrvcResource srvcResource = provider.getSrvcRes(location, sfb);
                srvcResource.doCheckout(flags, updates, updated, sfb);
                result = provider.createProxy(srvcResource, location, sfb);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
        }
        return result;
    }

    public static Resource doUncheckout(ResourceImpl thisResource, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        Resource result = null;
        provider.logStart("doUncheckout", WvcmServiceConverter.getPR(feedback), updates);
        try {
            try {
                SrvcResource srvcResource = provider.getSrvcRes(location, sfb);
                srvcResource.doUncheckout(updates, updated, sfb);
                result = provider.createProxy(srvcResource, location, sfb);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
        }
        return result;
    }

    public static Resource doSetLabel(ResourceImpl thisResource, String label, boolean overwrite, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        Resource result = null;
        provider.logStart("doSetLabel", WvcmServiceConverter.getPR(feedback), updates);
        try {
            try {
                SrvcResource srvcResource = provider.getSrvcRes(location, sfb);
                srvcResource.doSetLabel(label, overwrite, updates, updated, sfb);
                result = provider.createProxy(srvcResource, location, sfb);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
        }
        return result;
    }

    public static Resource doRemoveLabel(ResourceImpl thisResource, String label, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        Resource result = null;
        provider.logStart("doUncheckout", WvcmServiceConverter.getPR(feedback), updates);
        try {
            try {
                SrvcResource srvcResource = provider.getSrvcRes(location, sfb);
                srvcResource.doRemoveLabel(label, updates, updated, sfb);
                result = provider.createProxy(srvcResource, location, sfb);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
        }
        return result;
    }

    public static Resource doReadLabelledVersionProperties(ResourceImpl thisResource, String label, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        Resource result = null;
        provider.logStart("doReadLabelledVersionProperties", WvcmServiceConverter.getPR(feedback), updates);
        try {
            try {
                SrvcResource srvcResource = provider.getSrvcRes(location, sfb);
                SrvcResource srvcResult = srvcResource.doReadLabelledVersionProperties(label, updates, updated, sfb);
                if (srvcResult != null) {
                    result = provider.createProxy(srvcResult, srvcResult.location(), sfb);
                }
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
        }
        return result;
    }

    public static Resource doBaselineControl(ResourceImpl thisResource, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        Resource result = null;
        provider.logStart("doBaselineControl", WvcmServiceConverter.getPR(feedback), updates);
        try {
            try {
                SrvcResource srvcResource = provider.lookup(location, sfb);
                srvcResource = provider.doBaselineControl(location, updates, updated, sfb);
                result = provider.createProxy(srvcResource, location, sfb);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
        }
        return result;
    }

    public static List<Object> doCompareReport(ResourceImpl thisResource, VersionSet other, VersionSet.CompareFlag[] flags, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        List<Object> result = null;
        provider.logStart("doCompareReport", WvcmServiceConverter.getPR(feedback), updates);
        try {
            try {
                SrvcResource srvcResource = provider.getSrvcRes(location, sfb);
                result = srvcResource.doCompareReport(other.location(), flags, WvcmServiceConverter.getPR(feedback), updates, updated, sfb);
                WvcmServiceConverter.validateCompareReport(result, WvcmServiceConverter.getPR(feedback));
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
        }
        return result;
    }

    public static <T extends Resource> List<Object> doMergePreviewReport(ResourceImpl thisResource, List<T> sourceList, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        ArrayList<Location> sourceLocations = new ArrayList<Location>();
        int i = 0;
        while (i < sourceList.size()) {
            Resource r = (Resource)sourceList.get(i);
            if (r == null) {
                throw new WvcmException("Cannot have null entry in doMergePreview source list", (Resource)thisResource, WvcmException.ReasonCode.BAD_ARGUMENT_TYPE);
            }
            sourceLocations.add(r.location());
            ++i;
        }
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        List<Object> result = null;
        provider.logStart("doMergePreviewReport", WvcmServiceConverter.getPR(feedback), updates);
        try {
            try {
                SrvcResource srvcResource = provider.getSrvcRes(location, sfb);
                ArrayList<SrvcResource> sources = new ArrayList<SrvcResource>(sourceLocations.size());
                int i2 = 0;
                while (i2 < sourceLocations.size()) {
                    sources.add(provider.getSrvcRes((Location)sourceLocations.get(i2), sfb));
                    ++i2;
                }
                result = srvcResource.doMergePreviewReport(sources, WvcmServiceConverter.getPR(feedback), updates, updated, sfb);
                WvcmServiceConverter.validateMergePreviewReport(result, WvcmServiceConverter.getPR(feedback));
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
        }
        return result;
    }

    public static <T extends Resource> Resource doMerge(ResourceImpl thisResource, List<T> sourceList, Workspace.MergeFlag[] flags, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        ArrayList<Location> sourceLocations = new ArrayList<Location>();
        int i = 0;
        while (i < sourceList.size()) {
            Resource r = (Resource)sourceList.get(i);
            if (r == null) {
                throw new WvcmException("Cannot have null entry in doMerge source list", (Resource)thisResource, WvcmException.ReasonCode.BAD_ARGUMENT_TYPE);
            }
            sourceLocations.add(r.location());
            ++i;
        }
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        Resource result = null;
        provider.logStart("doMerge", WvcmServiceConverter.getPR(feedback), updates);
        try {
            try {
                SrvcResource srvcResource = provider.getSrvcRes(location, sfb);
                ArrayList<SrvcResource> sources = new ArrayList<SrvcResource>(sourceLocations.size());
                int i2 = 0;
                while (i2 < sourceLocations.size()) {
                    sources.add(provider.getSrvcRes((Location)sourceLocations.get(i2), sfb));
                    ++i2;
                }
                srvcResource.doMerge(sources, flags, updates, updated, sfb);
                result = provider.createProxy(srvcResource, location, sfb);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
        }
        return result;
    }

    public static <T extends Resource> Resource doUpdate(ResourceImpl thisResource, List<T> sourceList, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        ArrayList<Location> sourceLocations = new ArrayList<Location>();
        int i = 0;
        while (i < sourceList.size()) {
            Resource r = (Resource)sourceList.get(i);
            if (r == null) {
                throw new WvcmException("Cannot have null entry in doUpdate source list", (Resource)thisResource, WvcmException.ReasonCode.BAD_ARGUMENT_TYPE);
            }
            sourceLocations.add(r.location());
            ++i;
        }
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        Resource result = null;
        provider.logStart("doUpdate", WvcmServiceConverter.getPR(feedback), updates);
        try {
            try {
                SrvcResource srvcResource = provider.getSrvcRes(location, sfb);
                ArrayList<SrvcResource> sources = new ArrayList<SrvcResource>(sourceLocations.size());
                int i2 = 0;
                while (i2 < sourceLocations.size()) {
                    sources.add(provider.getSrvcRes((Location)sourceLocations.get(i2), sfb));
                    ++i2;
                }
                srvcResource.doUpdate(sources, updates, updated, sfb);
                result = provider.createProxy(srvcResource, location, sfb);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
        }
        return result;
    }

    public static Resource doLatestActivityVersionReport(ResourceImpl thisResource, Activity activity, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        Resource result = null;
        provider.logStart("doLatestActivityVersionReport", WvcmServiceConverter.getPR(feedback), updates);
        try {
            try {
                SrvcResource srvcResource = provider.getSrvcRes(location, sfb);
                SrvcResource srvcResult = srvcResource.doLatestActivityVersionReport(activity.location(), updates, updated, sfb);
                if (srvcResult != null) {
                    result = provider.createProxy(srvcResult, srvcResult.location(), sfb);
                }
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
        }
        return result;
    }

    public static <T extends Resource> Resource doVersionControl(ResourceImpl thisResource, ResourceList<T> resources, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        ArrayList<Location> locations = new ArrayList<Location>();
        int i = 0;
        while (i < resources.size()) {
            Resource r = (Resource)resources.get(i);
            if (r == null) {
                throw new WvcmException("Cannot have null entry in doVersionControl resource list", (Resource)thisResource, WvcmException.ReasonCode.BAD_ARGUMENT_TYPE);
            }
            locations.add(r.location());
            ++i;
        }
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        Resource result = null;
        provider.logStart("doVersionControl", WvcmServiceConverter.getPR(feedback), updates);
        try {
            try {
                SrvcResource srvcResource = provider.getSrvcRes(location, sfb);
                srvcResource.doVersionControl(locations, updates, updated, sfb);
                result = provider.createProxy(srvcResource, location, sfb);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
        }
        return result;
    }

    public static Resource doCheckinAll(ResourceImpl thisResource, String comment, ControllableResource.CheckinFlag[] flags, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        Resource result = null;
        provider.logStart("doCheckinAll", WvcmServiceConverter.getPR(feedback), updates);
        try {
            try {
                SrvcResource srvcResource = provider.getSrvcRes(location, sfb);
                srvcResource.doCheckinAll(comment, flags, updates, updated, sfb);
                result = provider.createProxy(srvcResource, location, sfb);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
        }
        return result;
    }

    public static <T extends Resource> Resource doCheckin(ResourceImpl thisResource, ResourceList<T> resources, String comment, ControllableResource.CheckinFlag[] flags, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        ArrayList<Location> locations = new ArrayList<Location>();
        int i = 0;
        while (i < resources.size()) {
            Resource r = (Resource)resources.get(i);
            if (r == null) {
                throw new WvcmException("Cannot have null entry in doCheckin resource list", (Resource)thisResource, WvcmException.ReasonCode.BAD_ARGUMENT_TYPE);
            }
            locations.add(r.location());
            ++i;
        }
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        Resource result = null;
        provider.logStart("doCheckin", WvcmServiceConverter.getPR(feedback), updates);
        try {
            try {
                SrvcResource srvcResource = provider.getSrvcRes(location, sfb);
                ArrayList<SrvcResource> srvcResources = new ArrayList<SrvcResource>(locations.size());
                int i2 = 0;
                while (i2 < locations.size()) {
                    srvcResources.add(provider.getSrvcRes((Location)locations.get(i2), sfb));
                    ++i2;
                }
                srvcResource.doCheckin(srvcResources, comment, flags, updates, updated, sfb);
                result = provider.createProxy(srvcResource, location, sfb);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
        }
        return result;
    }

    public static List<Object> doUpdateProperties(SrvcProvider provider, ResourceList<?> resources, Feedback feedback) throws WvcmException {
        return WvcmServiceConverter.doUpdateContextProperties(provider, resources, null, feedback);
    }

    public static List<Object> doUpdateContextProperties(SrvcProvider provider, ResourceList<?> resources, Resource context, Feedback feedback) throws WvcmException {
        int size = resources.size();
        ArrayList updatedList = new ArrayList(size);
        List<Map<PropertyNameList.PropertyName<?>, PropValue>> updatesList = WvcmServiceConverter.collectUpdates(resources);
        ArrayList<Location> locations = new ArrayList<Location>(size);
        int i = 0;
        while (i < size) {
            Resource r = (Resource)resources.get(i);
            if (r == null) {
                throw new WvcmException("Cannot have null entry in resource list", WvcmException.ReasonCode.BAD_ARGUMENT_TYPE);
            }
            locations.add(r.location());
            ++i;
        }
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        SrvcResource srvcContext = null;
        Location contextLocation = null;
        if (context != null) {
            srvcContext = provider.getSrvcRes(context.location(), sfb.nest(5));
            contextLocation = context.location();
        }
        ArrayList<Object> results = new ArrayList<Object>(size);
        provider.logStart("doUpdateProperties  ResourceList", WvcmServiceConverter.getPR(feedback), null);
        List<Object> srvcResources = provider.doUpdateContextProperties(locations, contextLocation, updatesList, updatedList, sfb.nest(50));
        int count = 0;
        for (Object obj : srvcResources) {
            ++count;
            try {
                Object resource = obj;
                if (obj instanceof SrvcResource) {
                    SrvcResource sr = (SrvcResource)obj;
                    resource = provider.createContextProxy(sr, sr.location(), srvcContext, sfb.nest(50 + 50 * count / size));
                }
                results.add(resource);
            }
            catch (WvcmException e) {
                results.add((Object)e);
            }
        }
        WvcmServiceConverter.processResults(resources, updatedList, feedback, provider, sfb);
        return results;
    }

    public static List<Object> doFind(SrvcProvider provider, ResourceList<?> queries, Feedback feedback) throws WvcmException {
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        provider.logStart("doFind ResourceList", WvcmServiceConverter.getPR(feedback), null);
        ArrayList<Object> results = new ArrayList<Object>(queries.size());
        int size = queries.size();
        if (size > 0) {
            int count = 0;
            for (Object obj : provider.doFind(queries, sfb)) {
                ++count;
                try {
                    Object resource = obj;
                    if (obj instanceof SrvcResource) {
                        SrvcResource sr = (SrvcResource)obj;
                        resource = provider.createProxy(sr, sr.location(), sfb.nest(100 * count / size));
                    }
                    results.add(resource);
                }
                catch (WvcmException e) {
                    results.add((Object)e);
                }
            }
            WvcmServiceConverter.processFeedback(provider, (ResourceImpl)queries.get(0), sfb, feedback);
        } else {
            provider.logCompletion(null, sfb);
        }
        return results;
    }

    public static <T extends ControllableResource> Resource doCreateVersionControlledResources(ResourceImpl thisResource, ResourceList<T> resources, Feedback feedback) throws WvcmException {
        Location location = thisResource.location();
        Map<PropertyNameList.PropertyName<?>, PropValue> updates = WvcmServiceConverter.collectUpdates(thisResource.getPropMap());
        ArrayList updated = new ArrayList();
        SrvcProvider provider = (SrvcProvider)thisResource.provider();
        int size = resources.size();
        ArrayList<Location> locations = new ArrayList<Location>(size);
        ArrayList<Location> versionLocations = new ArrayList<Location>(size);
        int i = 0;
        while (i < size) {
            ControllableResource r = (ControllableResource)resources.get(i);
            if (r == null) {
                throw new WvcmException("Cannot have null entry in resource list", WvcmException.ReasonCode.BAD_ARGUMENT_TYPE);
            }
            locations.add(r.location());
            Version v = r.getCheckedIn();
            if (v == null) {
                throw new WvcmException("Cannot have null entry in version list", WvcmException.ReasonCode.BAD_ARGUMENT_TYPE);
            }
            versionLocations.add(v.location());
            ++i;
        }
        SrvcFeedback sfb = provider.srvcFeedback(feedback);
        Resource result = null;
        provider.logStart("doCreateVersionControlledResources Workspace ResourceList", WvcmServiceConverter.getPR(feedback), updates);
        try {
            try {
                SrvcResource srvcResource = provider.getSrvcRes(location, sfb);
                provider.doCreateVersionControlledResources(locations, versionLocations, sfb.nest(50));
                result = provider.createProxy(srvcResource, location, sfb);
            }
            catch (WvcmException ex) {
                thisResource.wrapEx(ex);
                WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
            }
        }
        finally {
            WvcmServiceConverter.processResults(thisResource, updated, feedback, provider, sfb);
        }
        return result;
    }
}

