/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.interop;

import com.ibm.rational.wvcm.interop.InteropCore;
import com.ibm.rational.wvcm.interop.InteropUtilities;
import com.ibm.rational.wvcm.interop.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wvcm.ControllableFolder;
import javax.wvcm.ControllableResource;
import javax.wvcm.ControllableSymbolicLink;
import javax.wvcm.Feedback;
import javax.wvcm.Folder;
import javax.wvcm.PropertyRequestItem;
import javax.wvcm.Provider;
import javax.wvcm.Resource;
import javax.wvcm.SymbolicLinkVersion;
import javax.wvcm.Version;
import javax.wvcm.VersionHistory;
import javax.wvcm.WorkspaceProvider;
import javax.wvcm.WvcmException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ResourceVerifier {
    private final boolean checkClones;
    private final boolean checkFileContents;
    private final boolean checkLineSep;
    private final VersionVerifier versionVerifier;
    private final LinkVerifier linkVerifier;
    private final MessageHandler messageHandler;
    private final ResourceUnmatchHandler unmatchHandler;
    private final ExceptionHandler exceptionHandler;
    public static final PropertyRequestItem.PropertyRequest PR_ISVC_CHILDMAP = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{ControllableResource.IS_VERSION_CONTROLLED, ControllableResource.VERSION_HISTORY, ControllableResource.CHECKED_IN.nest(new PropertyRequestItem[]{SymbolicLinkVersion.LINK_TARGET}), InteropUtilities.PN_SYMLINK_TARGET_IS_DIR, Resource.CREATION_DATE, Folder.CHILD_MAP.nest(new PropertyRequestItem[]{ControllableResource.CHECKED_IN, ControllableResource.VERSION_HISTORY}), InteropCore.PR_CONTENT});
    public static final String CONTEXT_CONTENT_POSITION = "content-position";
    public static final MessageHandler NULL_MESSAGE_HANDLER = new MessageHandler(){

        @Override
        public void notify(MessageKind kind, Context context) {
        }
    };
    public static final ResourceUnmatchHandler NULL_RESOURCE_UNMATCH_HANDLER = new ResourceUnmatchHandler(){

        @Override
        public void notifyUnmatched(ResourceUnmatchKind kind, Resource thisCR, Resource thatCR, Context context) {
        }

        @Override
        public void notifyNull(ValueUnmatchedKind kind, Object thisValue, Object thatValue, Resource thisRes, Resource thatRes, Context context) {
        }

        @Override
        public void notifyUnmatched(ValueUnmatchedKind kind, Object thisValue, Object thatValue, Resource thisRes, Resource thatRes, Context context) {
        }
    };
    private static final ExceptionHandler NULL_EXCEPTION_HANDLER = new ExceptionHandler(){

        @Override
        public void notifyException(Throwable t, Context context) {
        }
    };

    public static Context createDefaultContext(IPath relativePath, Context.CRType type) {
        ResourceVerifier resourceVerifier = new ResourceVerifier();
        resourceVerifier.getClass();
        return resourceVerifier.new ControllableResourceContext(relativePath, type);
    }

    public static Context createDefaultContext(IPath relativePath, String versionName) {
        ResourceVerifier resourceVerifier = new ResourceVerifier();
        resourceVerifier.getClass();
        return resourceVerifier.new VersionContext(relativePath, versionName);
    }

    public static Context createDefaultContext(IPath relativePath, String versionName, String attributeName) {
        ResourceVerifier resourceVerifier = new ResourceVerifier();
        resourceVerifier.getClass();
        return resourceVerifier.new AttributeContext(relativePath, versionName, attributeName);
    }

    private ResourceVerifier() {
        this(false, false, false, null, null, null, null, null);
    }

    public ResourceVerifier(boolean checkClones, boolean checkFileContents, boolean checkLineSep, VersionVerifier versionVerifier, LinkVerifier linkVerifier, MessageHandler messageHandler, ResourceUnmatchHandler unmatchHandler, ExceptionHandler exceptionHandler) {
        this.checkClones = checkClones;
        this.checkFileContents = checkFileContents;
        this.checkLineSep = checkLineSep;
        this.versionVerifier = versionVerifier;
        this.linkVerifier = linkVerifier;
        this.messageHandler = messageHandler != null ? messageHandler : NULL_MESSAGE_HANDLER;
        this.unmatchHandler = unmatchHandler != null ? unmatchHandler : NULL_RESOURCE_UNMATCH_HANDLER;
        this.exceptionHandler = exceptionHandler != null ? exceptionHandler : NULL_EXCEPTION_HANDLER;
    }

    private static Context.CRType getCRType(ControllableResource cr) {
        try {
            if (cr != null && cr.getIsVersionControlled()) {
                if (ResourceVerifier.isSymLink(cr)) {
                    return Context.CRType.SYMBOLIC_LINK;
                }
                if (cr instanceof ControllableFolder) {
                    return Context.CRType.DIRECTORY;
                }
                return Context.CRType.FILE;
            }
        }
        catch (WvcmException wvcmException) {
            // empty catch block
        }
        return Context.CRType.UNDEFINED;
    }

    public void verify(IPath relativeParentPath, String bindingName, ControllableResource thisCRArg, ControllableResource otherCRArg, boolean isRoot) throws WvcmException {
        IPath relativePath = bindingName != null && relativeParentPath != null ? relativeParentPath.append(bindingName) : null;
        ArrayList<Context> context = new ArrayList<Context>();
        context.add(new ControllableResourceContext(relativePath, Context.CRType.UNDEFINED));
        try {
            this.verifyBody(relativePath, context, thisCRArg, otherCRArg, isRoot);
        }
        catch (Throwable t) {
            this.exceptionHandler.notifyException(t, (Context)context.get(0));
        }
    }

    private void verifyBody(IPath relativePath, List<Context> context, ControllableResource thisCRArg, ControllableResource otherCRArg, boolean isRoot) throws WvcmException {
        this.messageHandler.notify(MessageKind.NOTIFY_START, context.get(0));
        boolean endNotified = false;
        try {
            ControllableResource thisCR = null;
            if (thisCRArg != null) {
                thisCR = (ControllableResource)thisCRArg.doReadProperties((Feedback)PR_ISVC_CHILDMAP);
            }
            ControllableResource otherCR = null;
            if (otherCRArg != null) {
                otherCR = (ControllableResource)otherCRArg.doReadProperties((Feedback)PR_ISVC_CHILDMAP);
            }
            if (thisCR == null || !thisCR.getIsVersionControlled()) {
                context.add(0, new ControllableResourceContext(relativePath, ResourceVerifier.getCRType(otherCR)));
                if (otherCR != null && otherCR.getIsVersionControlled()) {
                    this.unmatchHandler.notifyUnmatched(ResourceUnmatchKind.THIS_CR_IS_NULL, (Resource)thisCR, (Resource)otherCR, context.get(0));
                }
                return;
            }
            if (otherCR == null || !otherCR.getIsVersionControlled()) {
                context.add(0, new ControllableResourceContext(relativePath, ResourceVerifier.getCRType(thisCR)));
                if (thisCR.getIsVersionControlled()) {
                    this.unmatchHandler.notifyUnmatched(ResourceUnmatchKind.THAT_CR_IS_NULL, (Resource)thisCR, (Resource)otherCR, context.get(0));
                }
                return;
            }
            if (this.linkVerifier != null) {
                this.linkVerifier.addTargetElement(thisCR, otherCR);
            }
            if (ResourceVerifier.isSymLink(thisCR)) {
                context.add(0, new ControllableResourceContext(relativePath, Context.CRType.SYMBOLIC_LINK));
                if (this.linkVerifier != null) {
                    this.linkVerifier.verify(relativePath, thisCR, otherCR);
                } else if (!ResourceVerifier.isSymLink(otherCR)) {
                    this.unmatchHandler.notifyUnmatched(ResourceUnmatchKind.THAT_CR_IS_NOT_SYMLINK, (Resource)thisCR, (Resource)otherCR, context.get(0));
                } else if (thisCR instanceof ControllableSymbolicLink) {
                    ResourceVerifier.verifySymLinks(relativePath, thisCR, otherCR, this.unmatchHandler);
                } else {
                    ResourceVerifier.verifyValues(relativePath, ValueUnmatchedKind.VALUE_LINK_TARGET, ResourceVerifier.getCheckedInTargetLocation(thisCR), ResourceVerifier.getCheckedInTargetLocation(otherCR), (Resource)thisCR, (Resource)otherCR, this.unmatchHandler, context.get(0));
                    ResourceVerifier.verifyValues(relativePath, ValueUnmatchedKind.VALUE_IS_DIRECTORY_LINK, ResourceVerifier.getTargetIsFolder(thisCR), ResourceVerifier.getTargetIsFolder(otherCR), (Resource)thisCR, (Resource)otherCR, this.unmatchHandler, context.get(0));
                }
            } else if (thisCR instanceof ControllableFolder) {
                context.add(0, new ControllableResourceContext(relativePath, Context.CRType.DIRECTORY));
                if (!(otherCR instanceof ControllableFolder)) {
                    this.unmatchHandler.notifyUnmatched(ResourceUnmatchKind.THAT_CR_IS_NOT_FOLDER, (Resource)thisCR, (Resource)otherCR, context.get(0));
                    return;
                }
                if (!isRoot && this.checkClones) {
                    ResourceVerifier.verifyClones(relativePath, thisCR, otherCR, this.unmatchHandler, context.get(0));
                }
                this.messageHandler.notify(MessageKind.NOTIFY_END, context.get(0));
                endNotified = true;
                ControllableFolder thisCF = (ControllableFolder)thisCR;
                ControllableFolder otherCF = (ControllableFolder)otherCR;
                Map thisChildMap = thisCF.getChildMap();
                Map otherChildMap = otherCF.getChildMap();
                for (String bn : thisChildMap.keySet()) {
                    ControllableResource thisChild = (ControllableResource)thisChildMap.get(bn);
                    ControllableResource otherChild = (ControllableResource)otherChildMap.get(bn);
                    this.verify(relativePath, bn, thisChild, otherChild, false);
                }
                for (String bn : otherChildMap.keySet()) {
                    ControllableResource thisChild = (ControllableResource)thisChildMap.get(bn);
                    ControllableResource otherChild = (ControllableResource)otherChildMap.get(bn);
                    if (otherChild.getVersionHistory() == null || thisChild != null) continue;
                    IPath childRelativePath = relativePath != null ? relativePath.append(bn) : null;
                    ControllableResourceContext childContext = new ControllableResourceContext(childRelativePath, Context.CRType.UNDEFINED);
                    this.messageHandler.notify(MessageKind.NOTIFY_START, childContext);
                    try {
                        otherChild = (ControllableResource)otherChild.doReadProperties((Feedback)new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{ControllableResource.IS_VERSION_CONTROLLED}));
                        childContext = new ControllableResourceContext(childRelativePath, ResourceVerifier.getCRType(otherChild));
                        this.unmatchHandler.notifyUnmatched(ResourceUnmatchKind.THIS_CR_IS_NULL, (Resource)thisChild, (Resource)otherChild, childContext);
                    }
                    finally {
                        this.messageHandler.notify(MessageKind.NOTIFY_END, childContext);
                    }
                }
            } else {
                context.add(0, new ControllableResourceContext(relativePath, Context.CRType.FILE));
                if (otherCR instanceof ControllableFolder) {
                    this.unmatchHandler.notifyUnmatched(ResourceUnmatchKind.THAT_CR_IS_NOT_FILE, (Resource)thisCR, (Resource)otherCR, context.get(0));
                    return;
                }
                this.verifyContents(relativePath, thisCR, otherCR);
                if (this.checkClones) {
                    ResourceVerifier.verifyClones(relativePath, thisCR, otherCR, this.unmatchHandler, context.get(0));
                }
                if (this.versionVerifier != null) {
                    this.versionVerifier.verify(relativePath, (Resource)thisCR, (Resource)otherCR);
                }
            }
        }
        finally {
            if (!endNotified) {
                this.messageHandler.notify(MessageKind.NOTIFY_END, context.get(0));
            }
        }
    }

    public static void verify(IPath relativeParentPath, ControllableResource thisCRArg, ControllableResource otherCRArg, boolean checkClones, boolean checkFileContents, boolean checkLineSep, VersionVerifier versionVerifier, LinkVerifier linkVerifier, MessageHandler messageHandler, ResourceUnmatchHandler unmatchHandler, ExceptionHandler exceptionHandler) throws WvcmException {
        ResourceVerifier resourceVerifier = new ResourceVerifier(checkClones, checkFileContents, checkLineSep, versionVerifier, linkVerifier, messageHandler, unmatchHandler, exceptionHandler);
        String bindingName = otherCRArg.location().lastSegment();
        resourceVerifier.verify(relativeParentPath, bindingName, thisCRArg, otherCRArg, true);
    }

    public static boolean isSymLink(ControllableResource cr) throws WvcmException {
        return InteropUtilities.getOrReadProperty((Resource)cr, ControllableResource.CHECKED_IN, null) instanceof SymbolicLinkVersion;
    }

    public static String getCheckedInTargetLocation(ControllableResource cr) throws WvcmException {
        Version ver = (Version)InteropUtilities.getOrReadProperty((Resource)cr, ControllableResource.CHECKED_IN, (Feedback)new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{SymbolicLinkVersion.LINK_TARGET}));
        return (String)InteropUtilities.getOrReadProperty((Resource)ver, SymbolicLinkVersion.LINK_TARGET, null);
    }

    public static Boolean getTargetIsFolder(ControllableResource cr) throws WvcmException {
        return InteropUtilities.getOrReadProperty((Resource)cr, InteropUtilities.PN_SYMLINK_TARGET_IS_DIR, null);
    }

    public static Date getCreationDate(ControllableResource cr) throws WvcmException {
        return (Date)InteropUtilities.getOrReadProperty((Resource)cr, Resource.CREATION_DATE, null);
    }

    public static int verifyValues(ValueUnmatchedKind kind, Object thisValue, Object thatValue, Resource thisRes, Resource thatRes, ResourceUnmatchHandler unmatchHandler) throws WvcmException {
        return ResourceVerifier.verifyValues(null, kind, thisValue, thatValue, thisRes, thatRes, unmatchHandler, ResourceVerifier.createDefaultContext(null, Context.CRType.FILE));
    }

    public static int verifyValues(IPath path, ValueUnmatchedKind kind, Object thisValue, Object thatValue, Resource thisRes, Resource thatRes, ResourceUnmatchHandler unmatchHandler, Context context) throws WvcmException {
        if (thisValue == null && thatValue == null) {
            return 0;
        }
        if (thisValue == null || thatValue == null) {
            unmatchHandler.notifyNull(kind, thisValue, thatValue, thisRes, thatRes, context);
            return 1;
        }
        boolean equals = thisValue instanceof byte[] && thatValue instanceof byte[] ? Arrays.equals((byte[])thisValue, (byte[])thatValue) : (thisValue instanceof Byte[] && thatValue instanceof Byte[] ? Arrays.equals((Object[])((Byte[])thisValue), (Object[])((Byte[])thatValue)) : thisValue.equals(thatValue));
        if (!equals) {
            unmatchHandler.notifyUnmatched(kind, thisValue, thatValue, thisRes, thatRes, context);
            return 1;
        }
        return 0;
    }

    public static void verifySymLinks(IPath relativePath, ControllableResource thisCR, ControllableResource otherCR, ResourceUnmatchHandler unmatchHandler) throws WvcmException {
        Context context = ResourceVerifier.createDefaultContext(relativePath, Context.CRType.SYMBOLIC_LINK);
        ResourceVerifier.verifyValues(relativePath, ValueUnmatchedKind.VALUE_LINK_TARGET, ResourceVerifier.getCheckedInTargetLocation(thisCR), ResourceVerifier.getCheckedInTargetLocation(otherCR), (Resource)thisCR, (Resource)otherCR, unmatchHandler, context);
        ResourceVerifier.verifyValues(relativePath, ValueUnmatchedKind.VALUE_IS_DIRECTORY_LINK, ResourceVerifier.getTargetIsFolder(thisCR), ResourceVerifier.getTargetIsFolder(otherCR), (Resource)thisCR, (Resource)otherCR, unmatchHandler, context);
        ResourceVerifier.verifyValues(relativePath, ValueUnmatchedKind.VALUE_CREATION_DATE, ResourceVerifier.getCreationDate(thisCR), ResourceVerifier.getCreationDate(otherCR), (Resource)thisCR, (Resource)otherCR, unmatchHandler, context);
    }

    public static void verifyClones(IPath relativePath, ControllableResource thisCR, ControllableResource otherCR, ResourceUnmatchHandler unmatchHandler, Context context) throws WvcmException {
        thisCR = (ControllableResource)thisCR.doReadProperties((Feedback)InteropCore.PR_VH_CLONE);
        VersionHistory thisVH = thisCR.getVersionHistory();
        String thisCloneInfo = InteropUtilities.getProperty((Resource)thisVH, InteropCore.PN_CLONE);
        otherCR = (ControllableResource)otherCR.doReadProperties((Feedback)InteropCore.PR_VH_CLONE);
        VersionHistory otherVH = otherCR.getVersionHistory();
        String otherCloneInfo = InteropUtilities.getProperty((Resource)otherVH, InteropCore.PN_CLONE);
        if (thisCloneInfo != null) {
            if (!thisCloneInfo.equals(otherVH.getResourceIdentifier())) {
                unmatchHandler.notifyUnmatched(ValueUnmatchedKind.VALUE_THIS_CLONE_INFO, thisCloneInfo, otherVH.getResourceIdentifier(), (Resource)thisCR, (Resource)otherCR, context);
            }
        } else if (otherCloneInfo != null) {
            if (!otherCloneInfo.equals(thisVH.getResourceIdentifier())) {
                unmatchHandler.notifyUnmatched(ValueUnmatchedKind.VALUE_THAT_CLONE_INFO, thisVH.getResourceIdentifier(), otherCloneInfo, (Resource)thisCR, (Resource)otherCR, context);
            }
        } else {
            unmatchHandler.notifyUnmatched(ResourceUnmatchKind.NO_CLONE_INFO, (Resource)thisCR, (Resource)otherCR, context);
        }
    }

    private void verifyContents(IPath relativePath, ControllableResource thisCR, ControllableResource otherCR) throws WvcmException {
        String thisContentType = thisCR.getContentType();
        String otherContentType = otherCR.getContentType();
        boolean isText = InteropUtilities.isTextContentType(thisContentType) && InteropUtilities.isTextContentType(otherContentType);
        Charset charset = null;
        if (isText) {
            if (this.checkLineSep) {
                ResourceVerifier.verifyValues(relativePath, ValueUnmatchedKind.VALUE_LINE_SEPARATOR, thisCR.getProperty(InteropUtilities.PN_LINE_SEPARATOR), otherCR.getProperty(InteropUtilities.PN_LINE_SEPARATOR), (Resource)thisCR, (Resource)otherCR, this.unmatchHandler, ResourceVerifier.createDefaultContext(relativePath, Context.CRType.FILE));
            }
            charset = ResourceVerifier.getCharset(thisCR);
        }
        if (this.checkFileContents) {
            WorkspaceProvider thisP = thisCR.workspaceProvider();
            WorkspaceProvider otherP = thisCR.workspaceProvider();
            ResourceVerifier.verifyContents(relativePath, (Resource)thisCR, (Provider)thisP, (Resource)otherCR, (Provider)otherP, isText ? charset : null, this.unmatchHandler, this.checkLineSep);
        }
    }

    public static Charset getCharset(ControllableResource thisCR) {
        Charset charset;
        try {
            String charsetName = (String)InteropUtilities.getOrReadProperty((Resource)thisCR, ControllableResource.CONTENT_CHARACTER_SET, null);
            charset = Charset.forName(charsetName);
        }
        catch (Exception e) {
            charset = Charset.defaultCharset();
        }
        return charset;
    }

    public static void verifyContents(IPath relativePath, Resource thisRes, Provider thisP, Resource otherRes, Provider otherP, Charset charset, ResourceUnmatchHandler unmatchHandler, boolean checkLineSep) throws WvcmException {
        PipedInputStream thisPins = new PipedInputStream();
        PipedOutputStream thisPouts = null;
        Thread thisReader = null;
        InputStreamReader thisISR = null;
        InteropUtilities.ChildException thisChildEx = new InteropUtilities.ChildException();
        PipedInputStream otherPins = new PipedInputStream();
        PipedOutputStream otherPouts = null;
        Thread otherReader = null;
        InputStreamReader otherISR = null;
        InteropUtilities.ChildException otherChildEx = new InteropUtilities.ChildException();
        try {
            try {
                thisPouts = InteropUtilities.createPipedOutputStream(thisP, thisPins);
                thisReader = new InteropUtilities.ContentReader(thisRes, thisPouts, thisRes, thisChildEx, null);
                otherPouts = InteropUtilities.createPipedOutputStream(otherP, otherPins);
                otherReader = new InteropUtilities.ContentReader(otherRes, otherPouts, otherRes, otherChildEx, null);
                if (charset != null) {
                    thisISR = new InputStreamReader((InputStream)thisPins, charset);
                    otherISR = new InputStreamReader((InputStream)otherPins, charset);
                    ResourceVerifier.verifyTextContents(relativePath, thisISR, thisChildEx, otherISR, otherChildEx, thisRes, otherRes, unmatchHandler, checkLineSep);
                } else {
                    ResourceVerifier.verifyBinaryContens(relativePath, thisPins, thisChildEx, otherPins, otherChildEx, thisRes, otherRes, unmatchHandler);
                }
            }
            catch (WvcmException e) {
                if (thisReader != null) {
                    thisReader.interrupt();
                }
                if (otherReader != null) {
                    otherReader.interrupt();
                }
                throw e;
            }
        }
        finally {
            if (thisPins != null) {
                try {
                    InteropUtilities.closePipedInputStream(thisP, thisPins);
                }
                catch (WvcmException wvcmException) {}
            }
            if (thisISR != null) {
                try {
                    thisISR.close();
                }
                catch (IOException iOException) {}
            }
            if (otherPins != null) {
                try {
                    InteropUtilities.closePipedInputStream(otherP, otherPins);
                }
                catch (WvcmException wvcmException) {}
            }
            if (otherISR != null) {
                try {
                    otherISR.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void handleChildEx(InteropUtilities.ChildException childEx) throws WvcmException {
        if (childEx.ex != null) {
            if (childEx.ex instanceof WvcmException) {
                throw (WvcmException)childEx.ex;
            }
            throw new WvcmException(Messages.InteropStream_ERROR_CONTENT_READER_DIED, WvcmException.ReasonCode.CONFLICT, childEx.ex);
        }
    }

    public static void verifyBinaryContens(IPath relativePath, InputStream thisIS, InteropUtilities.ChildException thisChildEx, InputStream otherIS, InteropUtilities.ChildException otherChildEx, Resource thisRes, Resource otherRes, ResourceUnmatchHandler unmatchHandler) throws WvcmException {
        int total = 0;
        int thisRead = 0;
        int otherRead = 0;
        Context context = ResourceVerifier.createDefaultContext(relativePath, Context.CRType.FILE);
        try {
            while (thisRead > -1 || otherRead > -1) {
                thisRead = thisIS.read();
                ResourceVerifier.handleChildEx(thisChildEx);
                otherRead = otherIS.read();
                ResourceVerifier.handleChildEx(otherChildEx);
                if (thisRead != -1 && otherRead != -1) {
                    byte thisByte = (byte)thisRead;
                    byte otherByte = (byte)otherRead;
                    if (thisByte != otherByte) {
                        context.setProperty(CONTEXT_CONTENT_POSITION, total);
                        unmatchHandler.notifyUnmatched(ValueUnmatchedKind.VALUE_CONTENT, thisByte, otherByte, thisRes, otherRes, context);
                        return;
                    }
                    ++total;
                    continue;
                }
                if (thisRead == -1 && otherRead == -1 || thisRead == otherRead) continue;
                context.setProperty(CONTEXT_CONTENT_POSITION, total);
                unmatchHandler.notifyUnmatched(ValueUnmatchedKind.VALUE_CONTENT_LENGTH, thisRead, otherRead, thisRes, otherRes, context);
                return;
            }
        }
        catch (IOException e) {
            throw new WvcmException("IO error", WvcmException.ReasonCode.READ_FAILED, (Throwable)e);
        }
    }

    private static Context createTextContentContext(IPath relativePath, Resource otherRes, int position) throws WvcmException {
        Context context = otherRes instanceof Version ? ResourceVerifier.createDefaultContext(relativePath, (String)InteropUtilities.getOrReadProperty(otherRes, Version.VERSION_NAME, null)) : ResourceVerifier.createDefaultContext(relativePath, Context.CRType.FILE);
        context.setProperty(CONTEXT_CONTENT_POSITION, position);
        return context;
    }

    public static void verifyTextContents(IPath relativePath, Reader thisReader, InteropUtilities.ChildException thisChildEx, Reader otherReader, InteropUtilities.ChildException otherChildEx, Resource thisRes, Resource otherRes, ResourceUnmatchHandler unmatchHandler, boolean checkLineSep) throws WvcmException {
        ArrayList<Integer> thisCharBuf = new ArrayList<Integer>();
        ArrayList<Integer> otherCharBuf = new ArrayList<Integer>();
        int total = 0;
        int thisRead = 0;
        int otherRead = 0;
        ArrayList<Integer> thisRemaining = new ArrayList<Integer>();
        ArrayList<Integer> otherRemaining = new ArrayList<Integer>();
        boolean isLSChecked = false;
        while (thisRead > -1 || otherRead > -1) {
            thisCharBuf.clear();
            thisRead = ResourceVerifier.readOneChar(thisRemaining, thisReader, thisCharBuf);
            ResourceVerifier.handleChildEx(thisChildEx);
            InteropUtilities.LineSeparator thisLS = ResourceVerifier.getLineSeparator(thisCharBuf);
            if (thisLS == InteropUtilities.LineSeparator.CR && thisCharBuf.size() == 2) {
                thisRemaining.add((Integer)thisCharBuf.remove(1));
            }
            otherCharBuf.clear();
            otherRead = ResourceVerifier.readOneChar(otherRemaining, otherReader, otherCharBuf);
            ResourceVerifier.handleChildEx(otherChildEx);
            InteropUtilities.LineSeparator otherLS = ResourceVerifier.getLineSeparator(otherCharBuf);
            if (otherLS == InteropUtilities.LineSeparator.CR && otherCharBuf.size() == 2) {
                otherRemaining.add((Integer)otherCharBuf.remove(1));
            }
            if (thisLS != null && otherLS != null) {
                if (checkLineSep && !isLSChecked && thisLS != otherLS) {
                    unmatchHandler.notifyUnmatched(ValueUnmatchedKind.VALUE_CONTENT_LINE_SEPARATOR, (Object)thisLS, (Object)otherLS, thisRes, otherRes, ResourceVerifier.createTextContentContext(relativePath, otherRes, total));
                    isLSChecked = true;
                }
            } else {
                if (thisLS != null || otherLS != null) {
                    if (thisCharBuf.size() == 0 || otherCharBuf.size() == 0) {
                        unmatchHandler.notifyUnmatched(ValueUnmatchedKind.VALUE_CONTENT_LENGTH, thisCharBuf.size(), otherCharBuf.size(), thisRes, otherRes, ResourceVerifier.createTextContentContext(relativePath, otherRes, total));
                        return;
                    }
                    unmatchHandler.notifyUnmatched(ValueUnmatchedKind.VALUE_CONTENT, (int)((Integer)thisCharBuf.get(0)), (int)((Integer)otherCharBuf.get(0)), thisRes, otherRes, ResourceVerifier.createTextContentContext(relativePath, otherRes, total));
                    return;
                }
                if (thisCharBuf.size() != otherCharBuf.size()) {
                    unmatchHandler.notifyUnmatched(ValueUnmatchedKind.VALUE_CONTENT_LENGTH, thisCharBuf.size(), otherCharBuf.size(), thisRes, otherRes, ResourceVerifier.createTextContentContext(relativePath, otherRes, total));
                    return;
                }
                if (thisCharBuf.size() > 0 && otherCharBuf.size() > 0 && !thisCharBuf.equals(otherCharBuf)) {
                    unmatchHandler.notifyUnmatched(ValueUnmatchedKind.VALUE_CONTENT, (int)((Integer)thisCharBuf.get(0)), (int)((Integer)otherCharBuf.get(0)), thisRes, otherRes, ResourceVerifier.createTextContentContext(relativePath, otherRes, total));
                    return;
                }
            }
            ++total;
        }
    }

    private static InteropUtilities.LineSeparator getLineSeparator(List<Integer> cb) {
        return ResourceVerifier.getLineSeparator(cb, 0);
    }

    private static InteropUtilities.LineSeparator getLineSeparator(List<Integer> cb, int off) {
        if (off < cb.size()) {
            char oneChar = (char)cb.get(off).intValue();
            if (oneChar == '\n') {
                return InteropUtilities.LineSeparator.LF;
            }
            if (oneChar == '\r') {
                char nextChar;
                if (off + 1 < cb.size() && (nextChar = (char)cb.get(off + 1).intValue()) == '\n') {
                    return InteropUtilities.LineSeparator.CRLF;
                }
                return InteropUtilities.LineSeparator.CR;
            }
        }
        return null;
    }

    private static int readOneChar(List<Integer> precedings, Reader reader, List<Integer> out) throws WvcmException {
        int oneChar = 0;
        try {
            int n = oneChar = precedings.size() > 0 ? precedings.remove(0).intValue() : reader.read();
            if (oneChar > -1) {
                char c = (char)oneChar;
                out.add(oneChar);
                if (c == '\r') {
                    int n2 = oneChar = precedings.size() > 0 ? precedings.remove(0).intValue() : reader.read();
                    if (oneChar > -1) {
                        out.add(oneChar);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new WvcmException("IO error", WvcmException.ReasonCode.READ_FAILED, (Throwable)e);
        }
        return oneChar;
    }

    public class AttributeContext
    extends VersionContext {
        private final String attributeName;

        public AttributeContext(IPath relativePath, String versionName, String attributeName) {
            super(relativePath, versionName);
            this.attributeName = attributeName;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + ":" + this.attributeName;
        }
    }

    public static interface Context {
        public IPath getRelativePath();

        public CRType getCRType();

        public Object getProperty(String var1);

        public void setProperty(String var1, Object var2);

        public static enum CRType {
            DIRECTORY,
            SYMBOLIC_LINK,
            FILE,
            UNDEFINED;

        }
    }

    public class ContextImpl
    implements Context {
        private final IPath relativePath;
        private final Map<String, Object> properties = new HashMap<String, Object>();

        public ContextImpl(IPath relativePath) {
            this.relativePath = relativePath;
        }

        @Override
        public IPath getRelativePath() {
            return this.relativePath != null ? this.relativePath : new Path("");
        }

        @Override
        public Context.CRType getCRType() {
            return Context.CRType.FILE;
        }

        @Override
        public Object getProperty(String name) {
            return this.properties.get(name);
        }

        @Override
        public void setProperty(String name, Object value) {
            this.properties.put(name, value);
        }

        public String toString() {
            return this.getRelativePath().toPortableString();
        }
    }

    public class ControllableResourceContext
    extends ContextImpl {
        private final Context.CRType type;

        public ControllableResourceContext(IPath relativePath, Context.CRType type) {
            super(relativePath);
            this.type = type;
        }

        @Override
        public Context.CRType getCRType() {
            return this.type;
        }
    }

    public static interface ExceptionHandler {
        public void notifyException(Throwable var1, Context var2) throws WvcmException;
    }

    public static interface LinkVerifier {
        public void addTargetElement(ControllableResource var1, ControllableResource var2) throws WvcmException;

        public void verify(IPath var1, ControllableResource var2, ControllableResource var3) throws WvcmException;
    }

    public static interface MessageHandler {
        public void notify(MessageKind var1, Context var2) throws WvcmException;
    }

    public static enum MessageKind {
        NOTIFY_START,
        NOTIFY_END;

    }

    public static interface ResourceUnmatchHandler {
        public void notifyUnmatched(ResourceUnmatchKind var1, Resource var2, Resource var3, Context var4) throws WvcmException;

        public void notifyNull(ValueUnmatchedKind var1, Object var2, Object var3, Resource var4, Resource var5, Context var6) throws WvcmException;

        public void notifyUnmatched(ValueUnmatchedKind var1, Object var2, Object var3, Resource var4, Resource var5, Context var6) throws WvcmException;
    }

    public static enum ResourceUnmatchKind {
        THIS_CR_IS_NULL,
        THAT_CR_IS_NULL,
        THAT_CR_IS_NOT_SYMLINK,
        THAT_CR_IS_NOT_FOLDER,
        THAT_CR_IS_NOT_FILE,
        THIS_VER_IS_NULL,
        THAT_VER_IS_NULL,
        NO_CLONE_INFO;

    }

    public static enum ValueUnmatchedKind {
        VALUE_LINK_TARGET,
        VALUE_IS_DIRECTORY_LINK,
        VALUE_THIS_CLONE_INFO,
        VALUE_THAT_CLONE_INFO,
        VALUE_LINE_SEPARATOR,
        VALUE_CONTENT,
        VALUE_CONTENT_LENGTH,
        VALUE_CONTENT_LINE_SEPARATOR,
        VALUE_CREATION_DATE,
        VALUE_SYNTHETIC_ID,
        VALUE_TARGET_ELEMENT_UNIVERSAL_SELECTOR,
        VERSION_VALUE_SHA_256,
        VERSION_VALUE_VERSION_NAME,
        VERSION_VALUE_ELEMENT_UNIVERSAL_SELECTOR,
        VERSION_VALUE_BRTYPE_DISPLAYNAME,
        VERSION_VALUE_ACTIVITY_NAME,
        VERSION_VALUE_IS_EXECUTABLE,
        VERSION_VALUE_COMMENT,
        VERSION_VALUE_CONTENT_CHARACTER_SET,
        VERSION_VALUE_CONTENT_TYPE,
        VERSION_VALUE_CREATION_DATE,
        VERSION_VALUE_CREATOR_DISPLAY_NAME,
        VERSION_VALUE_PRED_LIST_LEN,
        VERSION_VALUE_PRED_VER,
        VERSION_VALUE_MERGE_PRED_VER,
        VERSION_ATTRIBUTE;

    }

    public class VersionContext
    extends ContextImpl {
        private final String versionName;

        public VersionContext(IPath relativePath, String versionName) {
            super(relativePath);
            this.versionName = versionName;
        }

        public String getVersionName() {
            return this.versionName;
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + "@@" + this.versionName;
        }
    }

    public static interface VersionVerifier {
        public void verify(IPath var1, Resource var2, Resource var3) throws WvcmException;
    }
}

