/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.interop;

import com.ibm.rational.wvcm.interop.InteropUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wvcm.Feedback;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.ResourceList;
import javax.wvcm.WorkspaceProvider;
import javax.wvcm.WvcmException;

public class LinkedObjectUtils {
    private final String IA_HAS_OBJECT_LINKAGE_INFO;
    private final PropertyNameList.PropertyName<String> PN_OBJECT_LINKAGE;

    LinkedObjectUtils(PropertyNameList.PropertyName<String> linkageProperty, String iaHasObjectLinkageInfo) {
        this.PN_OBJECT_LINKAGE = linkageProperty;
        this.IA_HAS_OBJECT_LINKAGE_INFO = iaHasObjectLinkageInfo;
    }

    public <T extends Resource> T lookupLinkedObject(T oneResource, WorkspaceProvider otherP) throws WvcmException {
        String path = this.lookupLinkedObjectPath(oneResource, otherP);
        return this.lookupLinkedObject(oneResource, otherP, path);
    }

    public <T extends Resource> T lookupLinkedObject(T oneResource, WorkspaceProvider otherP, String path) throws WvcmException {
        if (path == null) {
            return null;
        }
        Class<?> type = oneResource.getClass();
        return (T)otherP.buildProxy(type, otherP.location(path));
    }

    public boolean hasObjectLinkageInfo(Map<String, String> initArgs) {
        return initArgs.containsKey(this.IA_HAS_OBJECT_LINKAGE_INFO);
    }

    private <T extends Resource> String lookupLinkedObjectPath(T oneResource, WorkspaceProvider otherProvider) throws WvcmException {
        if (this.hasObjectLinkageInfo(oneResource.provider().initArgs())) {
            return InteropUtilities.getProperty(oneResource, this.PN_OBJECT_LINKAGE);
        }
        if (!this.hasObjectLinkageInfo(otherProvider.initArgs())) {
            throw new WvcmException("Neither provider is storing object linkage information", oneResource, WvcmException.ReasonCode.FORBIDDEN);
        }
        Class<?> type = oneResource.getClass();
        Resource otherResourceQuery = otherProvider.buildProxy(type, otherProvider.rootLocation());
        otherResourceQuery.setProperty(this.PN_OBJECT_LINKAGE, (Object)oneResource.getResourceIdentifier());
        Resource otherResource = otherResourceQuery.doFind(null);
        if (otherResource == null) {
            return null;
        }
        return otherResource.getResourceIdentifier();
    }

    private Map<Resource, String> lookupLinkedObjectPaths(WorkspaceProvider srcProv, Set<Resource> srcResources, WorkspaceProvider tgtProv) throws WvcmException {
        int sourceCount = srcResources.size();
        HashMap<Resource, String> results = new HashMap<Resource, String>(sourceCount);
        if (this.hasObjectLinkageInfo(srcProv.initArgs())) {
            for (Resource res : srcResources) {
                results.put(res, InteropUtilities.getProperty(res, this.PN_OBJECT_LINKAGE));
            }
            return results;
        }
        if (!this.hasObjectLinkageInfo(tgtProv.initArgs())) {
            throw new WvcmException("Neither provider is storing object linkage information", null, WvcmException.ReasonCode.FORBIDDEN);
        }
        ArrayList<String> resIds = new ArrayList<String>(sourceCount);
        for (Resource resource : srcResources) {
            resIds.add(resource.getResourceIdentifier());
        }
        Map<String, String> helperMap = this.lookupLinkedObjectPaths(srcProv, resIds, tgtProv);
        for (Resource resource : srcResources) {
            results.put(resource, helperMap.get(resource.getResourceIdentifier()));
        }
        return results;
    }

    private Map<String, String> lookupLinkedObjectPaths(WorkspaceProvider srcProv, List<String> resIds, WorkspaceProvider tgtProv) throws WvcmException {
        HashMap<String, String> results = new HashMap<String, String>(resIds.size());
        ResourceList queries = tgtProv.resourceList(new Resource[0]);
        for (String resId : resIds) {
            Resource queryElement = tgtProv.resource(tgtProv.rootLocation());
            queryElement.setProperty(this.PN_OBJECT_LINKAGE, (Object)resId);
            queries.add((Object)queryElement);
        }
        ResourceList.ResponseIterator linkedObjects = queries.doFind(null);
        for (String resId : resIds) {
            Resource linkedObject = (Resource)linkedObjects.next();
            String value = linkedObject != null ? linkedObject.getResourceIdentifier() : null;
            results.put(resId, value);
        }
        return results;
    }

    public List<Resource> lookupLinkedObjects(WorkspaceProvider sourceProvider, List<? extends Resource> sources, WorkspaceProvider destinationProvider) throws WvcmException {
        int sourceCount = sources.size();
        if (sourceCount == 0) {
            return Collections.emptyList();
        }
        ArrayList<Resource> results = new ArrayList<Resource>(sourceCount);
        Map<Resource, String> resultMap = this.lookupLinkedObjectPaths(sourceProvider, new HashSet<Resource>(sources), destinationProvider);
        for (Resource resource : sources) {
            String destResId = resultMap.get(resource);
            Resource result = destinationProvider.resource(destinationProvider.location(destResId));
            results.add(result);
        }
        return results;
    }

    public ResourceList<Resource> lookupResourcesLinkedToTheseIds(WorkspaceProvider sourceProvider, List<String> resIds, WorkspaceProvider destinationProvider, Feedback feedback) throws WvcmException {
        ResourceList results = destinationProvider.resourceList(new Resource[0]);
        int sourceCount = resIds.size();
        if (sourceCount == 0) {
            return results;
        }
        Map<String, String> resultMap = this.lookupLinkedObjectPaths(sourceProvider, resIds, destinationProvider);
        for (String resId : resIds) {
            String destResId = resultMap.get(resId);
            Resource result = destinationProvider.resource(destinationProvider.location(destResId));
            results.add((Object)result);
        }
        return results;
    }
}

