/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.interop;

import com.ibm.rational.wvcm.factory.PluginProviderFactory;
import com.ibm.rational.wvcm.interop.InteropCore;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.wvcm.ProviderFactory;
import javax.wvcm.Stream;
import javax.wvcm.Workspace;
import javax.wvcm.WorkspaceProvider;
import javax.wvcm.WvcmException;

public class InteropStreamSegment {
    private static final String EMPTY_STRING = "";
    private static final String STRING_NULL = "null";
    private static final String JZPROVIDER_SHORTNAME = "JzProvider";
    private static final String JZPROVIDER_NAME = "com.ibm.team.connector.scm.client.JzProvider";
    private static final String CTPROVIDER_SHORTNAME = "CTProvider";
    private static final String CTPROVIDER_NAME = "com.ibm.rational.wvcm.ct.CTProvider";
    private String _wvcmProviderName;
    private Map<String, String> _initArgs;
    private InteropCore.InteropStreamState _state;
    private SyncRoots _syncRootPaths;
    private String _syncStreamPath;
    private String _syncWsPath;
    private String _internalStreamPath;
    private String _internalWsPath;
    private String _cloneStreamPath;
    private String _cloneWsPath;
    private String[] _sentoverBaselinePaths;
    private WorkspaceProvider _provider;
    private Map<String, String> _cachedInitArgs;
    private ProviderFactory.Callback _callback;
    private static final Pattern BRTYPE = Pattern.compile("\\|\\|BRTYPE\\|[^|]*");

    public InteropStreamSegment(String wvcmProviderName, Map<String, String> initArgs, ProviderFactory.Callback callback) {
        this._wvcmProviderName = wvcmProviderName;
        this._initArgs = initArgs != null ? initArgs : new Hashtable();
        this._state = InteropCore.InteropStreamState.OK;
        this._syncRootPaths = new SyncRoots(new String[0]);
        this._sentoverBaselinePaths = new String[0];
        this._provider = null;
        this._cachedInitArgs = null;
        this._callback = callback;
    }

    public InteropStreamSegment(String interopStreamValue, int minor_version, ProviderFactory.Callback callback) {
        String[] fields = interopStreamValue.split("\n\n\\.");
        int i = 0;
        this._wvcmProviderName = fields[i].equals(STRING_NULL) ? null : fields[i];
        ++i;
        if (this._wvcmProviderName.contains(CTPROVIDER_SHORTNAME)) {
            this._wvcmProviderName = CTPROVIDER_NAME;
        } else if (this._wvcmProviderName.contains(JZPROVIDER_SHORTNAME)) {
            this._wvcmProviderName = JZPROVIDER_NAME;
        }
        String[] initArgs = fields[i].split("\n\\.");
        ++i;
        this._initArgs = new HashMap<String, String>(initArgs.length);
        int j = 0;
        while (j < initArgs.length) {
            String val = EMPTY_STRING;
            if (j + 1 < initArgs.length) {
                val = initArgs[j + 1];
            }
            this._initArgs.put(initArgs[j], val);
            j += 2;
        }
        this._state = InteropCore.InteropStreamState.valueOf(fields[i]);
        this._internalStreamPath = fields[++i].equals(STRING_NULL) ? null : fields[i];
        this._syncStreamPath = fields[++i].equals(STRING_NULL) ? null : fields[i];
        this._cloneStreamPath = fields[++i].equals(STRING_NULL) ? null : fields[i];
        this._internalWsPath = fields[++i].equals(STRING_NULL) ? null : fields[i];
        this._syncWsPath = fields[++i].equals(STRING_NULL) ? null : fields[i];
        this._cloneWsPath = fields[++i].equals(STRING_NULL) ? null : fields[i];
        this._syncRootPaths = new SyncRoots(fields[++i].split("\n\\."));
        this._sentoverBaselinePaths = fields[++i].split("\n\\.");
        ++i;
        if (minor_version < 9) {
            i = 0;
            while (i < this._sentoverBaselinePaths.length) {
                if (this._sentoverBaselinePaths[i].startsWith("BASE_CC_BASELINE") && this._sentoverBaselinePaths[i].contains("||LBTYPE|lbtype:")) {
                    Matcher brtype = BRTYPE.matcher(this._sentoverBaselinePaths[i]);
                    this._sentoverBaselinePaths[i] = brtype.replaceFirst(EMPTY_STRING);
                }
                ++i;
            }
        }
        this._callback = callback;
    }

    public String toString() {
        String[] stringArray;
        StringBuffer s = new StringBuffer();
        s.append(this._wvcmProviderName);
        s.append("\n\n.");
        if (this._initArgs.size() > 0) {
            for (String key : this._initArgs.keySet()) {
                s.append(key);
                s.append("\n.");
                String value = this._initArgs.get(key);
                s.append(value.replace("\n", " "));
                s.append("\n.");
            }
        } else {
            s.append("\n.");
        }
        s.append("\n\n." + (Object)((Object)this._state) + "\n\n." + this._internalStreamPath + "\n\n." + this._syncStreamPath + "\n\n." + this._cloneStreamPath + "\n\n." + this._internalWsPath + "\n\n." + this._syncWsPath + "\n\n." + this._cloneWsPath + "\n\n.");
        if (this._syncRootPaths.paths.length > 0) {
            stringArray = this._syncRootPaths.paths;
            int n = this._syncRootPaths.paths.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                s.append(path);
                s.append("\n.");
                ++n2;
            }
        } else {
            s.append("\n.");
        }
        s.append("\n\n.");
        if (this._sentoverBaselinePaths.length > 0) {
            stringArray = this._sentoverBaselinePaths;
            int n = this._sentoverBaselinePaths.length;
            int n3 = 0;
            while (n3 < n) {
                String baselinePath = stringArray[n3];
                s.append(baselinePath);
                s.append("\n.");
                ++n3;
            }
        } else {
            s.append("\n.");
        }
        return s.toString();
    }

    public String get_wvcmProviderName() {
        return this._wvcmProviderName;
    }

    public Map<String, String> get_initArgs() {
        return this._initArgs;
    }

    public void put_initArgs(String key, String val) throws WvcmException {
        this._initArgs.put(key, val);
        this.provider();
    }

    public void putAll_initArgs(Map<String, String> initArgs) throws WvcmException {
        this._initArgs.putAll(initArgs);
        this.provider();
    }

    public InteropCore.InteropStreamState get_state() {
        return this._state;
    }

    public void set_state(InteropCore.InteropStreamState state) {
        this._state = state;
    }

    public String get_syncStreamPath() {
        return this._syncStreamPath;
    }

    public void set_syncStreamPath(String streamPath) {
        this._syncStreamPath = streamPath;
    }

    public String get_syncWsPath() {
        return this._syncWsPath;
    }

    public void set_syncWsPath(String wsPath) {
        this._syncWsPath = wsPath;
    }

    public String get_internalStreamPath() {
        return this._internalStreamPath;
    }

    public void set_internalStreamPath(String streamPath) {
        this._internalStreamPath = streamPath;
    }

    public String get_internalWsPath() {
        return this._internalWsPath;
    }

    public void set_internalWsPath(String wsPath) {
        this._internalWsPath = wsPath;
    }

    public String get_cloneStreamPath() {
        return this._cloneStreamPath;
    }

    public void set_cloneStreamPath(String streamPath) {
        this._cloneStreamPath = streamPath;
    }

    public String get_cloneWsPath() {
        return this._cloneWsPath;
    }

    public void set_cloneWsPath(String wsPath) {
        this._cloneWsPath = wsPath;
    }

    public String[] get_syncRootPaths() {
        return this._syncRootPaths.paths;
    }

    public void set_syncRootPaths(String[] rootPaths) {
        if (rootPaths == null) {
            throw new RuntimeException("Root paths must not be null");
        }
        this._syncRootPaths = new SyncRoots(rootPaths);
    }

    public SyncRoots get_syncRoots() {
        return this._syncRootPaths;
    }

    public void set_syncRoots(SyncRoots syncRoots) {
        if (syncRoots == null) {
            throw new RuntimeException("Sync roots must not be null");
        }
        this._syncRootPaths = syncRoots;
    }

    public int numSyncRoots() {
        return this._syncRootPaths.paths.length;
    }

    public String[] get_sentoverBaselinePaths() {
        return this._sentoverBaselinePaths;
    }

    public void set_sentoverBaselinePaths(String[] baselineNames) {
        this._sentoverBaselinePaths = baselineNames;
    }

    public void clearProviderCache() {
        if (this._provider != null) {
            this._provider.clearCache(null);
        }
        this._provider = null;
    }

    public WorkspaceProvider provider() throws WvcmException {
        if (this._provider == null || !this._cachedInitArgs.equals(this.get_initArgs())) {
            this._provider = (WorkspaceProvider)PluginProviderFactory.pluginCreateProvider((String)this.get_wvcmProviderName(), (ProviderFactory.Callback)this._callback, this.get_initArgs());
            this._cachedInitArgs = new HashMap<String, String>(0);
            this._cachedInitArgs.putAll(this.get_initArgs());
        }
        return this._provider;
    }

    public Stream cloneStream() throws WvcmException {
        String streamPath = this.get_cloneStreamPath();
        if (streamPath == null) {
            return null;
        }
        WorkspaceProvider p = this.provider();
        return p.stream(p.location(streamPath));
    }

    public Workspace cloneWs() throws WvcmException {
        String wsPath = this.get_cloneWsPath();
        if (wsPath == null) {
            return null;
        }
        WorkspaceProvider p = this.provider();
        return p.workspace(p.location(wsPath));
    }

    public Stream syncStream() throws WvcmException {
        String streamPath = this.get_syncStreamPath();
        if (streamPath == null) {
            return null;
        }
        WorkspaceProvider p = this.provider();
        return p.stream(p.location(streamPath));
    }

    public Workspace syncWs() throws WvcmException {
        String wsPath = this.get_syncWsPath();
        if (wsPath == null) {
            return null;
        }
        WorkspaceProvider p = this.provider();
        return p.workspace(p.location(wsPath));
    }

    public Stream internalStream() throws WvcmException {
        String streamPath = this.get_internalStreamPath();
        if (streamPath == null) {
            return null;
        }
        WorkspaceProvider p = this.provider();
        return p.stream(p.location(streamPath));
    }

    public Workspace internalWs() throws WvcmException {
        String wsPath = this.get_internalWsPath();
        if (wsPath == null) {
            return null;
        }
        WorkspaceProvider p = this.provider();
        return p.workspace(p.location(wsPath));
    }

    public static class SyncRoots {
        public String[] paths;

        public SyncRoots(String[] _paths) {
            this.paths = _paths;
        }
    }
}

