/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.interop;

import com.ibm.rational.wvcm.interop.InteropStreamSegment;
import com.ibm.rational.wvcm.interop.InteropUtilities;
import com.ibm.rational.wvcm.interop.Messages;
import com.ibm.rational.wvcm.interop.SendoverData;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wvcm.Activity;
import javax.wvcm.Baseline;
import javax.wvcm.Component;
import javax.wvcm.Configuration;
import javax.wvcm.ControllableFolder;
import javax.wvcm.ControllableResource;
import javax.wvcm.ControllableSymbolicLink;
import javax.wvcm.Feedback;
import javax.wvcm.Folder;
import javax.wvcm.FolderVersion;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.PropertyRequestItem;
import javax.wvcm.Provider;
import javax.wvcm.Resource;
import javax.wvcm.ResourceList;
import javax.wvcm.Stream;
import javax.wvcm.SymbolicLinkVersion;
import javax.wvcm.Task;
import javax.wvcm.Version;
import javax.wvcm.VersionHistory;
import javax.wvcm.VersionSet;
import javax.wvcm.Workspace;
import javax.wvcm.WorkspaceProvider;
import javax.wvcm.WvcmException;

public class InteropCore {
    public static final String CLONE_NAME = "CLONE";
    public static final String INTERNAL_NAME = "INTERNAL";
    public static final String CLONE_WORKSPACE_NAME = "CLONE_{0}";
    public static final String INTERNAL_WORKSPACE_NAME = "INTERNAL_{0}";
    public static final String SCM_CONNECTOR_NAMESPACE = "com.ibm.team.connector.scm";
    public static final String RATIONAL_WVCM_NAMESPACE = "com.ibm.rational.wvcm";
    public static final String IMPORTER_NAMESPACE = "com.ibm.team.importer";
    public static final String IA_PREFIX = "com.ibm.team.connector.scm.";
    public static final String IA_LINE_SEPARATOR = "com.ibm.team.connector.scm.LINE_DELIMITER";
    public static final String IA_WORKSPACE_LINE_SEPARATOR = "com.ibm.team.connector.scm.LINE_DELIMITER_WORKSPACE";
    public static final String IA_CHARACTER_SET = "com.ibm.team.connector.scm.CHARACTER_SET";
    public static final String IA_MAX_NUM_BATCH_ENTRIES = "com.ibm.team.connector.scm.MAX_NUM_BATCH_ENTRIES";
    public static final String IA_WORKSPACE_PATH = "com.ibm.rational.wvcm.WORKSPACE_LOCATION";
    public static final String IA_MERGE_WORKSPACE = "com.ibm.team.interop.MERGE_WORKSPACE";
    public static final String IA_THAT_WORKSPACE_NAME = "com.ibm.team.interop.OTHER_WORKSPACE_NAME";
    public static final String IA_THAT_STREAM_LOCATION = "com.ibm.team.interop.OTHER_STREAM_LOCATION";
    public static final String IA_RESTARTABLE_IMPORTS = "com.ibm.team.interop.RESTARTABLE_IMPORTS";
    public static final String IA_IMPORT_ONLY = "com.ibm.team.interop.IMPORT_ONLY";
    public static final String IA_RES_PER_CLONE_LINK_UPDATE = "com.ibm.team.interop.RESOURCES_PER_CLONE_LINK_UPDATE";
    public static final String IA_MAXIMUM_MEMBER_COUNT = "com.ibm.team.interop.MAXIMUM_MEMBER_COUNT";
    public static final String IA_DESYNC = "com.ibm.team.interop.DESYNC";
    public static final String DESYNC_COMPONENT = "component";
    public static final String IA_BASELINE_FILTER = "com.ibm.team.importer.BASELINE_ATTRIBUTE";
    public static final PropertyNameList.PropertyName<String> PN_CLONE = new PropertyNameList.PropertyName("com.ibm.team.interop", "CLONE");
    public static final PropertyNameList.PropertyName<String> PN_INTEROP_STREAM = new PropertyNameList.PropertyName("com.ibm.team.interop", "INTEROP_STREAM");
    public static final PropertyNameList.PropertyName<String> PN_INTEROP_STREAM_LOCKED = new PropertyNameList.PropertyName("com.ibm.team.interop", "INTEROP_STREAM_LOCKED");
    public static final PropertyNameList.PropertyName<String> PN_RESERVE_FOR_INTEROP = new PropertyNameList.PropertyName("com.ibm.team.interop", "RESERVE_FOR_INTEROP");
    public static final PropertyNameList.PropertyName<String> PN_RESERVED_FOR_INTEROP = new PropertyNameList.PropertyName("com.ibm.team.interop", "RESERVED_FOR_INTEROP");
    public static final PropertyNameList.PropertyName<String> PN_TASK_IDS = new PropertyNameList.PropertyName("com.ibm.team.interop", "TASK_IDS");
    public static final PropertyNameList.PropertyName<Integer> PN_MAXIMUM_MEMBER_COUNT = new PropertyNameList.PropertyName("com.ibm.team.interop", "MAXIMUM_MEMBER_COUNT");
    private static HashMap<Msg, String[]> msgs = new HashMap();
    public static final PropertyRequestItem.PropertyRequest PR_PATH;
    public static final PropertyRequestItem.PropertyRequest PR_PATH_CONFIG_COMP_DN;
    public static final PropertyRequestItem.PropertyRequest PR_CONTENT;
    public static final PropertyRequestItem.PropertyRequest PR_NEW_CONTENT_CHARACTERISTICS;
    public static final PropertyRequestItem.PropertyRequest PR_VH_CLONE;
    public static final PropertyRequestItem.PropertyRequest PR_VERSION_CHILDMAP;
    public static final PropertyRequestItem.PropertyRequest PR_CI_VH_VERSION_CHILDMAP;
    public static final PropertyRequestItem.PropertyRequest PR_CA_COMMENT_TASKS;
    public static final PropertyRequestItem.PropertyRequest PR_VH;
    public static final PropertyRequestItem.PropertyRequest PR_CHANGED_VERSIONS_ACT;
    public static final PropertyRequestItem.PropertyRequest PR_CHILDMAP;
    public static final PropertyRequestItem.PropertyRequest PR_CHILDMAP_VH;
    public static final PropertyRequestItem.PropertyRequest PR_CR_CHILD_CLONE;
    public static final PropertyRequestItem.PropertyRequest PR_PATH_CR_CHILD_CLONE;
    public static final PropertyRequestItem.PropertyRequest PR_PATH_VH_CR_CHILD_CLONE;
    public static final PropertyRequestItem.PropertyRequest PR_CI_LINK_TARGET;
    public static final PropertyRequestItem.PropertyRequest PR_CFG_PATH_WS_VH_CLONE;
    public static final PropertyRequestItem.PropertyRequest PR_CFG_RF;
    public static final PropertyRequestItem.PropertyRequest PR_CFG_RF_PATH_WS_VH_CLONE;
    public static final PropertyRequestItem.PropertyRequest PR_RF_VH;
    public static final PropertyRequestItem.PropertyRequest PR_ROOT_DN;
    public static final PropertyRequestItem.PropertyRequest PR_CLONE;
    public static final PropertyRequestItem.PropertyRequest PR_CI;
    public static final PropertyRequestItem.PropertyRequest PR_CI_VH_CLONE;
    public static final PropertyRequestItem.PropertyRequest PR_STREAM;
    public static final PropertyRequestItem.PropertyRequest PR_WORKSPACE;
    public static final PropertyRequestItem.PropertyRequest PR_CA_TASKS_COMMENT;
    public static final PropertyRequestItem.PropertyRequest PR_SYMLINK_TARGET_INFO;
    public static final PropertyRequestItem.PropertyRequest PR_VH_NAME;
    public static final PropertyRequestItem.PropertyRequest PR_CI_NEW_CONTENT;
    public static final PropertyRequestItem.PropertyRequest PR_CONFIG_VH;
    public static final PropertyRequestItem.PropertyRequest PR_NAME_VH;
    public static final PropertyRequestItem.PropertyRequest PR_BL;
    public static final PropertyRequestItem.PropertyRequest PR_BL_SUBS;
    public static final PropertyRequestItem.PropertyRequest PR_PATH_VH_CLONE;
    public static final PropertyRequestItem.PropertyRequest PR_CONFIG_VH_CLONE;
    public static final PropertyRequestItem.PropertyRequest PR_IS;
    private static Map<String, SyncStats> _syncStatsMap;
    private static final String IA_VERSION_KNOWS_PARENT = "com.ibm.rational.wvcm.VERSION_KNOWS_PARENT";
    private static final String IA_HAS_CLONE_INFO = "com.ibm.rational.wvcm.HAS_CLONE_INFO";
    public static PropertyRequestItem.PropertyRequest PR_BCF_CONFIG_VH;

    static {
        msgs.put(Msg.ERROR_SOURCE_CONTENT_DELETED, new String[]{Messages.InteropStream_ERROR_SOURCE_CONTENT_DELETED, Messages.InteropStream_ERROR_SOURCE_CONTENT_DELETED$explanation, Messages.InteropStream_ERROR_SOURCE_CONTENT_DELETED$useraction});
        msgs.put(Msg.ERROR_STREAM_RESERVED, new String[]{Messages.InteropStream_ERROR_STREAM_RESERVED, Messages.InteropStream_ERROR_STREAM_RESERVED$explanation, Messages.InteropStream_ERROR_STREAM_RESERVED$useraction});
        msgs.put(Msg.ERROR_STALE_DATA, new String[]{Messages.InteropStream_ERROR_STALE_DATA, Messages.InteropStream_ERROR_STALE_DATA$explanation, Messages.InteropStream_ERROR_STALE_DATA$useraction});
        msgs.put(Msg.ERROR_COULD_NOT_TRANSFER_ROOT, new String[]{Messages.InteropStream_ERROR_COULD_NOT_TRANSFER_ROOT, Messages.InteropStream_ERROR_COULD_NOT_TRANSFER_ROOT$explanation, Messages.InteropStream_ERROR_COULD_NOT_TRANSFER_ROOT$useraction});
        msgs.put(Msg.WARN_CLONE_NOT_FOUND, new String[]{Messages.InteropStream_WARN_CLONE_NOT_FOUND, Messages.InteropStream_WARN_CLONE_NOT_FOUND$explanation, Messages.InteropStream_WARN_CLONE_NOT_FOUND$useraction});
        msgs.put(Msg.ERROR_OLD_CLIENT, new String[]{Messages.InteropStream_ERROR_OLD_CLIENT, Messages.InteropStream_ERROR_OLD_CLIENT$explanation, Messages.InteropStream_ERROR_OLD_CLIENT$useraction});
        msgs.put(Msg.ERROR_ROOTS_HAVE_NO_BASELINES, new String[]{Messages.InteropStream_ERR_REMOVED_ROOTS_WITH_COUNT_AND_PATHNAMES, Messages.InteropStream_ERR_REMOVED_ROOTS_WITH_COUNT_AND_PATHNAMES$explanation, Messages.InteropStream_ERR_REMOVED_ROOTS_WITH_COUNT_AND_PATHNAMES$useraction});
        msgs.put(Msg.ERROR_AMBI_BL_NAMES, new String[]{Messages.InteropCore_ERR_MUST_RENAME_OTHER_AMBIG_BLS, Messages.InteropCore_ERR_MUST_RENAME_OTHER_AMBIG_BLS$explanation, Messages.InteropCore_ERR_MUST_RENAME_OTHER_AMBIG_BLS$useraction});
        PR_PATH = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Resource.PATHNAME_LOCATION});
        PR_PATH_CONFIG_COMP_DN = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Resource.PATHNAME_LOCATION, ControllableResource.CONFIGURATION.nest(new PropertyRequestItem[]{Configuration.VERSION_HISTORY.nest(new PropertyRequestItem[]{InteropUtilities.PR_DN})})});
        PR_CONTENT = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Version.CONTENT_TYPE, Version.CONTENT_CHARACTER_SET, Version.IS_EXECUTABLE, InteropUtilities.PN_LINE_SEPARATOR});
        PR_NEW_CONTENT_CHARACTERISTICS = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{PR_CONTENT, Version.COMMENT});
        PR_VH_CLONE = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{ControllableResource.VERSION_HISTORY.nest(new PropertyRequestItem[]{Resource.RESOURCE_IDENTIFIER, PN_CLONE})});
        PR_VERSION_CHILDMAP = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{PR_VH_CLONE, Version.COMMENT, FolderVersion.CHILD_MAP.nest(new PropertyRequestItem[]{PN_CLONE})});
        PR_CI_VH_VERSION_CHILDMAP = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{ControllableResource.CHECKED_IN.nest(new PropertyRequestItem[]{PR_VERSION_CHILDMAP, PR_NEW_CONTENT_CHARACTERISTICS})});
        PR_CA_COMMENT_TASKS = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Workspace.CURRENT_ACTIVITY_LIST.nest(new PropertyRequestItem[]{Activity.COMMENT, Activity.TASK_LIST.nest(new PropertyRequestItem[]{Task.DISPLAY_NAME, Task.COMMENT})})});
        PR_VH = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Version.VERSION_HISTORY.nest(new PropertyRequestItem[]{Resource.RESOURCE_IDENTIFIER})});
        PR_CHANGED_VERSIONS_ACT = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Resource.COMMENT, PR_VH_CLONE, Activity.TASK_LIST.nest(new PropertyRequestItem[]{PN_CLONE, Resource.DISPLAY_NAME, Resource.COMMENT, InteropUtilities.PN_TASK_ID})});
        PR_CHILDMAP = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Folder.CHILD_MAP});
        PR_CHILDMAP_VH = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{ControllableFolder.CHILD_MAP, ControllableFolder.VERSION_HISTORY});
        PR_CR_CHILD_CLONE = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Folder.CHILD_MAP.nest(new PropertyRequestItem[]{ControllableResource.CHECKED_IN, PR_VH_CLONE})});
        PR_PATH_CR_CHILD_CLONE = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Folder.PATHNAME_LOCATION, PR_CR_CHILD_CLONE});
        PR_PATH_VH_CR_CHILD_CLONE = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{ControllableFolder.PATHNAME_LOCATION, ControllableFolder.VERSION_HISTORY, PR_CR_CHILD_CLONE});
        PR_CI_LINK_TARGET = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{ControllableResource.CHECKED_IN.nest(new PropertyRequestItem[]{SymbolicLinkVersion.LINK_TARGET})});
        PR_CFG_PATH_WS_VH_CLONE = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{PR_VH_CLONE, ControllableResource.PATHNAME_LOCATION, ControllableResource.WORKSPACE, ControllableResource.CONFIGURATION.nest(new PropertyRequestItem[]{Configuration.VERSION_HISTORY})});
        PR_CFG_RF = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{PR_VH_CLONE, ControllableResource.PATHNAME_LOCATION, ControllableFolder.CONFIGURATION.nest(new PropertyRequestItem[]{Configuration.CHECKED_IN.nest(new PropertyRequestItem[]{Resource.DISPLAY_NAME}), Configuration.ROOT_FOLDER.nest(new PropertyRequestItem[]{ControllableFolder.PATHNAME_LOCATION}), Configuration.VERSION_HISTORY.nest(new PropertyRequestItem[]{Component.DISPLAY_NAME, PN_CLONE})})});
        PR_CFG_RF_PATH_WS_VH_CLONE = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{PR_VH_CLONE, ControllableResource.PATHNAME_LOCATION, ControllableResource.WORKSPACE, PR_CFG_RF});
        PR_RF_VH = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Configuration.ROOT_FOLDER.nest(new PropertyRequestItem[]{PR_VH_CLONE})});
        PR_ROOT_DN = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Component.ROOT_VERSION.nest(new PropertyRequestItem[]{Version.DISPLAY_NAME}), Component.DISPLAY_NAME});
        PR_CLONE = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{PN_CLONE});
        PR_CI = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{ControllableResource.CHECKED_IN});
        PR_CI_VH_CLONE = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{ControllableResource.CHECKED_IN.nest(new PropertyRequestItem[]{PR_VH_CLONE})});
        PR_STREAM = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Workspace.STREAM});
        PR_WORKSPACE = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Stream.WORKSPACE});
        PR_CA_TASKS_COMMENT = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Workspace.CURRENT_ACTIVITY_LIST.nest(new PropertyRequestItem[]{Activity.TASK_LIST.nest(new PropertyRequestItem[]{Task.COMMENT})})});
        PR_SYMLINK_TARGET_INFO = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{InteropUtilities.PN_SYMLINK_TARGET_IS_DIR, SymbolicLinkVersion.LINK_TARGET});
        PR_VH_NAME = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Configuration.VERSION_HISTORY.nest(new PropertyRequestItem[]{Component.DISPLAY_NAME})});
        PR_CI_NEW_CONTENT = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{ControllableResource.CHECKED_IN.nest(new PropertyRequestItem[]{PR_NEW_CONTENT_CHARACTERISTICS})});
        PR_CONFIG_VH = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{ControllableResource.CONFIGURATION.nest(new PropertyRequestItem[]{PR_VH})});
        PR_NAME_VH = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Baseline.DISPLAY_NAME, Configuration.VERSION_HISTORY});
        PR_BL = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Baseline.SUCCESSOR_LIST, Baseline.DISPLAY_NAME});
        PR_BL_SUBS = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{PR_BL, Baseline.SUB_BASELINE_LIST.nest(new PropertyRequestItem[]{Baseline.VERSION_HISTORY.nest(new PropertyRequestItem[]{InteropUtilities.PR_DN}), InteropUtilities.PR_DN})});
        PR_PATH_VH_CLONE = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{ControllableResource.PATHNAME_LOCATION, PR_VH_CLONE});
        PR_CONFIG_VH_CLONE = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{ControllableResource.CONFIGURATION.nest(new PropertyRequestItem[]{PR_VH_CLONE})});
        PR_IS = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{PN_INTEROP_STREAM});
        _syncStatsMap = new HashMap<String, SyncStats>(2);
        PR_BCF_CONFIG_VH = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Workspace.BASELINE_CONTROLLED_FOLDER_LIST.nest(new PropertyRequestItem[]{ControllableResource.CONFIGURATION.nest(new PropertyRequestItem[]{ControllableResource.VERSION_HISTORY.nest(new PropertyRequestItem[]{Resource.DISPLAY_NAME}), Configuration.ROOT_FOLDER.nest(new PropertyRequestItem[]{ControllableResource.VERSION_HISTORY.nest(new PropertyRequestItem[]{Resource.RESOURCE_IDENTIFIER})})})})});
    }

    public static String msg(Feedback nowork, Msg msgName, Object ... arguments) {
        return nowork.format(Messages.InteropStream_msgPlusExplanationPlusUseraction, new Object[]{nowork.format(msgs.get((Object)msgName)[0], arguments), msgs.get((Object)msgName)[1], msgs.get((Object)msgName)[2]});
    }

    public static void clearInteropStats() {
        _syncStatsMap.clear();
    }

    public static void incrementSyncStat(SyncStatType statType, Resource resource, int amount) throws WvcmException {
        InteropCore.incrementSyncStat(statType, resource.provider(), amount);
    }

    public static void incrementSyncStat(SyncStatType statType, Provider provider, int amount) {
        String key = provider.rootLocation().string();
        SyncStats syncStats = _syncStatsMap.get(key);
        if (syncStats == null) {
            syncStats = new SyncStats();
            _syncStatsMap.put(key, syncStats);
        }
        syncStats.incrementSyncStat(statType, amount);
    }

    public static SyncStats getSyncStats(Provider provider) {
        String key = provider.rootLocation().string();
        SyncStats result = _syncStatsMap.get(key);
        if (result == null) {
            result = new SyncStats();
        }
        return result;
    }

    public static int getInt(Provider p, String key, Feedback nowork) throws WvcmException {
        String value = (String)p.initArgs().get(key);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static boolean versionKnowsParent(Map<String, String> initArgs) {
        return initArgs.containsKey(IA_VERSION_KNOWS_PARENT);
    }

    public static boolean isFakeClonePath(String cloneVHPath) {
        return cloneVHPath != null && cloneVHPath.startsWith("NO_CLONE");
    }

    public static void setHasCloneInfo(Map<String, String> initArgs, boolean hasCloneInfo) {
        if (hasCloneInfo) {
            initArgs.put(IA_HAS_CLONE_INFO, InteropUtilities.TRUE_STRING);
        } else {
            initArgs.remove(IA_HAS_CLONE_INFO);
        }
    }

    public static boolean hasCloneInfo(Map<String, String> initArgs) {
        return initArgs.containsKey(IA_HAS_CLONE_INFO);
    }

    public static <T extends Resource> T lookupClone(T oneResource, WorkspaceProvider otherP) throws WvcmException {
        String path = InteropCore.lookupClonePath(oneResource, otherP);
        return InteropCore.buildProxy(oneResource, (Provider)otherP, path);
    }

    public static <T extends Resource> T buildProxy(T resource, Provider provider, String location) throws WvcmException {
        if (location == null) {
            return null;
        }
        Class<?> type = resource.getClass();
        return (T)provider.buildProxy(type, provider.location(location));
    }

    public static <T extends Resource> T lookupClone(SendoverData sd, T oneResource, WorkspaceProvider otherP) throws WvcmException {
        T otherResource = InteropCore.lookupClone(oneResource, otherP);
        if (otherResource == null) {
            List<Resource> clones = sd.getClonesToUpdate();
            if (InteropCore.hasCloneInfo(oneResource.provider().initArgs())) {
                int index = clones.indexOf(oneResource);
                if (index >= 0) {
                    return InteropCore.buildProxy(oneResource, (Provider)otherP, (String)clones.get(index).getProperty(PN_CLONE));
                }
            } else {
                if (!InteropCore.hasCloneInfo(otherP.initArgs())) {
                    throw new WvcmException("Neither provider is storing clone information", oneResource, WvcmException.ReasonCode.FORBIDDEN);
                }
                for (Resource otherClone : clones) {
                    Resource oneClone = InteropCore.buildProxy(otherClone, oneResource.provider(), (String)otherClone.getProperty(PN_CLONE));
                    if (!oneResource.equals(oneClone)) continue;
                    return (T)otherClone;
                }
            }
        }
        return otherResource;
    }

    public static <T extends Resource> String lookupClonePath(T oneResource, WorkspaceProvider otherProvider) throws WvcmException {
        if (InteropCore.hasCloneInfo(oneResource.provider().initArgs())) {
            return InteropUtilities.getProperty(oneResource, PN_CLONE);
        }
        if (!InteropCore.hasCloneInfo(otherProvider.initArgs())) {
            throw new WvcmException("Neither provider is storing clone information", oneResource, WvcmException.ReasonCode.FORBIDDEN);
        }
        Class<?> type = oneResource.getClass();
        Resource otherResourceQuery = otherProvider.buildProxy(type, otherProvider.rootLocation());
        otherResourceQuery.setProperty(PN_CLONE, (Object)oneResource.getResourceIdentifier());
        Resource otherResource = otherResourceQuery.doFind(null);
        if (otherResource == null) {
            return null;
        }
        return otherResource.getResourceIdentifier();
    }

    public static ControllableResource createFile(SendoverData sd, ControllableResource tgtCR, boolean doVersionControl, Version srcVersion, boolean isTree, Feedback nowork) throws WvcmException {
        String bn = tgtCR.location().lastSegment();
        InteropCore.copyVersionToCR(tgtCR, srcVersion, true, isTree, nowork);
        if (doVersionControl) {
            tgtCR = tgtCR.doVersionControl(nowork);
        }
        nowork.notifyCompleted(nowork.format(Messages.InteropStream_MSG_CREATED_FILE, new Object[]{bn}));
        sd.reportProgress();
        InteropCore.incrementSyncStat(SyncStatType.FILES_CREATED, (Resource)tgtCR, 1);
        return tgtCR;
    }

    public static Workspace createInteropWorkspace(String name, boolean isIsolated, Stream stream, Feedback feedback) throws WvcmException {
        WorkspaceProvider p = stream.workspaceProvider();
        Workspace ws = p.workspace(p.rootLocation().child(name));
        if (isIsolated) {
            ws.setIsolatedTarget(stream);
        } else {
            ws.setTarget(stream);
        }
        ws.setProperty(PN_RESERVE_FOR_INTEROP, (Object)InteropUtilities.TRUE_STRING);
        ws = ws.doCreateGeneratedResource(feedback);
        return ws;
    }

    public static void closeCurrentActivity(Workspace ws, String taskName, Feedback f) throws WvcmException {
        ws = (Workspace)ws.doReadProperties(f.nest(PR_CA_COMMENT_TASKS, 25));
        ResourceList activityList = ws.getCurrentActivityList();
        Task task = null;
        for (Activity activity : activityList) {
            if (activity.getComment() == null) {
                activity.setComment(Messages.InteropStream_SYNCHRONIZE);
            }
            if (activity.getTaskList().size() == 0) {
                if (task == null) {
                    task = InteropUtilities.tryCreateTask(taskName, ws, f.nest(50));
                }
                if (task != null) {
                    activity.setTaskList(InteropUtilities.makeList(task));
                }
            } else {
                Task tgtTask = (Task)activity.getTaskList().get(0);
                String tgtTaskName = tgtTask.getDisplayName();
                if (tgtTaskName == null || !tgtTaskName.contains(taskName)) {
                    String comment = tgtTask.getComment();
                    if (comment == null || comment.length() == 0) {
                        comment = taskName;
                    } else if (!comment.contains(taskName)) {
                        comment = f.format("{0}\n{1}", new Object[]{comment, taskName});
                    }
                    tgtTask.setComment(comment);
                    tgtTask.doWriteProperties(f.nest(50));
                }
            }
            activity.setIsComplete(true);
            activity.setOriginWorkspace(ws);
            activity.doWriteProperties(f.nest(75));
        }
        activityList.clear();
        ws.setCurrentActivityList(activityList);
        ws.doWriteProperties(f.nest(100));
    }

    public static Set<String> getSyncRootPaths(Workspace ws, InteropStreamSegment.SyncRoots syncRoots, Feedback f) throws WvcmException {
        WorkspaceProvider p = ws.workspaceProvider();
        HashSet<String> tgtRootPaths = new HashSet<String>();
        int n = syncRoots.paths.length;
        int i = 0;
        while (i < n) {
            VersionHistory vh = p.versionHistory(p.location(syncRoots.paths[i]));
            ControllableResource tgtRoot = InteropUtilities.doFindCRInWorkspace(ws, vh, f.nest(PR_PATH, 100 * (i + 1) / n));
            if (tgtRoot != null) {
                tgtRootPaths.add(tgtRoot.getPathnameLocation().string());
            }
            ++i;
        }
        return tgtRootPaths;
    }

    private static Map<VersionHistory, Version> computeSrvVh2srcVersionMap(ResourceList<Version> srcVersions) throws WvcmException {
        HashMap<VersionHistory, Version> srcVh2srcVersion = new HashMap<VersionHistory, Version>(srcVersions.size());
        for (Version srcVersion : srcVersions) {
            srcVh2srcVersion.put(srcVersion.getVersionHistory(), srcVersion);
        }
        return srcVh2srcVersion;
    }

    public static void sendoverTasks(Workspace tgtWs, String taskName, String checkinComments, ResourceList<Task> srcTasks, Feedback f) throws WvcmException {
        if (checkinComments.length() == 0 && srcTasks.size() == 0) {
            return;
        }
        WorkspaceProvider tgtP = tgtWs.workspaceProvider();
        ResourceList tgtActList = (tgtWs = (Workspace)tgtWs.doReadProperties(f.nest(PR_CA_TASKS_COMMENT, 25))).getCurrentActivityList();
        if (tgtActList == null) {
            return;
        }
        String tgtSummaryComment = "";
        ResourceList srcCloneTasks = tgtP.resourceList((Resource[])new Task[0]);
        for (Task srcTask : srcTasks) {
            String srcTaskName = srcTask.getDisplayName();
            String srcTaskId = InteropUtilities.getProperty((Resource)srcTask, InteropUtilities.PN_TASK_ID);
            if (srcTaskId != null) {
                srcTaskName = f.format("{0}: {1}", new Object[]{srcTaskId, srcTaskName});
            }
            tgtSummaryComment = f.format(Messages.InteropStream_MSG_SYNCHRONIZED_TASK_NAME, new Object[]{tgtSummaryComment, srcTaskName});
            Task tgtTask = InteropCore.lookupClone(srcTask, tgtP);
            if (tgtTask == null || srcCloneTasks.contains((Object)tgtTask)) continue;
            srcCloneTasks.add((Object)tgtTask);
        }
        if (checkinComments.length() > 0) {
            tgtSummaryComment = f.format("{0}\n{1}", new Object[]{tgtSummaryComment, checkinComments});
        }
        Task tgtSummaryTask = null;
        for (Activity tgtAct : tgtActList) {
            ResourceList tgtTasks = tgtAct.getTaskList();
            boolean isTaskAdded = false;
            if (tgtSummaryComment != null) {
                if (tgtTasks.size() > 0) {
                    Task task = (Task)tgtTasks.get(0);
                    String comment = task.getComment();
                    if (comment == null) {
                        comment = "";
                    }
                    comment = f.format("{0}\n{1}", new Object[]{comment, tgtSummaryComment});
                    InteropUtilities.trySetTaskComment(task, comment, f);
                } else {
                    if (tgtSummaryTask == null && (tgtSummaryTask = InteropUtilities.tryCreateTask(taskName, tgtWs, f.nest(50))) != null) {
                        InteropUtilities.trySetTaskComment(tgtSummaryTask, tgtSummaryComment, f);
                    }
                    if (tgtSummaryTask != null) {
                        tgtTasks.add(tgtSummaryTask);
                        isTaskAdded = true;
                    }
                }
            }
            if (srcCloneTasks.size() > 0) {
                tgtTasks.addAll((Collection)srcCloneTasks);
                isTaskAdded = true;
            }
            if (!isTaskAdded) continue;
            InteropUtilities.trySetActivityTaskList(tgtAct, (ResourceList<Task>)tgtTasks, tgtWs, f);
        }
    }

    public static void computeNewVersionList(ResourceList<Version> changes, ResourceList<Task> newTasks, ResourceList.ResponseIterator<VersionSet.CompareReport> compares) throws WvcmException {
        while (compares.hasNext()) {
            VersionSet.CompareReport change = (VersionSet.CompareReport)compares.next();
            if (change instanceof VersionSet.AddedVersion) {
                changes.add((Object)((VersionSet.AddedVersion)change).getVersion());
                continue;
            }
            if (change instanceof VersionSet.ChangedVersion) {
                changes.add((Object)((VersionSet.ChangedVersion)change).getNewVersion());
                continue;
            }
            if (change instanceof VersionSet.AddedActivity) {
                newTasks.addAll((Collection)((VersionSet.AddedActivity)change).getActivity().getTaskList());
                continue;
            }
            if (change instanceof VersionSet.PartiallyAddedActivity) {
                newTasks.addAll((Collection)((VersionSet.PartiallyAddedActivity)change).getActivity().getTaskList());
                continue;
            }
            if (!(change instanceof VersionSet.ChangedActivity)) continue;
            newTasks.addAll((Collection)((VersionSet.ChangedActivity)change).getActivity().getTaskList());
        }
    }

    public static Map<VersionHistory, Version> create_srcVh2srcVer(ControllableResource srcCR, ControllableResource tgtCR, Set<String> tgtRootPaths, Feedback f) throws WvcmException {
        if (tgtCR instanceof ControllableSymbolicLink || !(tgtCR instanceof ControllableFolder) || InteropUtilities.isPathAParentOf(tgtCR, tgtRootPaths)) {
            return null;
        }
        ControllableFolder srcCF = (ControllableFolder)srcCR;
        HashMap<VersionHistory, Version> srcVh2srcVer = new HashMap<VersionHistory, Version>();
        ResourceList.ResponseIterator srcCrIterator = srcCF.doReadMemberList(true, f.nest(PR_CI_VH_VERSION_CHILDMAP, 100));
        while (srcCrIterator.hasNext()) {
            ControllableResource srcCr = (ControllableResource)srcCrIterator.next();
            Version srcVer = srcCr.getCheckedIn();
            if (srcVer == null) continue;
            srcVh2srcVer.put(srcVer.getVersionHistory(), srcVer);
        }
        return srcVh2srcVer;
    }

    public static Map<VersionHistory, Version> computeTargetVh2SrcVerMap(WorkspaceProvider tgtProv, ResourceList<Version> srcChangedVersions, WorkspaceProvider srcProv) throws WvcmException {
        Map<VersionHistory, Version> srcVh2srcVersion = InteropCore.computeSrvVh2srcVersionMap(srcChangedVersions);
        Set<VersionHistory> srcVersionHistories = srcVh2srcVersion.keySet();
        Map<VersionHistory, String> srcVh2ClonePath = InteropCore.lookupClonePaths(srcProv, srcVersionHistories, tgtProv);
        HashMap<VersionHistory, Version> results = new HashMap<VersionHistory, Version>(srcChangedVersions.size());
        for (VersionHistory srcVersionHistory : srcVersionHistories) {
            VersionHistory tgtVH;
            String tgtCloneVHPath = srcVh2ClonePath.get(srcVersionHistory);
            if (tgtCloneVHPath == null || InteropCore.isFakeClonePath(tgtCloneVHPath) || (tgtVH = InteropCore.buildProxy(srcVersionHistory, (Provider)tgtProv, tgtCloneVHPath)) == null) continue;
            results.put(tgtVH, srcVh2srcVersion.get(srcVersionHistory));
        }
        return results;
    }

    public static void sendoverFolder(SendoverData sd, boolean isTree, ControllableFolder tgtFolder, VersionHistory tgtFolderVH, FolderVersion srcFolderVer, VersionHistory srcFolderVH, Feedback nowork) throws WvcmException {
        VersionHistory srcChildVH;
        if (tgtFolder instanceof ControllableSymbolicLink) {
            return;
        }
        WorkspaceProvider tgtProv = tgtFolder.workspaceProvider();
        WorkspaceProvider srcProv = srcFolderVer.workspaceProvider();
        boolean isChildRemoved = false;
        boolean isChildAdded = false;
        Map tgtFolderChildMap = tgtFolder.getChildMap();
        Map srcFolderVChildMap = srcFolderVer.getChildMap();
        Set<String> srcFolderVChildNames = srcFolderVChildMap.keySet();
        HashMap<String, Boolean> isSubTreeMap = new HashMap<String, Boolean>();
        sd.tgtProcessed.add(tgtFolderVH.location().string());
        HashSet<String> rebindNames = new HashSet<String>();
        for (String srcBN : srcFolderVChildNames) {
            Version srcChildVer;
            Version srcChildVer2;
            isSubTreeMap.put(srcBN, isTree);
            srcChildVH = (VersionHistory)srcFolderVChildMap.get(srcBN);
            if (!tgtFolderChildMap.containsKey(srcBN)) continue;
            VersionHistory tgtWantedChildVH = InteropCore.lookupClone(sd, srcChildVH, tgtProv);
            ControllableResource tgtChild = (ControllableResource)tgtFolderChildMap.get(srcBN);
            VersionHistory tgtChildVH = tgtChild.getVersionHistory();
            Version tgtChildVer = tgtChild.getCheckedIn();
            if (tgtChildVer != null && tgtWantedChildVH == null && tgtChildVH != null && InteropCore.lookupClonePath(tgtChildVH, srcProv) == null && (srcChildVer2 = InteropUtilities.doFindVersionInWorkspace(sd.srcWorkspace, srcChildVH, nowork.nest(PR_CLONE))) != null && !(srcChildVer2 instanceof SymbolicLinkVersion) && srcChildVer2.getClass().equals(tgtChildVer.getClass())) {
                InteropCore.linkClones((Resource)srcChildVH, (Resource)tgtChildVH, nowork);
                isSubTreeMap.put(srcBN, true);
            }
            String origPath = ((Location)InteropUtilities.getOrReadProperty((Resource)tgtChild, ControllableResource.PATHNAME_LOCATION, nowork)).string();
            if (!InteropCore.isSame(tgtChildVH, tgtWantedChildVH, tgtChildVer, srcChildVH, sd.srcWorkspace, nowork)) {
                InteropUtilities.rebindToTmp(tgtFolder, srcBN, srcFolderVChildNames, sd.tgtRootPaths, nowork);
                isChildRemoved = true;
                rebindNames.add(srcBN);
                continue;
            }
            if (!isTree || sd.tgtRootPaths.contains(origPath) || (srcChildVer = InteropUtilities.doFindVersionInWorkspace(sd.srcWorkspace, srcChildVH, nowork.nest(PR_VERSION_CHILDMAP))) == null) continue;
            sd.tgtVh2srcVer.put(tgtChildVH, srcChildVer);
        }
        for (String srcBN : srcFolderVChildNames) {
            if (!rebindNames.contains(srcBN) && tgtFolderChildMap.containsKey(srcBN)) continue;
            isChildAdded = true;
        }
        for (String bn : tgtFolderChildMap.keySet()) {
            if (srcFolderVChildMap.containsKey(bn)) continue;
            isChildRemoved = true;
        }
        if (isChildRemoved) {
            sd.tgtChildRemoved.put(tgtFolderVH, srcFolderVer);
        }
        if (isChildRemoved || isChildAdded) {
            nowork.notifyCompleted(nowork.format(Messages.InteropStream_MSG_UPDATED_FOLDER, new Object[]{InteropUtilities.getFriendlyPathname((Resource)tgtFolder, 200, nowork)}));
            sd.reportProgress();
            InteropCore.incrementSyncStat(SyncStatType.FOLDERS_UPDATED, (Resource)tgtFolder, 1);
        }
        for (String srcBN : srcFolderVChildNames) {
            ControllableResource tgtChild;
            srcChildVH = (VersionHistory)srcFolderVChildMap.get(srcBN);
            if (rebindNames.contains(srcBN) || !tgtFolderChildMap.containsKey(srcBN)) {
                InteropCore.bindVersionHistory(sd, (Boolean)isSubTreeMap.get(srcBN), tgtFolder, srcBN, srcChildVH, srcFolderVH, nowork);
                continue;
            }
            if (!((Boolean)isSubTreeMap.get(srcBN)).booleanValue() || (tgtChild = (ControllableResource)tgtFolderChildMap.get(srcBN)) instanceof ControllableSymbolicLink || !(tgtChild instanceof ControllableFolder)) continue;
            ControllableFolder tgtChildFolder = (ControllableFolder)tgtChild.doReadProperties(nowork.nest(PR_PATH_VH_CR_CHILD_CLONE));
            VersionHistory tgtChildFolderVH = tgtChildFolder.getVersionHistory();
            Version srcChildVer = sd.tgtVh2srcVer.get(tgtChildFolderVH);
            if (srcChildVer == null && (srcChildVer = InteropUtilities.doFindVersionInWorkspace(sd.srcWorkspace, srcChildVH, nowork.nest(PR_VH_CLONE))) != null) {
                sd.tgtVh2srcVer.put(tgtChildFolderVH, srcChildVer);
            }
            if (sd.tgtRootPaths.contains(tgtChildFolder.getPathnameLocation().string())) continue;
            InteropCore.sendoverFolder(sd, (Boolean)isSubTreeMap.get(srcBN), tgtChildFolder, tgtChildFolderVH, (FolderVersion)srcChildVer, srcChildVH, nowork);
        }
    }

    private static boolean isSame(VersionHistory curVH, VersionHistory cloneVH, Version curVersion, VersionHistory srcVH, Workspace srcWs, Feedback f) throws WvcmException {
        Feedback nowork = f.nest();
        if (cloneVH != null) {
            return cloneVH.equals(curVH);
        }
        if (!(curVersion instanceof SymbolicLinkVersion)) {
            return false;
        }
        ControllableResource srcCR = InteropUtilities.doFindCRInWorkspace(srcWs, srcVH, f.nest(PR_CI_LINK_TARGET, 100));
        Version srcVersion = null;
        srcVersion = srcCR == null ? (Version)InteropUtilities.doReadProperty((Resource)srcVH, VersionHistory.ROOT_VERSION, nowork) : srcCR.getCheckedIn();
        if (!(srcVersion instanceof SymbolicLinkVersion)) {
            return false;
        }
        String target1 = (String)InteropUtilities.doReadProperty((Resource)curVersion, SymbolicLinkVersion.LINK_TARGET, nowork);
        String target2 = (String)InteropUtilities.doReadProperty((Resource)srcVersion, SymbolicLinkVersion.LINK_TARGET, nowork);
        return target1.equals(target2);
    }

    public static void removeDeletedChildren(SendoverData sd, Feedback nowork) throws WvcmException {
        boolean isFirstUnbind = true;
        for (VersionHistory tgtFolderVH : sd.tgtChildRemoved.keySet()) {
            ControllableFolder tgtFolder = (ControllableFolder)InteropUtilities.doFindCRInWorkspace(sd.tgtWorkspace, tgtFolderVH, nowork.nest(PR_CHILDMAP));
            if (tgtFolder == null) continue;
            FolderVersion srcFolderVer = sd.tgtChildRemoved.get(tgtFolderVH);
            Map tgtFolderChildMap = tgtFolder.getChildMap();
            Map srcFolderVerChildMap = srcFolderVer.getChildMap();
            for (String bn : tgtFolderChildMap.keySet()) {
                if (srcFolderVerChildMap.containsKey(bn)) continue;
                if (isFirstUnbind) {
                    sd.tgtWorkspace.doCheckinAll(null, null, null);
                    isFirstUnbind = false;
                }
                tgtFolder.doUnbindChild(bn, nowork);
                nowork.notifyCompleted(nowork.format(Messages.InteropStream_MSG_DELETED, new Object[]{bn}));
            }
        }
    }

    public static void copyVersionToCR(ControllableResource tgtCR, Version srcVersion, boolean isNew, boolean isTree, Feedback f) throws WvcmException {
        Feedback nowork = f.nest();
        if (tgtCR instanceof ControllableSymbolicLink) {
            throw new RuntimeException("Cannot copy content for symbolic link: " + tgtCR.location());
        }
        try {
            if (isTree && !isNew && InteropUtilities.isContentEqual((Resource)tgtCR, (Resource)srcVersion, f.nest(30))) {
                return;
            }
        }
        catch (WvcmException e) {
            if (e.getReasonCode().equals((Object)WvcmException.ReasonCode.NOT_FOUND)) {
                nowork.notifyWarning(nowork.format(Messages.InteropCore_WARNING_HARD_LINK_IGNORED, new Object[]{tgtCR.location()}));
                return;
            }
            throw e;
        }
        WorkspaceProvider p = tgtCR.workspaceProvider();
        PipedInputStream pins = new PipedInputStream();
        PipedOutputStream pouts = InteropUtilities.createPipedOutputStream((Provider)p, pins);
        InteropUtilities.ChildException childEx = new InteropUtilities.ChildException();
        Resource accept = null;
        String tgtDefaultLSVal = (String)p.initArgs().get(IA_WORKSPACE_LINE_SEPARATOR);
        if (tgtDefaultLSVal != null) {
            accept = p.resource(tgtCR.location());
            accept.setProperty(InteropUtilities.PN_LINE_SEPARATOR, (Object)tgtDefaultLSVal);
        }
        InteropUtilities.ContentReader reader = new InteropUtilities.ContentReader((Resource)srcVersion, pouts, accept, childEx, nowork);
        Provider srcP = srcVersion.provider();
        if (isNew || srcP.initArgs().containsKey(IA_IMPORT_ONLY) && Boolean.valueOf((String)srcP.initArgs().get(IA_IMPORT_ONLY)).booleanValue()) {
            InteropCore.initializeContentProperties(tgtCR, srcVersion);
        }
        try {
            InteropUtilities.forceAbortWvcmException(tgtCR.provider(), 27, f);
            tgtCR.doWriteContent((InputStream)pins, null, f.nest(100));
        }
        catch (WvcmException e) {
            reader.interrupt();
            InteropUtilities.closePipedInputStream((Provider)p, pins);
            pins = new PipedInputStream();
            pouts = InteropUtilities.createPipedOutputStream((Provider)p, pins);
            childEx = new InteropUtilities.ChildException();
            new InteropUtilities.ContentReader((Resource)srcVersion, pouts, null, childEx, nowork);
            InteropUtilities.setBinaryContentProperties(tgtCR);
            tgtCR.doWriteContent((InputStream)pins, null, f.nest(100));
            f.notifyWarning(f.format(Messages.InteropStream_WARNING_BROUGHT_OVER_AS_BINARY, new Object[]{InteropUtilities.doReadProperty((Resource)srcVersion, Resource.DISPLAY_NAME, nowork)}));
        }
        InteropUtilities.closePipedInputStream((Provider)p, pins);
        if (childEx.ex != null) {
            if (childEx.ex instanceof WvcmException) {
                WvcmException readerException = (WvcmException)childEx.ex;
                String friendlyPathname = InteropUtilities.readFriendlyPathname((Resource)tgtCR, 0, nowork);
                if (WvcmException.ReasonCode.CONFLICT.equals((Object)readerException.getReasonCode())) {
                    try {
                        tgtCR.doUncheckout(f);
                    }
                    catch (WvcmException wvcmException) {
                        // empty catch block
                    }
                    String msg = InteropCore.msg(f, Msg.ERROR_SOURCE_CONTENT_DELETED, friendlyPathname, srcVersion.provider().displayName());
                    throw new WvcmException(msg, (Resource)tgtCR, WvcmException.ReasonCode.CONFLICT, (Throwable)readerException);
                }
                throw readerException;
            }
            throw new WvcmException(Messages.InteropStream_ERROR_CONTENT_READER_DIED, (Resource)tgtCR, WvcmException.ReasonCode.CONFLICT, childEx.ex);
        }
    }

    private static void initializeContentProperties(ControllableResource tgtCR, Version srcVersion) throws WvcmException {
        Version srcVer = srcVersion;
        if (srcVer.lookupProperty(Resource.CONTENT_TYPE) instanceof WvcmException) {
            srcVer = (Version)srcVersion.doReadProperties((Feedback)PR_NEW_CONTENT_CHARACTERISTICS);
        }
        tgtCR.setContentType(srcVer.getContentType());
        if (InteropUtilities.isTextContentType(srcVer.getContentType())) {
            InteropUtilities.setIfNotNull((Resource)tgtCR, (Resource)srcVer, InteropUtilities.PN_LINE_SEPARATOR);
            InteropUtilities.setIfNotNull((Resource)tgtCR, (Resource)srcVer, Resource.CONTENT_CHARACTER_SET);
        } else {
            tgtCR.setProperty(InteropUtilities.PN_LINE_SEPARATOR, (Object)InteropUtilities.LineSeparator.UNSPECIFIED.name());
        }
        InteropUtilities.setIfNotNull((Resource)tgtCR, (Resource)srcVer, Resource.IS_EXECUTABLE);
    }

    public static void linkClones(Resource oneResource, Resource otherResource, Feedback f) throws WvcmException {
        Resource result = InteropCore.initCloneLink(oneResource, otherResource, f);
        result.doWriteProperties(f.nest(100));
    }

    public static Resource initCloneLink(Resource oneResource, Resource otherResource, Feedback f) throws WvcmException {
        Resource result = null;
        if (InteropCore.hasCloneInfo(oneResource.provider().initArgs())) {
            InteropCore.initClone(oneResource, otherResource, f);
            result = oneResource;
        } else if (InteropCore.hasCloneInfo(otherResource.provider().initArgs())) {
            InteropCore.initClone(otherResource, oneResource, f);
            result = otherResource;
        } else {
            throw new WvcmException("Neither provider is storing clone information", oneResource, WvcmException.ReasonCode.FORBIDDEN);
        }
        return result;
    }

    public static void initClone(Resource oneResource, Resource otherResource, Feedback f) throws WvcmException {
        String oneCloneVal = InteropUtilities.getProperty(oneResource, PN_CLONE);
        if (oneCloneVal != null) {
            String oneName = (String)InteropUtilities.doReadProperty(oneResource, Resource.DISPLAY_NAME, f);
            String msg = f.format(Messages.InteropStream_ERROR_ALREADY_HAS_CLONE, new Object[]{oneName, otherResource.getResourceIdentifier(), oneCloneVal});
            throw new WvcmException(msg, oneResource, WvcmException.ReasonCode.CONFLICT);
        }
        oneResource.initProperty(PN_CLONE, (Object)otherResource.getResourceIdentifier());
        InteropCore.incrementSyncStat(SyncStatType.CLONES, oneResource, 1);
    }

    private static Map<VersionHistory, String> lookupClonePaths(WorkspaceProvider srcProv, Set<VersionHistory> srcVersionHistories, WorkspaceProvider tgtProv) throws WvcmException {
        HashMap<VersionHistory, String> results = new HashMap<VersionHistory, String>(srcVersionHistories.size());
        if (InteropCore.hasCloneInfo(srcProv.initArgs())) {
            for (VersionHistory versionHistory : srcVersionHistories) {
                results.put(versionHistory, InteropUtilities.getProperty((Resource)versionHistory, PN_CLONE));
            }
            return results;
        }
        if (!InteropCore.hasCloneInfo(tgtProv.initArgs())) {
            throw new WvcmException("Neither provider is storing clone information", null, WvcmException.ReasonCode.FORBIDDEN);
        }
        ResourceList queries = tgtProv.resourceList((Resource[])new VersionHistory[0]);
        for (VersionHistory srcVh : srcVersionHistories) {
            VersionHistory queryElement = tgtProv.versionHistory(tgtProv.rootLocation());
            queryElement.setProperty(PN_CLONE, (Object)srcVh.getResourceIdentifier());
            queries.add((Object)queryElement);
        }
        ResourceList.ResponseIterator clones = queries.doFind(null);
        for (VersionHistory srcVh : srcVersionHistories) {
            VersionHistory clone = (VersionHistory)clones.next();
            String value = clone != null ? clone.getResourceIdentifier() : null;
            results.put(srcVh, value);
        }
        return results;
    }

    static void tryLinkComponentClones(Component tgtComponent, Component srcComponent, String compName, Feedback f) throws WvcmException {
        try {
            InteropCore.linkClones((Resource)tgtComponent, (Resource)srcComponent, f);
        }
        catch (WvcmException e) {
            String msg = f.format(Messages.InteropStream_ERROR_COMPONENT_HAS_CLONE, new Object[]{compName});
            throw new WvcmException(msg, (Resource)srcComponent, WvcmException.ReasonCode.CONFLICT, (Throwable)e);
        }
    }

    private static void bindVersionHistory(SendoverData sd, boolean isTree, ControllableFolder tgtParentFolder, String bn, VersionHistory srcVH, VersionHistory srcParentVH, Feedback nowork) throws WvcmException {
        VersionHistory tgtVH;
        WorkspaceProvider tgtProv = tgtParentFolder.workspaceProvider();
        WorkspaceProvider srcProv = srcParentVH.workspaceProvider();
        Version tgtPredecessor = null;
        Version srcVer = null;
        if (sd.srcVh2srcVer != null) {
            srcVer = sd.srcVh2srcVer.get(srcVH);
        }
        if (srcVer == null) {
            srcVer = InteropUtilities.doFindOneVersionInWorkspace(sd.srcWorkspace, srcVH, nowork.nest(PR_VERSION_CHILDMAP));
        }
        if ((tgtVH = InteropCore.lookupClone(sd, srcVH, tgtProv)) != null) {
            ControllableResource tgtOrigCR = null;
            try {
                tgtOrigCR = InteropUtilities.doFindCRInWorkspace(sd.tgtWorkspace, tgtVH, nowork.nest(PR_PATH));
            }
            catch (WvcmException e) {
                if (e.getReasonCode().equals((Object)WvcmException.ReasonCode.NOT_FOUND)) {
                    srcVH.removeProperty(PN_CLONE);
                    srcVH.doWriteProperties(nowork);
                    ControllableResource srcOrigCR = InteropUtilities.doFindCRInWorkspace(sd.srcWorkspace, srcVH, nowork.nest(PR_PATH));
                    String pathname = InteropUtilities.getFriendlyPathname((Resource)srcOrigCR, 100, nowork);
                    nowork.notifyWarning(InteropCore.msg(nowork, Msg.WARN_CLONE_NOT_FOUND, pathname));
                }
                throw e;
            }
            if (tgtOrigCR != null) {
                if (sd.tgtCreated.contains(tgtVH.location().string())) {
                    String msg = nowork.format(Messages.InteropStream_MSG_HARD_LINK_DETECTED, new Object[]{tgtOrigCR.getPathnameLocation(), bn, tgtParentFolder.location()});
                    nowork.notifyWarning(msg);
                    return;
                }
                boolean tgtOrigIsRoot = InteropUtilities.isPathIn(tgtOrigCR, sd.tgtRootPaths);
                boolean tgtOrigIsBelowRoot = InteropUtilities.isPathAChildOf(tgtOrigCR, sd.tgtRootPaths);
                InteropUtilities.rebindFixup(tgtParentFolder, bn, tgtOrigCR, sd.tgtRootPaths, nowork);
                if (isTree && !tgtOrigIsRoot || !tgtOrigIsBelowRoot) {
                    if (tgtOrigCR instanceof ControllableSymbolicLink) {
                        throw new RuntimeException("Symbolic link should not be marked as a clone: " + tgtOrigCR.location());
                    }
                    if (tgtOrigCR instanceof ControllableFolder) {
                        ControllableFolder tgtFolder = tgtProv.controllableFolder(tgtParentFolder.location().child(bn));
                        tgtFolder = (ControllableFolder)tgtFolder.doReadProperties(nowork.nest(PR_PATH_CR_CHILD_CLONE));
                        InteropCore.sendoverFolder(sd, true, tgtFolder, tgtVH, (FolderVersion)srcVer, srcVH, nowork);
                    } else {
                        ControllableResource tgtCR = tgtProv.controllableResource(tgtParentFolder.location().child(bn));
                        sd.tgtProcessed.add(tgtVH.location().string());
                        InteropCore.copyVersionToCR(tgtCR, srcVer, true, isTree, nowork);
                        nowork.notifyCompleted(nowork.format(Messages.InteropStream_MSG_UPDATED, new Object[]{bn}));
                        sd.reportProgress();
                        InteropCore.incrementSyncStat(SyncStatType.FILES_UPDATED, (Resource)tgtCR, 1);
                    }
                } else {
                    nowork.notifyCompleted(nowork.format(Messages.InteropStream_MSG_MOVED, new Object[]{bn}));
                }
                return;
            }
            tgtPredecessor = (Version)InteropUtilities.doReadProperty((Resource)tgtVH, VersionHistory.ROOT_VERSION, nowork);
        }
        if (srcVer instanceof FolderVersion) {
            FolderVersion srcFolderVer = (FolderVersion)srcVer;
            ControllableFolder tgtFolder = tgtProv.controllableFolder(tgtParentFolder.location().child(bn));
            if (tgtPredecessor == null) {
                tgtFolder.doCreateResource(nowork);
                tgtFolder = (ControllableFolder)tgtFolder.doVersionControl(nowork.nest(PR_VH_CLONE));
                tgtVH = tgtFolder.getVersionHistory();
                sd.updateThisClone(srcVH, tgtVH);
                nowork.notifyCompleted(nowork.format(Messages.InteropStream_MSG_CREATED_FOLDER, new Object[]{bn}));
            } else {
                tgtFolder = (ControllableFolder)tgtFolder.doCreateVersionControlledResource(tgtPredecessor, nowork.nest(PR_CHILDMAP_VH));
                for (String childName : tgtFolder.getChildMap().keySet()) {
                    tgtFolder.doUnbindChild(childName, nowork);
                }
                nowork.notifyCompleted(nowork.format(Messages.InteropStream_MSG_RESTORED_FOLDER, new Object[]{bn}));
            }
            sd.tgtCreated.add(tgtFolder.getVersionHistory().location().string());
            sd.reportProgress();
            InteropCore.incrementSyncStat(SyncStatType.FOLDERS_CREATED, (Resource)tgtFolder, 1);
            Map srcFVChildMap = srcFolderVer.getChildMap();
            for (String childName : srcFVChildMap.keySet()) {
                VersionHistory srcChildVH = (VersionHistory)srcFVChildMap.get(childName);
                InteropCore.bindVersionHistory(sd, isTree, tgtFolder, childName, srcChildVH, srcVH, nowork);
            }
        } else if (srcVer instanceof SymbolicLinkVersion) {
            ControllableSymbolicLink tgtCSL = tgtProv.controllableSymbolicLink(tgtParentFolder.location().child(bn));
            SymbolicLinkVersion srcSLVer = (SymbolicLinkVersion)srcVer.doReadProperties((Feedback)PR_SYMLINK_TARGET_INFO);
            tgtCSL.setLinkTarget(srcSLVer.getLinkTarget());
            InteropCore.incrementSyncStat(SyncStatType.SYMLINKS_CREATED, (Resource)tgtCSL, 1);
            Boolean linkTargetIsDir = InteropUtilities.getProperty((Resource)srcSLVer, InteropUtilities.PN_SYMLINK_TARGET_IS_DIR);
            if (linkTargetIsDir == null) {
                try {
                    ControllableResource srcParentCR = InteropUtilities.doFindCRInWorkspace(sd.srcWorkspace, srcParentVH, nowork);
                    ControllableSymbolicLink srcCSL = srcProv.controllableSymbolicLink(srcParentCR.location().child(bn));
                    ControllableResource srcResource = (ControllableResource)srcCSL.doReadProperties((Feedback)PR_SYMLINK_TARGET_INFO);
                    linkTargetIsDir = InteropUtilities.getProperty((Resource)srcResource, InteropUtilities.PN_SYMLINK_TARGET_IS_DIR);
                }
                catch (WvcmException e) {
                    nowork.notifyWarning(nowork.format(Messages.InteropCore_WARNING_SYMLINK_TARGET_LOOKUP_FAILED, new Object[]{e.getMessage()}));
                }
            }
            if (linkTargetIsDir != null) {
                tgtCSL.setProperty(InteropUtilities.PN_SYMLINK_TARGET_IS_DIR, (Object)linkTargetIsDir);
            }
            tgtCSL = (ControllableSymbolicLink)tgtCSL.doCreateResource(nowork);
            tgtCSL.doVersionControl(nowork);
            nowork.notifyCompleted(nowork.format(Messages.InteropStream_MSG_CREATED_SYMLINK, new Object[]{bn}));
        } else {
            ControllableResource tgtCR = tgtProv.controllableResource(tgtParentFolder.location().child(bn));
            if (tgtPredecessor == null) {
                if (isTree) {
                    sd.putTgtCr2srcVer(tgtCR, srcVer);
                } else {
                    tgtCR = InteropCore.createFile(sd, tgtCR, true, srcVer, isTree, nowork.nest(PR_VH_CLONE));
                    tgtVH = tgtCR.getVersionHistory();
                    sd.updateThisClone(srcVH, tgtVH);
                }
            } else if (isTree) {
                FilesToRestoreInfo info = new FilesToRestoreInfo();
                info.tgtVersionToRestore = tgtPredecessor;
                info.srcVersion = srcVer;
                info.bindingName = bn;
                sd.filesToRestoreInfo.put(tgtCR, info);
            } else {
                tgtCR.doCreateVersionControlledResource(tgtPredecessor, nowork);
                InteropCore.copyVersionToCR(tgtCR, srcVer, false, isTree, nowork);
                nowork.notifyCompleted(nowork.format(Messages.InteropStream_MSG_RESTORED_FILE, new Object[]{bn}));
                sd.reportProgress();
                InteropCore.incrementSyncStat(SyncStatType.FILES_CREATED, (Resource)tgtCR, 1);
            }
        }
    }

    public static ControllableFolder getTgtBaselineControlledFolder(Workspace tgtCloneWs, Stream tgtStream, Configuration srcConfig, boolean isImportOnly, Feedback f) throws WvcmException {
        Feedback nowork = f.nest();
        WorkspaceProvider tgtProvider = tgtCloneWs.workspaceProvider();
        Component srcComponent = (Component)srcConfig.getVersionHistory();
        String compName = srcComponent.getDisplayName();
        Component tgtComponent = InteropCore.lookupClone(srcComponent, tgtProvider);
        ControllableFolder tgtBCF = null;
        if (tgtComponent == null && (tgtComponent = InteropUtilities.doFindComponent(tgtProvider, compName, f.nest(PR_CLONE, 10))) != null) {
            InteropCore.tryLinkComponentClones(tgtComponent, srcComponent, compName, nowork);
        }
        if (tgtComponent == null) {
            ControllableFolder root = (ControllableFolder)InteropUtilities.doReadProperty((Resource)tgtCloneWs, Workspace.CONFIGURATION_ROOT_FOLDER_HOME, f.nest(20));
            tgtBCF = tgtProvider.controllableFolder(root.location().child(compName));
            boolean doBaselineControl = false;
            try {
                InteropUtilities.forceAbortWvcmException(tgtBCF.provider(), 16, f);
                tgtBCF = (ControllableFolder)tgtBCF.doReadProperties(f.nest(PR_CFG_RF, 50));
            }
            catch (WvcmException e) {
                if (e.getReasonCode() != WvcmException.ReasonCode.NOT_FOUND) {
                    throw e;
                }
                tgtBCF = tgtBCF.doBaselineControl(f.nest(PR_CFG_RF, 50));
                f.notifyCompleted(f.format(Messages.InteropStream_MSG_CREATED_COMPONENT, new Object[]{compName}));
                doBaselineControl = true;
            }
            if (!doBaselineControl) {
                ControllableFolder configRoot;
                Configuration config = tgtBCF.getConfiguration();
                ControllableFolder controllableFolder = configRoot = config != null ? config.getRootFolder() : null;
                if (config == null || !tgtBCF.getPathnameLocation().equals(configRoot.getPathnameLocation())) {
                    tgtBCF = tgtBCF.doBaselineControl(f.nest(PR_CFG_RF, 50));
                    f.notifyCompleted(f.format(Messages.InteropStream_MSG_CREATED_COMPONENT, new Object[]{compName}));
                }
            }
            tgtComponent = (Component)tgtBCF.getConfiguration().getVersionHistory();
            InteropCore.tryLinkComponentClones(tgtComponent, srcComponent, compName, nowork);
        } else {
            Configuration tgtConfig = InteropUtilities.doFindConfigurationInWorkspace(tgtCloneWs, tgtComponent, f.nest(PR_RF_VH, 50));
            if (tgtConfig != null) {
                tgtBCF = tgtConfig.getRootFolder();
            } else {
                tgtComponent = (Component)tgtComponent.doReadProperties(f.nest(PR_ROOT_DN, 75));
                Baseline thisRootB = (Baseline)tgtComponent.getRootVersion();
                String tgtCompName = tgtComponent.getDisplayName();
                if (isImportOnly) {
                    Baseline srcInitialBaseline = (Baseline)srcConfig.getCheckedIn();
                    String name = srcInitialBaseline.getDisplayName();
                    List<Baseline> tgtBaselines = InteropUtilities.doFindNamedBaselinesInComponent(tgtProvider, name, tgtComponent, nowork);
                    if (tgtBaselines.size() == 1) {
                        thisRootB = (Baseline)tgtBaselines.get(0).doReadProperties((Feedback)InteropUtilities.PR_DN);
                    } else if (tgtBaselines.size() > 1) {
                        throw new WvcmException(InteropCore.msg(nowork, Msg.ERROR_AMBI_BL_NAMES, tgtCompName, name), WvcmException.ReasonCode.FORBIDDEN);
                    }
                }
                String blName = thisRootB.getDisplayName();
                tgtBCF = tgtProvider.controllableFolder(tgtCloneWs.location().child(tgtCompName));
                tgtBCF = tgtBCF.doCreateBaselineControlledFolder(thisRootB, f.nest(PR_VH_CLONE, 80));
                tgtConfig = InteropUtilities.doFindConfigurationInWorkspace(tgtCloneWs, tgtComponent, f.nest(PR_RF_VH, 90));
                if (tgtConfig == null) {
                    String msg = f.format("brought component ''{0}'' into workspace, but cannot find it via query", new Object[]{tgtCompName});
                    throw new IllegalStateException(msg);
                }
                tgtBCF = tgtConfig.getRootFolder();
                f.notifyCompleted(f.format(Messages.InteropStream_MSG_RESTORED_COMPONENT, new Object[]{tgtCompName, blName}));
            }
        }
        return tgtBCF;
    }

    public static ControllableResource createCloneRoot(boolean isRoot, ControllableFolder tgtBCF, Workspace tgtWorkspace, ControllableResource srcRoot, Location srcBCFLoc, Feedback f) throws WvcmException {
        ControllableResource existingTgtRoot;
        ControllableFolder tgtParent;
        VersionHistory tgtCloneVH;
        ControllableResource srcRootWithCloneInfo;
        ControllableFolder tgtRoot;
        String lastSegment;
        Feedback nowork;
        block18: {
            WorkspaceProvider tgtP = tgtBCF.workspaceProvider();
            WorkspaceProvider srcP = srcRoot.workspaceProvider();
            nowork = f.nest();
            lastSegment = srcRoot.location().lastSegment();
            tgtRoot = null;
            srcRootWithCloneInfo = (ControllableResource)srcRoot.doReadProperties(f.nest(PR_VH_CLONE, 25));
            VersionHistory srcRootVH = srcRootWithCloneInfo.getVersionHistory();
            String tgtCloneVHPath = InteropCore.lookupClonePath(srcRootVH, tgtP);
            if (InteropCore.isFakeClonePath(tgtCloneVHPath)) {
                throw new WvcmException(Messages.InteropStream_ERROR_ONLY_ONE_SYNCHRONIZED_PROJECT, WvcmException.ReasonCode.FORBIDDEN);
            }
            tgtCloneVH = null;
            if (tgtCloneVHPath != null && (tgtRoot = InteropUtilities.doFindCRInWorkspace(tgtWorkspace, tgtCloneVH = InteropCore.buildProxy(srcRootVH, (Provider)tgtP, tgtCloneVHPath), f.nest(PR_VH_CLONE, 50))) != null) {
                return tgtRoot;
            }
            if (srcBCFLoc.equals(srcRoot.location())) {
                if (tgtCloneVHPath != null && tgtRoot == null) {
                    tgtWorkspace = (Workspace)tgtWorkspace.doReadProperties((Feedback)PR_BCF_CONFIG_VH);
                    StringBuffer buf = new StringBuffer();
                    StringBuffer buf2 = new StringBuffer();
                    for (ControllableFolder bcf : tgtWorkspace.getBaselineControlledFolderList()) {
                        if (buf.length() > 0) {
                            buf.append(", ");
                        }
                        if (buf2.length() > 0) {
                            buf2.append(", ");
                        }
                        buf.append(bcf.getConfiguration().getVersionHistory().getDisplayName());
                        buf2.append(bcf.getConfiguration().getRootFolder().getVersionHistory().getResourceIdentifier());
                    }
                    throw new IllegalStateException("sync root VH already has a clone, but it is not visible in the target workspace. sync root VH RI: " + srcRootVH.getResourceIdentifier() + "\n\tsync root CR Location: " + srcRoot.location() + "\n\ttgtCloneVHPath: " + tgtCloneVHPath + "\n\ttarget workspace components: " + buf.toString() + "\n\ttarget workspace component root folder versionable identifiers: " + buf2.toString());
                }
                tgtRoot = tgtBCF;
                srcRoot = (ControllableResource)srcRoot.doReadProperties(f.nest(PR_VH_CLONE));
                InteropCore.linkClones((Resource)tgtRoot.getVersionHistory(), (Resource)srcRoot.getVersionHistory(), nowork);
                return tgtRoot;
            }
            Location srcParentLoc = srcRoot.location().parent();
            ControllableFolder srcParent = srcP.controllableFolder(srcParentLoc);
            tgtParent = (ControllableFolder)InteropCore.createCloneRoot(false, tgtBCF, tgtWorkspace, (ControllableResource)srcParent, srcBCFLoc, nowork);
            Location tgtRootLoc = tgtParent.location().child(lastSegment);
            if (srcRootWithCloneInfo instanceof ControllableFolder) {
                tgtRoot = tgtP.controllableFolder(tgtRootLoc);
                InteropCore.incrementSyncStat(SyncStatType.FOLDERS_CREATED, (Resource)tgtRoot, 1);
            } else {
                tgtRoot = tgtP.controllableResource(tgtRootLoc);
                InteropCore.incrementSyncStat(SyncStatType.FILES_CREATED, (Resource)tgtRoot, 1);
            }
            existingTgtRoot = null;
            try {
                InteropUtilities.forceAbortWvcmException(tgtRoot.provider(), 17, f);
                existingTgtRoot = (ControllableResource)tgtRoot.doReadProperties(f.nest(PR_VH_CLONE, 75));
            }
            catch (WvcmException e) {
                if (e.getReasonCode().equals((Object)WvcmException.ReasonCode.NOT_FOUND)) break block18;
                throw e;
            }
        }
        if (existingTgtRoot != null) {
            if (existingTgtRoot.getVersionHistory() == null) {
                tgtParent.doUnbindChild(lastSegment, nowork);
                nowork.notifyCompleted(nowork.format(Messages.InteropStream_MSG_DELETED, new Object[]{lastSegment}));
            } else {
                ControllableResource srcRootWithProp = (ControllableResource)srcRoot.doReadProperties(f.nest(PR_CI_NEW_CONTENT, 80));
                if (tgtCloneVH == null && existingTgtRoot.getClass() == srcRootWithProp.getClass()) {
                    InteropCore.linkClones((Resource)existingTgtRoot.getVersionHistory(), (Resource)srcRootWithCloneInfo.getVersionHistory(), f.nest(100));
                    if (!(existingTgtRoot instanceof ControllableFolder)) {
                        InteropCore.copyVersionToCR(existingTgtRoot, srcRootWithProp.getCheckedIn(), true, false, f.nest(85));
                    }
                    return tgtRoot;
                }
                String msg = f.format(Messages.InteropStream_ERROR_CLONE_TARGET_EXISTS, new Object[]{InteropUtilities.readFriendlyPathname((Resource)existingTgtRoot, 0, nowork)});
                throw new WvcmException(msg, WvcmException.ReasonCode.CANNOT_OVERWRITE);
            }
        }
        if (tgtCloneVH != null) {
            Version tgtPredecessor = (Version)InteropUtilities.doReadProperty((Resource)tgtCloneVH, VersionHistory.ROOT_VERSION, nowork);
            tgtRoot = tgtRoot.doCreateVersionControlledResource(tgtPredecessor, f.nest(100));
            String msgPrefix = isRoot ? Messages.InteropStream_MSG_RESTORED_ROOT : Messages.InteropStream_MSG_RESTORED_ANCESTOR;
            f.notifyCompleted(f.format(msgPrefix, new Object[]{lastSegment}));
            return tgtRoot;
        }
        tgtRoot.doCreateResource(f.nest(75));
        if (!(tgtRoot instanceof ControllableFolder)) {
            ControllableResource srcRootWithProp = (ControllableResource)srcRoot.doReadProperties(f.nest(PR_CI_NEW_CONTENT, 80));
            InteropCore.copyVersionToCR((ControllableResource)tgtRoot, srcRootWithProp.getCheckedIn(), true, false, f.nest(85));
        }
        tgtRoot = tgtRoot.doVersionControl(f.nest(PR_VH_CLONE, 100));
        InteropCore.linkClones((Resource)tgtRoot.getVersionHistory(), (Resource)srcRootWithCloneInfo.getVersionHistory(), nowork);
        return tgtRoot;
    }

    public static ControllableResource findCloneRoot(ControllableResource cr, Workspace ws, Feedback f) throws WvcmException {
        Feedback nowork = f.nest();
        VersionHistory vh = (VersionHistory)InteropUtilities.doReadProperty((Resource)cr, ControllableResource.VERSION_HISTORY, nowork);
        if (vh == null) {
            String msg = Messages.InteropStream_ERROR_MUST_BE_UNDER_VERSION_CONTROL;
            String name = InteropUtilities.readFriendlyPathname((Resource)cr, 200, nowork);
            throw new WvcmException(f.format(msg, new Object[]{name}), (Resource)cr, WvcmException.ReasonCode.CONFLICT);
        }
        ControllableResource rootCR = InteropUtilities.doFindCRInWorkspace(ws, vh, f);
        if (rootCR == null) {
            Version ver = InteropUtilities.doFindVersionInWorkspace(ws, vh, nowork);
            String msg = ver != null && ver instanceof SymbolicLinkVersion ? Messages.InteropStream_ERROR_SYMLINK_CANNOT_BE_A_ROOT : Messages.InteropStream_ERROR_ROOT_NOT_FOUND;
            String name = InteropUtilities.readFriendlyPathname((Resource)cr, 200, nowork);
            throw new WvcmException(f.format(msg, new Object[]{name}), (Resource)cr, WvcmException.ReasonCode.CONFLICT);
        }
        if (rootCR.getConfiguration() == null) {
            String msg = rootCR instanceof ControllableFolder ? Messages.InteropStream_ERROR_REQUESTED_SYNC_FOLDER_NOT_IN_CONFIG : Messages.InteropStream_ERROR_REQUESTED_SYNC_FILE_NOT_IN_CONFIG;
            String name = InteropUtilities.readFriendlyPathname((Resource)cr, 200, nowork);
            throw new WvcmException(f.format(msg, new Object[]{name}), (Resource)cr, WvcmException.ReasonCode.CONFLICT);
        }
        if (rootCR instanceof ControllableSymbolicLink) {
            throw new WvcmException(Messages.InteropStream_ERROR_SYMLINK_CANNOT_BE_A_ROOT, (Resource)rootCR, WvcmException.ReasonCode.CONFLICT);
        }
        return rootCR;
    }

    public static InteropStreamSegment.SyncRoots combinedSyncRoots(InteropStreamSegment.SyncRoots src1, InteropStreamSegment.SyncRoots src2) {
        String[] roots = new String[src1.paths.length + src2.paths.length];
        System.arraycopy(src1.paths, 0, roots, 0, src1.paths.length);
        System.arraycopy(src2.paths, 0, roots, src1.paths.length, src2.paths.length);
        return new InteropStreamSegment.SyncRoots(roots);
    }

    public static class FilesToRestoreInfo {
        Version srcVersion;
        Version tgtVersionToRestore;
        String bindingName;
    }

    public static enum InteropStreamOperation {
        INITIALIZE,
        SYNCHRONIZE,
        EXPORT,
        IMPORT;


        public String get_name() {
            switch (this) {
                case INITIALIZE: {
                    return Messages.InteropStream_OP_INITIALIZE;
                }
                case SYNCHRONIZE: {
                    return Messages.InteropStream_OP_SYNCHRONIZE;
                }
                case EXPORT: {
                    return Messages.InteropStream_OP_EXPORT;
                }
                case IMPORT: {
                    return Messages.InteropStream_OP_IMPORT;
                }
            }
            return Messages.InteropStream_OP_UNEXPECTED;
        }
    }

    public static enum InteropStreamState {
        OK,
        MERGE_NEEDED,
        OPERATION_PENDING,
        OPERATION_ACTIVE,
        OPERATION_ERROR,
        OPERATION_CANCELED;

    }

    public static enum Msg {
        ERROR_SOURCE_CONTENT_DELETED,
        ERROR_STREAM_RESERVED,
        ERROR_STALE_DATA,
        ERROR_COULD_NOT_TRANSFER_ROOT,
        WARN_CLONE_NOT_FOUND,
        ERROR_OLD_CLIENT,
        ERROR_ROOTS_HAVE_NO_BASELINES,
        ERROR_AMBI_BL_NAMES;

    }

    public static class NewRoot {
        public String path;
        public String[] pendingSubRootPaths;
        public InteropStreamSegment.SyncRoots srcSubRootPaths;
        public InteropStreamSegment.SyncRoots tgtSubRootPaths;

        public NewRoot(String _path, String[] _pendingSubRootPaths, InteropStreamSegment.SyncRoots _thisSubRootPaths, InteropStreamSegment.SyncRoots _thatSubRootPaths) {
            this.path = _path;
            this.pendingSubRootPaths = _pendingSubRootPaths;
            this.srcSubRootPaths = _thisSubRootPaths;
            this.tgtSubRootPaths = _thatSubRootPaths;
        }

        public NewRoot(String _path) {
            this.path = _path;
            this.pendingSubRootPaths = null;
            this.srcSubRootPaths = null;
            this.tgtSubRootPaths = null;
        }
    }

    public static enum SyncStatType {
        FILES_CREATED,
        FILES_UPDATED,
        FOLDERS_CREATED,
        FOLDERS_UPDATED,
        CHANGES,
        CLONES,
        SYMLINKS_CREATED;

    }

    public static class SyncStats {
        public static int numChanges = 0;
        public static int numClones = 0;
        public static int numFilesCreated = 0;
        public static int numFilesUpdated = 0;
        public static int numFoldersCreated = 0;
        public static int numFoldersUpdated = 0;
        public static int numSymlinksCreated = 0;
        private final Map<SyncStatType, Integer> _stats = new HashMap<SyncStatType, Integer>();

        private void incrementSyncStat(SyncStatType type, int amount) {
            this._stats.put(type, this.getAmount(type) + amount);
            if (type == SyncStatType.FILES_CREATED) {
                numFilesCreated += amount;
            } else if (type == SyncStatType.FILES_UPDATED) {
                numFilesUpdated += amount;
            } else if (type == SyncStatType.FOLDERS_CREATED) {
                numFoldersCreated += amount;
            } else if (type == SyncStatType.FOLDERS_UPDATED) {
                numFoldersUpdated += amount;
            } else if (type == SyncStatType.SYMLINKS_CREATED) {
                numSymlinksCreated += amount;
            } else if (type == SyncStatType.CHANGES) {
                numChanges += amount;
            } else if (type == SyncStatType.CLONES) {
                numClones += amount;
            }
        }

        public int getAmount(SyncStatType type) {
            Integer result = this._stats.get((Object)type);
            if (result == null) {
                return 0;
            }
            return result;
        }
    }
}

