/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CTInitArgUtils;
import com.ibm.rational.wvcm.ct.CommandProvider;
import com.ibm.rational.wvcm.ct.CommonUtils;
import com.ibm.rational.wvcm.ct.Messages;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.wvcm.WvcmException;
import org.eclipse.osgi.util.NLS;

public class CommandResult {
    private static final String INIT_ARGS_SEGMENT_SEPARATOR = ".";
    private static final String _USERNAME = "-username";
    private static final Map<String, String> NULL_ENV = new HashMap<String, String>();
    private static final Pattern UNABLE_TO_DETERMINE_VIEW_PATTERN = Pattern.compile("^cleartool: Error: Unable to determine view for \"(.*?)\": .*");
    private static final Pattern NOT_AN_OBJECT_IN_A_VOB = Pattern.compile("^cleartool: Error: Not an object in a vob: \"(.*?)\".");
    private static final String CLEARTOOL_ERROR = "cleartool: Error: .*";
    private static final String COMPONENT_NOT_FOUND_ERROR = "cleartool: Error: [Cc]omponent not found:.*";
    private static final String NO_VIEW_INFO_ERROR = "cleartool: Error: Cannot get view info for current view: not a ClearCase object.";
    private static final String NOT_A_VOB_OBJECT = "cleartool: Error: Not a vob object:";
    private static final String UNABLE_TO_FIND_REPLICA = "cleartool: Error: Unable to find replica in registry for VOB with object ID:";
    private static final String UNABLE_TO_LOCATE_VOB = "cleartool: Error: Unable to locate versioned object base with object id:";
    private static final String NTTYPE_SID_NOT_SUPPORTED = "cleartool: Error: \"NT\"-type SID is not supported by credmap_server";
    private static final String TROUBLE_FINDING_GLOBAL_DEFINITION = "cleartool: Error: Trouble finding the global definition for local type";
    private static int UNINITIALIZED = -16384;
    private final String _directory;
    private final List<String> _command;
    private int _stat;
    private IOException _ioEx;
    private List<String> _stdErr;
    private List<String> _stdOut;
    private long _durationMillis;
    private Map<String, String> _evs;

    public void assertSuccess(ResultBehaviorFlags flags) throws WvcmException {
        if (this._stat != 0 && (this._stdErr == null || this._stdErr.isEmpty())) {
            Object[] bindings = new String[]{this.getCommand().get(0), this.toString()};
            throw new WvcmException(NLS.bind((String)Messages.CommandResult_OP_FAILED_EMPTY_STDERR, (Object[])bindings), WvcmException.ReasonCode.FORBIDDEN);
        }
        ResultErrorKind resultErrorKind = this.isStdErrOK(this._stat, this._stdErr, flags);
        if (this._ioEx != null || resultErrorKind != null) {
            WvcmException e = this.computeOperationFailedException();
            if (this._stdErr != null) {
                if (flags.notFoundImpliesBackslashInNameOnWindows() && resultErrorKind.equals((Object)ResultErrorKind.OTHER_NOT_FOUND)) {
                    throw new WvcmException(Messages.CommandResult_ERROR_CHECK_FOR_BACKSLASHES, WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
                }
                for (String line : this._stdErr) {
                    Matcher m1 = UNABLE_TO_DETERMINE_VIEW_PATTERN.matcher(line);
                    if (m1.find()) {
                        e = new WvcmException(NLS.bind((String)Messages.CCaseLib_POSSIBLE_UNMOUNT, (Object)m1.group(1)), WvcmException.ReasonCode.CONFLICT, (Throwable)e);
                        continue;
                    }
                    Matcher m2 = NOT_AN_OBJECT_IN_A_VOB.matcher(line);
                    if (!m2.find()) continue;
                    e = new WvcmException(NLS.bind((String)Messages.CCaseLib_POSSIBLE_UNMOUNT, (Object)m2.group(1)), WvcmException.ReasonCode.CONFLICT, (Throwable)e);
                }
            }
            throw e;
        }
    }

    public WvcmException computeOperationFailedException() {
        Object[] bindings = new String[]{this.getCommand().get(0), this.toString()};
        WvcmException e = new WvcmException(NLS.bind((String)Messages.CommandResult_OPERATION_FAILED_ERROR, (Object[])bindings), WvcmException.ReasonCode.FORBIDDEN);
        return e;
    }

    private ResultErrorKind isStdErrOK(int stat, List<String> stdErrArray, ResultBehaviorFlags flags) throws WvcmException {
        ResultErrorKind result = null;
        if (stdErrArray == null || stdErrArray.isEmpty()) {
            return result;
        }
        if (flags == null) {
            throw new IllegalArgumentException("flags must not be null");
        }
        for (String line : stdErrArray) {
            if (line.matches(CLEARTOOL_ERROR)) {
                if (line.matches(CCaseLib.getNotFoundPattern())) {
                    if (flags.notFoundOK()) continue;
                    return ResultErrorKind.OTHER_NOT_FOUND;
                }
                if (line.matches(COMPONENT_NOT_FOUND_ERROR)) {
                    if (flags.notFoundOK()) continue;
                    return ResultErrorKind.COMPONENT_NOT_FOUND;
                }
                if (line.matches(NO_VIEW_INFO_ERROR)) {
                    if (flags.noViewInfoOK()) continue;
                    return ResultErrorKind.NO_VIEW_INFO;
                }
                if (line.startsWith(NOT_A_VOB_OBJECT)) {
                    if (flags.notFoundOK()) continue;
                    return ResultErrorKind.OTHER_NOT_FOUND;
                }
                if (line.startsWith(UNABLE_TO_FIND_REPLICA) || line.startsWith(UNABLE_TO_LOCATE_VOB)) {
                    if (!flags.vobNotFoundWarn()) {
                        return ResultErrorKind.OTHER_NOT_FOUND;
                    }
                    flags.feedback.notifyWarning(line);
                    continue;
                }
                if (line.startsWith(NTTYPE_SID_NOT_SUPPORTED)) {
                    if (!flags.ntTypeSidNotSupportedWarn()) {
                        return ResultErrorKind.OTHER_ERROR;
                    }
                    flags.feedback.notifyWarning(line);
                    continue;
                }
                if (line.startsWith(TROUBLE_FINDING_GLOBAL_DEFINITION)) {
                    if (!flags.troubleFindingGlobalDefinition()) {
                        return ResultErrorKind.OTHER_ERROR;
                    }
                    flags.feedback.notifyWarning(line);
                    continue;
                }
                return ResultErrorKind.OTHER_ERROR;
            }
            if (stat == 0) continue;
            return ResultErrorKind.OTHER_ERROR;
        }
        return result;
    }

    public CommandResult(String workingDirectory, List<String> command, Map<String, String> evs) {
        this._directory = workingDirectory;
        this._command = command;
        this._stat = UNINITIALIZED;
        this._evs = evs;
    }

    public final String getDirectory() {
        return this._directory;
    }

    public final List<String> getCommand() {
        return this._command;
    }

    public final int getStat() {
        return this._stat;
    }

    public String getStdErr() {
        return CommonUtils.myToString('\n', this._stdErr, false);
    }

    public String getStdOut() {
        String joinedString = CommonUtils.myToString('\n', this._stdOut, false);
        String trailingNewlinesRemoved = joinedString.replaceAll("\n+$", new String());
        return trailingNewlinesRemoved;
    }

    public List<String> getStdOutList() {
        return this._stdOut;
    }

    public List<String> getStdErrList() {
        return this._stdErr;
    }

    public long getDurationMillis() {
        return this._durationMillis;
    }

    public static List<String> splitStdOutList(List<String> strings) {
        ArrayList<String> result = new ArrayList<String>();
        for (String line : strings) {
            String[] fields;
            String[] stringArray = fields = line.split(", ");
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                String field = stringArray[n2];
                result.add(field);
                ++n2;
            }
        }
        return result;
    }

    public Map<String, String> getEvs() {
        return this._evs;
    }

    private String getEvsString() {
        StringBuffer buffer = new StringBuffer();
        ArrayList<String> keyList = new ArrayList<String>(this._evs.keySet());
        Collections.sort(keyList);
        for (String key : keyList) {
            String value = this._evs.get(key);
            buffer.append(String.valueOf(key) + "=" + value + "|");
        }
        return buffer.toString();
    }

    public String toString() {
        String durationString = this._durationMillis >= 0L ? String.valueOf(this._durationMillis) : new String();
        String dirString = this.getDirectory();
        if (dirString == null) {
            dirString = new String();
        }
        String statString = this.getStat() == UNINITIALIZED ? Messages.CommandResult_UNINITIALIZED_STAT : new Integer(this.getStat()).toString();
        String annotatedStdErr = this.getStdErr();
        if (this.getStdErr().matches("^CreateProcess: (.*?) error=267")) {
            annotatedStdErr = NLS.bind((String)Messages.CommandResult_ANNOTATED_STDERR, (Object)this.getStdErr(), (Object)Messages.CommandResult_CWD_TOO_LONG);
        }
        Object[] bindings = new String[]{annotatedStdErr, this.getStdOut(), CommonUtils.myToString(' ', this.getCommand(), false), dirString, statString, durationString, this.getEvsString()};
        return NLS.bind((String)Messages.CommandResult_COMMAND_INFO, (Object[])bindings);
    }

    public void updateResults(int stat, List<String> stdErr, List<String> stdOut, long durationMillis) {
        this._stat = stat;
        this._stdErr = stdErr;
        this._stdOut = stdOut;
        this._durationMillis = durationMillis;
    }

    public void updateResults(int stat, String stdErrString, String stdOutString, long durationMillis) {
        ArrayList<String> stdErr = null;
        ArrayList<String> stdOut = new ArrayList<String>();
        if (stdErrString != null && stdErrString.length() > 0) {
            stdErr = new ArrayList<String>(1);
            stdErr.add(stdErrString);
        }
        if (stdOutString != null && stdOutString.length() > 0) {
            stdOut = new ArrayList(1);
            stdOut.add(stdOutString);
        }
        this.updateResults(stat, stdErr, stdOut, durationMillis);
    }

    public void updateResults(IOException ioEx) {
        this._ioEx = ioEx;
        this._stdErr = Collections.singletonList(ioEx.getMessage());
        this._stdOut = new ArrayList<String>();
    }

    public void clearEnv() {
        this._evs = NULL_ENV;
    }

    public void assertSuccessNonCT(String installedScmConnectorsPath) throws WvcmException {
        if (this._stat != 0 || this._stdErr != null && !this._stdErr.isEmpty()) {
            String stdError = this.getStdErr();
            if (stdError.contains("crmregister: Error: The specified ClearQuest connection")) {
                this._stdErr.add(NLS.bind((String)Messages.CommandResult_MSG_CHECK_VALUE_OF_PROVIDER_PROPERTY, (Object)CommandResult.getPropertyFriendlyName(CTInitArgUtils.getCQDbsetNameKeyName())));
            }
            if (stdError.contains("crmregister: Error: Unable to locate database")) {
                this._stdErr.add(NLS.bind((String)Messages.CommandResult_MSG_CHECK_VALUE_OF_PROVIDER_PROPERTY, (Object)CommandResult.getPropertyFriendlyName(CTInitArgUtils.getCQUserdbNameKeyName())));
            }
            if (stdError.contains("Invalid Credentials: Either the login name or the password is incorrect.")) {
                String cqLoginName = this.getCQUsername();
                String cqLoginNameKey = CommandResult.getPropertyFriendlyName(CTInitArgUtils.getCQLoginNameKeyName());
                if (cqLoginName == null) {
                    cqLoginName = cqLoginNameKey;
                }
                this._stdErr.add(Messages.CommandResult_MSG_CQ_USERNAME);
                this._stdErr.add(NLS.bind((String)Messages.CommandResult_MSG_CHECK_VALUE_OF_PROVIDER_PROPERTY, (Object)cqLoginNameKey));
                this._stdErr.add(Messages.CommandResult_MSG_CQ_PASSWORD);
                this._stdErr.add(NLS.bind((String)Messages.CommandResult_MSG_CHECK_CQ_PASSWORD_FILE, (Object)cqLoginName));
                this._stdErr.add(CommandResult.computeMsgCqPasswordFile(installedScmConnectorsPath, cqLoginName));
            }
            Object[] bindings = new String[]{this.getCommand().get(0), this.toString()};
            throw new WvcmException(NLS.bind((String)Messages.CommandResult_OPERATION_FAILED_ERROR, (Object[])bindings), WvcmException.ReasonCode.FORBIDDEN);
        }
    }

    public static String getPropertyFriendlyName(String propertyName) {
        String friendlyName = propertyName;
        int nLastSegIndex = propertyName.lastIndexOf(INIT_ARGS_SEGMENT_SEPARATOR);
        if (nLastSegIndex > 0 && nLastSegIndex < propertyName.length()) {
            friendlyName = propertyName.substring(nLastSegIndex + 1);
        }
        return friendlyName;
    }

    private String getCQUsername() {
        String username = null;
        List<String> command = this.getCommand();
        int index = command.indexOf(_USERNAME);
        if (index != -1 && index != command.size() - 1) {
            username = command.get(index + 1);
        }
        return username;
    }

    public static String computeMsgCqPasswordFile(String passwordFolderPath, String cqLoginName) {
        return NLS.bind((String)Messages.CommandResult_MSG_CQ_PASSWORD_FILE, (Object)passwordFolderPath, (Object)cqLoginName);
    }

    public static class ResultBehaviorFlags {
        private boolean notFoundOK = false;
        private boolean noViewInfoOK = false;
        private boolean vobNotFoundWarn = false;
        private boolean ntTypeSidNotSupportedWarn = false;
        private boolean troubleFindingGlobalDefinition = false;
        private boolean notFoundImpliesBackslashInNameOnWindows = false;
        private SrvcFeedback feedback = null;

        ResultBehaviorFlags(SrvcFeedback feedback, Kind ... flagKinds) {
            this(flagKinds);
            this.feedback = feedback;
        }

        public ResultBehaviorFlags(Kind ... flagKinds) {
            Kind[] kindArray = flagKinds;
            int n = flagKinds.length;
            int n2 = 0;
            while (n2 < n) {
                Kind flagKind = kindArray[n2];
                switch (flagKind) {
                    case IGNORE_NOT_FOUND: {
                        this.notFoundOK = true;
                        break;
                    }
                    case IGNORE_NO_VIEW_INFO: {
                        this.noViewInfoOK = true;
                        break;
                    }
                    case WARN_VOB_NOT_FOUND: {
                        this.vobNotFoundWarn = true;
                        break;
                    }
                    case WARN_NTTYPE_SID_NOT_SUPPORTED: {
                        this.ntTypeSidNotSupportedWarn = true;
                        break;
                    }
                    case NOT_FOUND_IMPLIES_BACKSLASH_IN_NAME_ON_WINDOWS: {
                        if (!CommandProvider.IS_WINDOWS) break;
                        this.notFoundImpliesBackslashInNameOnWindows = true;
                        break;
                    }
                    case TROUBLE_FINDING_GLOBAL_DEFINITION: {
                        this.troubleFindingGlobalDefinition = true;
                    }
                }
                ++n2;
            }
        }

        public final boolean notFoundOK() {
            return this.notFoundOK;
        }

        public final boolean noViewInfoOK() {
            return this.noViewInfoOK;
        }

        public final boolean vobNotFoundWarn() {
            return this.vobNotFoundWarn;
        }

        public final boolean ntTypeSidNotSupportedWarn() {
            return this.ntTypeSidNotSupportedWarn;
        }

        public final boolean troubleFindingGlobalDefinition() {
            return this.troubleFindingGlobalDefinition;
        }

        public final boolean notFoundImpliesBackslashInNameOnWindows() {
            return this.notFoundImpliesBackslashInNameOnWindows;
        }

        private List<Kind> flags() {
            ArrayList<Kind> kinds = new ArrayList<Kind>();
            if (this.notFoundOK()) {
                kinds.add(Kind.IGNORE_NOT_FOUND);
            }
            if (this.noViewInfoOK()) {
                kinds.add(Kind.IGNORE_NO_VIEW_INFO);
            }
            if (this.vobNotFoundWarn()) {
                kinds.add(Kind.WARN_VOB_NOT_FOUND);
            }
            if (this.ntTypeSidNotSupportedWarn()) {
                kinds.add(Kind.WARN_NTTYPE_SID_NOT_SUPPORTED);
            }
            if (this.troubleFindingGlobalDefinition()) {
                kinds.add(Kind.TROUBLE_FINDING_GLOBAL_DEFINITION);
            }
            if (this.notFoundImpliesBackslashInNameOnWindows()) {
                kinds.add(Kind.NOT_FOUND_IMPLIES_BACKSLASH_IN_NAME_ON_WINDOWS);
            }
            return kinds;
        }

        public final ResultBehaviorFlags subtract(Kind flagKind) {
            ArrayList<Kind> kinds = new ArrayList<Kind>(this.flags());
            kinds.remove((Object)flagKind);
            return new ResultBehaviorFlags(this.feedback, kinds.toArray(new Kind[0]));
        }

        public static enum Kind {
            IGNORE_NOT_FOUND,
            IGNORE_NO_VIEW_INFO,
            WARN_VOB_NOT_FOUND,
            WARN_NTTYPE_SID_NOT_SUPPORTED,
            NOT_FOUND_IMPLIES_BACKSLASH_IN_NAME_ON_WINDOWS,
            TROUBLE_FINDING_GLOBAL_DEFINITION;

        }
    }

    static enum ResultErrorKind {
        COMPONENT_NOT_FOUND,
        OTHER_NOT_FOUND,
        NO_VIEW_INFO,
        OTHER_ERROR;

    }
}

