/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CTDoRead;
import com.ibm.rational.wvcm.ct.CTInitArgUtils;
import com.ibm.rational.wvcm.ct.CommandResult;
import com.ibm.rational.wvcm.ct.CommonUtils;
import com.ibm.rational.wvcm.ct.Messages;
import com.ibm.rational.wvcm.interop.InteropCore;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.wvcm.WvcmException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.osgi.util.NLS;

public class CommandProvider {
    private static final String TRUE;
    private static final String NOTIFY_DURATION_AND_CMD = "com.ibm.rational.wvcm.ct.CommandProvider.doNotifyDurationAndCmd";
    private static boolean _notifyDurationAndCmd;
    public static final String SPACE;
    public static final boolean IS_WINDOWS;
    Log _log = null;
    Map<String, String> _initArgs = null;
    final String _initialDirectory = System.getProperty("user.dir");
    private static final String RATL_UNIX_BASE = "/opt/rational";
    private static final String CT_EXECUTABLE = "cleartool";
    private static final String CP_EXECUTABLE = "clearprompt";
    public static String CT;
    protected static final String CRMREGISTER;
    protected static String CP;
    private static final String MVFSLOG = "mvfslog.exe";
    protected static final String MVFSSTORAGE;
    private static final String DEBUG = "debug";
    private static final String ERROR = "error";
    private static final String RATLPERL_OP_WIN = "ratlperl.exe";
    private static final String RATLPERL_OP_UNIX = "/opt/rational/common/bin/ratlperl";
    private static final String CQPERL_INC_UNIX = "/opt/rational/clearquest/shlib";
    private static String CQPERL_INC;
    private static final String CCHOME_EV = "CLEARCASEHOME";
    private static final String BIN = "bin";
    private static final String ALL_STARS = "*****";
    private static final String CCASE_WORK_ITEM_EV = "CCASE_JAZZ_WORK_ITEMS";
    private static final String CLEARCASE_TRACE_TRIGGERS_EV = "CLEARCASE_TRACE_TRIGGERS";
    private static AtomicInteger g_cumulativeWaitedCount;
    private static AtomicLong g_cumulativeWaitedTimeMillis;
    public static int FEEDBACK_DELAY_NO_CMD_FEEDBACK;
    public static int FEEDBACK_DELAY_NONE;
    private int _feedbackDelayMilliseconds;
    private static boolean CLEARCASE_AVAILABILITY_CHECKED;
    private static final Pattern p1;
    private static final Pattern p2;
    private static final String r2 = "$1$1\\\\\\\"";
    private static final Pattern p3;
    private static final String r3 = "$1$1";

    static {
        String ccHome;
        TRUE = Boolean.TRUE.toString();
        _notifyDurationAndCmd = TRUE.equals(System.getProperty(NOTIFY_DURATION_AND_CMD));
        SPACE = String.valueOf(' ');
        IS_WINDOWS = System.getProperty("os.name").contains("Windows");
        CT = IS_WINDOWS ? CT_EXECUTABLE : "/opt/rational/clearcase/bin/cleartool";
        CRMREGISTER = IS_WINDOWS ? "crmregister" : "/opt/rational/clearcase/bin/crmregister";
        CP = IS_WINDOWS ? CP_EXECUTABLE : "/opt/rational/clearcase/bin/clearprompt";
        MVFSSTORAGE = IS_WINDOWS ? "mvfsstorage.exe" : "/opt/rational/clearcase/etc/mvfsstorage";
        CQPERL_INC = null;
        g_cumulativeWaitedCount = new AtomicInteger(0);
        g_cumulativeWaitedTimeMillis = new AtomicLong(0L);
        if (!IS_WINDOWS && (ccHome = System.getenv(CCHOME_EV)) != null) {
            String newCT = null;
            newCT = ccHome.endsWith(CommonUtils.FWDSLASH) ? String.valueOf(ccHome) + BIN + CommonUtils.FWDSLASH + CT_EXECUTABLE : String.valueOf(ccHome) + CommonUtils.FWDSLASH + BIN + CommonUtils.FWDSLASH + CT_EXECUTABLE;
            File file = new File(newCT);
            if (file.isFile()) {
                CT = newCT;
            }
        }
        FEEDBACK_DELAY_NO_CMD_FEEDBACK = -1;
        FEEDBACK_DELAY_NONE = 0;
        CLEARCASE_AVAILABILITY_CHECKED = false;
        p1 = Pattern.compile("[ \t\\\\\\\"]");
        p2 = Pattern.compile("(\\\\*)\"");
        p3 = Pattern.compile("(\\\\+)\\z");
    }

    public CommandProvider(int feedbackDelayMilliseconds, Map<String, String> initArgs) throws WvcmException {
        this._feedbackDelayMilliseconds = feedbackDelayMilliseconds;
        this._initArgs = initArgs;
        if (this._initArgs == null) {
            this._initArgs = new HashMap<String, String>();
        }
        if (CLEARCASE_AVAILABILITY_CHECKED) {
            return;
        }
        try {
            new ProcessBuilder(CT, "quit").start();
            CLEARCASE_AVAILABILITY_CHECKED = true;
        }
        catch (IOException ioe) {
            String localHostName = new String();
            try {
                InetAddress localHost = InetAddress.getLocalHost();
                localHostName = localHost.getHostName();
            }
            catch (UnknownHostException uhe) {
                String message = IS_WINDOWS ? Messages.CommandProvider_UNABLE_TO_EXECUTE_CLEARTOOL_WINDOWS : Messages.CommandProvider_UNABLE_TO_EXECUTE_CLEARTOOL_UNIX;
                throw new WvcmException(NLS.bind((String)message, (Object)localHostName), WvcmException.ReasonCode.NOT_FOUND);
            }
            String message = IS_WINDOWS ? Messages.CommandProvider_UNABLE_TO_EXECUTE_CLEARTOOL_ON_LOCALHOST_WINDOWS : Messages.CommandProvider_UNABLE_TO_EXECUTE_CLEARTOOL_ON_LOCALHOST_UNIX;
            throw new WvcmException(message, WvcmException.ReasonCode.NOT_FOUND);
        }
    }

    public static boolean getNotifyDurationAndCmd() {
        return _notifyDurationAndCmd;
    }

    public static boolean setNotifyDurationAndCmd(boolean newValue) {
        boolean oldValue = _notifyDurationAndCmd;
        _notifyDurationAndCmd = newValue;
        return oldValue;
    }

    public String execute(SrvcFeedback feedback, String ... cleartoolArgs) throws WvcmException {
        CommandResult.ResultBehaviorFlags ignoreFlags = new CommandResult.ResultBehaviorFlags(CommandResult.ResultBehaviorFlags.Kind.IGNORE_NO_VIEW_INFO);
        return this.execute(feedback, null, ignoreFlags, cleartoolArgs);
    }

    public String execute(SrvcFeedback feedback, String workingDirectory, CommandResult.ResultBehaviorFlags flags, String ... cleartoolArgs) throws WvcmException {
        CommandResult r = this.executeGetResult(feedback, workingDirectory, Arrays.asList(cleartoolArgs));
        r.assertSuccess(flags);
        return r.getStdOut();
    }

    public String execute(SrvcFeedback feedback, List<String> cleartoolArgs) throws WvcmException {
        CommandResult.ResultBehaviorFlags ignoreFlags = new CommandResult.ResultBehaviorFlags(CommandResult.ResultBehaviorFlags.Kind.IGNORE_NO_VIEW_INFO);
        return this.execute(feedback, null, ignoreFlags, cleartoolArgs.toArray(new String[cleartoolArgs.size()]));
    }

    public CommandResult executeGetResult(SrvcFeedback feedback, String ... cleartoolArgs) throws WvcmException {
        return this.executeGetResult(feedback, null, Arrays.asList(cleartoolArgs));
    }

    public CommandResult executeGetResult(SrvcFeedback feedback, List<String> cleartoolArgs) throws WvcmException {
        return this.executeGetResult(feedback, cleartoolArgs.toArray(new String[cleartoolArgs.size()]));
    }

    public List<String> executeGetValues(SrvcFeedback feedback, String ... cleartoolArgs) throws WvcmException {
        CommandResult.ResultBehaviorFlags ignoreFlags = new CommandResult.ResultBehaviorFlags(CommandResult.ResultBehaviorFlags.Kind.IGNORE_NO_VIEW_INFO);
        return this.executeGetValues(feedback, null, ignoreFlags, cleartoolArgs);
    }

    public List<String> executeGetValues(SrvcFeedback feedback, List<String> cleartoolArgs) throws WvcmException {
        return this.executeGetValues(feedback, cleartoolArgs.toArray(new String[cleartoolArgs.size()]));
    }

    public List<String> executeGetValues(SrvcFeedback feedback, String workingDirectory, CommandResult.ResultBehaviorFlags flags, String ... cleartoolArgs) throws WvcmException {
        CommandResult r = this.executeGetResult(feedback, workingDirectory, Arrays.asList(cleartoolArgs));
        r.assertSuccess(flags);
        return r.getStdOutList();
    }

    public int getCleartoolWaitedCount() {
        return g_cumulativeWaitedCount.get();
    }

    public long getCleartoolWaitedTimeMillis() {
        return g_cumulativeWaitedTimeMillis.get();
    }

    private Log getLog() {
        if (this._log == null) {
            this._log = LogFactory.getLog((String)CommandProvider.class.getName());
        }
        return this._log;
    }

    CommandResult executeGetResult(SrvcFeedback feedback, String workingDirectory, List<String> cleartoolArgs) throws WvcmException {
        ArrayList<String> command = new ArrayList<String>(cleartoolArgs.size() + 1);
        command.add(CT);
        command.addAll(cleartoolArgs);
        return this.executeCommand(feedback, workingDirectory, command, Collections.EMPTY_LIST);
    }

    public CommandResult executeNonCTGetResult(String workingDirectory, List<String> cmdAndArgs, SrvcFeedback feedback) throws WvcmException {
        return this.executeCommand(feedback, workingDirectory, cmdAndArgs, Collections.EMPTY_LIST);
    }

    public String executeRatlPerl(String installedScmConnectorsPath, SrvcFeedback feedback, List<String> args) throws WvcmException {
        ArrayList<String> maskArgs = new ArrayList<String>();
        maskArgs.add("-password");
        return this.executeRatlPerl(installedScmConnectorsPath, feedback, args, maskArgs);
    }

    public String executeRatlPerl(String installedScmConnectorsPath, SrvcFeedback feedback, List<String> args, List<String> maskArgs) throws WvcmException {
        ArrayList<String> command = new ArrayList<String>(args.size() + 2);
        command.add(this.getRatlPerl(feedback));
        if (!IS_WINDOWS) {
            command.add(CommandProvider.getCQPerlIncludePath());
        }
        command.addAll(args);
        CommandResult r = this.executeCommand(feedback, null, command, maskArgs);
        r.assertSuccessNonCT(installedScmConnectorsPath);
        return r.getStdOut();
    }

    public String getRatlPerl(SrvcFeedback feedback) throws WvcmException {
        String ratlperl = RATLPERL_OP_WIN;
        if (!IS_WINDOWS) {
            ratlperl = RATLPERL_OP_UNIX;
        }
        return ratlperl;
    }

    private static String getCQPerlIncludePath() {
        if (CQPERL_INC == null) {
            CQPERL_INC = IS_WINDOWS ? new String() : "-I/opt/rational/clearquest/shlib";
        }
        return CQPERL_INC;
    }

    protected CommandResult executeCommand(SrvcFeedback feedback, String workingDirectory, List<String> command, List<String> maskArgs) throws WvcmException {
        return this.executeCommand(feedback, workingDirectory, command, maskArgs, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommandResult executeCommand(final SrvcFeedback feedback, String workingDirectory, List<String> command, List<String> maskArgs, boolean displayUI) throws WvcmException {
        String wDir;
        ArrayList<String> cmdList = new ArrayList<String>(command.size());
        cmdList.addAll(command);
        for (String maskArg : maskArgs) {
            int index = cmdList.indexOf(maskArg);
            if (index == -1 || index == cmdList.size() - 1) continue;
            cmdList.set(index + 1, ALL_STARS);
        }
        if (this.getLog().isDebugEnabled()) {
            String commandStringSanitized = CommonUtils.myToString(SPACE, cmdList, false);
            this.getLog().debug((Object)("starting: " + commandStringSanitized));
        }
        if ((wDir = workingDirectory) == null) {
            wDir = CCaseLib.getDefaultViewDir();
        }
        File dir = null;
        if (wDir != null && !(dir = new File(wDir)).exists()) {
            dir = null;
            wDir = null;
        }
        List<String> escapedCommand = command;
        if (IS_WINDOWS) {
            escapedCommand = new ArrayList<String>();
            for (String token : command) {
                escapedCommand.add(this.escapeCommand(token));
            }
        }
        long start = System.nanoTime();
        ProcessBuilder pb = new ProcessBuilder(escapedCommand);
        pb.directory(dir);
        Map<String, String> evs = pb.environment();
        if (IS_WINDOWS) {
            evs.put("NLSPATH", "C:\\");
            evs.put("LANG", "C");
        } else {
            evs.remove("NLSPATH");
        }
        evs.put("CONNECTOR_SYNCH", "1");
        if (!displayUI) {
            evs.put("ATRIA_WEB_GUI", "1");
        }
        evs.remove(CCASE_WORK_ITEM_EV);
        String workItemIds = System.getProperty(InteropCore.PN_TASK_IDS.toString());
        if (workItemIds != null) {
            evs.put(CCASE_WORK_ITEM_EV, workItemIds);
        }
        if (CTInitArgUtils.traceTriggers(this._initArgs)) {
            evs.put(CLEARCASE_TRACE_TRIGGERS_EV, "true");
        }
        CommandResult result = new CommandResult(wDir, cmdList, evs);
        try {
            ArrayList<String> finalStderr;
            ArrayList<String> finalStdout;
            InputStreamReader errorStreamReader;
            InputStreamReader inputStreamReader;
            Process child = pb.start();
            InputStreamReader inStream = inputStreamReader = this.createInputStreamReader(child.getInputStream());
            InputStreamReader erStream = errorStreamReader = this.createInputStreamReader(child.getErrorStream());
            CTDoReadException readStdOutEx = new CTDoReadException();
            CTDoReadException readStdErrEx = new CTDoReadException();
            List<String> _stdOut = Collections.synchronizedList(new ArrayList());
            List<String> _stdErr = Collections.synchronizedList(new ArrayList());
            CTDoRead osRead = new CTDoRead(inStream, readStdOutEx, _stdOut);
            CTDoRead erRead = new CTDoRead(erStream, readStdErrEx, _stdErr);
            Thread errReader = new Thread(erRead);
            errReader.start();
            Thread stdReader = new Thread(osRead);
            stdReader.start();
            Timer feedbackTimer = null;
            if (feedback != null) {
                String commandStringForFeedback;
                String string = commandStringForFeedback = this._feedbackDelayMilliseconds == FEEDBACK_DELAY_NO_CMD_FEEDBACK ? null : CommonUtils.myToString(SPACE, cmdList, false, 200);
                if (this._feedbackDelayMilliseconds == FEEDBACK_DELAY_NONE) {
                    feedback.notifyActive(commandStringForFeedback);
                } else if (this._feedbackDelayMilliseconds != FEEDBACK_DELAY_NO_CMD_FEEDBACK) {
                    feedbackTimer = new Timer("feedback Timer");
                    feedbackTimer.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            feedback.notifyActive(commandStringForFeedback);
                        }
                    }, this._feedbackDelayMilliseconds);
                }
            }
            int rval = child.waitFor();
            if (feedbackTimer != null) {
                feedbackTimer.cancel();
            }
            Thread thread = stdReader;
            synchronized (thread) {
                while (stdReader.isAlive()) {
                    stdReader.wait();
                }
            }
            thread = errReader;
            synchronized (thread) {
                while (errReader.isAlive()) {
                    errReader.wait();
                }
            }
            long completion = System.nanoTime();
            long durationMillis = (completion - start) / 1000000L;
            g_cumulativeWaitedCount.getAndIncrement();
            g_cumulativeWaitedTimeMillis.addAndGet(durationMillis);
            List<String> list = _stdOut;
            synchronized (list) {
                finalStdout = new ArrayList<String>(_stdOut);
                _stdOut.clear();
            }
            List<String> list2 = _stdErr;
            synchronized (list2) {
                finalStderr = new ArrayList<String>(_stdErr);
                _stdErr.clear();
            }
            result.updateResults(rval, finalStderr, finalStdout, durationMillis);
            if (readStdOutEx.ex != null) {
                throw new WvcmException(NLS.bind((String)Messages.CommandProvider_ERROR_READING_STDOUT, (Object)result.getCommand().get(0), (Object)result.toString()), null, WvcmException.ReasonCode.FORBIDDEN, readStdOutEx.ex);
            }
            if (readStdErrEx.ex != null) {
                throw new WvcmException(NLS.bind((String)Messages.CommandProvider_ERROR_READING_STDERR, (Object)result.getCommand().get(0), (Object)result.toString()), null, WvcmException.ReasonCode.FORBIDDEN, readStdErrEx.ex);
            }
            if (feedback != null && _notifyDurationAndCmd) {
                feedback.notifyCompleted(String.format("%s duration milli's: %d : %s", command.get(0), durationMillis, CommonUtils.myToString(SPACE, cmdList, false)));
            }
        }
        catch (IOException ioEx) {
            result.updateResults(ioEx);
        }
        catch (InterruptedException iexc) {
            iexc.printStackTrace();
        }
        if (!CTInitArgUtils.getDumpEnv(this._initArgs)) {
            result.clearEnv();
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)result.toString());
        }
        return result;
    }

    private InputStreamReader createInputStreamReader(InputStream inputStream) {
        Charset charset = Charset.defaultCharset();
        try {
            String charsetName = this._initArgs.get(CTInitArgUtils.getCharSetForCommandsKeyName());
            if (charsetName != null) {
                charset = Charset.forName(charsetName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new InputStreamReader(inputStream, charset.newDecoder().onUnmappableCharacter(CodingErrorAction.REPORT).onMalformedInput(CodingErrorAction.REPORT));
    }

    public String escapeCommand(String s) {
        String result = s;
        Matcher m1 = p1.matcher(s);
        if (result.length() == 0 || m1.find()) {
            Matcher m2 = p2.matcher(result);
            result = m2.replaceAll(r2);
            Matcher m3 = p3.matcher(result);
            result = m3.replaceAll(r3);
            result = "\"" + result + "\"";
        }
        return result;
    }

    public String executeCrmRegister(String installedScmConnectorsPath, SrvcFeedback feedback, List<String> args) throws WvcmException {
        ArrayList<String> maskArgs = new ArrayList<String>();
        maskArgs.add("-password");
        return this.executeCrmRegister(installedScmConnectorsPath, feedback, args, maskArgs);
    }

    public String executeCrmRegister(String installedScmConnectorsPath, SrvcFeedback feedback, List<String> args, List<String> maskArgs) throws WvcmException {
        ArrayList<String> command = new ArrayList<String>(args.size() + 1);
        command.add(CRMREGISTER);
        command.addAll(args);
        CommandResult r = this.executeCommand(feedback, null, command, maskArgs);
        r.assertSuccessNonCT(installedScmConnectorsPath);
        return r.getStdOut();
    }

    public static String getCT() {
        return CT;
    }

    public List<String> executeMvfsLog(SrvcFeedback feedback) throws WvcmException {
        this.executeMvfsLogDebug(feedback);
        return this.executeMvfsLogError(feedback).getStdOutList();
    }

    private CommandResult executeMvfsLogDebug(SrvcFeedback feedback) throws WvcmException {
        CommandResult r = this.executeCommand(feedback, null, Arrays.asList(MVFSLOG, DEBUG), new ArrayList<String>());
        r.assertSuccessNonCT(null);
        return r;
    }

    private CommandResult executeMvfsLogError(SrvcFeedback feedback) throws WvcmException {
        CommandResult r = this.executeCommand(feedback, null, Arrays.asList(MVFSLOG, ERROR), new ArrayList<String>());
        r.assertSuccessNonCT(null);
        return r;
    }

    public CommandResult executeCTGraphical(SrvcFeedback feedback, String ... cleartoolArgs) throws WvcmException {
        ArrayList<String> command = new ArrayList<String>(cleartoolArgs.length + 1);
        command.add(CT);
        command.addAll(Arrays.asList(cleartoolArgs));
        return this.executeCommand(feedback, null, command, Collections.EMPTY_LIST, true);
    }

    public static class CTDoReadException {
        public volatile Throwable ex = null;
    }
}

