/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CCaseObjInfo;
import com.ibm.rational.wvcm.ct.CTActivity;
import com.ibm.rational.wvcm.ct.CTBaseline;
import com.ibm.rational.wvcm.ct.CTComponent;
import com.ibm.rational.wvcm.ct.CTLocation;
import com.ibm.rational.wvcm.ct.CTProvider;
import com.ibm.rational.wvcm.ct.CTResource;
import com.ibm.rational.wvcm.ct.CTVOB;
import com.ibm.rational.wvcm.ct.CTView;
import com.ibm.rational.wvcm.ct.CommonUtils;
import com.ibm.rational.wvcm.ct.Messages;
import com.ibm.rational.wvcm.ct.ObjSelUtils;
import com.ibm.rational.wvcm.interop.InteropCore;
import com.ibm.rational.wvcm.interop.UcmImporter;
import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.impl.StreamImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.wvcm.Activity;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.Stream;
import javax.wvcm.WvcmException;

public class CTStream
extends CTActivity {
    private static final String PROJECT_PREFIX = "project_";
    private Map<String, CCaseObjInfo> _blObjInfoCache = new HashMap<String, CCaseObjInfo>();

    CTStream(Location location, CTProvider provider) {
        super(location, provider);
    }

    @Override
    public Class<?> get_proxyClass() {
        return StreamImpl.class;
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    protected Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        CCaseLib cc = this.provider().getCCaseLib();
        if (propertyName.equals((Object)Activity.LATEST_VERSION_LIST)) {
            return this.doGetBaselines(feedback);
        }
        if (propertyName.equals((Object)Resource.PATHNAME_LOCATION)) {
            String result = this.getSelector(feedback);
            return CTLocation.valueOf(CTLocation.Kind.STREAM, result);
        }
        if (propertyName.equals((Object)Resource.DISPLAY_NAME)) {
            return cc.getDisplayName(this.location().getDisplayName(), feedback);
        }
        if (propertyName.equals(CTProvider.FULLY_QUALIFIED_DISPLAY_NAME)) {
            String dispName = this.location().getDisplayName();
            String streamSel = cc.getExtendedName(null, dispName, feedback);
            if (streamSel != null) {
                streamSel = ObjSelUtils.formatSelectorNoKind(streamSel);
            }
            return streamSel;
        }
        if (propertyName.equals((Object)Stream.SOURCE_LIST)) {
            CTProvider p = this.provider();
            String dispName = this.location().getDisplayName();
            String FQName = cc.getExtendedName(null, dispName, feedback);
            List<CTLocation> locations = this.findUcmObjLocations(FQName, false, feedback);
            return p.getResources(locations, feedback);
        }
        if (propertyName.equals((Object)UcmImporter.PN_UCM_ORIGIN)) {
            CTProvider p = this.provider();
            String dispName = this.location().getDisplayName();
            String FQName = cc.getExtendedName(null, dispName, feedback);
            String vobSelector = ObjSelUtils.getObjSelVobSel(FQName);
            CTLocation loc = CTLocation.valueOf(CTLocation.Kind.VOBCOMPONENT, ObjSelUtils.formatSelector("vob", vobSelector));
            return CTVOB.lookup(loc, p);
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    public String getSelector(SrvcFeedback feedback) throws WvcmException {
        CCaseObjInfo ccInfo = this.getObjInfo(feedback);
        String vobUuidString = ccInfo.lookupVobUuid();
        if (vobUuidString == null) {
            throw new IllegalStateException("get pathname location property for location: " + this.location().string() + " could not get VOB UUID");
        }
        String result = ObjSelUtils.formatSelector("stream", ccInfo.getPathName(), vobUuidString);
        return result;
    }

    @Override
    public void setPropertyFromClient(PropertyNameList.PropertyName<?> propertyName, Object value, boolean initialize, SrvcFeedback feedback) throws WvcmException {
        super.setPropertyFromClient(propertyName, value, initialize, feedback);
        if (propertyName.equals((Object)InteropCore.PN_RESERVED_FOR_INTEROP)) {
            this.provider().getCCaseLib().reserve(this.getSelectorToLock(feedback), feedback);
        }
    }

    @Override
    public void removePropertyFromClient(PropertyNameList.PropertyName<?> propertyName, SrvcFeedback feedback) throws WvcmException {
        super.removePropertyFromClient(propertyName, feedback);
        if (propertyName.equals((Object)InteropCore.PN_RESERVED_FOR_INTEROP)) {
            this.provider().getCCaseLib().unlock(this.getSelectorToLock(feedback), feedback);
        }
    }

    private CCaseObjInfo getBlObjInfo(String blName, SrvcFeedback feedback) throws WvcmException {
        CCaseObjInfo result;
        boolean foundInCache = this._blObjInfoCache.containsKey(blName);
        if (!foundInCache) {
            result = CCaseObjInfo.getObjInfo(this.provider().getCCaseLib(), blName, feedback);
            this._blObjInfoCache.put(blName, result);
        } else {
            result = this._blObjInfoCache.get(blName);
        }
        return result;
    }

    public List<CTBaseline> doGetBaselines(SrvcFeedback feedback) throws WvcmException {
        CTProvider provider = this.provider();
        CTLocation myLoc = this.location();
        CCaseLib cc = provider.getCCaseLib();
        List<String> blNames = cc.getLatestRootedBaselines(myLoc.getDisplayName(), feedback);
        ArrayList<CTBaseline> latestBaselines = new ArrayList<CTBaseline>();
        for (String blName : blNames) {
            CCaseObjInfo blObjInfo = this.getBlObjInfo(blName, feedback);
            String blUniversalSelector = blObjInfo.getUniversalSelector();
            CTLocation blLoc = provider.location(blUniversalSelector);
            CTBaseline bl = (CTBaseline)provider.lookup((Location)blLoc, feedback);
            if (bl == null) {
                bl = new CTBaseline((Location)blLoc, provider);
                ((CTProvider.CTFeedback)feedback).setCTResourceCache((Location)blLoc, bl);
            }
            latestBaselines.add(bl);
        }
        return latestBaselines;
    }

    public static CTStream doCreateGeneratedResource(CTProvider provider, CTLocation locationHint, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        CCaseLib cc = provider.getCCaseLib();
        String streamName = CCaseLib.cleanName(locationHint.getDisplayName());
        PropValue targetStreamValue = updates != null ? updates.get(Stream.TARGET) : null;
        CTLocation targetStreamLoc = null;
        if (targetStreamValue != null) {
            targetStreamLoc = (CTLocation)((Object)targetStreamValue.get_value());
            updated.add(Stream.TARGET);
        }
        String targetStreamLocString = targetStreamLoc != null ? targetStreamLoc.getDisplayName() : null;
        boolean isIntegration = false;
        if (targetStreamLocString == null) {
            isIntegration = true;
            String pVobTag = provider.getDefaultPvobTag();
            if (pVobTag == null) {
                String msg = feedback.format(Messages.CTStream_PVOB_UNKNOWN, new Object[]{streamName});
                throw new WvcmException(msg, WvcmException.ReasonCode.CONFLICT);
            }
            String projSel = ObjSelUtils.formatSelector("project", PROJECT_PREFIX + streamName + CommonUtils.uniquifier(), pVobTag);
            cc.makeProject(projSel, null, feedback);
            targetStreamLocString = projSel;
        }
        String streamSelector = cc.makeStream(targetStreamLocString, isIntegration, null, streamName, feedback);
        CTLocation streamLoc = provider.location(streamSelector);
        CTStream result = new CTStream((Location)streamLoc, provider);
        return result;
    }

    public <T extends SrvcResource> void doUpdate(List<T> sources, SrvcFeedback feedback) throws WvcmException {
        CTProvider provider = this.provider();
        CCaseLib cc = provider.getCCaseLib();
        String streamSel = this.getUniversalSelector(feedback);
        for (T source : sources) {
            if (source instanceof CTView) {
                String viewStreamSel = ((CTView)((Object)source)).getStreamSelector(feedback);
                if (!cc.equalObjSels(streamSel, viewStreamSel, feedback)) {
                    throw new IllegalArgumentException("View/stream mismatch");
                }
                this.flush(feedback);
                continue;
            }
            throw new IllegalArgumentException("Source is not a view");
        }
    }

    public void doUnbindAll(SrvcFeedback feedback) throws WvcmException {
        CTProvider provider = this.provider();
        CCaseLib cc = provider.getCCaseLib();
        String streamSel = cc.getExtendedName(null, this.getUniversalSelector(feedback), feedback);
        cc.removeStream(streamSel, feedback);
        this.flush(feedback);
    }

    public CTComponent lookupSingleCompositeInitialFoundationBaseline(CTBaseline[] out_CompositeBaseline, SrvcFeedback feedback) throws WvcmException {
        String componentPSel;
        String rootDir;
        Map.Entry<String, Object> entry;
        CTProvider p = this.provider();
        CCaseLib cc = p.getCCaseLib();
        String selector = this.getUniversalSelector(feedback);
        List<String> initialFoundations = cc.getInitialFoundationBaselines(selector, feedback);
        CTBaseline baseline = null;
        CTResource result = null;
        if (initialFoundations.isEmpty()) {
            Map<String, String> map = cc.getFoundationBaselines(selector, false, feedback);
            if (map.size() == 1) {
                entry = map.entrySet().iterator().next();
                String baselineSel = (String)entry.getValue();
                baseline = CTBaseline.valueOf(p, baselineSel, feedback);
                String compSel = entry.getKey();
                result = CTComponent.valueOf(p, compSel, feedback);
            }
        } else {
            LinkedHashMap<String, List<String>> compositeBls = cc.getAllCompositeBaselines(initialFoundations, feedback);
            if (compositeBls.size() == 1) {
                entry = compositeBls.entrySet().iterator().next();
                baseline = CTBaseline.valueOf(p, entry.getKey(), feedback);
                baseline.setSubBaselineUniversalSelectors((List)entry.getValue(), feedback);
                result = baseline.getComponent(feedback);
            } else {
                Map<String, String> map = cc.getFoundationBaselines(selector, false, feedback);
                if (map.size() == 1) {
                    Map.Entry<String, String> entry2 = map.entrySet().iterator().next();
                    String baselineSel = entry2.getValue();
                    baseline = CTBaseline.valueOf(p, baselineSel, feedback);
                    String compSel = entry2.getKey();
                    result = CTComponent.valueOf(p, compSel, feedback);
                }
            }
        }
        if (result != null && (rootDir = cc.getComponentRootDir(componentPSel = result.getUniversalSelector(feedback), feedback)) != null && !rootDir.isEmpty()) {
            result = null;
            baseline = null;
        }
        if (result != null && out_CompositeBaseline != null) {
            out_CompositeBaseline[0] = baseline;
        }
        return result;
    }

    public static CTStream valueOf(CTProvider p, String streamSelector, SrvcFeedback feedback) throws WvcmException {
        CTLocation streamLoc = CTLocation.valueOf(CTLocation.Kind.STREAM, streamSelector);
        return (CTStream)p.get((Location)streamLoc, feedback);
    }
}

