/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.BaseCcSubVobCompRootInfo;
import com.ibm.rational.wvcm.ct.BaseCcSubVobCompRootInfoMap;
import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CCaseObjInfo;
import com.ibm.rational.wvcm.ct.CCaseVerInfo;
import com.ibm.rational.wvcm.ct.CTElement;
import com.ibm.rational.wvcm.ct.CTLocation;
import com.ibm.rational.wvcm.ct.CTProvider;
import com.ibm.rational.wvcm.ct.CTUcmView;
import com.ibm.rational.wvcm.ct.CTVersion;
import com.ibm.rational.wvcm.ct.CTView;
import com.ibm.rational.wvcm.ct.CommandProvider;
import com.ibm.rational.wvcm.ct.CommonUtils;
import com.ibm.rational.wvcm.ct.Messages;
import com.ibm.rational.wvcm.ct.ObjSelUtils;
import com.ibm.rational.wvcm.ct.Utils;
import com.ibm.rational.wvcm.interop.InteropCore;
import com.ibm.rational.wvcm.interop.InteropUtilities;
import com.ibm.rational.wvcm.ri.impl.ResourceImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcProvider;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.wvcm.ControllableResource;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.WvcmException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.NLS;

public class CTResource
extends SrvcResource {
    protected CTLocation _location;
    public static final SimpleDateFormat CCLongDateFormat = new SimpleDateFormat("yyyyMMdd.HHmmss");
    public static final long MILLI2NANO = 1000000L;
    private CCaseObjInfo _ccObjInfo = null;
    static final List<PropertyNameList.PropertyName<?>> VERSION_HISTORY_PROPERTIES = new ArrayList<PropertyNameList.PropertyName>(Arrays.asList(Resource.CONTENT_TYPE, Resource.CONTENT_CHARACTER_SET, Resource.IS_EXECUTABLE, InteropUtilities.PN_LINE_SEPARATOR));

    protected static void setResourceIdentifier(Resource resource, SrvcFeedback feedback) throws WvcmException {
        ((ResourceImpl)resource).setPropMapProperty(Resource.RESOURCE_IDENTIFIER, (Object)CTResource.getResourceIdentifier((SrvcProvider)resource.provider(), resource.location(), feedback));
    }

    CTResource(Location location, CTProvider provider) {
        if (location == null) {
            throw new IllegalArgumentException("Cannot create a CTResource with a null Location");
        }
        if (provider == null) {
            throw new IllegalArgumentException("Cannot create a CTResource with a null provider");
        }
        try {
            this._location = new CTLocation((CTLocation)location);
        }
        catch (WvcmException e) {
            throw new IllegalArgumentException("Cannot create a CTResource with this location", e);
        }
        this._provider = provider;
    }

    public CTLocation location() {
        return this._location;
    }

    public CTProvider provider() {
        return (CTProvider)this._provider;
    }

    public synchronized CCaseObjInfo getObjInfo(SrvcFeedback feedback) throws WvcmException {
        if (this._ccObjInfo == null) {
            this.setObjInfo(CCaseObjInfo.getObjInfo(this.provider().getCCaseLib(), this.location().getDisplayName(), feedback));
        }
        return this._ccObjInfo;
    }

    public synchronized void setObjInfo(CCaseObjInfo objInfo) {
        this._ccObjInfo = objInfo;
    }

    public synchronized void flush(SrvcFeedback feedback) {
        this.provider().flushPathnameCacheEntries(feedback);
        this.setObjInfo(null);
    }

    public static String getResourceIdentifier(SrvcProvider provider, Location location, SrvcFeedback feedback) throws WvcmException {
        CTProvider p = (CTProvider)provider;
        String locString = ((CTLocation)location).getDisplayName();
        if (ObjSelUtils.isUniversalSelector(locString)) {
            return locString;
        }
        CCaseObjInfo info = CCaseObjInfo.getObjInfo(p.getCCaseLib(), locString, feedback);
        return info.getUniversalSelector();
    }

    private static void repoCommonUtilsCopyInputToOutput(InputStream in, OutputStream out) throws IOException {
        try {
            byte[] bytes = new byte[32768];
            int len = 0;
            while (len > -1) {
                len = in.read(bytes);
                if (len <= 0) continue;
                out.write(bytes, 0, len);
            }
        }
        finally {
            in.close();
        }
    }

    public void readContentInternal(String pathName, OutputStream content, SrvcFeedback feedback) throws WvcmException {
        String nameToUse = this.getPathnameToUse(pathName, feedback);
        this.readContentInternalUsingPathname(nameToUse, content, feedback);
    }

    private String getPathnameToUse(String pathName, SrvcFeedback feedback) throws WvcmException {
        CCaseLib cc = this.provider().getCCaseLib();
        String nameToUse = cc.gpath(pathName, null, feedback);
        return nameToUse;
    }

    protected void readContentInternalUsingPathname(String nameToUse, OutputStream content, SrvcFeedback feedback) throws WvcmException {
        try {
            FileInputStream src = null;
            try {
                src = new FileInputStream(nameToUse);
            }
            catch (IOException ioe) {
                if (CommandProvider.IS_WINDOWS) {
                    src = new FileInputStream(this.provider().getCCaseLib().getClrtxtPath(feedback, nameToUse));
                }
                throw ioe;
            }
            CTResource.repoCommonUtilsCopyInputToOutput(src, content);
        }
        catch (IOException exception) {
            throw new WvcmException(NLS.bind((String)Messages.CTResource_READ_FILE_FAILED_ERROR, (Object)nameToUse, (Object)nameToUse), null, WvcmException.ReasonCode.READ_FAILED, (Throwable)exception);
        }
    }

    public List<CTLocation> findUcmObjLocations(String ucmObjSel, boolean children, SrvcFeedback feedback) throws WvcmException {
        ArrayList<CTLocation> results = new ArrayList<CTLocation>();
        CCaseLib cc = this.provider().getCCaseLib();
        List<String> objSels = cc.findUcmObjSels(ucmObjSel, children, feedback);
        for (String objSel : objSels) {
            CTLocation objLoc = ObjSelUtils.getObjSelKind(objSel).equals("stream") ? CTLocation.valueOf(CTLocation.Kind.STREAM, objSel) : CTLocation.valueOf(CTLocation.Kind.FOLDER, objSel);
            results.add(objLoc);
        }
        return results;
    }

    public static String getCustomAttName(PropertyNameList.PropertyName<?> propertyName) {
        return String.valueOf(propertyName.getNamespace()) + '_' + propertyName.getName();
    }

    protected Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.getNamespace() != null) {
            if (propertyName.equals((Object)InteropCore.PN_CLONE)) {
                return null;
            }
            if (propertyName.equals((Object)InteropUtilities.PN_SYMLINK_TARGET_IS_DIR)) {
                throw new WvcmException(NLS.bind((String)Messages.CTResource_ERROR_PROPERTY_NOT_DEFINED, (Object)propertyName.toString()), WvcmException.ReasonCode.PROPERTY_NOT_DEFINED_FOR_RESOURCE);
            }
            CCaseLib cc = this.provider().getCCaseLib();
            return cc.getAttr(CTResource.getCustomAttName(propertyName), this._location.getDisplayName(), feedback);
        }
        if (propertyName.equals((Object)Resource.RESOURCE_IDENTIFIER)) {
            return this.getUniversalSelector(feedback);
        }
        if (propertyName.equals((Object)Resource.PATHNAME_LOCATION)) {
            return this.getPathnameLocation(feedback);
        }
        if (propertyName.equals((Object)Resource.CREATION_DATE)) {
            return this.getCreationDate(feedback);
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    public String getUniversalSelector(SrvcFeedback feedback) throws WvcmException {
        String uuid = this._location.getDisplayName();
        if (uuid == null || !ObjSelUtils.isUniversalSelector(uuid)) {
            uuid = this.getObjInfo(feedback).getUniversalSelector();
        }
        return uuid;
    }

    protected String getObjectSelectorHoldingAttr() throws WvcmException {
        return this._location.getDisplayName();
    }

    public void setPropertyFromClient(PropertyNameList.PropertyName<?> propertyName, Object value, boolean initialize, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.getNamespace() != null) {
            CCaseLib cc = this.provider().getCCaseLib();
            cc.setAttr(CTResource.getCustomAttName(propertyName), this.getObjectSelectorHoldingAttr(), (String)value, !initialize, feedback);
        } else {
            super.setPropertyFromClient(propertyName, value, initialize, feedback);
        }
    }

    public void removePropertyFromClient(PropertyNameList.PropertyName<?> propertyName, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.getNamespace() != null) {
            CCaseLib cc = this.provider().getCCaseLib();
            cc.rmAttrIgnoreExpectedFailures(CTResource.getCustomAttName(propertyName), this.getObjectSelectorHoldingAttr(), feedback);
        } else {
            super.removePropertyFromClient(propertyName, feedback);
        }
    }

    public CTLocation getPathnameLocation(SrvcFeedback feedback) throws WvcmException {
        CTLocation result = CTLocation.valueOf(this.location().getKind(), this.getUniversalSelector(feedback));
        return result;
    }

    private Date getCreationDate(SrvcFeedback feedback) throws WvcmException {
        CCaseObjInfo info = this.getObjInfo(feedback);
        String dateString = info.getCreationDateString();
        try {
            Date result = CCLongDateFormat.parse(dateString);
            return result;
        }
        catch (ParseException e) {
            throw new WvcmException(NLS.bind((String)"internal error: Could not parse {0} as a CC numeric date formatted string", (Object)dateString), WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
        }
    }

    protected void checkinHelper(String comment, ControllableResource.CheckinFlag[] flags, List<String> checkouts, String viewTag, SrvcFeedback feedback) throws WvcmException {
        CTProvider provider = this.provider();
        CCaseLib cc = provider.getCCaseLib();
        if (checkouts.size() > 0) {
            boolean identicalOK = false;
            if (flags != null) {
                identicalOK = Arrays.asList(flags).contains(ControllableResource.CheckinFlag.CHECKIN_IDENTICAL);
            }
            cc.checkin(identicalOK, comment, checkouts, feedback);
            this.flush(feedback);
        }
    }

    protected void checkinAllHelper(String comment, ControllableResource.CheckinFlag[] flags, List<String> pathnames, String viewTag, SrvcFeedback feedback) throws WvcmException {
        CTProvider provider = this.provider();
        CCaseLib cc = provider.getCCaseLib();
        List<String> checkouts = cc.getCheckouts(pathnames, viewTag, feedback);
        if (checkouts.size() > 0) {
            this.checkinHelper(comment, flags, checkouts, viewTag, feedback);
        }
    }

    public Class<?> get_proxyClass() {
        return ResourceImpl.class;
    }

    public boolean isImmutable() throws WvcmException {
        return false;
    }

    public void clearPathname() {
        if (this._ccObjInfo != null) {
            this._ccObjInfo.clearPathname();
        }
    }

    public static String lookupBaseCcSubVobComponent(CTProvider p, String viewTag, String pathname, SrvcFeedback feedback) throws WvcmException {
        String[] selector = new String[1];
        boolean hasSubVobComponents = CTResource.baseCcComponentSelectorFromGPathLookup(selector, p, viewTag, pathname, feedback);
        String result = hasSubVobComponents && selector[0] != null ? selector[0] : null;
        return result;
    }

    private static BaseCcSubVobCompRootInfoMap computeSubVobPathMap(CTProvider p, String viewTag, String vobTag, String gpath, SrvcFeedback feedback) throws WvcmException {
        if (gpath == null) {
            throw new IllegalArgumentException("gpath must not be null");
        }
        CCaseLib cc = p.getCCaseLib();
        cc.setcsCurrent(viewTag, feedback);
        List<String> results = cc.findElementsWithGivenAttribute(gpath, "com.ibm.rational.interop.ClearCase.subVOB_Component", feedback);
        int resultsCount = results.size();
        BaseCcSubVobCompRootInfoMap map = new BaseCcSubVobCompRootInfoMap(resultsCount);
        ArrayList<IPath> visibleComponentRootIPaths = new ArrayList<IPath>(resultsCount);
        for (String path : results) {
            IPath iPathWithoutVerExt;
            String[] split = path.split("@@");
            boolean isVisibleInView = 1 == split.length;
            IPath iPath = iPathWithoutVerExt = isVisibleInView ? CommonUtils.getIPathWithoutVerExt(path) : null;
            if (iPathWithoutVerExt != null) {
                visibleComponentRootIPaths.add(iPathWithoutVerExt);
            }
            String subVobCompName = cc.getAttr("com.ibm.rational.interop.ClearCase.subVOB_Component", path, feedback);
            BaseCcSubVobCompRootInfo info = new BaseCcSubVobCompRootInfo(path, iPathWithoutVerExt, viewTag, isVisibleInView, subVobCompName);
            map.put(path, info);
        }
        CTResource.ensureNoNestedPaths(visibleComponentRootIPaths, feedback);
        CTResource.validateComponentNames(cc, map, feedback);
        CTResource.warnAboutInvisibleSubvobComps(cc, map, feedback);
        if (resultsCount > 0) {
            boolean headerPrinted = false;
            Map<IPath, CTVersion> rootVersions = CTElement.getRootVersions(p, vobTag, visibleComponentRootIPaths, feedback);
            int visibleResultsCount = 0;
            for (BaseCcSubVobCompRootInfo info : map.values()) {
                if (info.iPathWithoutVerExt == null) continue;
                ++visibleResultsCount;
            }
            for (String path : map.keySet()) {
                BaseCcSubVobCompRootInfo info = (BaseCcSubVobCompRootInfo)map.get(path);
                IPath crPath = info.iPathWithoutVerExt;
                if (crPath == null) continue;
                CTResource version = rootVersions.get(crPath);
                String verPath = version.getUniversalSelector(feedback);
                info.setRootVersionSelector(verPath);
                if (p.alreadyNotified(verPath)) continue;
                if (!headerPrinted) {
                    feedback.notifyActive(NLS.bind((String)Messages.CTResource_SUB_VOB_COMPS_HEADER, (Object)String.valueOf(visibleResultsCount)));
                    headerPrinted = true;
                }
                feedback.notifyActive(crPath.toString());
                p.notified(verPath);
            }
        } else if (!p.alreadyNotified(vobTag)) {
            feedback.notifyActive(NLS.bind((String)Messages.CTResource_INFO_NO_SUB_VOB_COMPS_FOUND, (Object)vobTag));
            p.notified(vobTag);
        }
        return map;
    }

    private static void validateComponentNames(CCaseLib cc, BaseCcSubVobCompRootInfoMap map, SrvcFeedback feedback) throws WvcmException {
        StringBuffer msg = new StringBuffer(Messages.CTResource_ERROR_RENAME_COMPONENTS);
        boolean found = false;
        for (String key : map.keySet()) {
            BaseCcSubVobCompRootInfo info = (BaseCcSubVobCompRootInfo)map.get(key);
            String name = info.name;
            if (!name.contains(CCaseLib.ATSIGN) && !name.contains(CCaseLib.SEMICOLON)) continue;
            msg.append(NLS.bind((String)Messages.CTResource_SPACES_VALUE_COLON_VALUE_NL, (Object)name, (Object)info.elemGPath));
            found = true;
        }
        if (found) {
            throw new WvcmException(msg.toString(), WvcmException.ReasonCode.FORBIDDEN);
        }
    }

    private static void warnAboutInvisibleSubvobComps(CCaseLib cc, BaseCcSubVobCompRootInfoMap map, SrvcFeedback feedback) throws WvcmException {
        if (map.size() < 1) {
            return;
        }
        boolean foundInvisible = false;
        StringBuffer msg = new StringBuffer(Messages.CTResource_INFO_INVISIBLE_COMPONENTS);
        for (String key : map.keySet()) {
            BaseCcSubVobCompRootInfo info = (BaseCcSubVobCompRootInfo)map.get(key);
            if (info.iPathWithoutVerExt != null) continue;
            msg.append(NLS.bind((String)Messages.CTResource_SPACES_VALUE_COLON_VALUE_NL, (Object)info.name, (Object)info.elemGPath));
            foundInvisible = true;
        }
        if (foundInvisible) {
            feedback.notifyCompleted(msg.toString());
        }
    }

    private static void ensureNoNestedPaths(List<IPath> crPaths, SrvcFeedback feedback) throws WvcmException {
        Utils.NestedPair nestedPair = Utils.findNestedPaths(crPaths);
        if (nestedPair != null) {
            throw new WvcmException(NLS.bind((String)Messages.CTControllableResource_ERROR_NESTED_SUB_VOB_COMPS, (Object)nestedPair.nestedPath, (Object)nestedPair.rootPath), WvcmException.ReasonCode.CONFLICT);
        }
    }

    protected static boolean baseCcComponentSelectorFromGPathLookup(String[] out_Selector, CTProvider p, String viewTag, String myPath, SrvcFeedback feedback) throws WvcmException {
        BaseCcSubVobCompRootInfoMap subVobPathMap = CTResource.getSubVobPathMap(p, viewTag, myPath, feedback);
        if (subVobPathMap.isEmpty()) {
            return false;
        }
        IPath myIPath = CommonUtils.getIPathWithoutVerExt(myPath);
        for (String key : subVobPathMap.keySet()) {
            BaseCcSubVobCompRootInfo info = (BaseCcSubVobCompRootInfo)subVobPathMap.get(key);
            IPath path = info.iPathWithoutVerExt;
            if (path == null || !path.isPrefixOf(myIPath)) continue;
            if (info.rootVersionSelector == null) {
                String msg = NLS.bind((String)"component root {0} for path {1} has null root version selector", (Object)info.elemGPath, (Object)myPath);
                throw new IllegalStateException(msg);
            }
            out_Selector[0] = info.rootVersionSelector;
            break;
        }
        return true;
    }

    public static BaseCcSubVobCompRootInfoMap getSubVobPathMap(CTProvider p, String viewTag, String myPath, SrvcFeedback feedback) throws WvcmException {
        String vobTag = p.getCCaseLib().getVobTagFromGpath(myPath, feedback);
        String key = String.valueOf(viewTag) + CommonUtils.FWDSLASH + vobTag;
        BaseCcSubVobCompRootInfoMap subVobPathMap = p.lookupMap(key);
        if (subVobPathMap == null) {
            String absPathIntoVob = String.valueOf(CCaseLib.getPathIntoView(viewTag)) + vobTag;
            subVobPathMap = CTResource.computeSubVobPathMap(p, viewTag, vobTag, absPathIntoVob, feedback);
            p.setMap(key, subVobPathMap);
        }
        return subVobPathMap;
    }

    protected CTView getDefaultUcmView(SrvcFeedback feedback) throws WvcmException {
        CTLocation viewLoc;
        String workspacePathViewTag;
        CTProvider p = this.provider();
        String providerTagForDefaultView = p.getTagForDefaultView();
        CTUcmView result = CTUcmView.valueOf(p, providerTagForDefaultView);
        String viewPath = (String)p.initArgs().get("com.ibm.rational.wvcm.WORKSPACE_LOCATION");
        if (viewPath != null && !providerTagForDefaultView.equals(workspacePathViewTag = (viewLoc = p.location(viewPath)).getViewTag())) {
            throw new IllegalStateException("provider tag for default view ('" + providerTagForDefaultView + "') does not match the tag from the workspace path: " + workspacePathViewTag);
        }
        return result;
    }

    protected String getOwner(SrvcFeedback feedback) throws WvcmException {
        CCaseObjInfo info = this.getObjInfo(feedback);
        String pn = info.getPathName();
        CCaseVerInfo verInfo = null;
        String ownerString = null;
        if (!info.getMtype().equals("derived object") && !info.getMtype().equals("view private object")) {
            verInfo = info instanceof CCaseVerInfo ? (CCaseVerInfo)info : CCaseVerInfo.getVerInfos(info.getCCaseLib(), Collections.singletonList(pn), feedback).get(pn);
            ownerString = verInfo.getOwner();
        }
        if (ownerString == null) {
            throw new WvcmException(NLS.bind((String)"internal error: Could not get owner of path:{0}", (Object)(verInfo != null ? verInfo.getElemPathName() : info.getPathName())), WvcmException.ReasonCode.FORBIDDEN);
        }
        return ownerString;
    }

    public static class CTTimer {
        long _startTime = System.nanoTime();

        public long duration() {
            return (System.nanoTime() - this._startTime) / 1000000L;
        }
    }
}

