/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CommonUtils;
import com.ibm.rational.wvcm.ct.Messages;
import com.ibm.rational.wvcm.ct.ObjSelUtils;
import com.ibm.rational.wvcm.ri.srvc.SrvcLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import javax.wvcm.Location;
import javax.wvcm.WvcmException;
import org.eclipse.osgi.util.NLS;

public class CTLocation
extends SrvcLocation {
    public static final String INFO_SEPARATOR_STRING = String.valueOf('|');
    private static final String GEN_SEPARATOR_STRING = String.valueOf('>');
    public static final String PATHNAME_SEPARATOR_STRING = String.valueOf('/');
    public static final String INFO_SEPARATOR_REGEX = String.valueOf('\\') + INFO_SEPARATOR_STRING;
    private static final String PARTS_SEPARATOR_STRING = "||";
    private static final String PARTS_SEPARATOR_REGEX = "\\|\\|";
    private static final String CTLOCATION_PREFIX = "(CTLocation: ";
    private static final String CONTEXT_PARTS = "(contextParts ";
    private static final String MYKIND = "myKind: ";
    private static final String MYINFO = ".  myInfo: ";
    private static final String CONTEXT_PREFIX = ".  ";
    private static final String NULL = "<null>";
    private Parts _parts;
    public static CTLocation _rootLoc = CTLocation.valueOf(Kind.ROOT_LOCATION, "||");
    public static CTLocation _relativeRootLoc = CTLocation.valueOf(Kind.SYMBOLIC_LINK_TARGET, new String());

    private CTLocation(Parts parts) throws WvcmException {
        super(null);
        this._parts = parts;
    }

    private static CTLocation createCTLocation(Parts parts) {
        CTLocation loc;
        try {
            loc = new CTLocation(parts);
        }
        catch (WvcmException e) {
            throw new RuntimeException("Could not create location", e);
        }
        return loc;
    }

    public CTLocation(CTLocation src) throws WvcmException {
        super(null);
        this._parts = src._parts;
    }

    public static CTLocation valueOf(Kind kind, String displayName) {
        if (kind == null) {
            throw new IllegalArgumentException("Null kind for location");
        }
        if (displayName == null) {
            throw new IllegalArgumentException("The displayname of a location cannot be null");
        }
        Parts myParts = new Parts(kind, displayName);
        CTLocation result = CTLocation.createCTLocation(myParts);
        return result;
    }

    public static CTLocation valueOf(String string) {
        return CTLocation.createCTLocation(new Parts(string));
    }

    public String string() {
        String stringRep = this._string;
        if (stringRep == null) {
            stringRep = this.getParts().string();
            if (!CTLocation.suppressStringCache(this.getParts().get_myKind())) {
                this._string = stringRep;
            }
        }
        return stringRep;
    }

    public String toString() {
        return CTLOCATION_PREFIX + this.string() + ')';
    }

    public int hashCode() {
        if (CTLocation.suppressStringCache(this.getParts().get_myKind())) {
            return this.getParts().hashCode();
        }
        return this.string().hashCode();
    }

    private static boolean suppressStringCache(Kind kind) {
        if (kind == null) {
            return false;
        }
        switch (kind) {
            case CONTROLLABLE_RESOURCE: 
            case SYMBOLIC_LINK_TARGET: 
            case VERSION: 
            case SYMBOLIC_LINK_VERSION: {
                return true;
            }
        }
        return false;
    }

    public CTLocation parent() {
        int lastIndexOf;
        Parts myParts = this.getParts();
        if (this.hasKind(Kind.CONFIGURATION)) {
            return this.lookupContextLocation(Kind.WORKSPACE);
        }
        if (this.hasKind(Kind.WORKSPACE) || this.hasKind(Kind.BASE_CC_VIEW)) {
            return _rootLoc;
        }
        String pathname = myParts.get_myInfo();
        String separator = GEN_SEPARATOR_STRING;
        Kind myKind = myParts.get_myKind();
        if (myKind == Kind.CONTROLLABLE_RESOURCE || myKind == Kind.SYMBOLIC_LINK_TARGET) {
            separator = PATHNAME_SEPARATOR_STRING;
        }
        if ((lastIndexOf = pathname.lastIndexOf(separator)) >= 0) {
            String viewPrefix;
            Kind kind = this.getKind();
            String parentPN = pathname.substring(0, lastIndexOf);
            if (kind == Kind.SYMBOLIC_LINK_TARGET) {
                if (parentPN.length() == 0) {
                    return _relativeRootLoc;
                }
                return CTLocation.valueOf(kind, parentPN);
            }
            HashMap<Kind, CTLocation> context = myParts.get_contextMap();
            String viewTag = ObjSelUtils.getViewTag(CCaseLib.getMvfsRoot(), this.getDisplayName());
            String info = parentPN;
            if (viewTag != null && CCaseLib.compareViewPrefix(parentPN, viewPrefix = CCaseLib.getPathIntoView(viewTag))) {
                info = viewTag;
                kind = Kind.WORKSPACE;
                context = new HashMap<Kind, CTLocation>(context);
                context.remove((Object)Kind.WORKSPACE);
            }
            Parts parentParts = new Parts(kind, info, context);
            return CTLocation.createCTLocation(parentParts);
        }
        return null;
    }

    private synchronized Parts getParts() {
        if (this._parts == null) {
            this._parts = new Parts(this._string);
            if (CTLocation.suppressStringCache(this._parts.get_myKind())) {
                this._string = null;
            }
        }
        return this._parts;
    }

    public final boolean hasKind(Kind kind) {
        if (kind == null) {
            return this.getKind() == null;
        }
        return kind.equals((Object)this.getKind());
    }

    public Location child(String bindingName) throws WvcmException {
        if (bindingName.indexOf(PARTS_SEPARATOR_STRING) != -1) {
            throw new WvcmException(NLS.bind((String)Messages.CTLocation_INVALID_CHILD_NAME_ERROR, (Object)PARTS_SEPARATOR_STRING), WvcmException.ReasonCode.ILLEGAL_LOCATION_SYNTAX);
        }
        if (this.equals((Object)_rootLoc)) {
            return CTLocation.valueOf(Kind.WORKSPACE, bindingName);
        }
        Kind myKind = this._parts.get_myKind();
        if (myKind != null) {
            switch (myKind) {
                case SYMBOLIC_LINK_TARGET: {
                    String name = bindingName;
                    if (this.getDisplayName().length() > 0 || bindingName.length() == 0) {
                        name = String.valueOf(this.getDisplayName()) + PATHNAME_SEPARATOR_STRING + name;
                    }
                    return CTLocation.valueOf(myKind, name);
                }
                case CONTROLLABLE_RESOURCE: {
                    CTLocation viewLoc = this.getViewLocation();
                    Parts resultParts = new Parts(Kind.CONTROLLABLE_RESOURCE, String.valueOf(this.getDisplayName()) + PATHNAME_SEPARATOR_STRING + bindingName);
                    if (viewLoc != null) {
                        resultParts.addContext(viewLoc);
                    }
                    CTLocation result = CTLocation.createCTLocation(resultParts);
                    return result;
                }
                case WORKSPACE: 
                case BASE_CC_VIEW: {
                    String viewTag = this.getViewTag();
                    String path = String.valueOf(CCaseLib.getPathIntoView(viewTag)) + PATHNAME_SEPARATOR_STRING + bindingName;
                    Parts resultParts = new Parts(Kind.CONTROLLABLE_RESOURCE, CommonUtils.canonicalizePathname(path));
                    resultParts.addContext(this);
                    return CTLocation.createCTLocation(resultParts);
                }
                case CONFIGURATION: {
                    throw new WvcmException(Messages.CTLocation_INVALID_CHILD_REQUEST_ERROR, WvcmException.ReasonCode.FORBIDDEN);
                }
            }
        }
        String path = String.valueOf(this.getDisplayName()) + GEN_SEPARATOR_STRING + bindingName;
        return CTLocation.valueOf(path);
    }

    public String lastSegment() {
        int finalSep;
        Parts myParts = this.getParts();
        String myInfo = myParts.get_myInfo();
        Kind myKind = myParts.get_myKind();
        String separator = GEN_SEPARATOR_STRING;
        if (myKind == Kind.CONTROLLABLE_RESOURCE || myKind == Kind.WORKSPACE || myKind == Kind.SYMBOLIC_LINK_TARGET) {
            separator = PATHNAME_SEPARATOR_STRING;
        }
        if ((finalSep = myInfo.lastIndexOf(separator)) == -1) {
            return myInfo;
        }
        return myInfo.substring(finalSep + separator.length());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CTLocation)) {
            return false;
        }
        CTLocation other = (CTLocation)((Object)o);
        Kind myKind = this.getKind();
        Kind otherKind = other.getKind();
        if (myKind != null && otherKind != null && (myKind.equals((Object)Kind.BASE_CC_VIEW) && otherKind.equals((Object)Kind.WORKSPACE) || myKind.equals((Object)Kind.WORKSPACE) && otherKind.equals((Object)Kind.BASE_CC_VIEW))) {
            String myViewTag = this.getDisplayName();
            String otherViewTag = other.getDisplayName();
            return myViewTag.equals(otherViewTag);
        }
        if (this._string != null && other._string != null) {
            return this._string.equals(other._string);
        }
        return this.getParts().equals(other.getParts());
    }

    public static Kind parseKind(String kindString) {
        Kind kind = CTLocation.computeKind(kindString);
        if (kind == null) {
            kind = CTLocation.computeKind(kindString.toUpperCase());
        }
        return kind;
    }

    private static Kind computeKind(String kindString) {
        Kind result;
        try {
            result = Kind.valueOf(kindString);
        }
        catch (IllegalArgumentException e) {
            result = null;
        }
        return result;
    }

    public String getViewTag() {
        Parts myParts = this.getParts();
        String myInfo = myParts.get_myInfo();
        if (this.hasKind(Kind.WORKSPACE) || this.hasKind(Kind.BASE_CC_VIEW)) {
            return myInfo;
        }
        if (myParts._myContext != null) {
            return ((CTLocation)((Object)myParts._myContext.get((Object)Kind.WORKSPACE))).getViewTag();
        }
        throw new IllegalArgumentException("CTLocation.getViewTag() could not get view tag from `" + this.string() + '\'');
    }

    public Kind getKind() {
        Parts myParts = this.getParts();
        Kind myKind = myParts.get_myKind();
        return myKind;
    }

    public static CTLocation createConfigurationLoc(CTLocation workspaceLocation, CTLocation componentLocation) {
        workspaceLocation.requireKind(Kind.WORKSPACE);
        componentLocation.requireKind(Kind.COMPONENT);
        return CTLocation.createJoinedLocation(Kind.CONFIGURATION, workspaceLocation, componentLocation);
    }

    public static CTLocation createBaseConfigurationLoc(CTLocation viewLocation, CTLocation vobLocation) {
        viewLocation.requireKind(Kind.BASE_CC_VIEW);
        vobLocation.requireKind(Kind.VOBCOMPONENT);
        return CTLocation.createJoinedLocation(Kind.CONFIGURATION, viewLocation, vobLocation);
    }

    public static CTLocation createJoinedLocation(Kind kind, CTLocation ... locations) {
        return CTLocation.createJoinedLocation(kind, null, locations);
    }

    public static CTLocation createJoinedLocation(Kind kind, String info, CTLocation ... locations) {
        Parts newParts = new Parts(kind, info);
        CTLocation[] cTLocationArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            CTLocation loc = cTLocationArray[n2];
            newParts.addContext(loc);
            ++n2;
        }
        return CTLocation.createCTLocation(newParts);
    }

    public String getDisplayName() {
        return this.getParts().get_myInfo();
    }

    public void requireKind(Kind kind) {
        this.getParts().requireKind(kind);
    }

    public CTLocation lookupContextLocation(Kind kind) {
        Parts myParts = this.getParts();
        if (myParts == null) {
            return null;
        }
        if (kind.equals((Object)myParts.get_myKind())) {
            return this;
        }
        HashMap<Kind, CTLocation> c = myParts.get_contextMap();
        return c == null ? null : c.get((Object)kind);
    }

    public CTLocation getContextLocation(Kind kind) throws WvcmException {
        CTLocation result = this.lookupContextLocation(kind);
        if (result == null) {
            throw new WvcmException(NLS.bind((String)Messages.CTLocation_MISSING_LOCATION_FOR_KIND_ERROR, (Object)kind.toString(), (Object)this.string()), WvcmException.ReasonCode.FORBIDDEN);
        }
        return result;
    }

    public static String getBrtypeFromInfo(String info) {
        String result = null;
        if (info != null) {
            if (info.contains(INFO_SEPARATOR_STRING)) {
                result = info.substring(0, info.indexOf(INFO_SEPARATOR_STRING));
                if (result.length() == 0) {
                    result = null;
                }
            } else {
                result = info;
            }
        }
        return result;
    }

    public static String getLbtypeFromInfo(String info) {
        String result = null;
        if (info != null && info.contains(INFO_SEPARATOR_STRING) && (result = info.substring(info.indexOf(INFO_SEPARATOR_STRING) + 1)).length() == 0) {
            result = null;
        }
        return result;
    }

    public static CTLocation createBranchLocation(CTLocation brtypeLocation, CTLocation lbtypeLocation) {
        CTLocation location = null;
        if (brtypeLocation != null) {
            brtypeLocation.requireKind(Kind.BRTYPE);
        }
        if (lbtypeLocation != null) {
            lbtypeLocation.requireKind(Kind.LBTYPE);
        }
        if (brtypeLocation != null) {
            if (lbtypeLocation != null) {
                String info = String.valueOf(brtypeLocation.getDisplayName()) + '_' + lbtypeLocation.getDisplayName();
                location = CTLocation.createJoinedLocation(Kind.BRANCH, info, brtypeLocation, lbtypeLocation);
            } else {
                location = CTLocation.createJoinedLocation(Kind.BRANCH, brtypeLocation.getDisplayName(), brtypeLocation);
            }
        } else if (lbtypeLocation != null) {
            location = CTLocation.createJoinedLocation(Kind.BRANCH, lbtypeLocation.getDisplayName(), lbtypeLocation);
        }
        return location;
    }

    public static CTLocation createBaseCCBaselineLocation(CTLocation brtypeLocation, CTLocation lbtypeLocation, CTLocation vobComponentLocation, CTLocation timeStampLocation) {
        CTLocation location = null;
        brtypeLocation.requireKind(Kind.BRTYPE);
        vobComponentLocation.requireKind(Kind.VOBCOMPONENT);
        timeStampLocation.requireKind(Kind.TIMESTAMP);
        String info = "BASECCBL" + timeStampLocation.getDisplayName();
        if (lbtypeLocation != null) {
            lbtypeLocation.requireKind(Kind.LBTYPE);
            location = CTLocation.createJoinedLocation(Kind.BASE_CC_BASELINE, info, brtypeLocation, lbtypeLocation, vobComponentLocation, timeStampLocation);
        } else {
            location = CTLocation.createJoinedLocation(Kind.BASE_CC_BASELINE, info, brtypeLocation, vobComponentLocation, timeStampLocation);
        }
        return location;
    }

    public static CTLocation createBaseViewLocation(String viewTag, CTLocation brtypeLoc, CTLocation lbtypeLoc) {
        Parts newParts = new Parts(Kind.BASE_CC_VIEW, viewTag);
        if (brtypeLoc != null) {
            brtypeLoc.requireKind(Kind.BRTYPE);
            newParts.addContext(brtypeLoc);
        }
        if (lbtypeLoc != null) {
            lbtypeLoc.requireKind(Kind.LBTYPE);
            newParts.addContext(lbtypeLoc);
        }
        CTLocation location = CTLocation.createCTLocation(newParts);
        return location;
    }

    private CTLocation getViewLocation() throws WvcmException {
        CTLocation viewLoc = this.lookupContextLocation(Kind.WORKSPACE);
        if (viewLoc == null) {
            viewLoc = this.lookupContextLocation(Kind.BASE_CC_VIEW);
        }
        return viewLoc;
    }

    public static CTLocation createBaseCCImporterBaselineLocation(CTLocation lbtypeLocation, CTLocation vobComponentLocation) {
        CTLocation location = null;
        lbtypeLocation.requireKind(Kind.LBTYPE);
        vobComponentLocation.requireKind(Kind.VOBCOMPONENT);
        String info = "BASECCBL";
        location = CTLocation.createJoinedLocation(Kind.BASE_CC_BASELINE, info, lbtypeLocation, vobComponentLocation);
        return location;
    }

    public static CTLocation createBaseCCImporterStreamLocation(CTLocation lbtypeLocation) {
        CTLocation location = null;
        lbtypeLocation.requireKind(Kind.BRTYPE);
        String info = lbtypeLocation.getDisplayName();
        location = CTLocation.createJoinedLocation(Kind.BRANCH, info, lbtypeLocation);
        return location;
    }

    public static enum Kind {
        ACTIVITY,
        BASELINE,
        COMPONENT,
        CONFIGURATION,
        CONTROLLABLE_RESOURCE,
        FOLDER,
        ROOT_LOCATION,
        SYMBOLIC_LINK_TARGET,
        STREAM,
        TASK,
        VERSION,
        SYMBOLIC_LINK_VERSION,
        WORKSPACE,
        WORKSPACE_CONFIGURATION,
        BRTYPE,
        LBTYPE,
        BRANCH,
        VOBCOMPONENT,
        TIMESTAMP,
        BASE_CC_BASELINE,
        BASE_CC_VIEW,
        VERSION_IN_SVC,
        ELEMENT_IN_SVC,
        CQTASK;

    }

    private static class Parts {
        private Kind _myKind;
        private String _myInfo;
        private HashMap<Kind, CTLocation> _myContext;

        public Parts(Kind kind, String info) {
            this(kind, info, new HashMap<Kind, CTLocation>());
        }

        public Parts(Kind kind, String info, HashMap<Kind, CTLocation> context) {
            this._myKind = kind;
            this._myInfo = info;
            this._myContext = context != null ? context : new HashMap();
        }

        public Parts(String locationString) {
            if (locationString == null) {
                throw new IllegalArgumentException("Location string must not be null");
            }
            String[] segments = this.getSegments(locationString);
            String[] myInfo = this.getInfoStrings(segments[0]);
            String kindString = myInfo[0];
            Kind myKind = CTLocation.parseKind(kindString);
            if (myKind == null) {
                this._myKind = null;
                this._myInfo = myInfo[0];
                this._myContext = null;
                return;
            }
            String details = myInfo.length > 1 ? myInfo[1] : new String();
            this._myKind = myKind;
            this._myInfo = details;
            this._myContext = new HashMap();
            int i = 1;
            while (i < segments.length) {
                String segment = segments[i];
                String[] infoSegments = this.getSegments(segment);
                String[] segmentInfo = this.getInfoStrings(infoSegments[0]);
                Kind segmentKind = CTLocation.parseKind(segmentInfo[0]);
                String info = segmentInfo.length > 1 ? segmentInfo[1] : new String();
                Parts segmentParts = new Parts(segmentKind, info);
                CTLocation segmentLocation = CTLocation.createCTLocation(segmentParts);
                this.addContext(segmentLocation);
                ++i;
            }
        }

        public String[] getInfoStrings(String segment) throws IllegalArgumentException {
            String[] myInfo = segment.split(INFO_SEPARATOR_REGEX);
            if (myInfo.length < 1) {
                throw new IllegalArgumentException("Could not interpret location string (could not find kind): " + segment);
            }
            return myInfo;
        }

        public String[] getSegments(String locationString) throws IllegalArgumentException {
            String[] segments = locationString.split(CTLocation.PARTS_SEPARATOR_REGEX);
            if (segments.length < 1) {
                throw new IllegalArgumentException("Could not interpret location string: " + locationString);
            }
            return segments;
        }

        public Kind get_myKind() {
            return this._myKind;
        }

        public String get_myInfo() {
            return this._myInfo;
        }

        public void requireKind(Kind expectedKind) {
            if (!this._myKind.equals((Object)expectedKind)) {
                throw new IllegalArgumentException("Expected kind: " + expectedKind.toString() + " actual kind: " + this._myKind.toString());
            }
        }

        public String toString() {
            StringBuffer result = new StringBuffer(CTLocation.CONTEXT_PARTS);
            result.append(CTLocation.MYKIND);
            result.append(this._myKind == null ? "(unspecified)" : this._myKind.toString());
            result.append(CTLocation.MYINFO);
            result.append(this._myInfo == null ? "(null)" : this._myInfo);
            result.append(CTLocation.CONTEXT_PREFIX);
            if (this._myContext == null) {
                result.append(CTLocation.NULL);
            } else {
                result.append(this._myContext.toString());
            }
            result.append(')');
            return result.toString();
        }

        private String string() {
            StringBuffer result = new StringBuffer();
            if (this._myKind != null) {
                result.append(this._myKind.toString());
                if (this.get_myInfo() != null) {
                    result.append(INFO_SEPARATOR_STRING);
                }
            }
            if (this.get_myInfo() != null) {
                result.append(this.get_myInfo());
            }
            if (this._myContext != null) {
                Set<Kind> keySet = this._myContext.keySet();
                ArrayList<Kind> keyList = new ArrayList<Kind>(keySet.size());
                keyList.addAll(keySet);
                Collections.sort(keyList);
                for (Kind contextKind : keyList) {
                    result.append(CTLocation.PARTS_SEPARATOR_STRING);
                    result.append(this._myContext.get((Object)contextKind).string());
                }
            }
            return result.toString();
        }

        public void addContext(CTLocation context) {
            Parts contextParts = context.getParts();
            this._myContext.put(contextParts.get_myKind(), context);
        }

        public HashMap<Kind, CTLocation> get_contextMap() {
            return this._myContext;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Parts)) {
                return false;
            }
            Parts other = (Parts)o;
            if (this._myKind != null ? !this._myKind.equals((Object)other._myKind) : other._myKind != null) {
                return false;
            }
            if (this._myInfo != null ? !this._myInfo.equals(other._myInfo) : other._myInfo != null) {
                return false;
            }
            return !(this._myContext != null ? !this._myContext.equals(other._myContext) : other._myContext != null);
        }

        public int hashCode() {
            int hash = 0;
            if (this._myKind != null) {
                hash += this._myKind.hashCode() << 4;
            }
            if (this._myInfo != null) {
                hash += this._myInfo.hashCode() << 2;
            }
            if (this._myContext != null) {
                hash += this._myContext.hashCode();
            }
            return hash;
        }
    }
}

