/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.BaseCcSubVobCompRootInfo;
import com.ibm.rational.wvcm.ct.BaseCcSubVobCompRootInfoMap;
import com.ibm.rational.wvcm.ct.CCaseElemInfo;
import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CCaseVerInfo;
import com.ibm.rational.wvcm.ct.CTBaseCCView;
import com.ibm.rational.wvcm.ct.CTControllableResource;
import com.ibm.rational.wvcm.ct.CTElement;
import com.ibm.rational.wvcm.ct.CTFolder;
import com.ibm.rational.wvcm.ct.CTFolderVersion;
import com.ibm.rational.wvcm.ct.CTInitArgUtils;
import com.ibm.rational.wvcm.ct.CTLocation;
import com.ibm.rational.wvcm.ct.CTProvider;
import com.ibm.rational.wvcm.ct.CTResource;
import com.ibm.rational.wvcm.ct.CTSymbolicLink;
import com.ibm.rational.wvcm.ct.CTVersion;
import com.ibm.rational.wvcm.ct.CTView;
import com.ibm.rational.wvcm.ct.CommonUtils;
import com.ibm.rational.wvcm.ct.Messages;
import com.ibm.rational.wvcm.ct.ObjSelUtils;
import com.ibm.rational.wvcm.ct.Utils;
import com.ibm.rational.wvcm.ri.impl.ControllableFolderImpl;
import com.ibm.rational.wvcm.ri.impl.ResourceImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.wvcm.ControllableResource;
import javax.wvcm.Folder;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.PropertyRequestItem;
import javax.wvcm.Resource;
import javax.wvcm.WorkspaceProvider;
import javax.wvcm.WvcmException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class CTControllableFolder
extends CTControllableResource {
    public static final String VOB_COLON = "vob:";

    CTControllableFolder(Location location, CTProvider provider) throws WvcmException {
        super(location, provider);
    }

    @Override
    public Class<?> get_proxyClass() {
        return ControllableFolderImpl.class;
    }

    @Override
    public Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Folder.CHILD_MAP)) {
            return this.getChildMap(feedback);
        }
        if (propertyName.equals((Object)Folder.CHILD_LIST)) {
            return this.getChildList(feedback);
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    protected List<SrvcResource> getChildList(SrvcFeedback feedback) throws WvcmException {
        Map<String, SrvcResource> childBindings = null;
        String pathName = this.getPathname(feedback);
        pathName = pathName.startsWith(VOB_COLON) ? pathName.substring(VOB_COLON.length()) : pathName;
        try {
            childBindings = this.processCCDirectory(pathName, feedback);
        }
        catch (WvcmException e) {
            if (e.getReasonCode().equals((Object)WvcmException.ReasonCode.METHOD_NOT_SUPPORTED)) {
                childBindings = this.processFSDirectory(pathName, feedback);
            }
            throw e;
        }
        ArrayList<SrvcResource> results = new ArrayList<SrvcResource>(childBindings.values());
        return results;
    }

    private Map<String, SrvcResource> processCCDirectory(String pathName, SrvcFeedback feedback) throws WvcmException {
        CTProvider provider = this.provider();
        CCaseLib cc = provider.getCCaseLib();
        Map<String, String> dir = cc.getCCDirectory(pathName, feedback);
        return this.processCCDirectory(provider, dir);
    }

    private Map<String, SrvcResource> processCCDirectory(CTProvider provider, Map<String, String> dir) throws WvcmException {
        HashMap<String, SrvcResource> childBindings = new HashMap<String, SrvcResource>();
        for (String leafname : dir.keySet()) {
            Location loc = this.location().child(leafname);
            String dumpMType = dir.get(leafname);
            CTControllableResource cr = dumpMType.equals("2") ? new CTControllableFolder(loc, provider) : (dumpMType.equals("7") ? new CTSymbolicLink(loc, provider) : new CTControllableResource(loc, provider));
            childBindings.put(leafname, cr);
        }
        return childBindings;
    }

    protected Map<String, SrvcResource> getChildMap(SrvcFeedback feedback) throws WvcmException {
        Map<String, SrvcResource> results = null;
        String pathName = this.getPathname(feedback);
        String prefix = VOB_COLON;
        pathName = pathName.startsWith(VOB_COLON) ? pathName.substring(VOB_COLON.length()) : pathName;
        try {
            CTProvider provider = this.provider();
            CCaseLib cc = provider.getCCaseLib();
            Map<String, String> dir = cc.getCCDirectory(pathName, feedback);
            results = this.processCCDirectory(provider, dir);
        }
        catch (WvcmException e) {
            if (e.getReasonCode().equals((Object)WvcmException.ReasonCode.METHOD_NOT_SUPPORTED)) {
                results = this.processFSDirectory(pathName, feedback);
            }
            throw e;
        }
        return results;
    }

    protected Map<String, SrvcResource> preLoadChildMap(Map<String, SrvcResource> originalMap, SrvcFeedback feedback) throws WvcmException {
        HashMap<String, SrvcResource> results = new HashMap();
        String pathName = this.getPathname(feedback);
        String prefix = VOB_COLON;
        pathName = pathName.startsWith(VOB_COLON) ? pathName.substring(VOB_COLON.length()) : pathName;
        CTProvider provider = this.provider();
        CTLocation myLoc = this.location();
        Set<String> childLeafNames = originalMap.keySet();
        try {
            TreeMap<String, String> childPathname2LeafnameMap = new TreeMap<String, String>();
            for (String leafname : childLeafNames) {
                String key = String.valueOf(pathName) + CommonUtils.FWDSLASH + leafname;
                childPathname2LeafnameMap.put(key, leafname);
            }
            Set<String> childPathnames = childPathname2LeafnameMap.keySet();
            Map<String, FileSystemObjectInfo> infos = CTControllableFolder.getInfos(provider, this.getView(feedback), childPathnames, feedback);
            for (String name : childPathnames) {
                String childLeafName = (String)childPathname2LeafnameMap.get(name);
                CTLocation resultLocation = (CTLocation)myLoc.child(childLeafName);
                FileSystemObjectInfo info = infos.get(name);
                CCaseVerInfo verInfo = info != null ? info.verInfo : null;
                CTControllableResource child = verInfo == null ? new CTControllableResource((Location)resultLocation, provider) : (CTControllableResource)provider.createAndCacheCTResource(resultLocation, verInfo, feedback);
                results.put(childLeafName, child);
            }
        }
        catch (Exception e) {
            results = originalMap;
        }
        return results;
    }

    protected List<SrvcResource> preLoadChildList(List<SrvcResource> originalList, SrvcFeedback feedback) throws WvcmException {
        ArrayList<SrvcResource> results = new ArrayList();
        CTProvider provider = this.provider();
        try {
            LinkedHashMap<String, SrvcResource> childPathnames2OrigResource = new LinkedHashMap<String, SrvcResource>();
            for (SrvcResource child : originalList) {
                childPathnames2OrigResource.put(((CTLocation)child.location()).getDisplayName(), child);
            }
            Set<String> childPathnames = childPathnames2OrigResource.keySet();
            Map<String, FileSystemObjectInfo> infos = CTControllableFolder.getInfos(provider, this.getView(feedback), childPathnames, feedback);
            for (String name : childPathnames) {
                SrvcResource originalRes = (SrvcResource)childPathnames2OrigResource.get(name);
                CTLocation resultLocation = (CTLocation)originalRes.location();
                FileSystemObjectInfo info = infos.get(name);
                CCaseVerInfo verInfo = info != null ? info.verInfo : null;
                SrvcResource child = verInfo == null ? originalRes : provider.createAndCacheCTResource(resultLocation, verInfo, feedback);
                results.add(child);
            }
        }
        catch (Exception e) {
            results = originalList;
        }
        return results;
    }

    protected Object convertPropValueToClient(WorkspaceProvider provider, Object value, boolean isResourceList, PropertyRequestItem.PropertyRequest propertyRequest, SrvcResource configuration, SrvcFeedback sfb) throws WvcmException {
        block4: {
            PropertyRequestItem.NestedPropertyName[] items;
            block5: {
                PropertyRequestItem.NestedPropertyName[] items2;
                if (!(value instanceof Map)) break block5;
                PropertyRequestItem.NestedPropertyName[] nestedPropertyNameArray = items2 = propertyRequest.toArray();
                int n = items2.length;
                int n2 = 0;
                while (n2 < n) {
                    PropertyRequestItem.NestedPropertyName item = nestedPropertyNameArray[n2];
                    PropertyNameList.PropertyName propName = item.getRoot();
                    if (propName.equals((Object)ControllableResource.CHECKED_IN) || propName.equals((Object)ControllableResource.VERSION_HISTORY)) {
                        value = this.preLoadChildMap((Map)value, sfb);
                        break block4;
                    }
                    ++n2;
                }
                break block4;
            }
            if (!(value instanceof List)) break block4;
            PropertyRequestItem.NestedPropertyName[] nestedPropertyNameArray = items = propertyRequest.toArray();
            int n = items.length;
            int n3 = 0;
            while (n3 < n) {
                PropertyRequestItem.NestedPropertyName item = nestedPropertyNameArray[n3];
                PropertyNameList.PropertyName propName = item.getRoot();
                if (propName.equals((Object)ControllableResource.CHECKED_IN) || propName.equals((Object)ControllableResource.VERSION_HISTORY)) {
                    value = this.preLoadChildList((List)value, sfb);
                    break;
                }
                ++n3;
            }
        }
        return super.convertPropValueToClient(provider, value, isResourceList, propertyRequest, configuration, sfb);
    }

    public static CTControllableFolder doCreate(CTProvider provider, Location loc, SrvcFeedback feedback) throws WvcmException {
        CTLocation location = (CTLocation)loc;
        CTLocation parentLoc = location.parent();
        CTControllableFolder parentFolder = CTControllableFolder.getParentFolder(provider, parentLoc, feedback);
        return parentFolder.doCreate(provider, location, feedback);
    }

    public CTControllableFolder doCreate(CTProvider provider, CTLocation location, SrvcFeedback feedback) throws WvcmException {
        this.prepareToWrite(feedback);
        String pathname = location.getDisplayName();
        CCaseLib cc = provider.getCCaseLib();
        cc.makeElement(true, pathname, feedback);
        CTControllableFolder result = (CTControllableFolder)provider.get((Location)location, feedback);
        return result;
    }

    public static CTControllableFolder getParentFolder(CTProvider provider, CTLocation parentLoc, SrvcFeedback feedback) throws WvcmException {
        CTControllableFolder parentFolder = (CTControllableFolder)provider.lookup((Location)parentLoc, feedback);
        if (parentFolder == null) {
            throw new WvcmException(NLS.bind((String)Messages.CTControllableFolder_ERROR_PARENT_NOT_FOUND, (Object)parentLoc.toString()), null, WvcmException.ReasonCode.NOT_FOUND);
        }
        return parentFolder;
    }

    public static CTControllableFolder doCreateComponentAndRoot(CTProvider provider, Location loc, SrvcFeedback feedback) throws WvcmException {
        CCaseLib cc = provider.getCCaseLib();
        CTLocation location = (CTLocation)loc;
        String viewTag = location.getViewTag();
        String streamSel = cc.getStreamUniversalSelector(viewTag, feedback);
        String pVobSel = ObjSelUtils.getObjSelVobSel(streamSel);
        String compRootPath = location.getDisplayName();
        String compName = location.lastSegment();
        try {
            cc.makeComponent(compRootPath, ObjSelUtils.formatSelector("component", compName, pVobSel), streamSel, true, feedback);
        }
        catch (WvcmException ex) {
            CTControllableFolder.validateCompRootTagVob(provider, location, ex);
            throw ex;
        }
        CTControllableFolder result = new CTControllableFolder(loc, provider);
        return result;
    }

    public static void validateCompRootTagVob(CTProvider provider, CTLocation location, WvcmException ex) throws WvcmException {
        File vobRoot;
        String compVobTag = CTInitArgUtils.getCompVobTag(provider.initArgs()).trim();
        if ((compVobTag.length() != 0 || location.parent().getDisplayName().contains(CommonUtils.canonicalizePathname(compVobTag))) && !(vobRoot = new File(location.parent().getDisplayName())).exists()) {
            WvcmException wvcmException = new WvcmException(NLS.bind((String)Messages.CTControllableFolder_ERROR_COULD_NOT_CREATE_COMPONENT_IN_VOB, (Object)compVobTag), null, WvcmException.ReasonCode.NOT_FOUND, (Throwable)ex);
            throw wvcmException;
        }
    }

    public void doUnbindChild(String bindingName, SrvcFeedback feedback) throws WvcmException {
        CTLocation myLoc;
        Location childLocation;
        CTProvider provider = this.provider();
        CTControllableResource child = (CTControllableResource)provider.lookup(childLocation = (myLoc = this.location()).child(bindingName), feedback);
        if (child == null) {
            throw new WvcmException(NLS.bind((String)Messages.CTControllableFolder_ERROR_COULD_NOT_FIND_CHILD, (Object)childLocation.string()), WvcmException.ReasonCode.NOT_FOUND);
        }
        boolean isUncontrolledResource = this.isUncontrolledResource(child, feedback);
        if (isUncontrolledResource) {
            String pathname = child.getPathname(feedback);
            File goner = new File(pathname);
            boolean success = goner.delete();
            if (!success) {
                throw new WvcmException(NLS.bind((String)Messages.CTControllableFolder_ERROR_FILE_DELETE_FAILE_WITH_PATHNAME, (Object)pathname), WvcmException.ReasonCode.FORBIDDEN);
            }
            return;
        }
        this.prepareToWrite(feedback);
        String myPathname = this.getPathname(feedback);
        CCaseLib cc = provider.getCCaseLib();
        cc.removeName(myPathname, bindingName, feedback);
        this.flush(feedback);
    }

    @Override
    public void doVersionControl(SrvcFeedback feedback) throws WvcmException {
    }

    public void doRebindChild(String bindingName, Location sourceFolderLocation, String sourceBindingName, Folder.RebindFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        CTProvider p = this.provider();
        CTControllableFolder sourceFolder = new CTControllableFolder(sourceFolderLocation, p);
        Location sourceChildLoc = sourceFolderLocation.child(sourceBindingName);
        CTControllableResource sourceCR = (CTControllableResource)p.lookup(sourceChildLoc, feedback);
        if (sourceCR == null) {
            throw new WvcmException(NLS.bind((String)Messages.CTControllableFolder_ERROR_COULD_NOT_FIND_CHILD, (Object)sourceChildLoc.string()), WvcmException.ReasonCode.NOT_FOUND);
        }
        String newFolderPathname = this.getPathname(feedback);
        String newPathname = String.valueOf(newFolderPathname) + '/' + bindingName;
        String oldFolderPathname = sourceFolder.getPathname(feedback);
        String oldPathname = String.valueOf(oldFolderPathname) + '/' + sourceBindingName;
        boolean isUncontrolledResource = this.isUncontrolledResource(sourceCR, feedback);
        if (isUncontrolledResource) {
            File source = new File(oldPathname);
            File destination = new File(newPathname);
            boolean result = source.renameTo(destination);
            if (!result) {
                throw new WvcmException(NLS.bind((String)Messages.CCaseLib_ERROR_RENAME_FAILED, (Object)oldPathname, (Object)newPathname), WvcmException.ReasonCode.FORBIDDEN);
            }
            return;
        }
        sourceFolder.prepareToWrite(feedback);
        this.prepareToWrite(feedback);
        CCaseLib cc = p.getCCaseLib();
        cc.moveName(oldPathname, newPathname, feedback);
        this.flush(feedback);
    }

    private boolean isUncontrolledResource(CTControllableResource sourceCR, SrvcFeedback feedback) throws WvcmException {
        return "view private object".equals(sourceCR.getObjInfo(feedback).getMtype());
    }

    public void doBindChild(String bindingName, Location childLocation, Folder.BindFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        CTProvider p = this.provider();
        this.prepareToWrite(feedback);
        CTControllableResource childCR = (CTControllableResource)p.lookup(childLocation, feedback);
        if (childCR == null) {
            throw new WvcmException(NLS.bind((String)Messages.CTControllableFolder_ERROR_COULD_NOT_FIND_CHILD, (Object)childLocation.toString()), null, WvcmException.ReasonCode.NOT_FOUND);
        }
        String oldPathname = childCR.getPathname(feedback);
        String myPathname = this.getPathname(feedback);
        String newPathname = String.valueOf(myPathname) + '/' + bindingName;
        CCaseLib cc = p.getCCaseLib();
        cc.link(oldPathname, newPathname, feedback);
        this.flush(feedback);
    }

    private Map<String, SrvcResource> processFSDirectory(String pathName, SrvcFeedback feedback) throws WvcmException {
        HashMap<String, SrvcResource> childBindings = new HashMap<String, SrvcResource>();
        CTProvider provider = this.provider();
        CCaseLib cc = provider.getCCaseLib();
        Map<String, Boolean> dir = cc.getFSDirectory(pathName, feedback);
        for (String leafname : dir.keySet()) {
            Location loc = this.location().child(leafname);
            Boolean isDirectory = dir.get(leafname);
            CTControllableResource cr = isDirectory != false ? new CTControllableFolder(loc, provider) : new CTControllableResource(loc, provider);
            childBindings.put(leafname, cr);
        }
        return childBindings;
    }

    public List<SrvcResource> doReadMemberList(Location unusedLocation, boolean deep, SrvcFeedback feedback) throws WvcmException {
        if (!deep) {
            throw new IllegalArgumentException("'deep=true' required when calling doReadMemberList");
        }
        CTProvider provider = this.provider();
        String pathname = this.getPathname(feedback);
        CCaseLib cc = provider.getCCaseLib();
        List<String> verNames = cc.listDirectoryTree(pathname, feedback);
        ArrayList<String> versionlessNames = new ArrayList<String>();
        for (String name : verNames) {
            if (!name.endsWith("@@")) continue;
            versionlessNames.add(name);
        }
        int count = versionlessNames.size();
        if (count > 0) {
            String msg = NLS.bind((String)Messages.CTControllableFolder_ERROR_TREE_HAS_ENTRIES_WITH_NO_SELECTED_VERSION, (Object[])new Object[]{count, pathname, versionlessNames.get(0)});
            throw new WvcmException(msg, WvcmException.ReasonCode.FORBIDDEN);
        }
        return CTControllableFolder.memberListHelper(provider, this.getView(feedback), verNames, feedback);
    }

    public static Map<String, FileSystemObjectInfo> getInfos(CTProvider provider, CTView view, Collection<String> names, SrvcFeedback feedback) throws WvcmException {
        if (names == null || names.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, FileSystemObjectInfo> results = new HashMap<String, FileSystemObjectInfo>(names.size());
        CCaseLib cc = provider.getCCaseLib();
        Map<String, CCaseVerInfo> verInfos = CCaseVerInfo.getVerInfos(cc, names, feedback);
        HashMap<String, String> name2elemPathName = new HashMap<String, String>(verInfos.size());
        for (String name : names) {
            String mtype;
            CCaseVerInfo verInfo = verInfos.get(name);
            if (verInfo == null || !"derived object version".equals(mtype = verInfo.getMtype()) && !"directory version".equals(mtype) && !"version".equals(mtype) && !"symbolic link".equals(mtype)) continue;
            String elemPathName = verInfo.getElemPathName();
            name2elemPathName.put(name, elemPathName);
        }
        Map<String, CCaseElemInfo> elemInfos = CCaseElemInfo.getElemInfos(cc, name2elemPathName.values(), feedback);
        boolean isBaseCc = view instanceof CTBaseCCView;
        for (String name : names) {
            results.put(name, null);
            CCaseVerInfo verInfo = verInfos.get(name);
            if (verInfo == null) continue;
            String elemPathname = (String)name2elemPathName.get(name);
            CCaseElemInfo elemInfo = elemPathname == null ? null : elemInfos.get(elemPathname);
            String elemUSel = null;
            CTElement elem = null;
            if (elemInfo != null) {
                String elemPathName = elemInfo.getPathName();
                if (!elemPathName.endsWith("@@")) {
                    throw new IllegalStateException(NLS.bind((String)"element pathname does not end with the extended naming symbol {0} {1}", (Object)elemPathName, (Object)"@@"));
                }
                elemUSel = elemInfo.getUniversalSelector();
                CTLocation elemLoc = CTElement.createElemLocation(provider, view, name, elemUSel, feedback);
                elem = (CTElement)provider.createAndCacheCTResource(elemLoc, elemInfo, feedback);
            }
            CTVersion ver = null;
            if (verInfo != null) {
                CTLocation verLoc = CTVersion.getVersionLocation(provider, isBaseCc, view.getViewTag(), name, verInfo, feedback);
                CTResource res = provider.createAndCacheCTResource(verLoc, verInfo, feedback);
                if (elemUSel != null && res instanceof CTVersion) {
                    ver = (CTVersion)res;
                    ver.setElemUSel(elemUSel);
                }
            }
            results.put(name, new FileSystemObjectInfo(name, verInfo, ver, elemInfo, elem));
        }
        return results;
    }

    private static List<SrvcResource> memberListHelper(CTProvider provider, CTView view, Collection<String> verNames, SrvcFeedback feedback) throws WvcmException {
        if (verNames == null || verNames.size() == 0) {
            return Collections.emptyList();
        }
        Map<String, FileSystemObjectInfo> infos = CTControllableFolder.getInfos(provider, view, verNames, feedback);
        HashMap<String, CTFolderVersion> pathnamesToFolderVersions = new HashMap<String, CTFolderVersion>();
        ArrayList<SrvcResource> entries = new ArrayList<SrvcResource>(infos.size());
        for (String verName : verNames) {
            FileSystemObjectInfo info = infos.get(verName);
            CTControllableResource ctcr = null;
            if (info == null || info.elemInfo == null || info.verInfo == null) {
                CTLocation resultLocation = CTLocation.valueOf(CTLocation.Kind.CONTROLLABLE_RESOURCE, verName);
                ctcr = new CTControllableResource((Location)resultLocation, provider);
            } else {
                String bindingName;
                Map<String, Object> parentChildMap;
                Object previous;
                int sep;
                String parentName;
                CTFolderVersion parentFolderVersion;
                CCaseElemInfo elemInfo = info.elemInfo;
                CCaseVerInfo verInfo = info.verInfo;
                String elemPathName = elemInfo.getPathName();
                if (!elemPathName.endsWith("@@")) {
                    throw new IllegalStateException(NLS.bind((String)"element pathname does not end with the extended naming symbol {0} {1}", (Object)elemPathName, (Object)"@@"));
                }
                int end = elemPathName.length() - "@@".length();
                String name = elemPathName.substring(0, end);
                CTLocation resultLocation = CTLocation.valueOf(CTLocation.Kind.CONTROLLABLE_RESOURCE, name);
                ctcr = (CTControllableResource)provider.createAndCacheCTResource(resultLocation, verInfo, feedback);
                if (info.ver != null && info.ver instanceof CTFolderVersion) {
                    pathnamesToFolderVersions.put(name, (CTFolderVersion)info.ver);
                }
                if ((parentFolderVersion = (CTFolderVersion)((Object)pathnamesToFolderVersions.get(parentName = name.substring(0, sep = name.lastIndexOf(47))))) != null && (previous = (parentChildMap = parentFolderVersion.getRawMap()).put(bindingName = name.substring(sep + 1), (Object)info.elem)) != null) {
                    throw new IllegalStateException(NLS.bind((String)"folder version {0} child map already contains binding name {1}", (Object)parentFolderVersion.location().string(), (Object)bindingName));
                }
            }
            entries.add(ctcr);
        }
        for (SrvcResource cr : entries) {
            ResourceImpl ctcr = cr.buildProxy(feedback.getPropertyRequestForResult(), feedback);
            feedback.setResourceCache((Location)cr.location(), (Resource)ctcr);
        }
        return entries;
    }

    private static CTControllableFolder lookup(CTProvider ctProvider, CTLocation subRootFileLoc, SrvcFeedback feedback) throws WvcmException {
        CTControllableFolder result = null;
        CTResource res = ctProvider.lookup((Location)subRootFileLoc, feedback);
        if (res instanceof CTControllableFolder) {
            result = (CTControllableFolder)res;
        }
        return result;
    }

    public List<SrvcResource> doFindRoots(int threshold, SrvcFeedback feedback) throws WvcmException {
        String pathname = this.getPathname(feedback.nest(10));
        File rootFile = new File(pathname);
        if (!rootFile.exists()) {
            throw new WvcmException(NLS.bind((String)Messages.CTControllableFolder_ERR_PATHNAME_E_NO_ENT, (Object)pathname), WvcmException.ReasonCode.FORBIDDEN);
        }
        if (!rootFile.isDirectory()) {
            throw new WvcmException(NLS.bind((String)Messages.CTControllableFolder_ERR_PATHNAME_NOT_TO_FOLDER, (Object)pathname), WvcmException.ReasonCode.FORBIDDEN);
        }
        ArrayList<CTLocation> roots = new ArrayList<CTLocation>();
        CTFolder.findBigFolders(this.provider().getCCaseLib(), this.location(), threshold, roots, feedback);
        ArrayList<Location> locations = new ArrayList<Location>(roots.size());
        for (CTLocation root : roots) {
            locations.add((Location)root);
        }
        CTView view = this.getView(feedback);
        CTElement.lookupControlledResourceLocs(view, locations, feedback);
        ArrayList<SrvcResource> results = new ArrayList<SrvcResource>(roots.size());
        CTProvider p = this.provider();
        for (CTLocation subRootFile : roots) {
            CTControllableFolder controllableFolder = CTControllableFolder.lookup(p, subRootFile, feedback);
            results.add(controllableFolder);
        }
        return results;
    }

    public static SrvcResource doCreateBaseCcSubVobComponent(CTProvider provider, String viewTag, CTLocation location, SrvcFeedback feedback) throws WvcmException {
        CTLocation parentLoc = location.parent();
        CTControllableFolder parentFolder = CTControllableFolder.getParentFolder(provider, parentLoc, feedback);
        CCaseLib cc = provider.getCCaseLib();
        String myPathname = location.getDisplayName();
        String componentName = location.lastSegment();
        String parentPathname = parentLoc.getDisplayName();
        if (!cc.containingVobHasBaseCcSubVobComponentAttype(parentPathname, feedback)) {
            String compVobTag = provider.getDefaultCompVobTag(feedback);
            String msg = NLS.bind((String)Messages.CTControllableFolder_ERROR_VOB_MUST_CONTAIN_SUBVOB_COMP_ATTYPE, (Object)myPathname);
            throw new WvcmException(msg, WvcmException.ReasonCode.FORBIDDEN);
        }
        CTControllableFolder result = (CTControllableFolder)provider.lookup((Location)location, feedback);
        if (result == null || result.getObjInfo(feedback) == null) {
            result = parentFolder.doCreate(provider, location, feedback);
        }
        CTElement vH = result.getVersionHistory(feedback);
        result.markAsBaseCcSubVobComponentRoot(vH, myPathname, componentName, feedback);
        return result;
    }

    private CTElement getVersionHistory(SrvcFeedback feedback) throws WvcmException {
        CTElement result = this.lookupVersionHistory(feedback);
        if (result == null) {
            throw new WvcmException(NLS.bind((String)Messages.CTControllableFolder_ERROR_NO_VH, (Object)this.location().toString()), WvcmException.ReasonCode.FORBIDDEN);
        }
        return result;
    }

    public void markAsBaseCcSubVobComponentRootForTests(String componentName, SrvcFeedback feedback) throws WvcmException {
        CTBaseCCView view = (CTBaseCCView)this.getView(feedback);
        String viewTag = view.getViewTag();
        String crPath = this.location().getDisplayName();
        BaseCcSubVobCompRootInfoMap subVobPathMap = CTControllableFolder.getSubVobPathMap(this.provider(), viewTag, crPath, feedback);
        CTElement elem = this.lookupVersionHistory(feedback);
        elem.markAsBaseCcSubVobComponentRoot(componentName, feedback);
        IPath crIPath = CommonUtils.getIPathWithoutVerExt(crPath);
        Utils.NestedPair nestedPair = subVobPathMap.findStartsWith(crIPath);
        if (nestedPair == null) {
            BaseCcSubVobCompRootInfo info = new BaseCcSubVobCompRootInfo(crPath, (IPath)new Path(crPath), viewTag, true, componentName);
            String verUsel = elem.getRootVersion(feedback).getUniversalSelector(feedback);
            info.setRootVersionSelector(verUsel);
            subVobPathMap.put(crPath, info);
            String vobSelector = this.getVobSelector(crPath, feedback);
            view.addVobComponentToList(vobSelector, feedback);
        }
    }

    private void markAsBaseCcSubVobComponentRoot(CTElement elem, String crPath, String componentName, SrvcFeedback feedback) throws WvcmException {
        IPath crIPath;
        CTBaseCCView view = (CTBaseCCView)this.getView(feedback);
        String viewTag = view.getViewTag();
        BaseCcSubVobCompRootInfoMap subVobPathMap = CTControllableFolder.getSubVobPathMap(this.provider(), viewTag, crPath, feedback);
        Utils.NestedPair nestedPair = subVobPathMap.findStartsWith(crIPath = CommonUtils.getIPathWithoutVerExt(crPath));
        if (nestedPair != null) {
            throw new WvcmException(NLS.bind((String)Messages.CTControllableResource_ERROR_NESTED_SUB_VOB_COMPS, (Object)nestedPair.nestedPath, (Object)nestedPair.rootPath), WvcmException.ReasonCode.CONFLICT);
        }
        BaseCcSubVobCompRootInfo info = new BaseCcSubVobCompRootInfo(crPath, (IPath)new Path(crPath), viewTag, true, componentName);
        elem.markAsBaseCcSubVobComponentRoot(componentName, feedback);
        String verUsel = elem.getRootVersion(feedback).getUniversalSelector(feedback);
        info.setRootVersionSelector(verUsel);
        subVobPathMap.put(crPath, info);
        String vobSelector = this.getVobSelector(crPath, feedback);
        view.addVobComponentToList(vobSelector, feedback);
    }

    public void unmarkAsBaseCcSubVobComponentRootForTests(SrvcFeedback feedback) throws WvcmException {
        CTBaseCCView view = (CTBaseCCView)this.getView(feedback);
        String viewTag = view.getViewTag();
        String crPath = this.location().getDisplayName();
        BaseCcSubVobCompRootInfoMap subVobPathMap = CTControllableFolder.getSubVobPathMap(this.provider(), viewTag, crPath, feedback);
        subVobPathMap.remove(crPath);
        CTElement vH = this.lookupVersionHistory(feedback);
        vH.unmarkAsBaseCcSubVobComponentRootForTest(feedback);
    }

    static class FileSystemObjectInfo {
        final String name;
        final CCaseVerInfo verInfo;
        final CTVersion ver;
        final CCaseElemInfo elemInfo;
        final CTElement elem;

        public FileSystemObjectInfo(String name, CCaseVerInfo verInfo, CTVersion ver, CCaseElemInfo elemInfo, CTElement elem) {
            this.name = name;
            this.verInfo = verInfo;
            this.ver = ver;
            this.elemInfo = elemInfo;
            this.elem = elem;
        }
    }
}

