/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CCaseObjInfo;
import com.ibm.rational.wvcm.ct.CommandResult;
import com.ibm.rational.wvcm.ct.CommonUtils;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wvcm.WvcmException;

public class CCaseVerInfo
extends CCaseObjInfo {
    private String _elemPathName;
    private String _comment;
    private String _owner;

    public String getElemPathName() {
        return this._elemPathName;
    }

    public String getComment() {
        return this._comment;
    }

    public String getOwner() {
        return this._owner;
    }

    public CCaseVerInfo(CCaseLib cc, String universalSelector, boolean isDirectory, String pathName, String mtype, String creationDateString, String elemPathName, String comment, String owner) {
        super(cc, universalSelector, isDirectory, pathName, mtype, creationDateString);
        this._elemPathName = CommonUtils.canonicalizePathname(elemPathName);
        this._comment = comment;
        this._owner = owner;
        try {
            if (this.getPathName().startsWith(this._elemPathName)) {
                this._elemPathName = this.getPathName().substring(0, this._elemPathName.length());
            }
        }
        catch (WvcmException wvcmException) {
            // empty catch block
        }
    }

    public static CCaseVerInfo lookupVerInfo(CCaseLib cc, String name, SrvcFeedback feedback) throws WvcmException {
        return CCaseVerInfo.getVerInfos(cc, Collections.singletonList(name), feedback).get(name);
    }

    public static Map<String, CCaseVerInfo> getVerInfos(CCaseLib cc, Collection<String> names, SrvcFeedback feedback) throws WvcmException {
        CommandResult.ResultBehaviorFlags flags = new CommandResult.ResultBehaviorFlags(CommandResult.ResultBehaviorFlags.Kind.IGNORE_NO_VIEW_INFO, CommandResult.ResultBehaviorFlags.Kind.NOT_FOUND_IMPLIES_BACKSLASH_IN_NAME_ON_WINDOWS);
        Map<String, CCaseVerInfo> verInfos = CCaseVerInfo.getVerInfos(cc, names, flags, feedback);
        if (verInfos == null) {
            throw new IllegalStateException(names + " not found, but no exception thrown");
        }
        return verInfos;
    }

    private static Map<String, CCaseVerInfo> getVerInfos(CCaseLib cc, Collection<String> pathNames, CommandResult.ResultBehaviorFlags flags, SrvcFeedback feedback) throws WvcmException {
        HashMap<String, CCaseVerInfo> result = new HashMap<String, CCaseVerInfo>(pathNames.size());
        if (pathNames.isEmpty()) {
            return result;
        }
        ArrayList<String> pathnamesList = new ArrayList<String>(pathNames);
        List<String[]> tokensList = cc.describeForVerInfo(pathnamesList, flags, feedback);
        Iterator<String> pathnamesIter = pathNames.iterator();
        for (String[] tokens : tokensList) {
            String name = pathnamesIter.next();
            if (tokens == null || tokens.length == 0 || "view private object".equals(tokens[0])) {
                result.put(name, null);
                continue;
            }
            if ("version".equals(tokens[0])) {
                tokens[0] = "version";
            } else if ("directory version".equals(tokens[0])) {
                tokens[0] = "directory version";
            }
            tokens[1] = String.valueOf(tokens[1].toCharArray());
            tokens[2] = String.valueOf(tokens[2].toCharArray());
            tokens[3] = String.valueOf(tokens[3].toCharArray());
            tokens[4] = String.valueOf(tokens[4].toCharArray());
            tokens[5] = String.valueOf(tokens[5].toCharArray());
            if (tokens.length > 6) {
                tokens[6] = String.valueOf(tokens[6].toCharArray());
                result.put(name, new CCaseVerInfo(cc, tokens[1], tokens[0].startsWith("directory"), tokens[2], tokens[0], tokens[3], tokens[4], tokens[6], tokens[5]));
                continue;
            }
            result.put(name, new CCaseVerInfo(cc, tokens[1], tokens[0].startsWith("directory"), tokens[2], tokens[0], tokens[3], tokens[4], "", tokens[5]));
        }
        return result;
    }
}

