/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CommandResult;
import com.ibm.rational.wvcm.ct.CommonUtils;
import com.ibm.rational.wvcm.ct.ObjSelUtils;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.wvcm.WvcmException;

public class CCaseObjInfo {
    private final CCaseLib _cc;
    private boolean _isDirectory;
    private String _pathname;
    private String _universalSelector;
    private String _mtype;
    private String _creationDateString;
    public static final Collection<String> FILE_SYSTEM_METATYPES = Arrays.asList("directory element", "directory version", "file element", "symbolic link", "version");

    public static CCaseObjInfo getObjInfo(CCaseLib cc, String pathName, SrvcFeedback feedback) throws WvcmException {
        List<CCaseObjInfo> objInfos = CCaseObjInfo.getObjInfos(cc, Collections.singletonList(pathName), feedback);
        if (objInfos.isEmpty()) {
            return null;
        }
        return objInfos.get(0);
    }

    public static List<CCaseObjInfo> getObjInfos(CCaseLib cc, List<String> pathNames, SrvcFeedback feedback) throws WvcmException {
        CommandResult.ResultBehaviorFlags flags = new CommandResult.ResultBehaviorFlags(CommandResult.ResultBehaviorFlags.Kind.IGNORE_NO_VIEW_INFO, CommandResult.ResultBehaviorFlags.Kind.NOT_FOUND_IMPLIES_BACKSLASH_IN_NAME_ON_WINDOWS);
        List<CCaseObjInfo> objInfos = CCaseObjInfo.getObjInfos(cc, pathNames, flags, feedback);
        if (objInfos == null) {
            throw new IllegalStateException(pathNames + " not found, but no exception thrown");
        }
        return objInfos;
    }

    public static CCaseObjInfo lookupObjInfo(CCaseLib cc, String pathName, SrvcFeedback feedback) throws WvcmException {
        List<CCaseObjInfo> objInfos = CCaseObjInfo.lookupObjInfos(cc, Collections.singletonList(pathName), feedback);
        if (objInfos.isEmpty()) {
            return null;
        }
        return objInfos.get(0);
    }

    public static List<CCaseObjInfo> lookupObjInfos(CCaseLib cc, List<String> pathNames, SrvcFeedback feedback) throws WvcmException {
        CommandResult.ResultBehaviorFlags ignoreFlags = new CommandResult.ResultBehaviorFlags(CommandResult.ResultBehaviorFlags.Kind.IGNORE_NOT_FOUND, CommandResult.ResultBehaviorFlags.Kind.IGNORE_NO_VIEW_INFO);
        return CCaseObjInfo.getObjInfos(cc, pathNames, ignoreFlags, feedback);
    }

    private static List<CCaseObjInfo> getObjInfos(CCaseLib cc, List<String> pathNames, CommandResult.ResultBehaviorFlags flags, SrvcFeedback feedback) throws WvcmException {
        ArrayList<CCaseObjInfo> results = new ArrayList<CCaseObjInfo>();
        if (pathNames.size() > 0) {
            List<String[]> tokensList = cc.describeForObjInfo(pathNames, flags, feedback);
            for (String[] tokens : tokensList) {
                if (tokens == null || tokens.length == 0) {
                    results.add(null);
                    continue;
                }
                results.add(new CCaseObjInfo(cc, tokens[1], tokens[0].startsWith("directory"), tokens[2], tokens[0], tokens[3]));
            }
        }
        return results;
    }

    public CCaseObjInfo(CCaseLib cc, String universalSelector, boolean isDirectory, String pathName, String mtype, String creationDateString) {
        this._cc = cc;
        this._universalSelector = universalSelector;
        this._isDirectory = isDirectory;
        this._pathname = CommonUtils.canonicalizePathname(pathName);
        this._mtype = mtype;
        this._creationDateString = creationDateString;
    }

    public String getPathName() throws WvcmException {
        if (this._pathname == null) {
            this._pathname = CommonUtils.canonicalizePathname(this._cc.getPathname(this._universalSelector, null));
        }
        return this._pathname;
    }

    public String getUniversalSelector() {
        return this._universalSelector;
    }

    public CCaseLib getCCaseLib() {
        return this._cc;
    }

    public boolean isDirectory() {
        return this._isDirectory;
    }

    public String getMtype() {
        return this._mtype;
    }

    public String getCreationDateString() {
        return this._creationDateString;
    }

    public String lookupVobUuid() {
        if (this._universalSelector != null) {
            String result = ObjSelUtils.vobUuidSelectorSubstring(this._universalSelector);
            return result;
        }
        return null;
    }

    public void clearPathname() {
        if (CCaseObjInfo.isFileSystemMetatype(this._mtype)) {
            this._pathname = null;
        }
    }

    public static boolean isFileSystemMetatype(String mtype) {
        return FILE_SYSTEM_METATYPES.contains(mtype);
    }
}

