/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.CCaseDirectoryEntryMap;
import com.ibm.rational.wvcm.ct.CTBaseCCView;
import com.ibm.rational.wvcm.ct.CTInitArgUtils;
import com.ibm.rational.wvcm.ct.CTLocation;
import com.ibm.rational.wvcm.ct.CTProvider;
import com.ibm.rational.wvcm.ct.CommandProvider;
import com.ibm.rational.wvcm.ct.CommandResult;
import com.ibm.rational.wvcm.ct.CommonUtils;
import com.ibm.rational.wvcm.ct.Messages;
import com.ibm.rational.wvcm.ct.ObjSelUtils;
import com.ibm.rational.wvcm.interop.InteropUtilities;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.wvcm.PropertyNameList;
import javax.wvcm.PropertyRequestItem;
import javax.wvcm.Workspace;
import javax.wvcm.WvcmException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class CCaseLib {
    protected Map<String, String> ctInitArgs;
    protected final CommandProvider ctProvider;
    private boolean cachingEnabled;
    private static final String CONFIG_SPEC = String.valueOf(CommonUtils.FWDSLASH) + "config_spec";
    public static final String APPLICATION_HTML = "application/html";
    public static final String APPLICATION_MSWORD = "application/msword";
    public static final String APPLICATION_UNKNOWN = "application/unknown";
    public static final String APPLICATION_XML = "application/xml";
    public static final String TEXT_PLAIN = "text/plain";
    private static String mvfsRoot;
    private static String defaultViewDir;
    private static final String MKACT_SCRIPT_NAME = "CreateUCMActivity.pl";
    private static final String DBID_SCRIPT_NAME = "GetUCMActivityDBID.pl";
    private static final String GET_COMMENT_SCRIPT_NAME = "GetRecordComment.pl";
    private static final String SET_COMMENT_SCRIPT_NAME = "SetRecordComment.pl";
    private static final String PERFORM_CQ_ACTION_SCRIPT_NAME = "PerformCQAction.pl";
    private static final String CQ_PROP_FILE_EXT = ".cq_password";
    private static final String GENERIC_HEADLINE;
    private static final String RECORD_TYPE_KEY = "Record_Type";
    private static final String RECORD_ID_KEY = "Record_ID";
    private static final String QUERY_PREFIX = "CQ:cq.repo.cq-record:";
    private static Map<String, String> CQ_CREDS;
    private static String MKACT_SCRIPT;
    private static String DBID_SCRIPT;
    private static String GET_COMMENT_SCRIPT;
    private static String SET_COMMENT_SCRIPT;
    private static String PERFORM_CQ_ACTION_SCRIPT;
    protected static final String UNINITIALIZED_NOT_FOUND = "Uninitialized IGNORE_NOT_FOUND pattern";
    private static String NOT_FOUND_PATTERN;
    protected static String NOT_FOUND;
    private static final String DOES_NOT_EXIST = "THIS_THING_DOES_NOT_EXIST";
    private static final String NF_PREFIX = "^cleartool: Error: Unable to .+? \".+?\" ?[:-] ";
    private static final String NF_PATTERN = "(.+?)";
    private static final String NF_SUFFIX = "\\.?$";
    private static final String NF_SEARCH = "^cleartool: Error: Unable to .+? \".+?\" ?[:-] (.+?)\\.?$";
    static final String DEFAULT_CQ_ACTION = "";
    static final String DEFAULT_CI_COMMENT = "";
    protected static final String READ_ONLY_PATTERN = "read only";
    public static final String SEMICOLON;
    public static final String ATSIGN;
    protected static final String CATCS = "catcs";
    protected static final String CHBL = "chbl";
    protected static final String CHECKIN = "checkin";
    protected static final String CHECKOUT = "checkout";
    protected static final String CHEVENT = "chevent";
    protected static final String CHPROJECT = "chproject";
    protected static final String CHTYPE = "chtype";
    protected static final String DELIVER = "deliver";
    protected static final String DESCRIBE = "describe";
    protected static final String DIFFBL = "diffbl";
    protected static final String DUMP = "dump";
    protected static final String FIND = "find";
    protected static final String LN = "ln";
    protected static final String LOCK = "lock";
    protected static final String LS = "ls";
    protected static final String LSACTIVITY = "lsactivity";
    protected static final String LSBL = "lsbl";
    protected static final String LSCO = "lsco";
    protected static final String LSFOLDER = "lsfolder";
    protected static final String LSHISTORY = "lshistory";
    protected static final String LSPRIVATE = "lsprivate";
    protected static final String LSPROJECT = "lsproject";
    protected static final String LSSTREAM = "lsstream";
    protected static final String LSTYPE = "lstype";
    protected static final String LSVIEW = "lsview";
    protected static final String LSVTREE = "lsvtree";
    protected static final String LSVOB = "lsvob";
    protected static final String MKACT = "mkact";
    protected static final String MKATTR = "mkattr";
    protected static final String MKBL = "mkbl";
    protected static final String MKBRTYPE = "mkbrtype";
    protected static final String MKCOMP = "mkcomp";
    protected static final String MKDIR = "mkdir";
    protected static final String MKELEM = "mkelem";
    protected static final String MKHLINK = "mkhlink";
    protected static final String MKLBTYPE = "mklbtype";
    protected static final String MKPROJECT = "mkproject";
    protected static final String MKSTREAM = "mkstream";
    protected static final String MKVIEW = "mkview";
    protected static final String MOVE = "move";
    protected static final String PROTECT = "protect";
    static final String PWV = "pwv";
    protected static final String REBASE = "rebase";
    protected static final String RMATTR = "rmattr";
    protected static final String RMBRANCH = "rmbranch";
    protected static final String RMNAME = "rmname";
    protected static final String RMSTREAM = "rmstream";
    protected static final String RMTYPE = "rmtype";
    protected static final String RMVIEW = "rmview";
    protected static final String SETACT = "setact";
    protected static final String SETCS = "setcs";
    protected static final String STARTVIEW = "startview";
    protected static final String UNCHECKOUT = "uncheckout";
    protected static final String UNLOCK = "unlock";
    protected static final String MKTYPE_PREFIX = "mk";
    protected static final String _ABORT = "-abort";
    protected static final String _ACTIVITY = "-activity";
    protected static final String _ACTIVITIES = "-activities";
    protected static final String _ADEPENDS_ON = "-adepends_on";
    protected static final String _ALL = "-all";
    protected static final String _AMODCOMP = "-amodcomp";
    protected static final String _ANCESTOR = "-ancestor";
    protected static final String _BASELINE = "-baseline";
    protected static final String _BRANCH = "-branch";
    protected static final String _CACT = "-cact";
    protected static final String _CANCEL = "-cancel";
    protected static final String _CHMOD = "-chmod";
    protected static final String _CI = "-ci";
    protected static final String _CO = "-co";
    protected static final String _COMMENT = "-comment";
    protected static final String _COMPLETE = "-complete";
    protected static final String _COMPONENT = "-component";
    protected static final String _CURRENT = "-current";
    protected static final String _CVIEW = "-cview";
    protected static final String _DDEPENDS_ON = "-ddepends_on";
    protected static final String _DEPTH = "-depth";
    protected static final String _DUMP = "-dump";
    protected static final String _ELEMENT = "-element";
    protected static final String _ELEMENTS = "-elements";
    protected static final String _FAMILY = "-family";
    protected static final String _FIRST_ONLY = "-first_only";
    protected static final String _FMT = "-fmt";
    protected static final String _FORCE = "-force";
    protected static final String _GLOBAL = "-global";
    protected static final String _GPATH = "-gpath";
    protected static final String _HEADLINE = "-headline";
    protected static final String _HOST = "-host";
    protected static final String _HPATH = "-hpath";
    protected static final String _IDENTICAL = "-identical";
    protected static final String _IN = "-in";
    protected static final String _INCREMENTAL = "-incremental";
    protected static final String _INTEGRATION = "-integration";
    protected static final String _INVOB = "-invob";
    protected static final String _KIND = "-kind";
    protected static final String _LONG = "-long";
    protected static final String _MASTER = "-master";
    protected static final String _MODEL = "-model";
    protected static final String _MODCOMP = "-modcomp";
    static final String _MVFSROOT = "-mvfsroot";
    protected static final String _NC = "-nc";
    protected static final String _NCO = "-nco";
    static final String _NONE = "-none";
    protected static final String _NSET = "-nset";
    protected static final String _NUSERS = "-nusers";
    protected static final String _NWARN = "-nwarn";
    protected static final String _OBSOLETE = "-obsolete";
    protected static final String _PNAME = "-pname";
    protected static final String _PRINT = "-print";
    protected static final String _READONLY = "-readonly";
    protected static final String _RECURSE = "-recurse";
    protected static final String _REPLACE = "-replace";
    protected static final String _RM = "-rm";
    protected static final String _RMALL = "-rmall";
    protected static final String _ROOT = "-root";
    protected static final String _S = "-s";
    protected static final String _SHARED = "-shared";
    protected static final String _SHORT = "-short";
    protected static final String _SINCE = "-since";
    protected static final String _STREAM = "-stream";
    protected static final String _TAG = "-tag";
    protected static final String _TMODE = "-tmode";
    protected static final String _TO = "-to";
    protected static final String _VERSION = "-version";
    protected static final String _VERSIONS = "-versions";
    protected static final String _VIEW = "-view";
    protected static final String _VISIBLE = "-visible";
    protected static final String COMPRESSED_FILE = "compressed_file";
    protected static final String FMT_BAR = "|";
    protected static final String FMT_HLINK_PREFIX = "%[hlink:";
    protected static final String FMT_NEWLINE = "\\n";
    protected static final String FMT_SUFFIX = "]p";
    protected static final String FMT_SUFFIX_COMMA = "]Cp";
    protected static final String FMT_ATTRIBUTE_PREFIX = "|%NS[";
    protected static final String FMT_ATTRIBUTE_SUFFIX = "]a";
    protected static final String PLUS_X = "+x";
    protected static final String MINUS_X = "-x";
    protected static final String FMT_ACTIVITY_P = "%[activity]Xp";
    protected static final String FMT_ACTIVITY_SHORT_P = "%[activity]p";
    protected static final String FMT_ACTIVITY_P_NEWLINE = "%[activity]Xp\\n";
    protected static final String FMT_ATTRIBUTES = "%a";
    protected static final String FMT_ATTRIBUTES_VALUE_ONLY = "%Sa";
    protected static final String FMT_BL_STREAM = "%[bl_stream]p";
    protected static final String FMT_CO = "%Rf";
    protected static final String FMT_COMPONENTS_CXP = "%[components]CXp";
    protected static final String FMT_COMPONENT_XP = "%[component]Xp";
    protected static final String FMT_CONTAINS_FOLDERS_CXP = "%[contains_folders]CXp";
    protected static final String FMT_CONTAINS_PROJECTS_CXP = "%[contains_projects]CXp";
    protected static final String FMT_CRM_RECORD_TYPE_P = "%[crm_record_type]p";
    protected static final String FMT_CRM_RECORD_ID_P = "%[crm_record_id]p";
    protected static final String FMT_DEPENDS_ON_CLOSURE_CXP_NEWLINE = "%[depends_on_closure]CXp\\n";
    protected static final String FMT_DEPENDS_ON_CXP = "%[depends_on]CXp\\n";
    protected static final String FMT_DSTREAMS_CXP = "%[dstreams]CXp";
    protected static final String FMT_ELEMENT_TYPE = "%[type]p";
    protected static final String FMT_EN = "%En";
    protected static final String FMT_FOUND_BLS_CXP = "%[found_bls]CXp";
    protected static final String FMT_GROUP = "%[group]p";
    protected static final String FMT_HLINK_FOUNDATION_P = "%[hlink:Foundation]p";
    protected static final String FMT_INITIAL_BL_XP = "%[initial_bl]Xp";
    protected static final String FMT_ISSTREAM_CXP = "%[istream]CXp";
    protected static final String FMT_LABEL_STATUS_P = "%[label_status]p";
    protected static final String FMT_LATEST_BLS_CXP = "%[latest_bls]CXp";
    protected static final String FMT_LOCKED_P = "%[locked]p";
    protected static final String FMT_MODEL_P = "%[model]p";
    protected static final String FMT_MOD_COMPONENTS_CXP = "%[mod_comps]CXp";
    protected static final String FMT_MTYPE = "%m";
    protected static final String FMT_N = "%n";
    protected static final String FMT_NC = "%Nc";
    protected static final String FMT_NUMERIC_DATE = "%Nd";
    protected static final String FMT_OBSOLETE = "%[locked]p";
    protected static final String FMT_OWNER = "%[group]p/%u";
    protected static final String FMT_PERMISSIONS_P = "%[permissions]p";
    protected static final String FMT_PRED_VERSION_NAME = "%PVn";
    protected static final String FMT_PREDECESSOR_XP = "%[predecessor]Xp";
    protected static final String FMT_PROJECT_XP = "%[project]Xp";
    protected static final String FMT_READ_ONLY = "%[read_only]p";
    protected static final String FMT_ROOT_DIR = "%[root_dir]p";
    protected static final String FMT_SLINK_TEXT_P = "%[slink_text]p";
    protected static final String FMT_TYPE_P = "%[type]p";
    protected static final String FMT_UNIVERSAL_SELECTOR_P = "%[universal_selector]p";
    protected static final String FMT_UNIVERSAL_SELECTOR_XP = "%[universal_selector]%Xp";
    protected static final String FMT_USER = "%u";
    protected static final String FMT_VERSION_NAME = "%Vn";
    protected static final String FMT_XN = "%Xn";
    public static final String ADMIN_VOB = "AdminVOB";
    protected static final String ATTRIBUTE = "attribute";
    protected static final String BASELINE_LBTYPE = "BaselineLbtype";
    protected static final String BRANCH_LATEST = "/LATEST";
    protected static final String COMPONENT_ROOT_DIR_HLTYPE = "ComponentRootDir";
    protected static final String HYPERLINK = "hyperlink";
    protected static final String INDEPENDENT_GUARD = "IndependentGuard";
    protected static final String LOCKED = "locked";
    protected static final String LOST_AND_FOUND_NAME = "lost+found";
    protected static final String MTYPE_EQUALS_SYMBOLIC_LINK = "mtype=symbolic link";
    protected static final String QUERY_BRTYPE_PREFIX = "brtype(";
    protected static final String QUERY_CREATED_SINCE_PREFIX = "created_since(";
    protected static final String QUERY_LABEL_TYPE = "lbtype(";
    protected static final String QUERY_NOT_LABEL_TYPE = "!lbtype(";
    protected static final char QUERY_SUFFIX_CHAR = ')';
    protected static final String QUERY_VERSION_PREFIX = "version(.../";
    protected static final String ROOT_FOLDER = "RootFolder";
    protected static final String UCM_REBASE_PVAR = "UCM_REBASE";
    protected static final String NOT_LABELED = "Not Labeled";
    protected static final String _UNAVAILABLE_ = "<unavailable>";
    static final String LATEST = "LATEST";
    static final String CHECKEDOUT = "CHECKEDOUT";
    protected static final String BACKSTOP = "BACKSTOP";
    private static final String CLEARTOOL_ERROR_PATTERN = "cleartool: Error: .*";
    private static final Pattern OBJECT_ALREADY_EXISTS_PATTERN;
    private static final String DEFAULT_MVFSROOT;
    public static final String AT_AT = "@@";
    public static final String AT = "@";
    private static final String AMPAMP = " && ";
    public static final String SPACE = " ";
    public static final String DOUBLE_QUOTE = "\"";
    public static final String EMPTY_STRING;
    private static final String DEPTH_LIMIT = "2";
    public static final String OBSOLETE = "obsolete";
    public static final String OPEN_PAREN;
    public static final String CLOSE_PAREN;
    public static final String MERGE_HLTYPE_NAME = "Merge";
    public static final String BASE_CC_SUBVOB_COMPONENT_ATTYPE = "com.ibm.rational.interop.ClearCase.subVOB_Component";
    private static final String ATT_TYPE_OPEN = "{attype(";
    private static final String ATT_TYPE_CLOSE = ")}";
    private static final String ADD = "add";
    private static final String _DATABASE = "-database";
    private static final String _CONNECTION = "-connection";
    private static final String _USERNAME = "-username";
    static final String _PASSWORD = "-password";
    private static final String _USERDB = "-userdb";
    private static final String _DBSET = "-dbset";
    private static final String _TYPE = "-type";
    private static final String _ID = "-id";
    private static final String _ACTION = "-action";
    private static final String COVOB_ATTR_NAMESPACE = "com.ibm.team.interop";
    private static final String COVOB_ATTR_NAME = "CoVOB";
    private static final String COVOB_ATTR = "com.ibm.team.interop_CoVOB";
    private static final String MVFS_CASE_PRESERVING_MODE = "Case PRESERVING mode";
    private static final String MVFS_DOWNCASING_MODE = "Downcasing mode";
    static final String DOT_REGEXP = "\\.";
    static final String COLON_REGEXP = "\\:";
    protected static final CommandResult.ResultBehaviorFlags IGNORE_Nothing;
    protected static final CommandResult.ResultBehaviorFlags IGNORE_NoViewInfo;
    protected static final CommandResult.ResultBehaviorFlags IGNORE_NotFound_NoViewInfo;
    Log log = null;
    public static final String DIRECTORY_CONTENT_TYPE = "text/directory";
    private final Cache _elementTypeToMimeContentType = new Cache();
    private final Cache _elementTypeToCharacterSet = new Cache();
    private static final String NO_BRANCH_CHECKED_OUT = "Error: No branch of element is checked out to view";
    private static final String UNABLE_TO_FIND_CHECKED_OUT_VERSION = "Error: Unable to find checked out version for";
    private static final Pattern NOT_CHECKED_IN_PATTERN;
    private static final Pattern CHECKIN_IDENTICAL_ERR_PATTERN;
    private static final String TRACE_TRIGGER_PATTERN = "^.*\\(cleartool\\): Firing.*";
    private static final String TRIGGER_WARNING_PATTERN = "cleartool: Warning: Trigger.*";
    private static final Pattern LS_VOB_OUT_PATTERN;
    private static final Pattern VOB_SEL_PATTERN;
    private static final String COMMENT_START_DELIM = "!#$";
    private static final String COMMENT_END_DELIM = "$#!";
    private final Cache describeOutputByName = new Cache();
    private static final String UTF_8 = "UTF-8";
    private static final Pattern ATTRIBUTE_TYPE_PATTERN;
    private static final Pattern VALUE_TYPE_PATTERN;
    protected Map<String, Map<String, String>> vobTag2attrMap = new HashMap<String, Map<String, String>>();
    private final Cache componentByBaseline = new Cache();
    private static final String KEY_OBJSEL = "objSel";
    private static final String KEY_UUID = "uuid";
    private static final Pattern NAME_PATTERN;
    private static final Pattern OID_PATTERN;
    private static final Pattern ELEM_DBID_PATTERN;
    private static final Pattern DUMP_OID_PATTERN;
    private static final Pattern MTYPE_PATTERN;
    public static final String DUMP_MTYPE_DIRECTORY = "2";
    public static final String DUMP_MTYPE_SYMLINK = "7";
    public static final String DUMP_MTYPE_VIEW_PRIVATE = "19";
    protected static final String LITERAL_VERTICAL_BAR_PATTERN = "\\|";
    private final HashMap<String, String> vobFamily2VobTag = new HashMap();
    private final Cache streamByView = new Cache();
    private final Cache projectByStream = new Cache();
    private final Cache labeltypeByBaseline = new Cache();
    private static Set<String> viewsOnUCMCQStreams;
    private static Set<String> activityOnNonCQEnabledProject;
    private static Set<String> activityOnCQEnabledProject;
    public static final Pattern TFD_CREATE_VERSION_FAILED;
    private final Cache mtypeByObject = new Cache();
    private static final Pattern CREATED_BASELINE_PATTERN;
    private static final Pattern UNLABELED_BASELINE_PATTERN;
    private static final Pattern COMPONENT_LINE_PATTERN;
    private final Cache rootDirByComponentAndView = new Cache();
    private static final Pattern HLINK_TO_EMPTY_PATTERN;
    private static final Pattern COMP_ROOT_DIR_PATTERN;
    private static final String HLINK_COLON = "hlink:";
    private static final Pattern HLINK_TARGET_LEFT_ARROW_PATTERN;
    private final Pattern ERROR_VIEW_TAG_EXISTS = Pattern.compile("View tag registry entry for tag '(.*)' already exists.");
    private static final Pattern LS_VOBVIEW_PATTERN;
    private final Cache mainBranchNameByVobTag = new Cache();
    String cachedVobTagValue = null;
    IPath cachedVobTagPath = null;
    private final Cache extendedNameByUSel = new Cache();
    private final Cache parentByStreamSel = new Cache();
    private static final Pattern CANT_CONTACT_ALBD_PATTERN;
    private final Cache baseCCViewInfo = new Cache();
    private static final Pattern SUPERTYPE_PATTERN;
    private final Cache queryStringForActivity = new Cache();
    private final Cache ucmActivityPvar = new Cache();
    private final Cache recordDbids = new Cache();
    private final Map<String, Boolean> cachedIsVOBUCM = new HashMap<String, Boolean>();
    private static final Pattern CRDE_PATTERN;
    private final Cache intstreamByStream = new Cache();
    private final Cache intstreamByProject = new Cache();
    private final Set<String> isBaseCCView = Collections.synchronizedSet(new HashSet());
    private final Set<String> isUCMView = Collections.synchronizedSet(new HashSet());
    private static Map<String, List<String>> checkoutVobs;
    private static List<Character> executableValues;
    private static final Pattern LOGFILE_PATTERN;
    private static final String EITHER_SLASH = ".*[/\\\\]";
    private static final String EOS_OR_EITHER_SLASH = "($|.*[/\\\\].+)";
    private static final String OPTIONAL_ATAT = "(@@)?";
    private static final String lAndFPattern = ".*[/\\\\]lost\\+found(@@)?($|.*[/\\\\].+)";
    private static final Pattern MTYPE_STREAM_PATTERN;
    private static final String CHILD_ACTIVITIES_HEADER = "child activities:";
    private static final String TIMELINES_HEADER = "timelines:";
    private static final Pattern DBID_PATTERN;
    private static final String FLEVEL7_MTYPE = "stream";
    private static final Pattern FOUNDATION_BL_PATTERN;
    protected Map<String, Map<String, String>> streamInitialFoundationMap = new HashMap<String, Map<String, String>>();
    private final HashMap<String, List<String>> allBaselinesForStreamByComponent = new HashMap();
    private final HashMap<String, List<String>> allObjectsWithAttribute = new HashMap();
    protected HashMap<String, Map<String, String>> streamFoundationMap = new HashMap();
    private final HashMap<String, List<String>> baselineMemberMap = new HashMap();
    static final Pattern CONSECUTIVE_LINE_BREAKS;
    public static final String VERSION_HISTORY_FMT_FIRST_PART;
    public static final String VERSION_HISTORY_FMT_W_ACT_FIRST_PART;
    public static final String VERSION_HISTORY_FMT_LAST_PART = "$#!\\n";
    public static final String BRANCH_TYPE_FMT = "%n|%[universal_selector]p|%[locked]p\\n";
    public static final String DIGITS_PATTERN = "\\d+";
    public static final String START_GROUPING_PATTERN;
    public static final String END_GROUPING_PATTERN;
    public static final String EITHER_WAY_ARROW_PATTERN = " (?:(?:<-)|(?:->)) ";
    public static final String ANYTHING_BUT_DOUBLE_QUOTE_PATTERN = "[^\"]+?";
    public static final String OPTIONAL_WHITE_SPACE = "\\s*";
    public static final Pattern MERGE_PATTERN;
    public static final String MERGE_INTO_ARROW = "<-";
    private static Pattern brTypePtn;
    private static Pattern streamPtn;
    private final HashMap<String, Boolean> _branchTypeAllCache = new HashMap();

    static {
        GENERIC_HEADLINE = Messages.CCaseLib_CQ_RECORD_NAME;
        CQ_CREDS = null;
        MKACT_SCRIPT = null;
        DBID_SCRIPT = null;
        GET_COMMENT_SCRIPT = null;
        SET_COMMENT_SCRIPT = null;
        PERFORM_CQ_ACTION_SCRIPT = null;
        NOT_FOUND_PATTERN = UNINITIALIZED_NOT_FOUND;
        NOT_FOUND = UNINITIALIZED_NOT_FOUND;
        SEMICOLON = String.valueOf(';');
        ATSIGN = String.valueOf('@');
        OBJECT_ALREADY_EXISTS_PATTERN = Pattern.compile("^.*?Error: Name \"(.*?)\" already exists.");
        DEFAULT_MVFSROOT = CommandProvider.IS_WINDOWS ? "M:" : "/view";
        EMPTY_STRING = new String();
        OPEN_PAREN = String.valueOf('(');
        CLOSE_PAREN = String.valueOf(')');
        IGNORE_Nothing = new CommandResult.ResultBehaviorFlags(new CommandResult.ResultBehaviorFlags.Kind[0]);
        IGNORE_NoViewInfo = new CommandResult.ResultBehaviorFlags(CommandResult.ResultBehaviorFlags.Kind.IGNORE_NO_VIEW_INFO);
        IGNORE_NotFound_NoViewInfo = new CommandResult.ResultBehaviorFlags(CommandResult.ResultBehaviorFlags.Kind.IGNORE_NOT_FOUND, CommandResult.ResultBehaviorFlags.Kind.IGNORE_NO_VIEW_INFO);
        NOT_CHECKED_IN_PATTERN = Pattern.compile("^.*?Error: Unable to check in \"(.*?)\"\\.");
        CHECKIN_IDENTICAL_ERR_PATTERN = Pattern.compile("^.*?By default, won't create version with data identical to predecessor.$");
        LS_VOB_OUT_PATTERN = Pattern.compile("^[ \\*] (.*?) .*? .*? \\(.*ucmvob.*\\)");
        VOB_SEL_PATTERN = Pattern.compile("vob:(.+?)");
        ATTRIBUTE_TYPE_PATTERN = Pattern.compile("^attribute type \"(.+)\"");
        VALUE_TYPE_PATTERN = Pattern.compile("^  value type: (\\w+)");
        NAME_PATTERN = Pattern.compile("===> name: \"(.*?)\", ino: .*");
        OID_PATTERN = Pattern.compile("     cataloged oid: ([0-9a-f.:]+) \\(mtype .*");
        ELEM_DBID_PATTERN = Pattern.compile("^elem=([0-9]+)  branch=.*");
        DUMP_OID_PATTERN = Pattern.compile("^oid=([^ ]*)");
        MTYPE_PATTERN = Pattern.compile("     cataloged oid: [0-9a-f.:]+ \\(mtype ([0-9]+)\\)");
        viewsOnUCMCQStreams = Collections.synchronizedSet(new HashSet());
        activityOnNonCQEnabledProject = Collections.synchronizedSet(new HashSet());
        activityOnCQEnabledProject = Collections.synchronizedSet(new HashSet());
        TFD_CREATE_VERSION_FAILED = Pattern.compile("^cleartool: Error: Type manager \"\\w+\" failed create_version operation.$");
        CREATED_BASELINE_PATTERN = Pattern.compile("Created baseline \"(.+?)\" in component.+");
        UNLABELED_BASELINE_PATTERN = Pattern.compile("cleartool: Warning: Some of stream \"(.+?)\"'s latest baselines are not labeled\nUnlabeled baselines can't be recommended and can't be rebased to.\nUse \"cleartool chbl -incremental <baseline-selector>\" to label these baselines:\n(.+?)");
        COMPONENT_LINE_PATTERN = Pattern.compile("(.+?) \\(component (.+?)\\)");
        HLINK_TO_EMPTY_PATTERN = Pattern.compile("\"(.+?)\" -> \"\"");
        COMP_ROOT_DIR_PATTERN = Pattern.compile(".+ -> \"(.+)@@(.*)\"");
        HLINK_TARGET_LEFT_ARROW_PATTERN = Pattern.compile("\".+?\" <- \"(.+?)\" ");
        LS_VOBVIEW_PATTERN = Pattern.compile("^.? +.+? +([^ ]+)");
        CANT_CONTACT_ALBD_PATTERN = Pattern.compile("^cleartool: Error: Unable to contact albd_server on host '(.*?)'");
        SUPERTYPE_PATTERN = Pattern.compile("^  supertype: (.+)");
        CRDE_PATTERN = Pattern.compile("^crde=(\\d+) *$");
        checkoutVobs = new Hashtable<String, List<String>>();
        executableValues = Arrays.asList(Character.valueOf('1'), Character.valueOf('3'), Character.valueOf('5'), Character.valueOf('7'), Character.valueOf('x'));
        LOGFILE_PATTERN = Pattern.compile("^\\s*Kernel logfile:\\s+\"(.+)\"$");
        MTYPE_STREAM_PATTERN = Pattern.compile("^mtype=(\\S+)");
        DBID_PATTERN = Pattern.compile("(\\d+) ");
        FOUNDATION_BL_PATTERN = Pattern.compile("<-\\s+\"(\\S+)\"");
        CONSECUTIVE_LINE_BREAKS = Pattern.compile("\n[\t\n ]*\n");
        VERSION_HISTORY_FMT_FIRST_PART = "%m|%[universal_selector]p|%Vn|%PVn|%Nd|%[group]p" + CommonUtils.FWDSLASH + FMT_USER + '|' + "%[locked]p" + '|' + FMT_HLINK_PREFIX + MERGE_HLTYPE_NAME + FMT_SUFFIX + '|' + COMMENT_START_DELIM;
        VERSION_HISTORY_FMT_W_ACT_FIRST_PART = "%m|%[universal_selector]p|%Vn|%PVn|%Nd|%[group]p" + CommonUtils.FWDSLASH + FMT_USER + '|' + FMT_ACTIVITY_SHORT_P + '|' + "%[locked]p" + '|' + FMT_HLINK_PREFIX + MERGE_HLTYPE_NAME + FMT_SUFFIX + '|' + COMMENT_START_DELIM;
        START_GROUPING_PATTERN = OPEN_PAREN;
        END_GROUPING_PATTERN = CLOSE_PAREN;
        MERGE_PATTERN = Pattern.compile("\"Merge" + ATSIGN + DIGITS_PATTERN + ATSIGN + ANYTHING_BUT_DOUBLE_QUOTE_PATTERN + DOUBLE_QUOTE + START_GROUPING_PATTERN + EITHER_WAY_ARROW_PATTERN + END_GROUPING_PATTERN + DOUBLE_QUOTE + START_GROUPING_PATTERN + ANYTHING_BUT_DOUBLE_QUOTE_PATTERN + END_GROUPING_PATTERN + DOUBLE_QUOTE + OPTIONAL_WHITE_SPACE);
        brTypePtn = Pattern.compile("^branch type \"(.+)\"$");
        streamPtn = Pattern.compile("Guarded by: (.+)$");
    }

    public final String getTextMode() {
        InteropUtilities.LineSeparator ls = InteropUtilities.LineSeparator.valueOf((String)this.ctInitArgs.get("com.ibm.team.connector.scm.LINE_DELIMITER"));
        InteropUtilities.LineSeparator wls = InteropUtilities.LineSeparator.valueOf((String)this.getActualWorkspaceLineSeparator());
        if (ls.equals((Object)InteropUtilities.LineSeparator.LF) && wls.equals((Object)InteropUtilities.LineSeparator.CRLF)) {
            return "insert_cr";
        }
        if (ls.equals((Object)InteropUtilities.LineSeparator.CRLF) && wls.equals((Object)InteropUtilities.LineSeparator.LF)) {
            return "strip_cr";
        }
        if (!ls.equals((Object)wls)) {
            throw new RuntimeException("Unexpected LINE_SEPARATOR and WINDOWS_LINE_SEPARATOR values");
        }
        return "transparent";
    }

    public String getWorkspaceLineSeparator() {
        InteropUtilities.LineSeparator ls = InteropUtilities.LineSeparator.valueOf((String)this.ctInitArgs.get("com.ibm.team.connector.scm.LINE_DELIMITER_WORKSPACE"));
        return ls.name();
    }

    public String getActualWorkspaceLineSeparator() {
        InteropUtilities.LineSeparator ls = InteropUtilities.LineSeparator.valueOf((String)this.ctInitArgs.get("com.ibm.team.connector.scm.LINE_DELIMITER_WORKSPACE"));
        if (InteropUtilities.LineSeparator.PLATFORM.equals((Object)ls)) {
            return CommandProvider.IS_WINDOWS ? InteropUtilities.LineSeparator.CRLF.name() : InteropUtilities.LineSeparator.LF.name();
        }
        return ls.name();
    }

    public String getWorkspaceLineDelimiterText() {
        switch (InteropUtilities.LineSeparator.valueOf((String)this.getActualWorkspaceLineSeparator())) {
            case CRLF: {
                return "\r\n";
            }
            case LF: {
                return "\n";
            }
        }
        throw new RuntimeException("Unexpected LineSeparator value");
    }

    static final String getDefaultViewDir() {
        return defaultViewDir;
    }

    public static void setDefaultViewTag(String viewTag) {
        defaultViewDir = CCaseLib.getPathIntoView(viewTag);
    }

    void logDebug(String msg) {
        if (this.log == null) {
            this.log = LogFactory.getLog((String)CCaseLib.class.getName());
        }
        this.log.debug((Object)msg);
    }

    void logInfo(String msg) {
        System.out.println(msg);
    }

    void logIgnoredExceptionAsNotAlwaysVisible(String methodName, String operation, Exception e) {
        this.logDebug("Ignored Exception: method: " + methodName + " in an attempt to " + operation + " is ignoring exception: " + e.getMessage());
    }

    void logIgnoredExceptionAsNotAlwaysVisible(String methodName, String operation, Exception e, String extraDescription) {
        this.logDebug("Ignored Exception: method: " + methodName + " in an attempt to " + operation + " is ignoring exception: " + e.getMessage() + " with additional description: " + extraDescription);
    }

    void logIgnoredExceptionAsAlwaysVisible(String methodName, String logMessage, Exception e) {
        Object[] bindings = new String[]{methodName, e.getMessage()};
        this.logInfo(NLS.bind((String)logMessage, (Object[])bindings));
    }

    void logIgnoredExceptionAsAlwaysVisible(String methodName, String logMessage, Exception e, String extraDescription) {
        Object[] bindings = new String[]{methodName, e.getMessage(), extraDescription};
        this.logInfo(NLS.bind((String)logMessage, (Object[])bindings));
    }

    public CCaseLib(CommandProvider provider, Map<String, String> initArgs, boolean enableCaching) {
        String defaultViewTag;
        this.ctProvider = provider;
        this.ctInitArgs = initArgs == null ? new HashMap() : initArgs;
        this.cachingEnabled = enableCaching;
        CTProvider.CTFeedback feedback = new CTProvider.CTFeedback(null);
        if (mvfsRoot == null) {
            try {
                mvfsRoot = this.ctProvider.execute((SrvcFeedback)feedback, PWV, _MVFSROOT);
            }
            catch (WvcmException e) {
                mvfsRoot = DEFAULT_MVFSROOT;
                this.logIgnoredExceptionAsAlwaysVisible("CCaseLib.CCaseLib", Messages.CCaseLib_IGNORED_EXCEPTION_GET_MVFS_ROOT, (Exception)((Object)e));
            }
        }
        defaultViewDir = (defaultViewTag = CTInitArgUtils.getViewTag(this.ctInitArgs)) == null ? null : CCaseLib.getPathIntoView(defaultViewTag);
        this._elementTypeToMimeContentType.put(null, "binary_delta_file", APPLICATION_UNKNOWN);
        this._elementTypeToMimeContentType.put(null, COMPRESSED_FILE, APPLICATION_UNKNOWN);
        this._elementTypeToMimeContentType.put(null, "compressed_text_file", TEXT_PLAIN);
        this._elementTypeToMimeContentType.put(null, "directory", DIRECTORY_CONTENT_TYPE);
        this._elementTypeToMimeContentType.put(null, "file", APPLICATION_UNKNOWN);
        this._elementTypeToMimeContentType.put(null, "file_system_object", APPLICATION_UNKNOWN);
        this._elementTypeToMimeContentType.put(null, "html", APPLICATION_HTML);
        this._elementTypeToMimeContentType.put(null, "ms_word", APPLICATION_MSWORD);
        this._elementTypeToMimeContentType.put(null, "process_def_object", APPLICATION_UNKNOWN);
        this._elementTypeToMimeContentType.put(null, "rose", APPLICATION_UNKNOWN);
        this._elementTypeToMimeContentType.put(null, "rosert", APPLICATION_UNKNOWN);
        this._elementTypeToMimeContentType.put(null, "text_file", TEXT_PLAIN);
        this._elementTypeToMimeContentType.put(null, "xde", APPLICATION_UNKNOWN);
        this._elementTypeToMimeContentType.put(null, "xml", APPLICATION_XML);
        this._elementTypeToMimeContentType.put(null, "utf16be_file", TEXT_PLAIN);
        this._elementTypeToMimeContentType.put(null, "utf16le_file", TEXT_PLAIN);
        this._elementTypeToMimeContentType.put(null, "utf32be_file", TEXT_PLAIN);
        this._elementTypeToMimeContentType.put(null, "utf32le_file", TEXT_PLAIN);
        this._elementTypeToMimeContentType.put(null, "utf8_file", TEXT_PLAIN);
        this._elementTypeToMimeContentType.put(null, new String(), APPLICATION_UNKNOWN);
        this._elementTypeToCharacterSet.put(null, "binary_delta_file", CCaseLib.EMPTY_STRING);
        this._elementTypeToCharacterSet.put(null, COMPRESSED_FILE, CCaseLib.EMPTY_STRING);
        this._elementTypeToCharacterSet.put(null, "compressed_text_file", CCaseLib.EMPTY_STRING);
        this._elementTypeToCharacterSet.put(null, "directory", CCaseLib.EMPTY_STRING);
        this._elementTypeToCharacterSet.put(null, "file", CCaseLib.EMPTY_STRING);
        this._elementTypeToCharacterSet.put(null, "file_system_object", CCaseLib.EMPTY_STRING);
        this._elementTypeToCharacterSet.put(null, "html", CCaseLib.EMPTY_STRING);
        this._elementTypeToCharacterSet.put(null, "ms_word", CCaseLib.EMPTY_STRING);
        this._elementTypeToCharacterSet.put(null, "process_def_object", CCaseLib.EMPTY_STRING);
        this._elementTypeToCharacterSet.put(null, "rose", CCaseLib.EMPTY_STRING);
        this._elementTypeToCharacterSet.put(null, "rosert", CCaseLib.EMPTY_STRING);
        this._elementTypeToCharacterSet.put(null, "text_file", CCaseLib.EMPTY_STRING);
        this._elementTypeToCharacterSet.put(null, "xde", CCaseLib.EMPTY_STRING);
        this._elementTypeToCharacterSet.put(null, "xml", CCaseLib.EMPTY_STRING);
        this._elementTypeToCharacterSet.put(null, "utf16be_file", "UTF-16BE");
        this._elementTypeToCharacterSet.put(null, "utf16le_file", "UTF-16LE");
        this._elementTypeToCharacterSet.put(null, "utf32be_file", "UTF-32BE");
        this._elementTypeToCharacterSet.put(null, "utf32le_file", "UTF-32LE");
        this._elementTypeToCharacterSet.put(null, "utf8_file", UTF_8);
        this._elementTypeToCharacterSet.put(null, CCaseLib.EMPTY_STRING, CCaseLib.EMPTY_STRING);
        if (!NOT_FOUND_PATTERN.equals(UNINITIALIZED_NOT_FOUND)) {
            return;
        }
        try {
            CommandResult result = this.ctProvider.executeGetResult((SrvcFeedback)feedback, DESCRIBE, _SHORT, DOES_NOT_EXIST);
            String error = result.getStdErr();
            Pattern pattern = Pattern.compile(NF_SEARCH);
            Matcher m = pattern.matcher(error);
            if (m.find()) {
                NOT_FOUND = m.group(1);
                NOT_FOUND_PATTERN = NF_PREFIX + NOT_FOUND + NF_SUFFIX;
            }
        }
        catch (WvcmException e) {
            this.logIgnoredExceptionAsAlwaysVisible("CCaseLib.CCaseLib", Messages.CCaseLib_IGNORED_EXCEPTION_MATCH_NOT_FOUND_MSG, (Exception)((Object)e));
        }
    }

    static final String getNotFoundPattern() throws WvcmException {
        if (NOT_FOUND_PATTERN.equals(UNINITIALIZED_NOT_FOUND)) {
            throw new WvcmException(UNINITIALIZED_NOT_FOUND, WvcmException.ReasonCode.FORBIDDEN);
        }
        return NOT_FOUND_PATTERN;
    }

    public static final String getMvfsRoot() {
        if (mvfsRoot == null) {
            throw new IllegalStateException("CCaseLib has not been initialized");
        }
        return mvfsRoot;
    }

    public static final String getPathIntoView(String viewTag) {
        return String.format("%s%s%s", mvfsRoot, File.separator, viewTag);
    }

    public static boolean compareViewPrefix(String viewPrefix1, String viewPrefix2) {
        String prefix1 = viewPrefix1;
        String prefix2 = viewPrefix2;
        if (CommandProvider.IS_WINDOWS) {
            prefix1 = prefix1.toLowerCase().replace(File.separator, CTLocation.PATHNAME_SEPARATOR_STRING);
            prefix2 = prefix2.toLowerCase().replace(File.separator, CTLocation.PATHNAME_SEPARATOR_STRING);
        }
        return prefix1.equals(prefix2);
    }

    public void checkin(boolean identicalOK, String ciComment, List<String> checkouts, SrvcFeedback feedback) throws WvcmException {
        ArrayList<String> cleartoolArgs = new ArrayList<String>(7);
        cleartoolArgs.add(CHECKIN);
        cleartoolArgs.add(_NWARN);
        if (identicalOK) {
            cleartoolArgs.add(_IDENTICAL);
        }
        this.addCommentArg(cleartoolArgs, ciComment);
        List<CommandResult> checkoutResults = this.executeBatched(feedback, null, cleartoolArgs, checkouts);
        for (CommandResult checkoutResult : checkoutResults) {
            List<String> pathsToUnco;
            if (checkoutResult.getStat() == 0 || checkoutResult.getStdErrList() == null) continue;
            if (!identicalOK && (pathsToUnco = CCaseLib.getPathsToUnco(checkouts.size(), checkoutResult)).size() > 0) {
                System.out.printf("** Duplicate content write to ClearCase\n", new Object[0]);
                this.uncheckoutSilently(pathsToUnco, feedback);
            }
            ArrayList<String> newStdErr = new ArrayList<String>(checkoutResult.getStdErrList().size());
            for (String line : checkoutResult.getStdErrList()) {
                if (line.contains(NO_BRANCH_CHECKED_OUT) || line.contains(UNABLE_TO_FIND_CHECKED_OUT_VERSION)) {
                    feedback.notifyWarning(NLS.bind((String)Messages.CCaseLib_WARNING_IGNORE_CLEARTOOL_ERROR, (Object)line));
                    continue;
                }
                newStdErr.add(line);
            }
            checkoutResult.updateResults(checkoutResult.getStat(), newStdErr, checkoutResult.getStdOutList(), checkoutResult.getDurationMillis());
            if (checkoutResult.getStdErrList().isEmpty()) continue;
            checkoutResult.assertSuccess(IGNORE_NotFound_NoViewInfo);
        }
    }

    private void addCommentArg(List<String> cleartoolArgs, String ciComment) {
        String comment = ciComment;
        String defaultCIComment = CTInitArgUtils.getCheckinComment(this.ctInitArgs);
        if (defaultCIComment != null && defaultCIComment.length() > 0) {
            comment = comment == null ? defaultCIComment : String.valueOf(defaultCIComment) + "\n" + comment;
        }
        if (comment == null) {
            cleartoolArgs.add(_NC);
        } else {
            cleartoolArgs.add(_COMMENT);
            cleartoolArgs.add(comment);
        }
    }

    public static List<String> getPathsToUnco(int size, CommandResult checkoutResult) throws WvcmException {
        ArrayList<String> pathsToUnco = new ArrayList<String>(size);
        List<String> stdErr = checkoutResult.getStdErrList();
        ArrayList<String> newStdErr = new ArrayList<String>(stdErr.size());
        boolean getNotCheckedInName = false;
        for (String line : stdErr) {
            if (!line.matches(CLEARTOOL_ERROR_PATTERN)) {
                if (!line.matches(TRACE_TRIGGER_PATTERN) && !line.matches(TRIGGER_WARNING_PATTERN)) continue;
                newStdErr.add(line);
                continue;
            }
            if (getNotCheckedInName) {
                Matcher notCheckedIn = NOT_CHECKED_IN_PATTERN.matcher(line);
                if (notCheckedIn.find()) {
                    String uncheckout = notCheckedIn.replaceAll("$1");
                    pathsToUnco.add(uncheckout);
                }
                getNotCheckedInName = false;
                continue;
            }
            Matcher m = CHECKIN_IDENTICAL_ERR_PATTERN.matcher(line);
            getNotCheckedInName = m.find();
            if (getNotCheckedInName) continue;
            newStdErr.add(line);
        }
        checkoutResult.updateResults(checkoutResult.getStat(), newStdErr, checkoutResult.getStdOutList(), checkoutResult.getDurationMillis());
        return pathsToUnco;
    }

    private void uncheckoutSilently(List<String> checkouts, SrvcFeedback feedback) throws WvcmException {
        ArrayList<String> cleartoolArgs = new ArrayList<String>(Arrays.asList(UNCHECKOUT, _RM));
        this.executeBatched(feedback, cleartoolArgs, checkouts);
    }

    public List<String> getCheckouts(List<String> componentRoots, String viewTag, SrvcFeedback feedback) throws WvcmException {
        List<String> checkouts = new ArrayList<String>();
        if (!componentRoots.isEmpty()) {
            String pathIntoView = CCaseLib.getPathIntoView(viewTag);
            ArrayList<String> cleartoolArgs = new ArrayList<String>(Arrays.asList(LSCO, _CVIEW, _SHORT, _ALL));
            checkouts = this.executeBatched(feedback, pathIntoView, IGNORE_NoViewInfo, cleartoolArgs, componentRoots);
            if (checkouts.size() > 1) {
                HashSet<String> fixedCheckouts = new HashSet<String>(checkouts.size());
                fixedCheckouts.addAll(checkouts);
                if (fixedCheckouts.size() < checkouts.size()) {
                    checkouts = new ArrayList(fixedCheckouts.size());
                    checkouts.addAll(fixedCheckouts);
                }
            }
        }
        return checkouts;
    }

    private List<CommandResult> executeBatched(SrvcFeedback feedback, String cwd, List<String> cleartoolArgs, List<String> objNames) throws WvcmException {
        ArrayList<CommandResult> result = new ArrayList<CommandResult>(objNames.size());
        ArrayList<String> args = new ArrayList<String>(cleartoolArgs);
        int maxCmdLen = CTInitArgUtils.getMaxCmdLen(this.ctInitArgs);
        int cleartoolArgLen = 0;
        for (String cleartoolArg : cleartoolArgs) {
            cleartoolArgLen += cleartoolArg.length() + 1;
        }
        int cmdLen = cleartoolArgLen;
        for (String objName : objNames) {
            int newLen = cmdLen + objName.length() + 1;
            if (newLen <= maxCmdLen || cmdLen == cleartoolArgLen) {
                cmdLen = newLen;
            } else {
                result.add(this.ctProvider.executeGetResult(feedback, cwd, args));
                args.clear();
                args.addAll(cleartoolArgs);
                cmdLen = cleartoolArgLen + objName.length() + 1;
            }
            args.add(objName);
        }
        result.add(this.ctProvider.executeGetResult(feedback, cwd, args));
        return result;
    }

    private List<String> executeBatched(SrvcFeedback feedback, String cwd, CommandResult.ResultBehaviorFlags flags, List<String> cleartoolArgs, List<String> objNames) throws WvcmException {
        List<CommandResult> commandResults = this.executeBatched(feedback, cwd, cleartoolArgs, objNames);
        ArrayList<String> result = new ArrayList<String>(objNames.size());
        for (CommandResult r : commandResults) {
            boolean hasBackslash;
            CommandResult.ResultBehaviorFlags successFlags = flags;
            if (CommandProvider.IS_WINDOWS && !(hasBackslash = this.hasBackSlash(r.getCommand().subList(cleartoolArgs.size() + 1, r.getCommand().size())))) {
                successFlags = successFlags.subtract(CommandResult.ResultBehaviorFlags.Kind.NOT_FOUND_IMPLIES_BACKSLASH_IN_NAME_ON_WINDOWS);
            }
            r.assertSuccess(successFlags);
            result.addAll(r.getStdOutList());
        }
        return result;
    }

    private boolean hasBackSlash(List<String> paths) {
        for (String path : paths) {
            if (path.indexOf(CommonUtils.BACKSLASH) < 0) continue;
            return true;
        }
        return false;
    }

    private List<String> executeBatched(SrvcFeedback feedback, List<String> cleartoolArgs, List<String> objNames) throws WvcmException {
        return this.executeBatched(feedback, null, IGNORE_NoViewInfo, cleartoolArgs, objNames);
    }

    public String getCheckouts(String viewTag, String path, SrvcFeedback feedback) throws WvcmException {
        return this.ctProvider.execute(feedback, LSPRIVATE, _CO, _SHORT, _TAG, viewTag, _INVOB, path);
    }

    public List<String> findStreams(String pVobTag, String filter, boolean all, SrvcFeedback feedback) throws WvcmException {
        ArrayList<String> cleartoolArgs = new ArrayList<String>(Arrays.asList(LSSTREAM, _FMT, "%Xn\\n"));
        if (filter != null && filter.length() != 0) {
            if (all) {
                cleartoolArgs.add(_RECURSE);
            }
            cleartoolArgs.add(_IN);
            cleartoolArgs.add(String.valueOf(filter) + '@' + pVobTag);
        } else {
            cleartoolArgs.add(_INVOB);
            cleartoolArgs.add(pVobTag);
        }
        return this.ctProvider.executeGetValues(feedback, cleartoolArgs);
    }

    public List<String> getPvobSelectors(boolean all, SrvcFeedback feedback) throws WvcmException {
        CommandResult r = this.ctProvider.executeGetResult(feedback, LSVOB);
        r.assertSuccess(IGNORE_NoViewInfo);
        if (r.getStat() != 0 || r.getStdOutList() == null || r.getStdOutList().size() == 0) {
            throw new WvcmException(Messages.CCaseLib_NO_VOBS_FOUND, WvcmException.ReasonCode.NOT_FOUND);
        }
        ArrayList<String> pvobs = new ArrayList<String>();
        int i = 0;
        while (i < r.getStdOutList().size()) {
            Matcher m = LS_VOB_OUT_PATTERN.matcher(r.getStdOutList().get(i));
            if (m.find()) {
                pvobs.add(ObjSelUtils.formatSelector("vob", m.group(1)));
                if (!all) {
                    return pvobs;
                }
            }
            ++i;
        }
        return pvobs;
    }

    List<String> findUcmObjSels(String ucmObjSel, boolean children, SrvcFeedback feedback) throws WvcmException {
        List<String> cmd;
        List<String> childCmd;
        List<String> sourceCmd;
        Matcher m = VOB_SEL_PATTERN.matcher(ucmObjSel);
        if (m.find()) {
            return this.findUcmObjSels(m.replaceFirst(String.format("folder:%s@$1", ROOT_FOLDER)), children, feedback);
        }
        String objKind = ObjSelUtils.getObjSelKind(ucmObjSel);
        if (objKind == null) {
            objKind = this.getUcmObjKind(ucmObjSel, feedback);
        }
        if (objKind.equals("folder")) {
            sourceCmd = null;
            childCmd = Arrays.asList(LSFOLDER, _FMT, FMT_CONTAINS_FOLDERS_CXP, FMT_CONTAINS_PROJECTS_CXP, ucmObjSel);
        } else if (objKind.equals("project")) {
            sourceCmd = null;
            childCmd = Arrays.asList(LSPROJECT, _FMT, FMT_ISSTREAM_CXP, ucmObjSel);
        } else if (objKind.equals(FLEVEL7_MTYPE)) {
            sourceCmd = Arrays.asList(LSSTREAM, _FMT, FMT_DSTREAMS_CXP, ucmObjSel);
            childCmd = null;
        } else {
            throw new WvcmException(NLS.bind((String)Messages.CCaseLib_FIND_UCM_OBJ_LOCATIONS_BAD_OBJECT_KIND_ERROR, (Object)objKind), WvcmException.ReasonCode.FORBIDDEN);
        }
        List<String> list = cmd = children ? childCmd : sourceCmd;
        if (cmd == null) {
            return Collections.emptyList();
        }
        List<String> outList = this.ctProvider.executeGetValues(feedback, cmd);
        List<String> objSels = CommandResult.splitStdOutList(outList);
        return objSels;
    }

    public void deliverStream(String fromStream, String toView, Workspace.MergeFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        CommandResult r = this.ctProvider.executeGetResult(feedback, DELIVER, _COMPLETE, _FORCE, _ABORT, _STREAM, fromStream, _TO, toView);
        r.assertSuccess(IGNORE_NotFound_NoViewInfo);
        if (r.getStat() != 0) {
            this.ctProvider.execute(feedback, DELIVER, _CANCEL, _FORCE, _STREAM, fromStream);
            throw new WvcmException(NLS.bind((String)Messages.CCaseLib_DELIVER_FAILED_ERROR, (Object)r.getStdErr()), WvcmException.ReasonCode.CANNOT_MERGE_CHECKOUT_NOT_ALLOWED);
        }
    }

    public void lock(String objSel, SrvcFeedback feedback) throws WvcmException {
        try {
            CommandResult r = this.ctProvider.executeGetResult(feedback, LOCK, objSel);
            r.assertSuccess(IGNORE_NotFound_NoViewInfo);
        }
        catch (WvcmException e) {
            throw new WvcmException(NLS.bind((String)Messages.CCaseLib_LOCK_FAILED_ERROR, (Object)objSel), WvcmException.ReasonCode.CONFLICT);
        }
    }

    public void reserve(String objSel, SrvcFeedback feedback) throws WvcmException {
        String loginName = System.getProperty("user.name");
        String expectedCCLoginName = CTInitArgUtils.getCCLoginName(this.ctInitArgs);
        if (expectedCCLoginName != null && !expectedCCLoginName.equals(loginName)) {
            throw new WvcmException(NLS.bind((String)Messages.CCaseLib_UNEXPECTED_LOGIN_NAME, (Object)loginName, (Object)expectedCCLoginName), WvcmException.ReasonCode.UNAUTHORIZED);
        }
        if (this.rebaseInProgress(objSel, feedback)) {
            throw new WvcmException(NLS.bind((String)Messages.CCaseLib_ERROR_REBASE_IN_PROGRESS, (Object)objSel), WvcmException.ReasonCode.CONFLICT);
        }
        CommandResult r = this.ctProvider.executeGetResult(feedback, LOCK, _NUSERS, loginName, objSel);
        r.assertSuccess(IGNORE_NotFound_NoViewInfo);
    }

    public void unlock(String objSel, SrvcFeedback feedback) throws WvcmException {
        this.ctProvider.execute(feedback, UNLOCK, objSel);
    }

    public boolean isLocked(String objSel, SrvcFeedback feedback) throws WvcmException {
        String stdOut = this.ctProvider.execute(feedback, DESCRIBE, _FMT, "%[locked]p", objSel);
        return stdOut.equals(LOCKED);
    }

    public void checkout(String pathname, SrvcFeedback feedback) throws WvcmException {
        this.ctProvider.execute(feedback, CHECKOUT, _NC, pathname);
    }

    public void checkout(String pathname, String viewTag, String streamSelector, SrvcFeedback feedback) throws WvcmException {
        CommandResult r = this.ctProvider.executeGetResult(feedback, CHECKOUT, _NC, pathname);
        if (r.getStdErr().contains("cleartool: Error: To operate on UCM branch, must be set to an activity and a UCM view.")) {
            try {
                this.makeActivityInView(viewTag, streamSelector, null, null, true, feedback);
            }
            catch (WvcmException e) {
                this.logIgnoredExceptionAsAlwaysVisible("CCaseLib.checkout", Messages.CCaseLib_IGNORED_EXCEPTION_CREATE_ACTIVITY_FOR_CHECKOUT, (Exception)((Object)e));
            }
            this.checkout(pathname, feedback);
        } else {
            r.assertSuccess(IGNORE_NoViewInfo);
        }
    }

    public void uncheckout(String pathname, SrvcFeedback feedback) throws WvcmException {
        this.ctProvider.execute(feedback, UNCHECKOUT, _RM, pathname);
    }

    public List<String[]> describeForVerInfo(List<String> pathnames, CommandResult.ResultBehaviorFlags flags, SrvcFeedback feedback) throws WvcmException {
        return this.describeForObjInfo(pathnames, true, false, flags, feedback);
    }

    public List<String[]> describeForElemInfo(List<String> pathnames, CommandResult.ResultBehaviorFlags flags, SrvcFeedback feedback) throws WvcmException {
        return this.describeForObjInfo(pathnames, false, true, flags, feedback);
    }

    public List<String[]> describeForObjInfo(List<String> pathnames, CommandResult.ResultBehaviorFlags flags, SrvcFeedback feedback) throws WvcmException {
        return this.describeForObjInfo(pathnames, false, false, flags, feedback);
    }

    private List<String[]> describeForObjInfo(List<String> pathnames, boolean getElementPathName, boolean getElementInfo, CommandResult.ResultBehaviorFlags flags, SrvcFeedback feedback) throws WvcmException {
        if (getElementPathName && getElementInfo) {
            throw new IllegalArgumentException("Only one of getElementPathName and getElementType may be specified");
        }
        ArrayList<String> stdOutList = new ArrayList<String>(pathnames.size());
        ArrayList<String> reorderedPathnames = new ArrayList<String>(pathnames.size());
        ArrayList<String> subsetToDescribe = new ArrayList<String>();
        for (String pathname : pathnames) {
            String describeOutput = this.describeOutputByName.get(null, pathname);
            if (describeOutput == null) {
                subsetToDescribe.add(pathname);
                continue;
            }
            stdOutList.add(describeOutput);
            reorderedPathnames.add(pathname);
        }
        String isSyncCCVersionCommentsEnabledString = CTInitArgUtils.getSyncCCVersionComments(this.ctInitArgs);
        boolean isSyncCCVersionCommentsEnabled = isSyncCCVersionCommentsEnabledString != null && isSyncCCVersionCommentsEnabledString.equalsIgnoreCase("true");
        int count = 4;
        String format = "%m|%[universal_selector]p|%n|%Nd";
        if (getElementPathName) {
            if (isSyncCCVersionCommentsEnabled) {
                format = String.valueOf(format) + "|%En|%[group]p/%u|!#$%Nc$#!";
                count += 3;
            } else {
                format = String.valueOf(format) + "|%En|%[group]p/%u";
                count += 2;
            }
        } else if (getElementInfo) {
            format = String.valueOf(format) + "|%[type]p|%[permissions]p";
            count += 2;
        }
        format = String.valueOf(format) + FMT_NEWLINE;
        ArrayList<String> argsPrefix = new ArrayList<String>(Arrays.asList(DESCRIBE, _FMT, format));
        if (subsetToDescribe.size() > 0) {
            stdOutList.addAll(this.executeBatched(feedback, null, flags, argsPrefix, subsetToDescribe));
            reorderedPathnames.addAll(subsetToDescribe);
        }
        ArrayList<String[]> result = new ArrayList<String[]>(pathnames.size());
        int i = 0;
        while (i < stdOutList.size()) {
            String mtype;
            String line = (String)stdOutList.get(i);
            String[] tokens = CCaseLib.getObjInfoTokens(line, count, argsPrefix, subsetToDescribe, stdOutList);
            if (getElementPathName) {
                tokens[4] = ObjSelUtils.extendedElemPathName(tokens[4]);
                if (isSyncCCVersionCommentsEnabled) {
                    String[] comment = new String[1];
                    i = this.getComment(i, tokens[count - 1], stdOutList, comment);
                    tokens[count - 1] = new String(comment[0]);
                }
            }
            if (!((mtype = tokens[0]).endsWith("version") || mtype.equals("symbolic link") || mtype.endsWith("element") || mtype.equals("view private object") || mtype.equals("derived object"))) {
                this.describeOutputByName.put(null, (String)reorderedPathnames.get(i), line);
                this.describeOutputByName.put(null, tokens[1], line);
            }
            result.add(tokens);
            ++i;
        }
        return result;
    }

    public int getComment(int i, String input, List<String> stdOutList, String[] resultComment) throws WvcmException {
        int commentStartIdx = input.indexOf(COMMENT_START_DELIM);
        if (commentStartIdx != -1) {
            String commentStart = input.substring(commentStartIdx + COMMENT_START_DELIM.length());
            int commentEndIdx = commentStart.indexOf(COMMENT_END_DELIM);
            if (commentEndIdx != -1) {
                resultComment[0] = commentStart.substring(0, commentEndIdx);
            } else {
                StringBuffer result = new StringBuffer(commentStart);
                boolean endOfCommentFound = false;
                int j = i + 1;
                while (j < stdOutList.size()) {
                    i = j;
                    commentEndIdx = stdOutList.get(j).indexOf(COMMENT_END_DELIM);
                    if (commentEndIdx != -1) {
                        result.append(this.getWorkspaceLineDelimiterText()).append(stdOutList.get(j).substring(0, commentEndIdx));
                        endOfCommentFound = true;
                        break;
                    }
                    result.append(this.getWorkspaceLineDelimiterText()).append(stdOutList.get(j));
                    ++j;
                }
                if (!endOfCommentFound) {
                    String changeSetCommentFormat = CTInitArgUtils.getChangeSetCommentFormatOption(this.ctInitArgs);
                    if (changeSetCommentFormat == null) {
                        changeSetCommentFormat = EMPTY_STRING;
                    }
                    throw new WvcmException(NLS.bind((String)Messages.CCaseLib_ERROR_INVALID_CHANGE_SET_COMMENT_FORMAT, (Object)changeSetCommentFormat), WvcmException.ReasonCode.ABORTED);
                }
                resultComment[0] = result.toString();
            }
        }
        return i;
    }

    public List<String> describeGetElemPathnames(List<String> verStrings, CommandResult.ResultBehaviorFlags flags, SrvcFeedback feedback) throws WvcmException {
        if (verStrings.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<String> cleartoolArgs = new ArrayList<String>(Arrays.asList(DESCRIBE, _FMT, "%En\\n"));
        return this.executeBatched(feedback, null, flags, cleartoolArgs, verStrings);
    }

    public String describeShort(String arg, CommandResult.ResultBehaviorFlags flags, String viewTag, SrvcFeedback feedback) throws WvcmException {
        String dirContext = viewTag == null ? null : CCaseLib.getPathIntoView(viewTag);
        try {
            return this.ctProvider.execute(feedback, dirContext, flags, DESCRIBE, _SHORT, arg);
        }
        catch (WvcmException ex) {
            if (ObjSelUtils.isUniversalSelector(arg) && ex.getMessage().contains("cleartool: Error: Not a vob object: ")) {
                throw new WvcmException(String.valueOf(Messages.CCaseLib_POSSIBLE_RMELEM) + '\n' + ex.getMessage(), WvcmException.ReasonCode.NOT_FOUND);
            }
            throw ex;
        }
    }

    /*
     * Unable to fully structure code
     */
    public List<String> describeShort(List<String> ids, CommandResult.ResultBehaviorFlags flags, String viewTag, SrvcFeedback feedback) throws WvcmException {
        dirContext = viewTag == null ? null : CCaseLib.getPathIntoView(viewTag);
        cmd = new ArrayList<String>(Arrays.asList(new String[]{"describe", "-short"}));
        try {
            return this.executeBatched(feedback, dirContext, flags, cmd, ids);
        }
        catch (WvcmException ex) {
            results = new ArrayList<String>();
            ** for (id : ids)
        }
lbl-1000:
        // 1 sources

        {
            results.add(this.describeShort(id, flags, viewTag, feedback));
            continue;
        }
lbl11:
        // 1 sources

        return results;
    }

    public String describeGetSLink(String objSel, SrvcFeedback feedback) throws WvcmException {
        String stdOut = this.ctProvider.execute(feedback, DESCRIBE, _FMT, FMT_SLINK_TEXT_P, objSel);
        return stdOut;
    }

    public List<String> diffBl(boolean activities, boolean elements, boolean firstOnly, String firstVersionSet, String secondVersionSet, String contextViewTag, SrvcFeedback feedback) throws WvcmException {
        String workingDirectory = CCaseLib.getPathIntoView(contextViewTag);
        ArrayList<String> args = new ArrayList<String>();
        args.add(DIFFBL);
        if (activities) {
            args.add(_ACTIVITIES);
        }
        args.add(elements ? _ELEMENT : _VERSIONS);
        if (firstOnly) {
            args.add(_FIRST_ONLY);
        }
        args.add(firstVersionSet);
        args.add(secondVersionSet);
        List<String> outputLines = this.ctProvider.executeGetValues(feedback, workingDirectory, IGNORE_Nothing, args.toArray(new String[args.size()]));
        if (!activities || elements || !firstOnly) {
            int count = outputLines.size();
            int i = 0;
            while (i < count) {
                String line = outputLines.get(i);
                if (line.startsWith("<<") || line.startsWith(">>") || line.startsWith(MERGE_INTO_ARROW) || line.startsWith("->")) {
                    ++i;
                    continue;
                }
                outputLines.remove(i);
                --count;
            }
        }
        return outputLines;
    }

    private List<String> generateAttrArgs(String attype, String objectSelector, String value) {
        String preparedValue;
        try {
            preparedValue = URLEncoder.encode(value, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unexpected UnsupportedEncodingException encoding characters with UTF-8");
        }
        return Arrays.asList(attype, DOUBLE_QUOTE + preparedValue + DOUBLE_QUOTE, objectSelector);
    }

    public String getAttr(String attype, String objectSelector, SrvcFeedback feedback) throws WvcmException {
        String value = this.ctProvider.execute(feedback, DESCRIBE, _FMT, "%NS[" + attype + FMT_ATTRIBUTE_SUFFIX, objectSelector);
        int valueLength = value.length();
        try {
            String result = valueLength <= 2 ? null : URLDecoder.decode(value.substring(1, valueLength - 1), UTF_8);
            return result;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unexpected UnsupportedEncodingException decoding characters with UTF-8");
        }
    }

    public Map<String, String> getAllAttributeTypes(String vobTag, SrvcFeedback feedback) throws WvcmException {
        Map<String, String> attrs = this.vobTag2attrMap.get(vobTag);
        if (attrs != null) {
            return attrs;
        }
        List<String> lines = this.ctProvider.executeGetValues(feedback, LSTYPE, _LONG, _KIND, "attype", _INVOB, vobTag);
        attrs = new HashMap<String, String>();
        String attype = null;
        for (String line : lines) {
            Matcher vm;
            Matcher am = ATTRIBUTE_TYPE_PATTERN.matcher(line);
            if (am.find()) {
                attype = am.group(1);
                continue;
            }
            if (attype == null || !(vm = VALUE_TYPE_PATTERN.matcher(line)).find()) continue;
            String vtype = vm.group(1);
            attrs.put(attype, vtype);
        }
        this.vobTag2attrMap.put(vobTag, attrs);
        return attrs;
    }

    public Map<String, Map<String, String>> getRawAttributesForVersionHistoryEntries(String elemUSel, Map<String, String> attypes, SrvcFeedback feedback) throws WvcmException {
        String format = "%m|%[universal_selector]p|%a|%Sa\n";
        List<String> lines = this.ctProvider.executeGetValues(feedback, null, new CommandResult.ResultBehaviorFlags(new CommandResult.ResultBehaviorFlags.Kind[0]), LSHISTORY, _NCO, _FMT, format, elemUSel);
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        for (String line : lines) {
            String[] tokens = line.split(LITERAL_VERTICAL_BAR_PATTERN);
            if (tokens.length < 2) {
                throw new IllegalStateException(String.format("stdout line contains %d tokens, but at least it should contain 2 tokens.\n", tokens.length));
            }
            String mtype = tokens[0];
            if (!"version".equals(mtype) && !"derived object version".equals(mtype)) continue;
            String versionUSel = tokens[1];
            if (tokens.length == 2) {
                result.put(versionUSel, null);
                continue;
            }
            if (tokens.length != 4) {
                result.put(versionUSel, Collections.emptyMap());
                continue;
            }
            HashMap<String, String> attrs = new HashMap<String, String>();
            if (attypes == null) {
                attypes = this.getAllAttributeTypes(ObjSelUtils.getObjSelVobSel(versionUSel), feedback);
            }
            if (this.fillRawAttributes(attrs, tokens[2], tokens[3], attypes, feedback)) {
                result.put(versionUSel, attrs.isEmpty() ? null : attrs);
                continue;
            }
            result.put(versionUSel, Collections.emptyMap());
        }
        return result;
    }

    private boolean fillRawAttributes(Map<String, String> result, String pairsStr, String valuesStr, Map<String, String> attypes, SrvcFeedback feedback) throws WvcmException {
        String[] values;
        if (pairsStr.length() < 2 || valuesStr.length() < 2) {
            return false;
        }
        pairsStr = pairsStr.substring(1, pairsStr.length() - 1);
        valuesStr = valuesStr.substring(1, valuesStr.length() - 1);
        String[] pairs = pairsStr.split(", ");
        if (pairs.length != (values = valuesStr.split(", ")).length) {
            return false;
        }
        int i = 0;
        while (i < pairs.length) {
            String pair = pairs[i];
            int eq = pair.indexOf(61);
            if (eq == -1) {
                return false;
            }
            String attype = pair.substring(0, eq);
            if (result.containsKey(attype)) {
                return false;
            }
            String vtype = attypes.get(attype);
            if (vtype == null) {
                return false;
            }
            String value = pair.substring(eq + 1);
            if (!value.equals(values[i])) {
                return false;
            }
            if ("string".equals(vtype)) {
                if (value.length() < 2 || !value.startsWith(DOUBLE_QUOTE) || !value.endsWith(DOUBLE_QUOTE)) {
                    return false;
                }
                value = value.substring(1, value.length() - 1);
            }
            result.put(attype, value);
            ++i;
        }
        return true;
    }

    public Map<String, String> getRawAttributesForGpath(String path, SrvcFeedback feedback) throws WvcmException {
        String attrString = this.ctProvider.execute(feedback, DESCRIBE, _FMT, "%a|%Sa", path);
        if (attrString == null) {
            return null;
        }
        String[] strings = attrString.split(LITERAL_VERTICAL_BAR_PATTERN);
        if (strings.length == 0) {
            return null;
        }
        String vobTag = this.getVobTagFromGpath(path, feedback);
        Map<String, String> attypes = this.getAllAttributeTypes(vobTag, feedback);
        HashMap<String, String> result = new HashMap<String, String>();
        if (strings.length == 2 && this.fillRawAttributes(result, strings[0], strings[1], attypes, feedback)) {
            return result.isEmpty() ? null : result;
        }
        return this.getRawAttributes(path, attypes, feedback);
    }

    public Map<String, String> getRawAttributes(String path, Map<String, String> attypes, SrvcFeedback feedback) throws WvcmException {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String attype : attypes.keySet()) {
            String value = this.ctProvider.execute(feedback, DESCRIBE, _FMT, "%NS[" + attype + FMT_ATTRIBUTE_SUFFIX, path);
            if (value == null || value.isEmpty()) continue;
            if ("string".equals(attypes.get(attype))) {
                value = this.unquote(value);
            }
            result.put(attype, value);
        }
        return result.isEmpty() ? null : result;
    }

    public List<String> getComponents(List<String> baselineSels, boolean objSelector, SrvcFeedback feedback) throws WvcmException {
        String key;
        ArrayList<String> result = new ArrayList<String>(baselineSels.size());
        ArrayList<String> subsetToCompute = new ArrayList<String>();
        String string = key = objSelector ? KEY_OBJSEL : KEY_UUID;
        if (baselineSels.isEmpty()) {
            return result;
        }
        for (String baselineSel : baselineSels) {
            String componentName = this.componentByBaseline.get(key, baselineSel);
            if (componentName != null) continue;
            subsetToCompute.add(baselineSel);
        }
        List<Object> computedComponents = Collections.emptyList();
        if (subsetToCompute.size() > 0) {
            computedComponents = this.computeComponents(subsetToCompute, objSelector, feedback);
            this.componentByBaseline.put(key, subsetToCompute, computedComponents);
        }
        Iterator it = computedComponents.iterator();
        for (String baselineSel : baselineSels) {
            String componentName = this.componentByBaseline.get(key, baselineSel);
            if (componentName == null) {
                if (!it.hasNext()) {
                    throw new IllegalStateException("Uncached component list is not of expected length");
                }
                componentName = (String)it.next();
            }
            result.add(componentName);
        }
        return result;
    }

    public String getComponent(String baselineSel, boolean objSelector, SrvcFeedback feedback) throws WvcmException {
        return this.getComponents(Collections.singletonList(baselineSel), objSelector, feedback).get(0);
    }

    public Map<String, String> getRootedComponents(String streamSel, String viewTag, SrvcFeedback feedback) throws WvcmException {
        return this.getRootedComponentsHelper(streamSel, viewTag, false, feedback);
    }

    private Map<String, String> getRootedComponentsHelper(String streamSel, String viewTag, boolean onlyModifiable, SrvcFeedback feedback) throws WvcmException {
        List<String> allComponents = this.getRootedComponentNameSelectors(streamSel, onlyModifiable, feedback);
        Map<String, String> result = this.computeComponentRootDirs(allComponents, viewTag == null ? null : CCaseLib.getPathIntoView(viewTag), feedback);
        return result;
    }

    public List<String> getRootedComponentNameSelectors(String streamSel, boolean onlyModifiable, SrvcFeedback feedback) throws WvcmException {
        if (streamSel == null) {
            throw new IllegalArgumentException("Stream selector must not be null");
        }
        if (onlyModifiable) {
            List<String> lines = this.ctProvider.executeGetValues(feedback, DESCRIBE, _FMT, FMT_MOD_COMPONENTS_CXP, streamSel);
            List<String> allComponents = CommandResult.splitStdOutList(lines);
            return allComponents;
        }
        return new ArrayList<String>(this.getFoundationBaselines(streamSel, true, feedback).keySet());
    }

    public Map<String, String> getModifiableRootedComponents(String streamSel, String viewTag, SrvcFeedback feedback) throws WvcmException {
        return this.getRootedComponentsHelper(streamSel, viewTag, true, feedback);
    }

    public String getInitialBaseline(String compSel, SrvcFeedback feedback) throws WvcmException {
        return this.ctProvider.execute(feedback, DESCRIBE, _FMT, FMT_INITIAL_BL_XP, compSel);
    }

    public void syncToStreamConfiguration(String viewTag, SrvcFeedback feedback) throws WvcmException {
        CommandResult r = this.ctProvider.executeGetResult(feedback, SETCS, _STREAM, _TAG, viewTag);
        String stdErr = r.getStdErr();
        if (stdErr.contains("cleartool: Error: Unable to get snapshot view handle")) {
            throw new WvcmException(NLS.bind((String)Messages.CCaseLib_ERROR_CCLT, (Object)stdErr), WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
        }
        r.assertSuccess(IGNORE_NoViewInfo);
    }

    public String getCurrentActivity(String viewTag, SrvcFeedback feedback) throws WvcmException {
        String curAct = this.ctProvider.execute(feedback, LSACTIVITY, _CACT, _FMT, FMT_UNIVERSAL_SELECTOR_P, _VIEW, viewTag);
        return curAct.length() == 0 ? null : curAct;
    }

    public CCaseDirectoryEntryMap getDirectoryOfVobObjects(String verString, String vobuuid, SrvcFeedback feedback) throws WvcmException {
        if (verString == null) {
            throw new IllegalArgumentException("Null version for getDirectory()");
        }
        List<String> entryLines = this.ctProvider.executeGetValues(feedback, LS, _DUMP, verString);
        if (entryLines == null) {
            throw new IllegalArgumentException("getDirectoryOfVobObjects: null result from executing ls -dump of " + verString);
        }
        CCaseDirectoryEntryMap result = new CCaseDirectoryEntryMap(entryLines.size());
        boolean lookingForName = true;
        String name = null;
        for (String line : entryLines) {
            if (lookingForName) {
                Matcher nameMatcher = NAME_PATTERN.matcher(line);
                if (!nameMatcher.find() || (name = nameMatcher.replaceFirst("$1")).equals(LOST_AND_FOUND_NAME)) continue;
                lookingForName = false;
                continue;
            }
            Matcher oidMatcher = OID_PATTERN.matcher(line);
            if (!oidMatcher.find()) continue;
            String oid = oidMatcher.replaceFirst("$1");
            result.put(ObjSelUtils.makeUsel(vobuuid, oid), name);
            lookingForName = true;
            name = null;
        }
        return result;
    }

    public String getElementUsel(String verSelectorString, String vobSel, SrvcFeedback feedback) throws WvcmException {
        List<String> verDump = this.ctProvider.executeGetValues(feedback, DUMP, verSelectorString);
        String oid = null;
        for (String line : verDump) {
            Matcher m = ELEM_DBID_PATTERN.matcher(line);
            if (m.find()) {
                String elemDbidString = m.replaceAll("$1");
                String dbidSel = ObjSelUtils.formatSelector("dbid", elemDbidString, vobSel);
                String result = this.getUniversalSelector(dbidSel, feedback);
                return result;
            }
            Matcher m2 = DUMP_OID_PATTERN.matcher(line);
            if (m2.find()) {
                oid = m2.group(1);
            }
            if (!line.startsWith(MTYPE_EQUALS_SYMBOLIC_LINK)) continue;
            String result = ObjSelUtils.formatSelector("oid", oid, vobSel);
            return result;
        }
        return null;
    }

    private List<String> getElemPathNames(List<String> pathNames, SrvcFeedback feedback) throws WvcmException {
        List<String> elemPathNamesAlmost = this.describeGetElemPathnames(pathNames, IGNORE_Nothing, feedback);
        ArrayList<String> result = new ArrayList<String>(elemPathNamesAlmost.size());
        for (String elemPathName : elemPathNamesAlmost) {
            result.add(ObjSelUtils.extendedElemPathName(elemPathName));
        }
        return result;
    }

    private String getElemPathName(String pathName, SrvcFeedback feedback) throws WvcmException {
        return this.getElemPathNames(Collections.singletonList(pathName), feedback).get(0);
    }

    private List<String> computeUniversalSelectors(List<String> objNames, SrvcFeedback feedback) throws WvcmException {
        ArrayList<String> cleartoolArgs = new ArrayList<String>(Arrays.asList(DESCRIBE, _FMT, "%[universal_selector]p\\n"));
        return this.executeBatched(feedback, cleartoolArgs, objNames);
    }

    private String computeUniversalSelector(String objName, SrvcFeedback feedback) throws WvcmException {
        return this.computeUniversalSelectors(Collections.singletonList(objName), feedback).get(0);
    }

    public List<String> getUniversalSelectors(List<String> objNames, SrvcFeedback feedback) throws WvcmException {
        List<String> result = new ArrayList<String>(objNames.size());
        boolean needCompute = false;
        for (String objName : objNames) {
            if (!ObjSelUtils.isUniversalSelector(objName)) {
                result.clear();
                needCompute = true;
                break;
            }
            result.add(objName);
        }
        if (needCompute) {
            result = this.computeUniversalSelectors(objNames, feedback);
        }
        return result;
    }

    public String getUniversalSelector(String objName, SrvcFeedback feedback) throws WvcmException {
        return this.getUniversalSelectors(Collections.singletonList(objName), feedback).get(0);
    }

    public Map<String, Boolean> getFSDirectory(String pathname, SrvcFeedback feedback) throws WvcmException {
        if (pathname == null) {
            throw new IllegalArgumentException("Null pathname for getFSDirectory()");
        }
        String targetName = ObjSelUtils.isOidSelector(pathname) ? this.gpathNoVersionExtension(pathname, null, feedback) : pathname;
        File rootdir = new File(targetName);
        File[] files = rootdir.listFiles();
        if (files == null) {
            throw new IllegalArgumentException("Can't list files for non-directory: " + targetName);
        }
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(files.length);
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (file.exists()) {
                boolean isDirectory = file.isDirectory();
                result.put(file.getName(), new Boolean(isDirectory));
            }
            ++i;
        }
        return result;
    }

    public Map<String, String> getCCDirectory(String pathname, SrvcFeedback feedback) throws WvcmException {
        if (pathname == null) {
            throw new IllegalArgumentException("Null pathname for getCCDirectory()");
        }
        String targetName = ObjSelUtils.isOidSelector(pathname) ? this.gpathNoVersionExtension(pathname, null, feedback) : pathname;
        List<String> entryLines = this.directoryTreeHelper(targetName, false, feedback);
        HashMap<String, String> result = new HashMap<String, String>();
        String name = null;
        for (String line : entryLines) {
            if (name == null) {
                Matcher nameMatcher = NAME_PATTERN.matcher(line);
                if (!nameMatcher.find() || !(name = nameMatcher.group(1)).equals(LOST_AND_FOUND_NAME)) continue;
                name = null;
                continue;
            }
            Matcher mtypeMatcher = MTYPE_PATTERN.matcher(line);
            if (!mtypeMatcher.find()) continue;
            String mtype = mtypeMatcher.group(1);
            result.put(name, mtype);
            name = null;
        }
        return result;
    }

    private List<String> directoryTreeHelper(String targetName, boolean doRecurse, SrvcFeedback feedback) throws WvcmException {
        ArrayList<String> args = new ArrayList<String>(4);
        args.add(LS);
        if (doRecurse) {
            args.add(_RECURSE);
            args.add(_SHORT);
        } else {
            args.add(_DUMP);
        }
        args.add(targetName);
        CommandResult r = this.ctProvider.executeGetResult(feedback, null, args);
        if (r.getStat() != 0) {
            String pattern = "cleartool: Error: Pathname is not within a VOB:";
            if (r.getStdErr() != null && r.getStdErr().startsWith(pattern)) {
                throw new WvcmException(r.toString(), WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
            }
            r.assertSuccess(IGNORE_Nothing);
        }
        List<String> stdOutList = r.getStdOutList();
        if (r.getStdOutList() == null) {
            throw new IllegalArgumentException("directoryTreeHelper: null result from executing cleartool ls of " + targetName);
        }
        return stdOutList;
    }

    private String gpathNoVersionExtension(String pathname, String viewTag, SrvcFeedback feedback) throws WvcmException {
        String versionExtensionPattern = "@@/.+";
        return this.gpath(pathname, viewTag, feedback).replaceAll("@@/.+", new String());
    }

    public List<String> getLatestRootedBaselines(String streamSel, SrvcFeedback feedback) throws WvcmException {
        List<String> allBaselines = this.getLatestBaselines(streamSel, feedback);
        List<String> rootedComponents = this.getUniversalSelectors(new ArrayList<String>(this.getRootedComponents(streamSel, null, feedback).keySet()), feedback);
        List<String> allComponents = this.getComponents(allBaselines, false, feedback);
        ArrayList<String> result = new ArrayList<String>(rootedComponents.size());
        Iterator<String> it = allComponents.iterator();
        for (String baseline : allBaselines) {
            if (!it.hasNext()) {
                throw new IllegalStateException("Number of components does not match number of baselines");
            }
            String component = it.next();
            if (!rootedComponents.contains(component)) continue;
            result.add(baseline);
        }
        return result;
    }

    public List<String> getLatestBaselines(String streamSel, SrvcFeedback feedback) throws WvcmException {
        List<String> baselines = this.ctProvider.executeGetValues(feedback, DESCRIBE, _FMT, FMT_LATEST_BLS_CXP, streamSel);
        return CommandResult.splitStdOutList(baselines);
    }

    public static String[] getObjInfoTokens(String line, int count, List<String> cleartoolArgs, List<String> objNames, List<String> fullStdOutList) {
        String[] tokens = line.split(LITERAL_VERTICAL_BAR_PATTERN);
        if (tokens.length != count) {
            String argString = cleartoolArgs == null ? "<command not provided>" : CommonUtils.myToString(' ', cleartoolArgs, false);
            String objString = objNames == null ? "<object names not provided>" : CommonUtils.myToString(' ', objNames, false);
            String stdOutString = fullStdOutList == null ? "<stdout not provided>" : CommonUtils.myToString('\n', fullStdOutList, false);
            throw new IllegalStateException(String.format("stdout line contains %d tokens, but expected %d tokens separated by '|'.\nLine:\n%s\nCleartool command and full output:\n\n%s\n%s\n\n%s\n", tokens.length, count, line, argString, objString, stdOutString));
        }
        return tokens;
    }

    public static String[] getObjInfoTokens(String line, int count) {
        return CCaseLib.getObjInfoTokens(line, count, null, null, null);
    }

    public String computeVobTagFromVobFamilyUuid(String vobFamilyUUID, SrvcFeedback feedback) throws WvcmException {
        if (this.vobFamily2VobTag.containsKey(vobFamilyUUID)) {
            return this.vobFamily2VobTag.get(vobFamilyUUID);
        }
        CommandResult.ResultBehaviorFlags ignoreFlags = new CommandResult.ResultBehaviorFlags(CommandResult.ResultBehaviorFlags.Kind.IGNORE_NO_VIEW_INFO);
        List<String> lines = this.ctProvider.executeGetValues(feedback, null, ignoreFlags, LSVOB, _SHORT, _FAMILY, vobFamilyUUID);
        int count = lines.size();
        if (count > 1) {
            throw new WvcmException(NLS.bind((String)Messages.ERR_TOO_MANY_VOB_TAGS_WITH_COUNT, (Object)vobFamilyUUID, (Object)count), WvcmException.ReasonCode.CONFLICT);
        }
        String vobTag = count > 0 ? lines.get(0) : EMPTY_STRING;
        this.vobFamily2VobTag.put(vobFamilyUUID, vobTag);
        return vobTag;
    }

    private String[] getViewsStreamSelectorParts(String viewTag, SrvcFeedback feedback) throws WvcmException {
        CommandResult.ResultBehaviorFlags ignoreFlags = IGNORE_NotFound_NoViewInfo;
        String stdout = this.ctProvider.execute(feedback, null, ignoreFlags, LSSTREAM, _FMT, "%[universal_selector]%Xp|%n", _VIEW, viewTag);
        String[] parts = CCaseLib.getObjInfoTokens(stdout, 2);
        return parts;
    }

    public String getStreamUniversalSelector(String viewTag, SrvcFeedback feedback) throws WvcmException {
        String streamSel = this.streamByView.get(null, viewTag);
        if (streamSel == null && (streamSel = this.getViewsStreamSelectorParts(viewTag, feedback)[0]).length() > 0) {
            this.streamByView.put(null, viewTag, streamSel);
        }
        return streamSel;
    }

    public String getProjectObjectSelector(String streamSel, SrvcFeedback feedback) throws WvcmException {
        String projectSel = this.projectByStream.get(null, streamSel);
        if (projectSel == null && (projectSel = this.ctProvider.execute(feedback, DESCRIBE, _FMT, FMT_PROJECT_XP, streamSel)) != null) {
            this.projectByStream.put(null, streamSel, projectSel);
        }
        return projectSel;
    }

    public String getVobuuid(String verString, SrvcFeedback feedback) throws WvcmException {
        String vobUSel = this.computeUniversalSelector(ObjSelUtils.formatSelector("vob", verString), feedback);
        String result = ObjSelUtils.vobUuidSelectorSubstring(vobUSel);
        return result;
    }

    public String getVobSelector(String vobTag, SrvcFeedback feedback) throws WvcmException {
        return this.computeUniversalSelector(ObjSelUtils.formatSelector("vob", vobTag), feedback);
    }

    public String getLabelTypeName(String baselineSelector, SrvcFeedback feedback) throws WvcmException {
        String lbtypeName = this.labeltypeByBaseline.get(null, baselineSelector);
        if (lbtypeName == null && (lbtypeName = this.computeTypeNameFromHyperlink(BASELINE_LBTYPE, baselineSelector, feedback)).length() > 0) {
            this.labeltypeByBaseline.put(null, baselineSelector, lbtypeName);
        }
        return lbtypeName;
    }

    protected String computeTypeNameFromHyperlink(String hltype, String baselineSelector, SrvcFeedback feedback) throws WvcmException {
        List<String> targets = this.getHyperlinkTargets(hltype, baselineSelector, feedback);
        if (targets.isEmpty()) {
            return new String();
        }
        return ObjSelUtils.getObjSelName(targets.get(0));
    }

    public String makeActivityInView(String viewTag, String streamSelector, String title, String comment, boolean setCurrent, SrvcFeedback feedback) throws WvcmException {
        String streamsPvobUUIDString = ObjSelUtils.vobUuidSelectorSubstring(streamSelector);
        String activity = null;
        if (!viewsOnUCMCQStreams.contains(viewTag)) {
            List<String> cleartoolArgs = this.mkactCommandPrefixArgs(title, comment, setCurrent);
            CommandResult.ResultBehaviorFlags ignoreFlags = IGNORE_NotFound_NoViewInfo;
            CommandResult r = this.ctProvider.executeGetResult(feedback, CCaseLib.getPathIntoView(viewTag), cleartoolArgs);
            if (r.getStat() != 0) {
                String pattern = "cleartool: Error: The \"mkactivity\" command can not be used in a stream which is\ncontained in a ClearQuest-enabled project.";
                if (r.getStdErr() != null && r.getStdErr().startsWith(pattern)) {
                    activity = this.createAndSetCQActivity(title, viewTag, streamsPvobUUIDString, feedback);
                    viewsOnUCMCQStreams.add(viewTag);
                    activityOnCQEnabledProject.add(activity);
                } else {
                    r.assertSuccess(ignoreFlags);
                }
            } else {
                String info = r.getStdOut();
                activity = ObjSelUtils.createActivitySelectorFromStdOut(streamsPvobUUIDString, info);
                activityOnNonCQEnabledProject.add(activity);
            }
        } else {
            activity = this.createAndSetCQActivity(title, viewTag, streamsPvobUUIDString, feedback);
            activityOnCQEnabledProject.add(activity);
        }
        return activity;
    }

    public boolean isActivityOnCQEnabledProject(String activitySelector, SrvcFeedback feedback) throws WvcmException {
        boolean result = false;
        if (activityOnCQEnabledProject.contains(activitySelector)) {
            result = true;
        } else if (activityOnNonCQEnabledProject.contains(activitySelector)) {
            result = false;
        } else {
            Map<String, String> pvarMap = this.getCQPvarForActivity(activitySelector, feedback);
            if (pvarMap.isEmpty()) {
                result = false;
                activityOnNonCQEnabledProject.add(activitySelector);
            } else {
                result = true;
                activityOnCQEnabledProject.add(activitySelector);
            }
        }
        return result;
    }

    public String makeActivityInStream(String streamSelector, String title, String comment, SrvcFeedback feedback) throws WvcmException {
        List<String> cleartoolArgs = this.mkactCommandPrefixArgs(title, comment, true);
        cleartoolArgs.add(_IN);
        cleartoolArgs.add(streamSelector);
        CommandResult.ResultBehaviorFlags ignoreFlags = IGNORE_NotFound_NoViewInfo;
        String info = this.ctProvider.execute(feedback, null, ignoreFlags, cleartoolArgs.toArray(new String[cleartoolArgs.size()]));
        return ObjSelUtils.createActivitySelectorFromStdOut(ObjSelUtils.getObjSelVobSel(streamSelector), info);
    }

    private final List<String> mkactCommandPrefixArgs(String title, String comment, boolean setCurrent) {
        ArrayList<String> args = new ArrayList<String>(6);
        args.add(MKACT);
        args.add(_FORCE);
        if (title != null && title.length() != 0) {
            args.add(_HEADLINE);
            args.add(title);
        }
        if (comment != null) {
            args.add(_COMMENT);
            args.add(comment);
        }
        if (!setCurrent) {
            args.add(_NSET);
        }
        return args;
    }

    public void changeElementType(String elemType, String controlledPathname, SrvcFeedback fb) throws WvcmException {
        this.ctProvider.execute(fb, CHTYPE, _FORCE, _PNAME, elemType, controlledPathname);
    }

    public void makeElement(boolean isDirectory, String pathname, SrvcFeedback feedback) throws WvcmException {
        ArrayList<String> cleartoolArgs = new ArrayList<String>(7);
        if (isDirectory) {
            cleartoolArgs.add(MKDIR);
        } else {
            cleartoolArgs.add(MKELEM);
        }
        this.addCommentArg(cleartoolArgs, null);
        if (!isDirectory) {
            cleartoolArgs.add(_CI);
        }
        cleartoolArgs.add(_MASTER);
        cleartoolArgs.add(pathname);
        CommandResult result = this.ctProvider.executeGetResult(feedback, cleartoolArgs);
        if (isDirectory) {
            result.assertSuccess(IGNORE_NoViewInfo);
        } else {
            boolean elemChtype = false;
            List<String> stdErr = result.getStdErrList();
            for (String line : stdErr) {
                Matcher m = TFD_CREATE_VERSION_FAILED.matcher(line);
                if (!m.find()) continue;
                elemChtype = true;
                break;
            }
            if (elemChtype) {
                this.changeElementType(COMPRESSED_FILE, pathname, feedback);
                this.checkin(true, null, Collections.singletonList(pathname), feedback);
            } else {
                result.assertSuccess(IGNORE_NoViewInfo);
            }
        }
    }

    public void checkoutIgnoreExpectedFailures(String viewTag, String pathname, String streamSelector, SrvcFeedback feedback) throws WvcmException {
        int status;
        String crde;
        CommandResult r = this.ctProvider.executeGetResult(feedback, CHECKOUT, _NC, pathname);
        boolean alreadyCheckedOut = false;
        boolean notVobObject = false;
        boolean loggedHeader = false;
        for (String line : r.getStdErrList()) {
            if (!line.matches(CLEARTOOL_ERROR_PATTERN)) continue;
            if (!loggedHeader) {
                this.logDebug(NLS.bind((String)Messages.CCaseLib_IGNORED_ERROR, (Object)"CCaseLib.checkoutIgnoreExpectedFailures"));
                loggedHeader = true;
            }
            this.logDebug(line);
            if (line.matches("cleartool: Error: Element \".*?\" is already checked out to view \".*?\".")) {
                alreadyCheckedOut = true;
                continue;
            }
            if (!line.contains("cleartool: Error: Not a vob object")) continue;
            notVobObject = true;
        }
        if (alreadyCheckedOut || notVobObject) {
            return;
        }
        String stdErr = r.getStdErr();
        if (stdErr.contains("cleartool: Error: Config spec indicates that checkouts are not allowed for element") && (crde = this.lookupComponentCRDE(pathname, feedback)) == null) {
            throw new WvcmException(NLS.bind((String)Messages.CTUcmView_ERROR_INVALID_UCM_COMPONENT, (Object)pathname), WvcmException.ReasonCode.NOT_FOUND);
        }
        if (stdErr.contains("the stream lacks foundation baselines")) {
            String compSel = this.lookupFriendlyUcmComponentSelectorFromGPath(pathname, feedback);
            if (compSel == null) {
                throw new WvcmException(NLS.bind((String)Messages.CCaseLib_PATH_MUST_BE_IN_A_COMPONENT_ERROR, (Object)pathname), WvcmException.ReasonCode.NOT_FOUND);
            }
            String projSel = this.getProjectObjectSelector(streamSelector, feedback);
            this.ctProvider.execute(feedback, CHPROJECT, _AMODCOMP, compSel, projSel);
            this.rebaseStreamComp(viewTag, streamSelector, compSel, feedback);
            r = this.ctProvider.executeGetResult(feedback, CHECKOUT, _NC, pathname);
            stdErr = r.getStdErr();
        }
        if (stdErr.contains("cleartool: Error: To operate on UCM branch, must be set to an activity and a UCM view.")) {
            this.makeActivityInView(viewTag, streamSelector, null, null, true, feedback);
            r = this.ctProvider.executeGetResult(feedback, CHECKOUT, _NC, pathname);
            stdErr = r.getStdErr();
        }
        if ((status = r.getStat()) == 1 && stdErr.length() == 0) {
            this.cleanupThenRetryCheckout(viewTag, pathname, feedback);
            return;
        }
        if (stdErr.contains("cleartool: Warning: Non-UCM checkout of \"" + pathname + "\".  Any modifications will not participate in any UCM change management operations.")) {
            this.cleanupThenRetryCheckout(viewTag, pathname, feedback);
        }
        r.assertSuccess(IGNORE_Nothing);
    }

    private void cleanupThenRetryCheckout(String viewTag, String pathname, SrvcFeedback feedback) throws WvcmException {
        this.ctProvider.execute(feedback, SETCS, _CURRENT, _TAG, viewTag);
        this.uncheckout(pathname, feedback);
        this.checkout(pathname, feedback);
    }

    public void rmAttrIgnoreExpectedFailures(String attype, String objectSelector, SrvcFeedback feedback) throws WvcmException {
        String stdErr;
        String[] cleartoolArgs = new String[]{RMATTR, attype, objectSelector};
        CommandResult.ResultBehaviorFlags ignoreFlags = new CommandResult.ResultBehaviorFlags(CommandResult.ResultBehaviorFlags.Kind.IGNORE_NO_VIEW_INFO);
        CommandResult r = this.ctProvider.executeGetResult(feedback, null, Arrays.asList(cleartoolArgs));
        boolean ok = false;
        if (r.getStat() == 1 && (stdErr = r.getStdErr()) != null && (stdErr.contains("cleartool: Error: Attribute type not found: \"" + attype + "\".") || stdErr.contains("cleartool: Error: No attribute of type \"" + attype + "\" on object."))) {
            ok = true;
        }
        if (!ok) {
            r.assertSuccess(ignoreFlags);
        }
    }

    public void setActivity(String viewTag, String actName, SrvcFeedback feedback) throws WvcmException {
        this.ctProvider.execute(feedback, SETACT, _VIEW, viewTag, actName);
    }

    public void setAttr(String attype, String objectSelector, String value, boolean replace, SrvcFeedback feedback) throws WvcmException {
        ArrayList<String> cleartoolArgs = new ArrayList<String>(4);
        cleartoolArgs.add(MKATTR);
        cleartoolArgs.add(_NC);
        if (replace) {
            cleartoolArgs.add(_REPLACE);
        }
        cleartoolArgs.addAll(this.generateAttrArgs(attype, objectSelector, value));
        CommandResult r = this.ctProvider.executeGetResult(feedback, cleartoolArgs);
        this.retryIfNoType(r, cleartoolArgs, "attype", feedback);
    }

    public void setHyperlink(String hltype, String fromObjectSelector, String toObjectSelector, SrvcFeedback feedback) throws WvcmException {
        ArrayList<String> cleartoolArgs = new ArrayList<String>(Arrays.asList(MKHLINK, _NC, hltype, fromObjectSelector, toObjectSelector));
        CommandResult r = this.ctProvider.executeGetResult(feedback, cleartoolArgs);
        this.retryIfNoType(r, cleartoolArgs, "hltype", feedback);
    }

    private final void retryIfNoType(CommandResult result, List<String> cleartoolArgs, String typeString, SrvcFeedback feedback) throws WvcmException {
        String primaryErr;
        if (result.getStat() == 0) {
            return;
        }
        String typeKind = null;
        if (typeString.equals("attype")) {
            typeKind = ATTRIBUTE;
        } else if (typeString.equals("hltype")) {
            typeKind = HYPERLINK;
        } else {
            throw new IllegalArgumentException("Type not yet supported: " + typeString);
        }
        if (result.getStdErrList() == null || result.getStdErrList().size() == 0) {
            throw new IllegalArgumentException("Error parsing arguments");
        }
        Pattern MK_ERR_PATTERN = Pattern.compile("^.*? " + typeKind + " type \"(.*?)\" not found in VOB \"(.*?)\" and no global type definition can be found.$");
        Matcher m = MK_ERR_PATTERN.matcher(primaryErr = result.getStdErrList().get(0));
        if (!m.find()) {
            if (primaryErr.contains("cleartool: Error: Object already has an attribute of type")) {
                throw new WvcmException(Messages.CCaseLib_ERROR_STREAM_RESERVED, null, WvcmException.ReasonCode.FORBIDDEN);
            }
            result.assertSuccess(IGNORE_Nothing);
            throw new IllegalStateException("cleartool error processing failed: " + primaryErr);
        }
        String mkTypeArg = m.replaceFirst("$1@$2");
        this.ctProvider.execute(feedback, MKTYPE_PREFIX + typeString, _NC, _GLOBAL, _SHARED, mkTypeArg);
        this.ctProvider.execute(feedback, cleartoolArgs);
    }

    public String gpathDontCanonicalize(String oidSel, String viewTag, SrvcFeedback feedback) throws WvcmException {
        return this.gpath(Collections.singletonList(oidSel), viewTag, false, feedback).get(0);
    }

    public String gpath(String oidSel, String viewTag, SrvcFeedback feedback) throws WvcmException {
        return this.gpath(Collections.singletonList(oidSel), viewTag, true, feedback).get(0);
    }

    public List<String> gpath(List<String> oidSels, String viewTag, boolean canonicalize, SrvcFeedback feedback) throws WvcmException {
        List<String> pathnames = this.describeShort(oidSels, IGNORE_Nothing, viewTag, feedback);
        return canonicalize ? CommonUtils.canonicalizePathnames(pathnames) : pathnames;
    }

    private String getUcmObjKind(String objSel, SrvcFeedback feedback) throws WvcmException {
        String objSelector = ObjSelUtils.formatSelector("anyactivity", objSel);
        String mtype = this.mtypeByObject.get(null, objSel);
        if (mtype == null && (mtype = this.ctProvider.execute(feedback, DESCRIBE, _FMT, FMT_MTYPE, objSelector)) != null) {
            this.mtypeByObject.put(null, objSelector, mtype);
        }
        return mtype;
    }

    public String makeBaseline(String viewTag, String componentSel, String nameHint, List<String> addDependentComps, List<String> dropDependentComps, SrvcFeedback feedback) throws WvcmException {
        return this.makeBaseline(viewTag, componentSel, nameHint, false, addDependentComps, dropDependentComps, feedback);
    }

    public String makeBaseline(String viewTag, String componentSel, String nameHint, boolean identical, List<String> addDependentComps, List<String> dropDependentComps, SrvcFeedback feedback) throws WvcmException {
        String dropDepComponents;
        String addDepComponents;
        String baseName = nameHint != null ? CCaseLib.cleanName(nameHint) : Messages.CCaseLib_CTWVCM_BASELINE_NAME;
        ArrayList<String> cleartoolArgs = new ArrayList<String>(Arrays.asList(MKBL, _VIEW, viewTag));
        if (componentSel != null) {
            cleartoolArgs.add(_COMPONENT);
            cleartoolArgs.add(componentSel);
        }
        if (identical) {
            cleartoolArgs.add(_IDENTICAL);
        }
        if (!(addDepComponents = CommonUtils.getCommaSeparatedFromList(addDependentComps)).equals(EMPTY_STRING)) {
            cleartoolArgs.add(_ADEPENDS_ON);
            cleartoolArgs.add(addDepComponents);
        }
        if (!(dropDepComponents = CommonUtils.getCommaSeparatedFromList(dropDependentComps)).equals(EMPTY_STRING)) {
            cleartoolArgs.add(_DDEPENDS_ON);
            cleartoolArgs.add(dropDepComponents);
        }
        cleartoolArgs.add(baseName);
        CommandResult r = this.ctProvider.executeGetResult(feedback, cleartoolArgs);
        Matcher errMatcher = UNLABELED_BASELINE_PATTERN.matcher(r.getStdErr());
        if (errMatcher.find()) {
            String[] warningLines;
            String componentName = ObjSelUtils.isUniversalSelector(componentSel) ? this.describeShort(componentSel, IGNORE_Nothing, viewTag, feedback) : ObjSelUtils.getObjSelName(componentSel);
            String baselineName = null;
            String allWarningLines = errMatcher.replaceFirst("$2").trim();
            String[] stringArray = warningLines = allWarningLines.split(FMT_NEWLINE);
            int n = warningLines.length;
            int n2 = 0;
            while (n2 < n) {
                String warningLine = stringArray[n2];
                Matcher lineMatcher = COMPONENT_LINE_PATTERN.matcher(warningLine);
                String warningBlName = lineMatcher.replaceFirst("$1").trim();
                String warningCompName = lineMatcher.replaceFirst("$2").trim();
                if (componentName.equals(warningCompName)) {
                    baselineName = warningBlName;
                    break;
                }
                ++n2;
            }
            if (baselineName != null) {
                String streamSel = this.getStreamUniversalSelector(viewTag, feedback);
                try {
                    this.ctProvider.execute(feedback, CHBL, _INCREMENTAL, ObjSelUtils.formatSelector("baseline", baselineName, ObjSelUtils.getObjSelVobSel(streamSel)));
                }
                catch (WvcmException ex) {
                    if (ex.getMessage().contains("Some baselines could not be labeled")) {
                        throw new WvcmException(Messages.CCaseLib_CHBL_LABEL_CONFLICT_ERROR, WvcmException.ReasonCode.FORBIDDEN, (Throwable)ex);
                    }
                    throw ex;
                }
            }
        } else {
            r.assertSuccess(IGNORE_NotFound_NoViewInfo);
            String componentName = ObjSelUtils.getObjSelName(componentSel);
            String baselineMade = null;
            for (String line : r.getStdOutList()) {
                Matcher m = CREATED_BASELINE_PATTERN.matcher(line);
                if (!m.find() || !line.contains(componentName)) continue;
                baselineMade = m.group(1);
                break;
            }
            return baselineMade;
        }
        return null;
    }

    public String getLatestBaselineInStreamOfComponent(String streamSel, String compName, SrvcFeedback feedback) throws WvcmException {
        String result = this.lookupLatestBaselineInStreamOfComponent(streamSel, compName, feedback);
        if (result == null) {
            throw new WvcmException(NLS.bind((String)Messages.CCaseLib_ERROR_COULD_NOT_FIND_BASELINE_IN_STREAM, (Object)compName, (Object)streamSel), WvcmException.ReasonCode.NOT_FOUND);
        }
        return result;
    }

    String lookupLatestBaselineInStreamOfComponent(String streamSel, String compName, SrvcFeedback feedback) throws WvcmException {
        List<String> latestBaselines = this.getLatestBaselines(streamSel, feedback);
        if (!ObjSelUtils.isUniversalSelector(compName)) {
            throw new IllegalArgumentException("Component path must be a universal selector");
        }
        String result = null;
        List<String> components = this.getComponents(latestBaselines, false, feedback);
        Iterator<String> blIt = latestBaselines.iterator();
        for (String component : components) {
            String bl = blIt.next();
            if (!compName.equals(component)) continue;
            result = bl;
            break;
        }
        return result;
    }

    private List<String> computeComponents(List<String> blSelectors, boolean objSelector, SrvcFeedback feedback) throws WvcmException {
        ArrayList<String> cleartoolArgs = new ArrayList<String>(Arrays.asList(DESCRIBE, _FMT, "%[component]Xp\\n"));
        List<String> componentSels = this.executeBatched(feedback, cleartoolArgs, blSelectors);
        if (!objSelector) {
            componentSels = this.getUniversalSelectors(componentSels, feedback);
        }
        return componentSels;
    }

    public List<String> getComponentRootDirPathnames(List<String> compSels, String viewTag, SrvcFeedback feedback) throws WvcmException {
        return this.getComponentRootDirs(compSels, CCaseLib.getPathIntoView(viewTag), feedback);
    }

    public String getComponentRootDirPathname(String compSel, String viewTag, SrvcFeedback feedback) throws WvcmException {
        return this.getComponentRootDirPathnames(Collections.singletonList(compSel), viewTag, feedback).get(0);
    }

    private List<String> getComponentRootDirs(List<String> compSels, String pathIntoView, SrvcFeedback feedback) throws WvcmException {
        List result = this.rootDirByComponentAndView.get(pathIntoView, compSels);
        if (result.isEmpty()) {
            Map<String, String> rootDirs = this.computeComponentRootDirs(compSels, pathIntoView, feedback);
            for (String compSel : compSels) {
                String rootDir = rootDirs.get(compSel);
                if (rootDir == null) {
                    throw new WvcmException(NLS.bind((String)Messages.CCaseLib_COULD_NOT_GET_COMPONENT_ROOT, (Object)compSel, (Object)pathIntoView), null, WvcmException.ReasonCode.FORBIDDEN);
                }
                result.add(rootDir);
            }
            this.rootDirByComponentAndView.put(pathIntoView, compSels, result);
        }
        return result;
    }

    private Map<String, String> computeComponentRootDirs(List<String> componentNames, String pathIntoView, SrvcFeedback feedback) throws WvcmException {
        HashMap<String, String> result = new HashMap<String, String>(componentNames.size());
        List<String> lines = this.getHyperlinks(COMPONENT_ROOT_DIR_HLTYPE, componentNames, pathIntoView, feedback);
        Iterator<String> it = componentNames.iterator();
        for (String line : lines) {
            if (!it.hasNext()) {
                throw new IllegalStateException("Number of hyperlink lines does not match number of components");
            }
            String name = it.next();
            if (line.length() == 0) continue;
            if (pathIntoView == null) {
                String hlinkSel;
                CommandResult cmdResult;
                String value = null;
                Matcher hlinkMatcher = HLINK_TO_EMPTY_PATTERN.matcher(line);
                if (hlinkMatcher.find() && (cmdResult = this.ctProvider.executeGetResult(feedback, DUMP, HLINK_COLON + (hlinkSel = hlinkMatcher.group(1)))).getStat() != 0 && cmdResult.getStdErr().contains("cleartool: Error: Unable to find replica in registry for VOB with object ID")) {
                    value = _UNAVAILABLE_;
                }
                result.put(name, value);
                continue;
            }
            Matcher m = COMP_ROOT_DIR_PATTERN.matcher(line);
            if (!m.find()) {
                throw new WvcmException(NLS.bind((String)Messages.CCaseLib_COULD_NOT_GET_COMPONENT_ROOT, (Object)name, (Object)pathIntoView), null, WvcmException.ReasonCode.FORBIDDEN);
            }
            String vobRootDir = m.replaceFirst("$1");
            result.put(name, CommonUtils.canonicalizePathname(vobRootDir));
        }
        return result;
    }

    private List<String> getHyperlinks(String hltype, List<String> objectNames, String pathIntoView, SrvcFeedback feedback) throws WvcmException {
        if (objectNames.size() == 0) {
            return new ArrayList<String>();
        }
        CommandResult.ResultBehaviorFlags ignoreFlags = IGNORE_NotFound_NoViewInfo;
        ArrayList<String> cleartoolArgs = new ArrayList<String>(Arrays.asList(DESCRIBE, _FMT, FMT_HLINK_PREFIX + hltype + FMT_SUFFIX + FMT_NEWLINE));
        return this.executeBatched(feedback, pathIntoView, ignoreFlags, cleartoolArgs, objectNames);
    }

    protected String getHyperlinksLine(String hltype, String objectName, SrvcFeedback feedback) throws WvcmException {
        List<String> linkLines = this.getHyperlinks(hltype, Collections.singletonList(objectName), null, feedback);
        if (linkLines.size() == 0) {
            return new String();
        }
        return linkLines.get(0);
    }

    public List<String> getHyperlinkTargets(String hltype, String objSel, SrvcFeedback feedback) throws WvcmException {
        return this.getHyperlinkEnds(true, hltype, objSel, feedback);
    }

    public List<String> getHyperlinkSources(String hltype, String objSel, SrvcFeedback feedback) throws WvcmException {
        return this.getHyperlinkEnds(false, hltype, objSel, feedback);
    }

    private List<String> getHyperlinkEnds(boolean isTarget, String hltype, String objSel, SrvcFeedback feedback) throws WvcmException {
        ArrayList<String> result = new ArrayList<String>();
        String arrow = isTarget ? "->" : MERGE_INTO_ARROW;
        String[] tokens = this.getHyperlinksLine(hltype, objSel, feedback).split(SPACE);
        boolean nextIsResult = false;
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (nextIsResult) {
                if (token.charAt(0) == '\"') {
                    token = token.substring(1, token.length() - 1);
                }
                result.add(token);
                nextIsResult = false;
            } else {
                nextIsResult = token.equals(arrow);
            }
            ++n2;
        }
        return result;
    }

    public void removeName(String folderPathname, String nameToRemove, SrvcFeedback feedback) throws WvcmException {
        String pathname = String.valueOf(folderPathname) + '/' + nameToRemove;
        this.ctProvider.execute(feedback, RMNAME, _NC, _FORCE, pathname);
    }

    public void moveName(String oldPathname, String newPathname, SrvcFeedback feedback) throws WvcmException {
        this.ctProvider.execute(feedback, MOVE, _NC, oldPathname, newPathname);
    }

    public void link(String oldVersPathname, String newPathname, SrvcFeedback feedback) throws WvcmException {
        this.ctProvider.execute(feedback, LN, _NC, oldVersPathname, newPathname);
    }

    public void symLink(String linkTarget, String newPathname, SrvcFeedback feedback) throws WvcmException {
        this.ctProvider.execute(feedback, LN, _S, _NC, linkTarget, newPathname);
    }

    public final String makeView(String viewTagHint, String stream, String viewMode, SrvcFeedback feedback) throws WvcmException {
        String viewTag = String.valueOf(InteropUtilities.BUILD_ID_PREFIX) + viewTagHint;
        int viewTagIndex = 2;
        ArrayList<String> args = new ArrayList<String>(14);
        args.add(MKVIEW);
        if (stream != null) {
            args.add(_STREAM);
            args.add(stream);
            viewTagIndex = 4;
        }
        String viewStgParentDir = CTInitArgUtils.getStgLoc(this.ctInitArgs);
        ObjSelUtils.validateViewStgPath(viewStgParentDir);
        String path = ObjSelUtils.computeStgPath(true, viewTag, viewStgParentDir);
        if (viewMode != null) {
            args.addAll(Arrays.asList(_TAG, viewTag, _TMODE, viewMode));
        } else {
            args.addAll(Arrays.asList(_TAG, viewTag, _TMODE, this.getTextMode()));
        }
        boolean useTripleSet = CTInitArgUtils.useTripleSet(this.ctInitArgs);
        if (useTripleSet) {
            String host = CTInitArgUtils.getHost(this.ctInitArgs);
            String hpathStgDir = CTInitArgUtils.getHpath(this.ctInitArgs);
            String gpathStgDir = CTInitArgUtils.getGpath(this.ctInitArgs);
            ObjSelUtils.validateViewStgPath(gpathStgDir);
            String hpath = ObjSelUtils.computeStgPath(true, viewTag, hpathStgDir);
            String gpath = ObjSelUtils.computeStgPath(true, viewTag, gpathStgDir);
            args.addAll(Arrays.asList(_HOST, host, _HPATH, hpath, _GPATH, gpath));
        }
        args.add(path);
        boolean keepTrying = true;
        String uniqueViewTag = viewTag;
        while (keepTrying) {
            CommandResult r = this.ctProvider.executeGetResult(feedback, args);
            if (r.getStdErr().contains("registry entry already exists") || this.ERROR_VIEW_TAG_EXISTS.matcher(r.getStdErr()).find()) {
                String suffix;
                int viewTagLen;
                byte underscore = 95;
                byte[] viewTagChars = uniqueViewTag.getBytes();
                if (viewTagChars[(viewTagLen = uniqueViewTag.length()) - 2] == underscore && viewTagChars[viewTagLen - 1] == 57) {
                    suffix = CommonUtils.uniquifier();
                    uniqueViewTag = String.valueOf(viewTag) + suffix;
                    keepTrying = false;
                } else if (viewTagChars[viewTagLen - 2] == underscore && viewTagChars[viewTagLen - 1] >= 48 && viewTagChars[viewTagLen - 1] <= 56) {
                    int n = viewTagLen - 1;
                    viewTagChars[n] = (byte)(viewTagChars[n] + 1);
                    uniqueViewTag = new String(viewTagChars);
                } else {
                    suffix = "_1";
                    uniqueViewTag = String.valueOf(viewTag) + suffix;
                }
                args.set(viewTagIndex, uniqueViewTag);
                path = ObjSelUtils.computeStgPath(true, uniqueViewTag, viewStgParentDir);
                args.set(args.size() - 1, path);
                if (useTripleSet) {
                    String hpathStgDir = CTInitArgUtils.getHpath(this.ctInitArgs);
                    String gpathStgDir = CTInitArgUtils.getGpath(this.ctInitArgs);
                    String hpath = ObjSelUtils.computeStgPath(true, uniqueViewTag, hpathStgDir);
                    String gpath = ObjSelUtils.computeStgPath(true, uniqueViewTag, gpathStgDir);
                    args.set(args.size() - 2, gpath);
                    args.set(args.size() - 4, hpath);
                }
                if (keepTrying) continue;
                this.ctProvider.execute(feedback, args);
                continue;
            }
            r.assertSuccess(IGNORE_NoViewInfo);
            keepTrying = false;
        }
        return uniqueViewTag;
    }

    public final String makeView(String viewTag, String stream, SrvcFeedback feedback) throws WvcmException {
        return this.makeView(viewTag, stream, this.getTextMode(), feedback);
    }

    public final String makeComponent(String compRootPath, String compSel, String streamSel, boolean isSubVobComponent, SrvcFeedback feedback) throws WvcmException {
        int sep = 47;
        String compName = ObjSelUtils.getObjSelName(compSel);
        String uniqueCompSel = compSel;
        String uniqueRoot = CommonUtils.canonicalizePathname(compRootPath);
        if (isSubVobComponent && !uniqueRoot.endsWith(String.valueOf('/') + compName)) {
            throw new IllegalArgumentException("Component name must match last segment of component path");
        }
        String[] cleartoolArgs = new String[]{MKCOMP, _NC, _ROOT, compRootPath, compSel};
        CommandResult r = this.ctProvider.executeGetResult(feedback, cleartoolArgs);
        String stdErr = r.getStdErr();
        if (r.getStat() != 0 && stdErr != null && stdErr.contains("cleartool: Error: Invalid name: ")) {
            WvcmException cmdFaildException = r.computeOperationFailedException();
            throw new WvcmException(NLS.bind((String)Messages.CCaseLib_ERROR_MKCOMP_FAILED_INVALID_NAME, (Object)compName), WvcmException.ReasonCode.FORBIDDEN, (Throwable)cmdFaildException);
        }
        r.assertSuccess(IGNORE_NoViewInfo);
        if (streamSel != null) {
            String projSel = this.getProjectObjectSelector(streamSel, feedback);
            this.ctProvider.execute(feedback, CHPROJECT, _AMODCOMP, compSel, projSel);
            String defaultUCMViewTag = CTInitArgUtils.getIntViewTag(this.ctInitArgs);
            this.rebaseStreamComp(defaultUCMViewTag, streamSel, compSel, feedback);
        }
        return uniqueCompSel;
    }

    public String makeProject(String projectSel, List<String> compSel, SrvcFeedback feedback) throws WvcmException {
        return this.makeProject(projectSel, compSel, false, feedback);
    }

    public String makeProject(String projectSel, List<String> compSel, boolean singleStream, SrvcFeedback feedback) throws WvcmException {
        ArrayList<String> cleartoolArgs = new ArrayList<String>(Arrays.asList(MKPROJECT, _NC, _IN, ROOT_FOLDER));
        if (compSel != null) {
            cleartoolArgs.add(_MODCOMP);
            cleartoolArgs.add(CommonUtils.getCommaSeparatedFromList(compSel));
        }
        if (singleStream) {
            cleartoolArgs.add(_MODEL);
            cleartoolArgs.add("SIMPLE");
        }
        cleartoolArgs.add(projectSel);
        CommandResult r = this.ctProvider.executeGetResult(feedback, cleartoolArgs);
        Matcher alreadyExists = OBJECT_ALREADY_EXISTS_PATTERN.matcher(r.getStdErr());
        if (alreadyExists.find()) {
            String projectName = ObjSelUtils.getObjSelName(projectSel);
            String pVobSelector = ObjSelUtils.getObjSelVobSel(projectSel);
            projectSel = ObjSelUtils.formatSelector("project", String.valueOf(projectName) + CommonUtils.uniquifier(true), pVobSelector);
            cleartoolArgs.set(cleartoolArgs.size() - 1, projectSel);
            this.ctProvider.execute(feedback, cleartoolArgs);
        } else {
            r.assertSuccess(IGNORE_NoViewInfo);
        }
        return projectSel;
    }

    public String makeStream(String in, boolean isIntegration, List<String> baselineSel, String streamName, SrvcFeedback feedback) throws WvcmException {
        return this.makeStream(in, isIntegration, false, baselineSel, streamName, feedback);
    }

    public String makeStream(String in, boolean isIntegration, boolean readOnly, List<String> baselineSel, String streamName, SrvcFeedback feedback) throws WvcmException {
        ArrayList<String> cleartoolArgs = new ArrayList<String>(Arrays.asList(MKSTREAM, _NC, _IN, in));
        if (isIntegration) {
            cleartoolArgs.add(_INTEGRATION);
        }
        if (readOnly) {
            cleartoolArgs.add(_READONLY);
        }
        if (baselineSel != null) {
            cleartoolArgs.add(_BASELINE);
            cleartoolArgs.add(CommonUtils.getCommaSeparatedFromList(baselineSel));
        }
        String pVobSelector = ObjSelUtils.getObjSelVobSel(in);
        String streamSel = ObjSelUtils.formatSelector(FLEVEL7_MTYPE, streamName, pVobSelector);
        cleartoolArgs.add(streamSel);
        CommandResult r = this.ctProvider.executeGetResult(feedback, cleartoolArgs);
        Matcher alreadyExists = OBJECT_ALREADY_EXISTS_PATTERN.matcher(r.getStdErr());
        if (alreadyExists.find()) {
            streamSel = ObjSelUtils.formatSelector(FLEVEL7_MTYPE, String.valueOf(streamName) + CommonUtils.uniquifier(true), pVobSelector);
            cleartoolArgs.set(cleartoolArgs.size() - 1, streamSel);
            this.ctProvider.execute(feedback, cleartoolArgs);
        } else {
            r.assertSuccess(IGNORE_NoViewInfo);
        }
        return streamSel;
    }

    public void removeView(String viewTag, SrvcFeedback feedback) throws WvcmException {
        String viewStorageDir;
        block2: {
            viewStorageDir = null;
            try {
                viewStorageDir = this.getStorageDirectory(viewTag, false, feedback);
            }
            catch (WvcmException e) {
                if (e.getMessage().contains("No matching entries found for view tag")) break block2;
                throw e;
            }
        }
        this.ctProvider.execute(feedback, CommonUtils.FWDSLASH, IGNORE_NotFound_NoViewInfo, RMVIEW, _FORCE, _TAG, viewTag);
        this.waitForItToBeGone(viewStorageDir);
    }

    protected void waitForItToBeGone(String storageDir) {
        if (storageDir != null) {
            File dir = new File(storageDir);
            try {
                int i = 0;
                while (dir.exists()) {
                    if (i >= 10) {
                        throw new IllegalStateException("Storage directory not gone after 10 seconds");
                    }
                    ++i;
                    Thread.sleep(1000L);
                    dir = new File(storageDir);
                }
            }
            catch (InterruptedException e) {
                this.logIgnoredExceptionAsAlwaysVisible("CCaseLib.waitForItToBeGone", Messages.CCaseLib_IGNORED_EXCEPTION_WAIT_FOR_STORAGE_REMOVAL, e);
            }
        }
    }

    public void removeStream(String streamSel, SrvcFeedback feedback) throws WvcmException {
        this.ctProvider.execute(feedback, RMSTREAM, _FORCE, streamSel);
    }

    public String getStorageDirectory(String vTag, boolean isVobTag, SrvcFeedback feedback) throws WvcmException {
        String info = this.ctProvider.execute(feedback, isVobTag ? LSVOB : LSVIEW, vTag);
        Matcher m = LS_VOBVIEW_PATTERN.matcher(info);
        if (!m.find()) {
            throw new WvcmException(NLS.bind((String)Messages.ObjSelUtils_COULD_NOT_FIND_STORAGE_ERROR, (Object)vTag, (Object)info), WvcmException.ReasonCode.FORBIDDEN);
        }
        String result = m.group(1);
        return result;
    }

    public static final String cleanName(String displayName) {
        return displayName.replaceAll("[:|@\\\\/ ]", ObjSelUtils.UNDERSCORE);
    }

    public String getMainBranchName(String vobTag, SrvcFeedback feedback) throws WvcmException {
        String result = this.mainBranchNameByVobTag.get(null, vobTag);
        if (result != null) {
            return result;
        }
        result = this.ctProvider.execute(feedback, DESCRIBE, _FMT, FMT_N, ObjSelUtils.formatSelector("wko", "3", vobTag));
        this.mainBranchNameByVobTag.put(null, vobTag, result);
        return result;
    }

    public List<String> findElementsWithGivenAttribute(String searchRoot, String attypeName, SrvcFeedback feedback) throws WvcmException {
        List<String> results = null;
        if (this.containingVobHasBaseCcSubVobComponentAttype(searchRoot, feedback)) {
            String attPattern = ATT_TYPE_OPEN + attypeName + ATT_TYPE_CLOSE;
            results = this.ctProvider.executeGetValues(feedback, FIND, searchRoot, _ALL, _ELEMENT, attPattern, _PRINT);
        } else {
            results = Collections.emptyList();
        }
        return results;
    }

    public String lookupFriendlyUcmComponentSelectorFromGPath(String gpath, SrvcFeedback feedback) throws WvcmException {
        String result = null;
        String vobTag = this.getVobTagFromGpath(gpath, feedback);
        String crdeDBID = this.lookupComponentCRDE(gpath, feedback);
        if (crdeDBID != null) {
            result = this.getComponentSelector(ObjSelUtils.formatSelector("dbid", crdeDBID, vobTag), feedback);
        }
        return result;
    }

    public String lookupComponentSelectorFromGPath(String gpath, SrvcFeedback feedback) throws WvcmException {
        String compSel = this.lookupFriendlyUcmComponentSelectorFromGPath(gpath, feedback);
        if (compSel != null) {
            compSel = this.getUniversalSelector(compSel, feedback);
        }
        return compSel;
    }

    public String getComponentSelectorFromComponentRoot(String gpath, SrvcFeedback feedback) throws WvcmException {
        String result = null;
        String elemGpath = String.valueOf(gpath) + AT_AT;
        String compSel = this.getComponentSelector(elemGpath, feedback);
        if (compSel != null) {
            result = this.getUniversalSelector(compSel, feedback);
        }
        return result;
    }

    String getComponentSelector(String path, SrvcFeedback feedback) throws WvcmException {
        String result = null;
        String line = this.getHyperlinksLine(COMPONENT_ROOT_DIR_HLTYPE, path, feedback);
        if (line.length() == 0) {
            return null;
        }
        Matcher m = HLINK_TARGET_LEFT_ARROW_PATTERN.matcher(line);
        if (!m.find()) {
            throw new WvcmException(NLS.bind((String)Messages.CCaseLib_COULD_NOT_GET_COMPONENT_SELECTOR_ERROR, (Object)COMPONENT_ROOT_DIR_HLTYPE, (Object)line), null, WvcmException.ReasonCode.FORBIDDEN);
        }
        result = m.group(1);
        return result;
    }

    public String getVobTagFromGpath(String gpath, SrvcFeedback feedback) throws WvcmException {
        String viewTag;
        if (this.cachedVobTagPath != null && this.cachedVobTagPath.isPrefixOf((IPath)new Path(gpath))) {
            return this.cachedVobTagValue;
        }
        CommandResult r = this.ctProvider.executeGetResult(feedback, DESCRIBE, _SHORT, ObjSelUtils.formatSelector("vob", gpath));
        try {
            r.assertSuccess(new CommandResult.ResultBehaviorFlags(CommandResult.ResultBehaviorFlags.Kind.IGNORE_NO_VIEW_INFO));
        }
        catch (WvcmException ex) {
            if (ex.getMessage().contains("Unable to determine VOB for pathname")) {
                throw new WvcmException(NLS.bind((String)Messages.CCaseLib_UNABLE_TO_DETERMINE_VOB, (Object)ex.getMessage()), WvcmException.ReasonCode.NOT_FOUND);
            }
            throw ex;
        }
        String vobTag = r.getStdOut();
        if (vobTag != null && vobTag.length() > 0 && (viewTag = ObjSelUtils.getViewTag(mvfsRoot, gpath)) != null) {
            this.cachedVobTagValue = vobTag;
            this.cachedVobTagPath = new Path(String.valueOf(CCaseLib.getPathIntoView(viewTag)) + vobTag);
        }
        return vobTag;
    }

    public boolean equalObjSels(String sel1, String sel2, SrvcFeedback feedback) throws WvcmException {
        if (sel1 == null || sel2 == null || sel1.length() == 0 || sel2.length() == 0) {
            return false;
        }
        String uSel1 = this.getUniversalSelector(sel1, feedback);
        String uSel2 = this.getUniversalSelector(sel2, feedback);
        return uSel1.equals(uSel2);
    }

    public String getDisplayName(String objSel, SrvcFeedback feedback) throws WvcmException {
        return this.ctProvider.execute(feedback, DESCRIBE, _FMT, FMT_N, objSel);
    }

    public String getExtendedName(String viewTag, String objSel, SrvcFeedback feedback) throws WvcmException {
        String result = null;
        String objSelKind = ObjSelUtils.getObjSelKind(objSel);
        if ((ObjSelUtils.isUniversalSelector(objSel) || "lbtype".equals(objSelKind)) && (result = this.extendedNameByUSel.get(null, objSel)) != null) {
            return result;
        }
        CommandResult.ResultBehaviorFlags ignoreFlags = IGNORE_NoViewInfo;
        String viewPath = null;
        if (viewTag != null) {
            viewPath = CCaseLib.getPathIntoView(viewTag);
        } else {
            ignoreFlags = IGNORE_NotFound_NoViewInfo;
        }
        result = this.ctProvider.execute(feedback, viewPath, ignoreFlags, DESCRIBE, _FMT, FMT_XN, objSel);
        if (result.startsWith("folder:") || result.startsWith("stream:") || "lbtype".equals(objSelKind)) {
            this.extendedNameByUSel.put(null, objSel, result);
        }
        return result;
    }

    public String getParentStream(String streamSel, SrvcFeedback feedback) throws WvcmException {
        String parentStream = null;
        if (this.parentByStreamSel.containsKey(null, streamSel)) {
            parentStream = this.parentByStreamSel.get(null, streamSel);
            if (parentStream.equals(EMPTY_STRING)) {
                parentStream = null;
            }
        } else {
            String streamObjectSelector = streamSel;
            if (ObjSelUtils.isUniversalSelector(streamSel)) {
                streamObjectSelector = this.getExtendedName(null, streamSel, feedback);
            }
            CommandResult r = this.ctProvider.executeGetResult(feedback, LSSTREAM, _ANCESTOR, _FMT, "%m|%Xn\\n", _DEPTH, "2", streamObjectSelector);
            r.assertSuccess(IGNORE_Nothing);
            List<String> ancestorTree = r.getStdOutList();
            if (ancestorTree.size() != 2) {
                StringBuffer msg = new StringBuffer(String.format("Expected 2 lines in ancestor tree of %s.\nStandard Output:%s\n", streamSel, r.getStdOut()));
                throw new IllegalStateException(msg.toString());
            }
            String[] tokens = CCaseLib.getObjInfoTokens(ancestorTree.get(0), 2);
            parentStream = tokens[0].equals(FLEVEL7_MTYPE) ? tokens[1] : EMPTY_STRING;
            this.parentByStreamSel.put(null, streamSel, parentStream);
        }
        return parentStream;
    }

    public boolean isViewValid(String viewTag, SrvcFeedback feedback) throws WvcmException {
        CommandResult r = this.ctProvider.executeGetResult(feedback, LSVIEW, viewTag);
        this.checkAlbdRunning(r);
        if (r == null || r.getStat() != 0 || r.getStdOutList() == null || r.getStdOutList().size() == 0) {
            return false;
        }
        return r.getStdOutList().get(0).charAt(0) == '*' || (r = this.ctProvider.executeGetResult(feedback, STARTVIEW, viewTag)) != null && r.getStat() == 0 && (r.getStdErrList() == null || r.getStdErrList().size() == 0);
    }

    public boolean isVobValid(String vobTag, SrvcFeedback feedback) {
        CommandResult r = this.getLsVobOutput(vobTag, feedback);
        return r != null && r.getStat() == 0 && r.getStdOutList() != null && r.getStdOutList().size() != 0;
    }

    public boolean isVobMounted(String vobTag, SrvcFeedback feedback) {
        CommandResult r = this.getLsVobOutput(vobTag, feedback);
        return r != null && r.getStat() == 0 && r.getStdOutList() != null && r.getStdOutList().size() != 0 && r.getStdOutList().get(0).charAt(0) == '*';
    }

    private CommandResult getLsVobOutput(String vobTag, SrvcFeedback feedback) {
        CommandResult r;
        try {
            r = this.ctProvider.executeGetResult(feedback, LSVOB, vobTag);
            this.checkAlbdRunning(r);
        }
        catch (WvcmException e) {
            this.logIgnoredExceptionAsAlwaysVisible("CCaseLib.getLsVobOutput", Messages.CCaseLib_IGNORED_EXCEPTION_LIST_VOB, (Exception)((Object)e));
            return null;
        }
        return r;
    }

    public void checkAlbdRunning(CommandResult r) throws WvcmException {
        if (r.getStdErrList().size() != 0) {
            for (String error : r.getStdErrList()) {
                Matcher m = CANT_CONTACT_ALBD_PATTERN.matcher(error);
                if (!m.find()) continue;
                String message = CommandProvider.IS_WINDOWS ? Messages.CommandProvider_UNABLE_TO_EXECUTE_CLEARTOOL_WINDOWS : Messages.CommandProvider_UNABLE_TO_EXECUTE_CLEARTOOL_UNIX;
                throw new WvcmException(NLS.bind((String)message, (Object)m.replaceFirst("$1")), WvcmException.ReasonCode.NOT_FOUND);
            }
        }
    }

    public String[] queryStream(String streamSelSuffix, SrvcFeedback feedback) throws WvcmException {
        String streamSel = ObjSelUtils.isFullyQualifiedSelector(streamSelSuffix) ? streamSelSuffix : ObjSelUtils.formatSelector(FLEVEL7_MTYPE, streamSelSuffix);
        String vobSel = ObjSelUtils.getObjSelVobSel(streamSel);
        if (!this.isVobValid(vobSel, feedback)) {
            throw new WvcmException(NLS.bind((String)Messages.CCaseLib_INVALID_PVOB_TAG_ERROR, (Object)vobSel), WvcmException.ReasonCode.FORBIDDEN);
        }
        CommandResult r = this.ctProvider.executeGetResult(feedback, LSSTREAM, _FMT, "%Xn|%[read_only]p\\n", streamSel);
        if (r.getStat() != 0 || r.getStdErrList() != null && r.getStdErrList().size() != 0 || r.getStdOutList() == null || r.getStdOutList().size() != 1) {
            return null;
        }
        String[] tokens = r.getStdOut().split(LITERAL_VERTICAL_BAR_PATTERN);
        return tokens;
    }

    public String getComponentPathnameFromAnyKindOfName(String viewTag, String displayName, SrvcFeedback feedback) throws WvcmException {
        String result = ObjSelUtils.isUniversalSelector(displayName) ? this.getComponentRootDirPathname(displayName, viewTag, feedback) : ObjSelUtils.composePathname(viewTag, String.valueOf('/') + displayName, ".");
        return result;
    }

    public String getPathname(String versionUniversalSelector, SrvcFeedback feedback) throws WvcmException {
        return this.ctProvider.execute(feedback, DESCRIBE, _FMT, "%n\\n", versionUniversalSelector);
    }

    public String getVerExtendedPathnameInView(String viewTag, String versionSelector, SrvcFeedback feedback) throws WvcmException {
        String viewPath = null;
        if (viewTag != null) {
            viewPath = CCaseLib.getPathIntoView(viewTag);
        }
        return this.ctProvider.execute(feedback, viewPath, IGNORE_NoViewInfo, DESCRIBE, _CVIEW, _FMT, "%n\\n", versionSelector);
    }

    public String getComment(String pathname, SrvcFeedback feedback) throws WvcmException {
        return this.ctProvider.execute(feedback, DESCRIBE, _FMT, FMT_NC, pathname);
    }

    public void setComment(String pathname, String comment, SrvcFeedback feedback) throws WvcmException {
        this.ctProvider.execute(feedback, CHEVENT, _REPLACE, _COMMENT, comment, pathname);
    }

    public String removeType(String typeSel, SrvcFeedback feedback) throws WvcmException {
        return this.ctProvider.execute(feedback, RMTYPE, _NC, _RMALL, _FORCE, typeSel);
    }

    public String getViewConfigSpec(String viewTag, SrvcFeedback feedback) throws WvcmException {
        return this.ctProvider.execute(feedback, CATCS, _TAG, viewTag);
    }

    public void setViewConfigSpec(String viewTag, String[] configSpec, SrvcFeedback feedback) throws WvcmException {
        String viewStorage = this.getStorageDirectory(viewTag, false, feedback);
        String fileName = String.valueOf(viewStorage) + CONFIG_SPEC;
        File file = new File(fileName);
        try {
            FileOutputStream fos = new FileOutputStream(file);
            PrintWriter writer = new PrintWriter(fos);
            int i = 0;
            while (i < configSpec.length) {
                writer.println(configSpec[i]);
                ++i;
            }
            writer.close();
            fos.close();
            this.ctProvider.execute(feedback, SETCS, _CURRENT, _TAG, viewTag);
        }
        catch (FileNotFoundException exception) {
            throw new WvcmException(NLS.bind((String)Messages.CCaseLib_CS_FILE_NOT_FOUND_ERROR, (Object)file.getAbsolutePath()), WvcmException.ReasonCode.WRITE_FAILED);
        }
        catch (IOException exception) {
            throw new WvcmException(NLS.bind((String)Messages.CCaseLib_CS_FILE_NOT_FOUND_ERROR, (Object)file.getAbsolutePath()), WvcmException.ReasonCode.WRITE_FAILED);
        }
    }

    public String mkBrType(String brtypeName, String vobTag, SrvcFeedback feedback) throws WvcmException {
        String name = this.createExtendedTypeName("brtype", brtypeName, vobTag);
        String[] args = new String[]{MKBRTYPE, _NC, _GLOBAL, name};
        CommandResult r = this.ctProvider.executeGetResult(feedback, args);
        Matcher alreadyExists = OBJECT_ALREADY_EXISTS_PATTERN.matcher(r.getStdErr());
        if (alreadyExists.find() || r.getStdErr().contains("would eclipse global definition of branch type") || r.getStdErr().contains("would be eclipsed by definition") || r.getStdErr().contains("Cannot define branch type with the same name as a label type")) {
            args[args.length - 1] = name = this.createExtendedTypeName("brtype", String.valueOf(brtypeName) + CommonUtils.uniquifier(), vobTag);
            this.ctProvider.execute(feedback, args);
        } else {
            r.assertSuccess(IGNORE_NoViewInfo);
        }
        return name;
    }

    public String mkLbType(String lbtypeName, String vobTag, SrvcFeedback feedback) throws WvcmException {
        String name = this.createExtendedTypeName("lbtype", lbtypeName, vobTag);
        String[] args = new String[]{MKLBTYPE, _NC, _GLOBAL, _SHARED, name};
        CommandResult r = this.ctProvider.executeGetResult(feedback, args);
        Matcher alreadyExists = OBJECT_ALREADY_EXISTS_PATTERN.matcher(r.getStdErr());
        if (alreadyExists.find() || r.getStdErr().contains("would eclipse global definition of label type") || r.getStdErr().contains("would be eclipsed by definition") || r.getStdErr().contains("Cannot define label type with the same name as a branch type")) {
            args[args.length - 1] = name = this.createExtendedTypeName("lbtype", String.valueOf(lbtypeName) + CommonUtils.uniquifier(), vobTag);
            this.ctProvider.execute(feedback, args);
        } else {
            r.assertSuccess(IGNORE_NoViewInfo);
        }
        return name;
    }

    private String createExtendedTypeName(String type, String typeName, String vobTag) {
        return ObjSelUtils.formatSelector(type, typeName, vobTag);
    }

    public String validateBranchType(String brtypeSelSuffix, SrvcFeedback feedback) throws WvcmException {
        String brtypeSel = ObjSelUtils.formatSelector("brtype", brtypeSelSuffix);
        return this.validateAndLockType(brtypeSel, false, feedback);
    }

    public String validateAndLockLabelType(String lbtypeSelSuffix, SrvcFeedback feedback) throws WvcmException {
        String lbtypeSel = ObjSelUtils.formatSelector("lbtype", lbtypeSelSuffix);
        String lbtypeName = ObjSelUtils.getObjSelName(lbtypeSel);
        if (this.isPredefinedLabelType(lbtypeName)) {
            throw new WvcmException(NLS.bind((String)Messages.CCaseLib_INVALID_PREDEFINED_LABEL_TYPE_ERROR, (Object)lbtypeSelSuffix), WvcmException.ReasonCode.FORBIDDEN);
        }
        return this.validateAndLockType(lbtypeSel, true, feedback);
    }

    private boolean isPredefinedLabelType(String typeName) {
        return typeName.equals(LATEST) || typeName.equals(CHECKEDOUT) || typeName.equals(BACKSTOP);
    }

    private String validateAndLockType(String typeSel, boolean lock, SrvcFeedback feedback) throws WvcmException {
        String stdout = this.validateTypeInternal(typeSel, feedback);
        String[] tokens = CCaseLib.getObjInfoTokens(stdout, 2);
        String type = tokens[0];
        String lockStatus = tokens[1];
        if (!lockStatus.equals(LOCKED) && lock) {
            this.lock(typeSel, feedback);
        }
        return type;
    }

    public void validateType(String typeSel) throws WvcmException {
        CTProvider.CTFeedback feedback = new CTProvider.CTFeedback(null);
        this.validateTypeInternal(typeSel, feedback);
    }

    private String validateTypeInternal(String typeSel, SrvcFeedback feedback) throws WvcmException {
        CommandResult r = null;
        try {
            String vobSel = ObjSelUtils.getObjSelVobSel(typeSel);
            if (!this.isVobValid(vobSel, feedback)) {
                throw new WvcmException(NLS.bind((String)Messages.CCaseLib_INVALID_ADMIN_VOB_TAG_ERROR, (Object)vobSel), WvcmException.ReasonCode.NOT_FOUND);
            }
            r = this.ctProvider.executeGetResult(feedback, LSTYPE, _FMT, "%Xn|%[locked]p\\n", typeSel);
            r.assertSuccess(IGNORE_NoViewInfo);
            if (r.getStdOutList() == null || r.getStdOutList().size() != 1) {
                String msg = EMPTY_STRING;
                for (String s : r.getStdErrList()) {
                    msg = String.valueOf(msg) + s;
                }
                throw new WvcmException(msg, WvcmException.ReasonCode.CONFLICT);
            }
        }
        catch (WvcmException e) {
            throw new WvcmException(NLS.bind((String)Messages.CTProvider_ERROR_TYPE_SELECTOR_NOT_FOUND, (Object)typeSel), WvcmException.ReasonCode.NOT_FOUND, (Throwable)e);
        }
        return r.getStdOut();
    }

    public List<String> findNewVersions(String searchRoot, String createdSince, String syncBranch, SrvcFeedback feedback) throws WvcmException {
        ArrayList<String> findArgs = new ArrayList<String>();
        findArgs.add(FIND);
        findArgs.add(searchRoot);
        findArgs.add(_ALL);
        findArgs.add(_VERSION);
        String timeQuery = "{created_since(" + createdSince + ')' + AMPAMP + QUERY_VERSION_PREFIX + syncBranch + BRANCH_LATEST + ')' + '}';
        findArgs.add(timeQuery);
        findArgs.add(_BRANCH);
        String branchQuery = QUERY_BRTYPE_PREFIX + syncBranch + ')';
        findArgs.add(branchQuery);
        findArgs.add(_PRINT);
        return this.ctProvider.executeGetValues(feedback, findArgs);
    }

    String getBaseCCInfo(String viewTag, SrvcFeedback feedback) throws WvcmException {
        String info = this.baseCCViewInfo.get(null, viewTag);
        if (info == null) {
            String label;
            String configSpec = this.getViewConfigSpec(viewTag, feedback);
            String branch = CCaseLib.getBrtypeFromConfigSpec(configSpec);
            if (branch == null) {
                branch = EMPTY_STRING;
            }
            if ((label = CCaseLib.getLbypeFromConfigSpec(configSpec)) == null) {
                label = EMPTY_STRING;
            }
            info = new String(String.valueOf(branch) + CTLocation.INFO_SEPARATOR_STRING + label);
            this.baseCCViewInfo.put(null, viewTag, info);
        }
        if (info.equals(CTLocation.INFO_SEPARATOR_STRING)) {
            return null;
        }
        return info;
    }

    private static String getBrtypeFromConfigSpec(String configSpec) {
        String branch = null;
        if (configSpec.contains(CTBaseCCView.ConfigSpec.BRANCH_INFO)) {
            int start = configSpec.indexOf(CTBaseCCView.ConfigSpec.BRANCH_INFO) + CTBaseCCView.ConfigSpec.BRANCH_INFO.length();
            int end = configSpec.lastIndexOf(CTBaseCCView.ConfigSpec.BRANCH_INFO);
            branch = configSpec.substring(start, end);
        }
        return branch;
    }

    private static String getLbypeFromConfigSpec(String configSpec) {
        String label = null;
        if (configSpec.contains(CTBaseCCView.ConfigSpec.LABEL_INFO)) {
            int start = configSpec.indexOf(CTBaseCCView.ConfigSpec.LABEL_INFO) + CTBaseCCView.ConfigSpec.LABEL_INFO.length();
            int end = configSpec.lastIndexOf(CTBaseCCView.ConfigSpec.LABEL_INFO);
            label = configSpec.substring(start, end);
        }
        return label;
    }

    public void setcsCurrent(String viewTag, SrvcFeedback feedback) throws WvcmException {
        this.ctProvider.execute(feedback, null, IGNORE_Nothing, SETCS, _CURRENT, _TAG, viewTag);
    }

    public void startView(String viewTag, SrvcFeedback feedback) throws WvcmException {
        this.ctProvider.execute(feedback, null, IGNORE_Nothing, STARTVIEW, viewTag);
    }

    public String getElementType(String elementUsel, SrvcFeedback feedback) throws WvcmException {
        return this.ctProvider.execute(feedback, DESCRIBE, _FMT, "%[type]p", elementUsel);
    }

    public synchronized String elementTypeToCharacterSet(String vobSel, String elementType, SrvcFeedback feedback) throws WvcmException {
        String result = this._elementTypeToCharacterSet.get(null, elementType);
        if (result == null) {
            this.updateEltypeToStandardTypeMap(this._elementTypeToCharacterSet, vobSel, elementType, feedback);
            result = this._elementTypeToCharacterSet.get(null, elementType);
        }
        return result;
    }

    public synchronized String elementTypeToMimeContentType(String vobSel, String elementType, SrvcFeedback feedback) throws WvcmException {
        String result = this._elementTypeToMimeContentType.get(null, elementType);
        if (result == null) {
            this.updateEltypeToStandardTypeMap(this._elementTypeToMimeContentType, vobSel, elementType, feedback);
            result = this._elementTypeToMimeContentType.get(null, elementType);
        }
        return result;
    }

    private String updateEltypeToStandardTypeMap(Cache eltypeToStandardType, String vobSel, String elementType, SrvcFeedback feedback) throws WvcmException {
        ArrayList<String> elementTypes = new ArrayList<String>();
        String result = null;
        String nextType = elementType;
        block0: while (result == null) {
            elementTypes.add(nextType);
            String eltypeSel = ObjSelUtils.formatSelector("eltype", nextType, vobSel);
            List<String> lines = this.ctProvider.executeGetValues(feedback, DESCRIBE, _LONG, eltypeSel);
            for (String line : lines) {
                Matcher m = SUPERTYPE_PATTERN.matcher(line);
                if (!m.find()) continue;
                nextType = m.group(1);
                result = eltypeToStandardType.get(null, nextType);
                continue block0;
            }
        }
        for (String eltype : elementTypes) {
            eltypeToStandardType.put(null, eltype, result);
        }
        return result;
    }

    private String createAndSetCQActivity(String headline, String viewTag, String streamPvobUuid, SrvcFeedback feedback) throws WvcmException {
        String recordID = this.createUCMUtilityActivityRecord(headline, feedback);
        this.setActivity(viewTag, recordID, feedback);
        String activitySelector = ObjSelUtils.formatSelector("activity", recordID, streamPvobUuid);
        return activitySelector;
    }

    private String createUCMUtilityActivityRecord(String headline, SrvcFeedback feedback) throws WvcmException {
        Map<String, String> cqArgs = this.getCQLoginInfo(feedback);
        String login = cqArgs.get(_USERNAME);
        String password = cqArgs.get(_PASSWORD);
        String dbset = cqArgs.get(_DBSET);
        String userdb = cqArgs.get(_USERDB);
        if (headline == null) {
            headline = GENERIC_HEADLINE;
        } else if (headline.trim().length() == 0) {
            headline = GENERIC_HEADLINE;
        }
        String script = this.getMkactScriptAbsolutePath();
        ArrayList<String> ratlPerlArgs = new ArrayList<String>();
        ratlPerlArgs.add(script);
        ratlPerlArgs.add(_USERNAME);
        ratlPerlArgs.add(login);
        ratlPerlArgs.add(_PASSWORD);
        ratlPerlArgs.add(password);
        ratlPerlArgs.add(_USERDB);
        ratlPerlArgs.add(userdb);
        ratlPerlArgs.add(_DBSET);
        ratlPerlArgs.add(dbset);
        ratlPerlArgs.add(_HEADLINE);
        ratlPerlArgs.add(headline);
        String recordID = this.ctProvider.executeRatlPerl(this.getPasswordFolderPath(), feedback, ratlPerlArgs);
        return recordID;
    }

    private File getInstalledScmConnectorsLocation() {
        String installLocation = CTInitArgUtils.getInstallLocation(this.ctInitArgs);
        if (installLocation == null) {
            throw new NullPointerException("InstalledScmConnectorsLocation");
        }
        return new File(installLocation, "ScmConnectors");
    }

    private String getMkactScriptAbsolutePath() {
        if (MKACT_SCRIPT == null) {
            File script = new File(this.getInstalledScmConnectorsLocation(), MKACT_SCRIPT_NAME);
            MKACT_SCRIPT = script.getAbsolutePath();
        }
        return MKACT_SCRIPT;
    }

    private String getDbidScriptAbsolutePath() {
        if (DBID_SCRIPT == null) {
            File script = new File(this.getInstalledScmConnectorsLocation(), DBID_SCRIPT_NAME);
            DBID_SCRIPT = script.getAbsolutePath();
        }
        return DBID_SCRIPT;
    }

    private String getReadCommentScriptAbsolutePath() {
        if (GET_COMMENT_SCRIPT == null) {
            File script = new File(this.getInstalledScmConnectorsLocation(), GET_COMMENT_SCRIPT_NAME);
            GET_COMMENT_SCRIPT = script.getAbsolutePath();
        }
        return GET_COMMENT_SCRIPT;
    }

    private String getWriteCommentScriptAbsolutePath() {
        if (SET_COMMENT_SCRIPT == null) {
            File script = new File(this.getInstalledScmConnectorsLocation(), SET_COMMENT_SCRIPT_NAME);
            SET_COMMENT_SCRIPT = script.getAbsolutePath();
        }
        return SET_COMMENT_SCRIPT;
    }

    private String getCQActionScriptAbsolutePath() {
        if (PERFORM_CQ_ACTION_SCRIPT == null) {
            File script = new File(this.getInstalledScmConnectorsLocation(), PERFORM_CQ_ACTION_SCRIPT_NAME);
            PERFORM_CQ_ACTION_SCRIPT = script.getAbsolutePath();
        }
        return PERFORM_CQ_ACTION_SCRIPT;
    }

    private Map<String, String> getCQLoginInfo(SrvcFeedback feedback) throws WvcmException {
        if (CQ_CREDS == null) {
            HashMap<String, String> args = new HashMap<String, String>();
            String cqLoginName = CTInitArgUtils.getCQLoginName(this.ctInitArgs);
            if (cqLoginName == null || cqLoginName.trim().equals(EMPTY_STRING)) {
                StringBuffer messageBuffer = new StringBuffer();
                messageBuffer.append(Messages.CCaseLib_INVALID_CQ_USERNAME);
                messageBuffer.append(NLS.bind((String)Messages.CommandResult_MSG_CHECK_VALUE_OF_PROVIDER_PROPERTY, (Object)CommandResult.getPropertyFriendlyName(CTInitArgUtils.getCQLoginNameKeyName())));
                throw new WvcmException(messageBuffer.toString(), WvcmException.ReasonCode.NOT_FOUND);
            }
            String dbsetName = CTInitArgUtils.getCQDbsetName(this.ctInitArgs);
            if (dbsetName == null || dbsetName.trim().equals(EMPTY_STRING)) {
                StringBuffer messageBuffer = new StringBuffer();
                messageBuffer.append(Messages.CCaseLib_INVALID_CQ_DBSET);
                messageBuffer.append(NLS.bind((String)Messages.CommandResult_MSG_CHECK_VALUE_OF_PROVIDER_PROPERTY, (Object)CommandResult.getPropertyFriendlyName(CTInitArgUtils.getCQDbsetNameKeyName())));
                throw new WvcmException(messageBuffer.toString(), WvcmException.ReasonCode.NOT_FOUND);
            }
            String userdbName = CTInitArgUtils.getCQUserdbName(this.ctInitArgs);
            if (userdbName == null || userdbName.trim().equals(EMPTY_STRING)) {
                StringBuffer messageBuffer = new StringBuffer();
                messageBuffer.append(Messages.CCaseLib_INVALID_CQ_USERDB);
                messageBuffer.append(NLS.bind((String)Messages.CommandResult_MSG_CHECK_VALUE_OF_PROVIDER_PROPERTY, (Object)CommandResult.getPropertyFriendlyName(CTInitArgUtils.getCQUserdbNameKeyName())));
                throw new WvcmException(messageBuffer.toString(), WvcmException.ReasonCode.NOT_FOUND);
            }
            Properties properties = new Properties();
            String passwordFolderPath = this.getPasswordFolderPath();
            File passwordFile = new File(passwordFolderPath, String.valueOf(cqLoginName) + CQ_PROP_FILE_EXT);
            try {
                properties.load(new FileInputStream(passwordFile));
                String password = properties.getProperty(_PASSWORD);
                if (password == null) {
                    StringBuffer messageBuffer = new StringBuffer();
                    messageBuffer.append(NLS.bind((String)Messages.CCaseLib_ERROR_CANNOT_GET_PWD_FOR_CQ_USER, (Object)cqLoginName));
                    messageBuffer.append(NLS.bind((String)Messages.CCaseLib_INVALID_CQ_PASSWORD_PROPERTY, (Object)CommonUtils.canonicalizePathname(passwordFile.getAbsolutePath())));
                    messageBuffer.append(CommandResult.computeMsgCqPasswordFile(this.getPasswordFolderPath(), cqLoginName));
                    throw new WvcmException(messageBuffer.toString(), WvcmException.ReasonCode.NOT_FOUND);
                }
                args.put(_DBSET, dbsetName);
                args.put(_USERDB, userdbName);
                args.put(_USERNAME, cqLoginName);
                args.put(_PASSWORD, password);
                ArrayList<String> crmRegisterArgs = new ArrayList<String>();
                crmRegisterArgs.add(ADD);
                crmRegisterArgs.add(_DATABASE);
                crmRegisterArgs.add(userdbName);
                crmRegisterArgs.add(_CONNECTION);
                crmRegisterArgs.add(dbsetName);
                crmRegisterArgs.add(_USERNAME);
                crmRegisterArgs.add(cqLoginName);
                crmRegisterArgs.add(_PASSWORD);
                crmRegisterArgs.add(password);
                this.ctProvider.executeCrmRegister(passwordFolderPath, feedback, crmRegisterArgs);
                CQ_CREDS = args;
            }
            catch (FileNotFoundException e) {
                StringBuffer messageBuffer = new StringBuffer();
                messageBuffer.append(NLS.bind((String)Messages.CCaseLib_ERROR_CANNOT_GET_PWD_FOR_CQ_USER, (Object)cqLoginName));
                if (passwordFile.exists() && !passwordFile.canRead()) {
                    String user = System.getProperty("user.name", "sync");
                    messageBuffer.append(NLS.bind((String)Messages.CCaseLib_NO_READ_PERMISSION_CQ_PWD_FILE, (Object)user, (Object)CommonUtils.canonicalizePathname(passwordFile.getAbsolutePath())));
                } else {
                    messageBuffer.append(NLS.bind((String)Messages.CCaseLib_MISSING_CQ_PWD_FILE, (Object)CommonUtils.canonicalizePathname(passwordFile.getAbsolutePath())));
                    messageBuffer.append(NLS.bind((String)Messages.CommandResult_MSG_CQ_PASSWORD_FILE, (Object)passwordFolderPath, (Object)cqLoginName));
                }
                throw new WvcmException(messageBuffer.toString(), WvcmException.ReasonCode.NOT_FOUND);
            }
            catch (IOException e) {
                StringBuffer messageBuffer = new StringBuffer();
                messageBuffer.append(NLS.bind((String)Messages.CCaseLib_ERROR_CANNOT_GET_PWD_FOR_CQ_USER, (Object)cqLoginName));
                messageBuffer.append(NLS.bind((String)Messages.CommandResult_MSG_CQ_PASSWORD_FILE, (Object)passwordFolderPath, (Object)cqLoginName));
                messageBuffer.append(NLS.bind((String)Messages.CCaseLib_ERROR_READING_PROPERTIES_FILE, (Object)cqLoginName));
                throw new WvcmException(messageBuffer.toString(), WvcmException.ReasonCode.READ_FAILED);
            }
        }
        return CQ_CREDS;
    }

    private String getPasswordFolderPath() {
        return CTInitArgUtils.getStreamScriptDirectory(this.ctInitArgs);
    }

    public String getQueryStringForCQResource(String activitySelector, SrvcFeedback feedback) throws WvcmException {
        String queryString = this.queryStringForActivity.get(null, activitySelector);
        if (queryString == null) {
            Map<String, String> pvarMap = this.getCQPvarForActivity(activitySelector, feedback);
            Map<String, String> cqArgs = this.getCQLoginInfo(feedback);
            if (!pvarMap.isEmpty() && !cqArgs.isEmpty()) {
                String recordType = pvarMap.get(RECORD_TYPE_KEY);
                String recordID = pvarMap.get(RECORD_ID_KEY);
                String dbset = cqArgs.get(_DBSET).replaceAll(DOUBLE_QUOTE, new String());
                String userdb = cqArgs.get(_USERDB).replaceAll(DOUBLE_QUOTE, new String());
                String dbid = this.getRecordDbid(cqArgs, recordType, recordID, feedback);
                queryString = QUERY_PREFIX + recordType + CommonUtils.FWDSLASH + dbid + '@' + dbset + CommonUtils.FWDSLASH + userdb;
                try {
                    queryString = URLEncoder.encode(queryString, UTF_8);
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException("Unexpected UnsupportedEncodingException encoding characters with UTF-8");
                }
                this.queryStringForActivity.put(null, activitySelector, queryString);
            } else {
                throw new WvcmException(NLS.bind((String)Messages.CCaseLib_MISSING_CQ_QUERY_ERROR, (Object)activitySelector), WvcmException.ReasonCode.FORBIDDEN);
            }
        }
        return queryString;
    }

    private Map<String, String> getCQPvarForActivity(String activitySelector, SrvcFeedback feedback) throws WvcmException {
        String pvar = this.ucmActivityPvar.get(null, activitySelector);
        if (pvar == null) {
            pvar = this.ctProvider.execute(feedback, DESCRIBE, _FMT, "%[crm_record_type]p|%[crm_record_id]p", activitySelector);
            this.ucmActivityPvar.put(null, activitySelector, pvar);
        }
        StringTokenizer tokens = new StringTokenizer(pvar, FMT_BAR);
        HashMap<String, String> pvarMap = new HashMap<String, String>();
        if (tokens.countTokens() >= 2) {
            String recordType = tokens.nextToken();
            String recordID = tokens.nextToken();
            pvarMap.put(RECORD_TYPE_KEY, recordType);
            pvarMap.put(RECORD_ID_KEY, recordID);
        }
        return pvarMap;
    }

    private String getRecordDbid(Map<String, String> cqArgs, String recordType, String recordID, SrvcFeedback feedback) throws WvcmException {
        String dbid = this.recordDbids.get(recordType, recordID);
        if (dbid == null) {
            String login = cqArgs.get(_USERNAME);
            String password = cqArgs.get(_PASSWORD);
            String dbset = cqArgs.get(_DBSET);
            String userdb = cqArgs.get(_USERDB);
            String script = this.getDbidScriptAbsolutePath();
            ArrayList<String> ratlPerlArgs = new ArrayList<String>();
            ratlPerlArgs.add(script);
            ratlPerlArgs.add(_USERNAME);
            ratlPerlArgs.add(login);
            ratlPerlArgs.add(_PASSWORD);
            ratlPerlArgs.add(password);
            ratlPerlArgs.add(_USERDB);
            ratlPerlArgs.add(userdb);
            ratlPerlArgs.add(_DBSET);
            ratlPerlArgs.add(dbset);
            ratlPerlArgs.add(_TYPE);
            ratlPerlArgs.add(recordType);
            ratlPerlArgs.add(_ID);
            ratlPerlArgs.add(recordID);
            dbid = this.ctProvider.executeRatlPerl(this.getPasswordFolderPath(), feedback, ratlPerlArgs);
            this.recordDbids.put(recordType, recordID, dbid);
        }
        return dbid;
    }

    public String getCQActivityComment(String activitySelector, SrvcFeedback feedback) throws WvcmException {
        Map<String, String> pvarMap = this.getCQPvarForActivity(activitySelector, feedback);
        String recordType = pvarMap.get(RECORD_TYPE_KEY);
        String recordId = pvarMap.get(RECORD_ID_KEY);
        Map<String, String> cqArgs = this.getCQLoginInfo(feedback);
        String login = cqArgs.get(_USERNAME);
        String password = cqArgs.get(_PASSWORD);
        String dbset = cqArgs.get(_DBSET);
        String userdb = cqArgs.get(_USERDB);
        String script = this.getReadCommentScriptAbsolutePath();
        ArrayList<String> ratlPerlArgs = new ArrayList<String>();
        ratlPerlArgs.add(script);
        ratlPerlArgs.add(_USERNAME);
        ratlPerlArgs.add(login);
        ratlPerlArgs.add(_PASSWORD);
        ratlPerlArgs.add(password);
        ratlPerlArgs.add(_USERDB);
        ratlPerlArgs.add(userdb);
        ratlPerlArgs.add(_DBSET);
        ratlPerlArgs.add(dbset);
        ratlPerlArgs.add(_TYPE);
        ratlPerlArgs.add(recordType);
        ratlPerlArgs.add(_ID);
        ratlPerlArgs.add(recordId);
        String comment = this.ctProvider.executeRatlPerl(this.getPasswordFolderPath(), feedback, ratlPerlArgs);
        return comment;
    }

    public void setCQActivityComment(String activitySelector, String comment, SrvcFeedback feedback) throws WvcmException {
        Map<String, String> pvarMap = this.getCQPvarForActivity(activitySelector, feedback);
        String recordType = pvarMap.get(RECORD_TYPE_KEY);
        String recordId = pvarMap.get(RECORD_ID_KEY);
        Map<String, String> cqArgs = this.getCQLoginInfo(feedback);
        String login = cqArgs.get(_USERNAME);
        String password = cqArgs.get(_PASSWORD);
        String dbset = cqArgs.get(_DBSET);
        String userdb = cqArgs.get(_USERDB);
        String script = this.getWriteCommentScriptAbsolutePath();
        ArrayList<String> ratlPerlArgs = new ArrayList<String>();
        ratlPerlArgs.add(script);
        ratlPerlArgs.add(_USERNAME);
        ratlPerlArgs.add(login);
        ratlPerlArgs.add(_PASSWORD);
        ratlPerlArgs.add(password);
        ratlPerlArgs.add(_USERDB);
        ratlPerlArgs.add(userdb);
        ratlPerlArgs.add(_DBSET);
        ratlPerlArgs.add(dbset);
        ratlPerlArgs.add(_TYPE);
        ratlPerlArgs.add(recordType);
        ratlPerlArgs.add(_ID);
        ratlPerlArgs.add(recordId);
        ratlPerlArgs.add(_COMMENT);
        ratlPerlArgs.add(comment);
        this.ctProvider.executeRatlPerl(this.getPasswordFolderPath(), feedback, ratlPerlArgs);
    }

    void fixInvisibleElementPaths(String viewTag, String oldVersPathname, String newPathname, String newParentPathname, SrvcFeedback feedback) throws WvcmException {
        String vobTag = this.getVobTagFromGpath(oldVersPathname, feedback);
        String delimiter = this.getMainBranchName(vobTag, feedback);
        InvisiblePathname invisiblePathname = new InvisiblePathname(oldVersPathname, delimiter);
        Stack<TempVisiblePath> stack = new Stack<TempVisiblePath>();
        while (invisiblePathname.hasDescendant()) {
            boolean visible;
            String oldBase = invisiblePathname.originalPathname();
            String parent = invisiblePathname.parentPathname();
            List<String> args = Arrays.asList(DESCRIBE, _FMT, FMT_EN, oldBase);
            CommandResult r = this.ctProvider.executeGetResult(feedback, args);
            boolean bl = visible = r.getStat() == 0 && !r.getStdOut().contains(AT_AT);
            if (!visible || invisiblePathname.isLast()) {
                boolean isCheckedOut = this.isCheckedout(parent, feedback);
                if (!isCheckedOut) {
                    this.checkout(parent, feedback);
                }
                if (!visible) {
                    invisiblePathname.assignUniqueLeafName();
                    String base = invisiblePathname.visiblePathname();
                    this.link(oldBase, base, feedback);
                }
                if (!isCheckedOut || !invisiblePathname.isLast()) {
                    stack.push(new TempVisiblePath(viewTag, parent, invisiblePathname.leafName(), isCheckedOut || parent.equals(newParentPathname)));
                }
            }
            invisiblePathname.makeChildVisible();
        }
        this.moveName(invisiblePathname.parentPathname(), newPathname, feedback);
        while (!stack.isEmpty()) {
            TempVisiblePath path = (TempVisiblePath)stack.pop();
            path.restore(delimiter, feedback);
        }
    }

    private void removeBranch(String branchName, SrvcFeedback feedback) throws WvcmException {
        this.ctProvider.execute(feedback, RMBRANCH, _NC, _FORCE, branchName);
    }

    public boolean isCheckedout(String pathname, SrvcFeedback feedback) throws WvcmException {
        boolean checkout = false;
        String status = this.ctProvider.execute(feedback, DESCRIBE, _FMT, FMT_CO, pathname);
        if (status != null && status.contains("reserved")) {
            checkout = true;
        }
        return checkout;
    }

    public void performCQActionOnUCMRecord(String activitySelector, SrvcFeedback feedback) throws WvcmException {
        String newAction = CTInitArgUtils.getCQUCMRecordAction(this.ctInitArgs).trim();
        if (!newAction.equals("")) {
            Map<String, String> pvarMap = this.getCQPvarForActivity(activitySelector, feedback);
            String recordType = pvarMap.get(RECORD_TYPE_KEY);
            String recordId = pvarMap.get(RECORD_ID_KEY);
            Map<String, String> cqArgs = this.getCQLoginInfo(feedback);
            String login = cqArgs.get(_USERNAME);
            String password = cqArgs.get(_PASSWORD);
            String dbset = cqArgs.get(_DBSET);
            String userdb = cqArgs.get(_USERDB);
            String script = this.getCQActionScriptAbsolutePath();
            ArrayList<String> ratlPerlArgs = new ArrayList<String>();
            ratlPerlArgs.add(script);
            ratlPerlArgs.add(_USERNAME);
            ratlPerlArgs.add(login);
            ratlPerlArgs.add(_PASSWORD);
            ratlPerlArgs.add(password);
            ratlPerlArgs.add(_USERDB);
            ratlPerlArgs.add(userdb);
            ratlPerlArgs.add(_DBSET);
            ratlPerlArgs.add(dbset);
            ratlPerlArgs.add(_TYPE);
            ratlPerlArgs.add(recordType);
            ratlPerlArgs.add(_ID);
            ratlPerlArgs.add(recordId);
            ratlPerlArgs.add(_ACTION);
            ratlPerlArgs.add(newAction);
            this.ctProvider.executeRatlPerl(this.getPasswordFolderPath(), feedback, ratlPerlArgs);
        }
    }

    public boolean isVOBUCMEnabledFromGPath(String gpath, SrvcFeedback feedback) throws WvcmException {
        String vobTag = this.getVobTagFromGpath(gpath, feedback);
        Boolean ret = this.cachedIsVOBUCM.get(vobTag);
        if (ret != null) {
            return ret;
        }
        String viewTag = ObjSelUtils.getViewTag(mvfsRoot, gpath);
        String vobPath = String.valueOf(CCaseLib.getPathIntoView(viewTag)) + vobTag;
        boolean enabled = false;
        String vobCompCrde = this.lookupComponentCRDE(vobPath, feedback);
        if (vobCompCrde != null) {
            enabled = true;
        } else {
            Map<String, String> children = this.getCCDirectory(vobPath, feedback);
            for (String child : children.keySet()) {
                String childPath;
                String compCrde;
                String mtype = children.get(child);
                if (!mtype.equals("2") || (compCrde = this.lookupComponentCRDE(childPath = String.valueOf(vobPath) + CommonUtils.FWDSLASH + child, feedback)) == null) continue;
                enabled = true;
                break;
            }
        }
        this.cachedIsVOBUCM.put(vobTag, enabled);
        return enabled;
    }

    public String lookupComponentCRDE(String gpath, SrvcFeedback feedback) throws WvcmException {
        String crdeDBID = null;
        String elemGpath = gpath.endsWith(AT_AT) ? gpath : this.getElemPathName(gpath, feedback);
        List<String> lines = this.ctProvider.executeGetValues(feedback, DUMP, elemGpath);
        for (String string : lines) {
            Matcher m = CRDE_PATTERN.matcher(string);
            if (!m.find()) continue;
            crdeDBID = m.replaceFirst("$1");
            break;
        }
        return crdeDBID;
    }

    public String getComponentRootDir(String compSelector, SrvcFeedback feedback) throws WvcmException {
        return this.ctProvider.execute(feedback, DESCRIBE, _FMT, FMT_ROOT_DIR, compSelector);
    }

    public void rebaseStream(String viewTag, String streamSelector, String blSel, SrvcFeedback feedback) throws WvcmException {
        this.rebaseStream(viewTag, streamSelector, blSel, null, true, feedback);
    }

    public String rebaseStreamComp(String viewTag, String streamSelector, String compSel, SrvcFeedback feedback) throws WvcmException {
        return this.rebaseStream(viewTag, streamSelector, null, compSel, true, feedback);
    }

    public String rebaseStream(String viewTag, String streamSelector, String blSel, String compSel, boolean complete, SrvcFeedback feedback) throws WvcmException {
        CommandResult r;
        if (blSel == null || blSel.equals(EMPTY_STRING)) {
            if (compSel == null || compSel.equals(EMPTY_STRING)) {
                throw new IllegalArgumentException(String.format("Illegal baseline set for rebasing stream %s", streamSelector));
            }
            blSel = this.getInitialBaseline(compSel, feedback);
        }
        boolean viewCreated = false;
        if (viewTag == null) {
            viewTag = this.makeViewOnStream(streamSelector, feedback);
            viewCreated = true;
        }
        ArrayList<String> rebaseArgs = new ArrayList<String>(Arrays.asList(REBASE, _VIEW, viewTag, _STREAM, streamSelector, _BASELINE, blSel));
        if (complete) {
            rebaseArgs.add(_COMPLETE);
        }
        if ((r = this.ctProvider.executeGetResult(feedback, rebaseArgs)).getStdErr().contains("is not attached to stream")) {
            viewTag = this.makeViewOnStream(streamSelector, feedback);
            viewCreated = true;
            this.rebaseStream(viewTag, streamSelector, blSel, feedback);
        } else if (r.getStdErr().contains("because it is not from the parent stream,\nin the parent's stream foundation, from the same project or delivered to the\nparent stream.")) {
            String parentStream;
            String parentViewTag;
            String newBlSel;
            String intStream = this.getIntStreamOfStream(streamSelector, feedback);
            if (ObjSelUtils.isUniversalSelector(streamSelector)) {
                streamSelector = this.getExtendedName(viewTag, streamSelector, feedback);
            }
            if (streamSelector.equals(intStream)) {
                r.assertSuccess(IGNORE_NoViewInfo);
            }
            if (!blSel.equals(newBlSel = this.rebaseStream(parentViewTag = this.makeViewOnStream(parentStream = this.getParentStream(streamSelector, feedback), feedback), parentStream, blSel, compSel, true, feedback))) {
                feedback.notifyWarning(feedback.format(Messages.CCaseLib_WARNING_REBASE_TO_NON_INITIAL, new Object[]{parentStream, newBlSel, streamSelector}));
                blSel = newBlSel;
            }
            this.rebaseStream(viewTag, streamSelector, blSel, feedback);
            this.removeView(parentViewTag, feedback);
        } else if (compSel != null && !compSel.equals(EMPTY_STRING) && (r.getStdErr().contains("Can't switch to baseline") || r.getStdErr().contains("Can't revert to earlier baseline"))) {
            blSel = this.getFoundationBaselines(streamSelector, true, feedback).get(compSel);
        } else {
            r.assertSuccess(IGNORE_NoViewInfo);
        }
        if (viewCreated) {
            this.removeView(viewTag, feedback);
        }
        return blSel;
    }

    private String getIntStreamOfStream(String streamSel, SrvcFeedback feedback) throws WvcmException {
        String intStream = this.intstreamByStream.get(null, streamSel);
        if (intStream == null) {
            String projectSel = this.getProjectObjectSelector(streamSel, feedback);
            intStream = this.getIntStreamOfProject(projectSel, feedback);
            this.intstreamByStream.put(null, streamSel, intStream);
        }
        return intStream;
    }

    private String getIntStreamOfProject(String projectSel, SrvcFeedback feedback) throws WvcmException {
        String intStream = this.intstreamByProject.get(null, projectSel);
        if (intStream == null && (intStream = this.ctProvider.execute(feedback, DESCRIBE, _FMT, FMT_ISSTREAM_CXP, projectSel)) != null) {
            this.intstreamByProject.put(null, projectSel, intStream);
        }
        return intStream;
    }

    public String makeViewOnStream(String streamSelector, SrvcFeedback feedback) throws WvcmException {
        String viewTag = this.makeView("temp_view", this.getExtendedName(null, streamSelector, feedback), feedback);
        return viewTag;
    }

    public boolean isBaseCCView(String viewTag, SrvcFeedback feedback) throws WvcmException {
        boolean returnValue = false;
        if (this.isBaseCCView.contains(viewTag)) {
            returnValue = true;
        }
        if (!returnValue && !this.isUCMView.contains(viewTag)) {
            String stream = this.getViewStream(viewTag, feedback);
            if (stream != null) {
                this.isUCMView.add(viewTag);
            } else {
                returnValue = true;
                this.isBaseCCView.add(viewTag);
            }
        }
        return returnValue;
    }

    private String getViewStream(String viewTag, SrvcFeedback feedback) throws WvcmException {
        CommandResult r = this.ctProvider.executeGetResult(feedback, LSSTREAM, _SHORT, _VIEW, viewTag);
        int stat = r.getStat();
        String stdout = r.getStdOut();
        String stderr = r.getStdErr();
        if (stat == 1 && (stderr == null || stderr.isEmpty()) && (stdout == null || stdout.isEmpty())) {
            return null;
        }
        r.assertSuccess(IGNORE_NotFound_NoViewInfo);
        String result = stdout == null || stdout.isEmpty() ? null : stdout;
        return result;
    }

    void setCheckoutVOBList(String objSel, String pathname, SrvcFeedback feedback) throws WvcmException {
        String myPath = CommonUtils.canonicalizePathname(pathname);
        List<String> vobList = checkoutVobs.get(objSel);
        if (vobList != null) {
            String viewTag = ObjSelUtils.getViewTag(mvfsRoot, myPath);
            String viewPath = CCaseLib.getPathIntoView(viewTag);
            String myRelativePath = myPath.substring(viewPath.length());
            for (String path : vobList) {
                String storedPath = CommonUtils.canonicalizePathname(path);
                if (!myRelativePath.startsWith(String.valueOf(storedPath) + CommonUtils.FWDSLASH)) continue;
                return;
            }
        } else {
            vobList = new ArrayList<String>();
        }
        String vobPath = this.getVobTagFromGpath(myPath, feedback);
        vobList.add(vobPath);
        checkoutVobs.put(objSel, vobList);
        String vobSelector = this.getVobSelector(vobPath, feedback);
        String coVobs = this.getAttr(COVOB_ATTR, objSel, feedback);
        if (coVobs != null) {
            if (!coVobs.contains(vobSelector)) {
                coVobs = String.valueOf(coVobs) + CTLocation.INFO_SEPARATOR_STRING + vobSelector;
                this.setAttr(COVOB_ATTR, objSel, coVobs, true, feedback);
            }
        } else {
            this.setAttr(COVOB_ATTR, objSel, vobSelector, false, feedback);
        }
    }

    void clearCheckoutVOBPathList(String objSel, SrvcFeedback feedback) throws WvcmException {
        try {
            this.rmAttrIgnoreExpectedFailures(COVOB_ATTR, objSel, feedback);
        }
        catch (WvcmException wvcmException) {
            // empty catch block
        }
        if (checkoutVobs.containsKey(objSel)) {
            checkoutVobs.remove(objSel);
        }
    }

    List<String> getCheckoutVobPathList(String objSel, SrvcFeedback feedback) throws WvcmException {
        String coVobs = this.getAttr(COVOB_ATTR, objSel, feedback);
        ArrayList<String> coVobPaths = new ArrayList<String>();
        if (coVobs != null) {
            String[] oidsArray;
            String[] stringArray = oidsArray = coVobs.split(CTLocation.INFO_SEPARATOR_REGEX);
            int n = oidsArray.length;
            int n2 = 0;
            while (n2 < n) {
                String oidSelector = stringArray[n2];
                String familyUUID = ObjSelUtils.getObjSelName(oidSelector);
                coVobPaths.add(String.valueOf('.') + this.computeVobTagFromVobFamilyUuid(familyUUID, feedback));
                ++n2;
            }
        }
        return coVobPaths;
    }

    public void setExecutePermission(String elementPath, boolean permission, SrvcFeedback feedback) throws WvcmException {
        ArrayList<String> cleartoolArgs = new ArrayList<String>();
        cleartoolArgs.add(PROTECT);
        cleartoolArgs.add(_CHMOD);
        if (permission) {
            cleartoolArgs.add(PLUS_X);
        } else {
            cleartoolArgs.add(MINUS_X);
        }
        cleartoolArgs.add(elementPath);
        CommandResult r = this.ctProvider.executeGetResult(feedback, cleartoolArgs);
        String stdErr = r.getStdErr();
        if (!stdErr.contains("cleartool: Error: Not a vob object")) {
            r.assertSuccess(IGNORE_Nothing);
        }
    }

    public static boolean isExecutable(String perms) {
        ArrayList<Character> permList = new ArrayList<Character>();
        int i = 0;
        while (i < perms.length()) {
            permList.add(Character.valueOf(perms.charAt(i)));
            ++i;
        }
        permList.retainAll(executableValues);
        return !permList.isEmpty();
    }

    public String getAdminVobTagForTests(String vobTag, SrvcFeedback feedback) throws WvcmException {
        String objSel = ObjSelUtils.formatSelector("vob", vobTag);
        List<String> hLinks = this.getHyperlinkEnds(true, ADMIN_VOB, objSel, feedback);
        String result = hLinks.size() > 0 ? ObjSelUtils.getObjSelName(hLinks.get(0)) : vobTag;
        return result;
    }

    public boolean isCasePreservingMVFS(SrvcFeedback feedback) throws WvcmException {
        boolean casePreserving;
        block10: {
            casePreserving = false;
            if (!CommandProvider.IS_WINDOWS) {
                casePreserving = true;
            } else {
                try {
                    File[] logFiles;
                    File printedLogFile;
                    File parent;
                    List<String> logLines = this.ctProvider.executeMvfsLog(feedback);
                    String logFileName = null;
                    for (String logEntry : logLines) {
                        Matcher m = LOGFILE_PATTERN.matcher(logEntry);
                        if (!m.find()) continue;
                        logFileName = m.group(1);
                        break;
                    }
                    if (logFileName == null || !(parent = new File((printedLogFile = new File(logFileName)).getParent())).exists()) break block10;
                    File[] fileArray = logFiles = CCaseLib.getFilesByLastModifiedDate(parent);
                    int n = logFiles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line;
                        File logFile = fileArray[n2];
                        BufferedReader reader = new BufferedReader(new FileReader(logFile));
                        while ((line = reader.readLine()) != null) {
                            if (line.contains(MVFS_CASE_PRESERVING_MODE)) {
                                casePreserving = true;
                            } else if (!line.contains(MVFS_DOWNCASING_MODE)) {
                                continue;
                            }
                            break block10;
                        }
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return casePreserving;
    }

    private static File[] getFilesByLastModifiedDate(File dir) {
        File[] logFiles = dir.listFiles();
        Arrays.sort(logFiles, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                return (int)(f2.lastModified() - f1.lastModified());
            }
        });
        return logFiles;
    }

    public List<String> listDirectoryTree(String pathName, SrvcFeedback feedback) throws WvcmException {
        return CCaseLib.removeLostAndFoundEntries(this.directoryTreeHelper(pathName, true, feedback));
    }

    public static List<String> removeLostAndFoundEntries(List<String> entries) {
        ArrayList<String> results = new ArrayList<String>();
        for (String entry : entries) {
            boolean matches = entry.matches(lAndFPattern);
            if (matches) continue;
            results.add(entry);
        }
        return results;
    }

    public List<String> getInitialFoundationBaselines(String streamSelector, SrvcFeedback feedback) throws WvcmException {
        String mtype = null;
        boolean timelineStarted = false;
        ArrayList<Integer> timelines = new ArrayList<Integer>();
        List<String> lines = this.ctProvider.executeGetValues(feedback, DUMP, streamSelector);
        for (String string : lines) {
            Object m;
            if (mtype == null) {
                m = MTYPE_STREAM_PATTERN.matcher(string);
                if (!((Matcher)m).find()) continue;
                mtype = ((Matcher)m).group(1);
                continue;
            }
            if (!timelineStarted) {
                if (FLEVEL7_MTYPE.equals(mtype)) {
                    timelineStarted = string.startsWith(TIMELINES_HEADER);
                    continue;
                }
                timelineStarted = string.startsWith(CHILD_ACTIVITIES_HEADER);
                continue;
            }
            if (string.contains(CommonUtils.COLON)) break;
            m = DBID_PATTERN.matcher(string);
            if (!((Matcher)m).find()) continue;
            timelines.add(Integer.parseInt(((Matcher)m).group(1)));
        }
        String vobSel = ObjSelUtils.getObjSelVobSel(streamSelector);
        if (!FLEVEL7_MTYPE.equals(mtype)) {
            if (timelines.size() < 3) {
                lines.clear();
            } else {
                lines = this.ctProvider.executeGetValues(feedback, DUMP, ObjSelUtils.formatSelector("dbid", Integer.toString((Integer)timelines.get(2)), vobSel));
            }
            timelines.clear();
            timelineStarted = false;
            for (String string : lines) {
                if (!timelineStarted) {
                    timelineStarted = string.startsWith(CHILD_ACTIVITIES_HEADER);
                    continue;
                }
                if (string.contains(CommonUtils.COLON)) break;
                Matcher m = DBID_PATTERN.matcher(string);
                if (!m.find()) continue;
                timelines.add(Integer.parseInt(m.group(1)));
            }
        }
        ArrayList<String> baselines = new ArrayList<String>();
        for (Integer timeline : timelines) {
            lines = this.ctProvider.executeGetValues(feedback, DESCRIBE, _FMT, FMT_HLINK_FOUNDATION_P, ObjSelUtils.formatSelector("dbid", Integer.toString(timeline), vobSel));
            Matcher m = FOUNDATION_BL_PATTERN.matcher(lines.get(0));
            if (!m.find()) continue;
            baselines.add(m.group(1));
        }
        return baselines;
    }

    public String getInitialFoundationBaseline(String streamSelector, String componentSelector, SrvcFeedback feedback) throws WvcmException {
        Map<String, String> componentToBaselineMap;
        String baseline = null;
        if (ObjSelUtils.isUniversalSelector(componentSelector)) {
            componentSelector = this.getExtendedName(null, componentSelector, feedback);
        }
        if ((componentToBaselineMap = this.streamInitialFoundationMap.get(streamSelector)) == null) {
            List<String> baselines = this.getInitialFoundationBaselines(streamSelector, feedback);
            componentToBaselineMap = this.getComponentToBaselineMap(baselines, true, feedback);
            this.streamInitialFoundationMap.put(streamSelector, componentToBaselineMap);
        }
        if ((baseline = componentToBaselineMap.get(componentSelector)) == null) {
            baseline = this.getBaselineInFoundation(null, streamSelector, componentSelector, feedback);
        }
        return baseline;
    }

    public List<String> getAllBaselines(String streamSelector, String componentSelector, SrvcFeedback feedback) throws WvcmException {
        List<String> allBaselines = null;
        String originalComponentSelector = componentSelector;
        if (ObjSelUtils.isUniversalSelector(componentSelector)) {
            componentSelector = this.getExtendedName(null, componentSelector, feedback);
        }
        if (allBaselines == null) {
            ArrayList<String> cleartoolArgs = new ArrayList<String>(Arrays.asList(LSBL, _FMT));
            StringBuffer formatOptions = new StringBuffer();
            formatOptions.append(FMT_XN);
            formatOptions.append(FMT_BAR).append(FMT_LABEL_STATUS_P);
            String attribute = null;
            PropertyRequestItem.PropertyRequest pr = feedback.getPropertyRequestForResult();
            if (pr != null) {
                Map prMap = pr.toMap();
                for (PropertyNameList.PropertyName propertyName : prMap.keySet()) {
                    if (!"com.ibm.team.importer".equals(propertyName.getNamespace()) || (attribute = propertyName.getName()) == null || attribute.equals(EMPTY_STRING)) continue;
                    String attributeSelector = attribute;
                    if (!ObjSelUtils.isFullyQualifiedSelector(attributeSelector)) {
                        attributeSelector = ObjSelUtils.formatSelector("attype", attributeSelector);
                    }
                    try {
                        this.validateAndLockType(attributeSelector, false, feedback);
                    }
                    catch (WvcmException e) {
                        throw new WvcmException(NLS.bind((String)Messages.CCaseLib_ERROR_INVALID_ATTRIBUTE, (Object)attributeSelector), WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
                    }
                    formatOptions.append(FMT_ATTRIBUTE_PREFIX);
                    String attributeName = ObjSelUtils.getObjSelName(attributeSelector);
                    formatOptions.append(attributeName);
                    formatOptions.append(FMT_ATTRIBUTE_SUFFIX);
                    break;
                }
            }
            formatOptions.append(FMT_NEWLINE);
            cleartoolArgs.add(formatOptions.toString());
            cleartoolArgs.add(_STREAM);
            cleartoolArgs.add(streamSelector);
            cleartoolArgs.add(_COMPONENT);
            cleartoolArgs.add(componentSelector);
            allBaselines = this.ctProvider.executeGetValues(feedback, cleartoolArgs);
            ArrayList<String> newAllBaselinesList = new ArrayList<String>(allBaselines.size());
            ArrayList<String> baselinesWithAttribute = new ArrayList<String>();
            for (String baseline : allBaselines) {
                String[] baselineAttribute = baseline.split(LITERAL_VERTICAL_BAR_PATTERN);
                if (baselineAttribute.length >= 2) {
                    if (baselineAttribute[1].equals(NOT_LABELED)) continue;
                    newAllBaselinesList.add(baselineAttribute[0]);
                    if (baselineAttribute.length != 3) continue;
                    baselinesWithAttribute.add(String.valueOf(baselineAttribute[0]) + FMT_BAR + baselineAttribute[2]);
                    continue;
                }
                StringBuffer exceptionMessage = new StringBuffer(String.format("Baseline output contains no tokens separated by '|'.\nExpected atleast 2 tokens in the output.\nParsed line:\n%s\n", "Stream:\n%s\n", "Component:\n%s\n", baseline, streamSelector, componentSelector));
                throw new IllegalStateException(exceptionMessage.toString());
            }
            allBaselines = newAllBaselinesList;
            if (attribute != null) {
                if (this.allObjectsWithAttribute.containsKey(attribute)) {
                    List<String> existingBaselinesWithAttribute = this.allObjectsWithAttribute.get(attribute);
                    existingBaselinesWithAttribute.addAll(baselinesWithAttribute);
                    this.allObjectsWithAttribute.put(attribute, existingBaselinesWithAttribute);
                } else {
                    this.allObjectsWithAttribute.put(attribute, baselinesWithAttribute);
                }
            }
            this.allBaselinesForStreamByComponent.put(String.valueOf(streamSelector) + originalComponentSelector, allBaselines);
        }
        return allBaselines;
    }

    public String getAttribute(String ObjectDesc, String attribute, SrvcFeedback feedback) throws WvcmException {
        String val = null;
        if (this.allObjectsWithAttribute.containsKey(attribute)) {
            List<String> allObjects = this.allObjectsWithAttribute.get(attribute);
            for (String objectWithAttribute : allObjects) {
                String[] objectAttribute = CCaseLib.getObjInfoTokens(objectWithAttribute, 2);
                if (!objectAttribute[0].equals(ObjectDesc)) continue;
                val = objectAttribute[1];
                break;
            }
        } else {
            String attributeSelector = attribute;
            if (!ObjSelUtils.isFullyQualifiedSelector(attributeSelector)) {
                attributeSelector = ObjSelUtils.formatSelector("attype", attributeSelector);
            }
            val = this.getAttr(ObjSelUtils.getObjSelName(attributeSelector), ObjectDesc, feedback);
        }
        val = this.unquote(val);
        return val;
    }

    public String unquote(String val) {
        if (val != null && val.length() > 1 && val.startsWith(DOUBLE_QUOTE) && val.endsWith(DOUBLE_QUOTE)) {
            val = val.substring(1, val.length() - 1);
        }
        return val;
    }

    public Map<String, String> getFoundationBaselines(String streamSelector, boolean recurse, SrvcFeedback feedback) throws WvcmException {
        List<String> bls = this.ctProvider.executeGetValues(feedback, DESCRIBE, _FMT, FMT_FOUND_BLS_CXP, streamSelector);
        return this.getComponentToBaselineMap(bls, recurse, feedback);
    }

    private Map<String, String> getComponentToBaselineMap(List<String> bls, boolean recurse, SrvcFeedback feedback) throws WvcmException {
        HashMap<String, String> componentBaselineMap = new HashMap<String, String>();
        if (bls.size() > 0) {
            bls = CommandResult.splitStdOutList(bls);
            List<String> componentList = this.getComponents(bls, true, feedback);
            Iterator<String> componentIterator = componentList.iterator();
            for (String baseline : bls) {
                String component = componentIterator.next();
                componentBaselineMap.put(component, baseline);
            }
            if (recurse) {
                List<String> memberBls = this.getMemberBaselines(bls, feedback);
                List<String> memberComponentList = this.getComponents(memberBls, true, feedback);
                Iterator<String> memberComponentIterator = memberComponentList.iterator();
                for (String member : memberBls) {
                    String component = memberComponentIterator.next();
                    if (componentBaselineMap.containsKey(component)) continue;
                    componentBaselineMap.put(component, member);
                }
            }
        }
        return componentBaselineMap;
    }

    public String getPredecessorBaseline(String baselineSelector, SrvcFeedback feedback) throws WvcmException {
        String baseline = this.ctProvider.execute(feedback, DESCRIBE, _FMT, FMT_PREDECESSOR_XP, baselineSelector);
        return ObjSelUtils.formatSelector("baseline", baseline);
    }

    public String getBaselineInFoundation(String viewTag, String streamSelector, String componentSelector, SrvcFeedback feedback) throws WvcmException {
        if (ObjSelUtils.isUniversalSelector(componentSelector)) {
            componentSelector = this.getExtendedName(viewTag, componentSelector, feedback);
        }
        Map<Object, Object> componentFoundBlsMap = new HashMap();
        if (this.streamFoundationMap.containsKey(streamSelector)) {
            componentFoundBlsMap = this.streamFoundationMap.get(streamSelector);
        } else {
            componentFoundBlsMap = this.getFoundationBaselines(streamSelector, true, feedback);
            this.streamFoundationMap.put(streamSelector, componentFoundBlsMap);
        }
        String foundation = (String)componentFoundBlsMap.get(componentSelector);
        return foundation;
    }

    public List<String> getMemberBaselines(List<String> bls, SrvcFeedback feedback) throws WvcmException {
        ArrayList<String> memberBaselines = new ArrayList<String>();
        ArrayList<String> cleartoolArgs = new ArrayList<String>(Arrays.asList(DESCRIBE, _FMT, FMT_DEPENDS_ON_CLOSURE_CXP_NEWLINE));
        ArrayList<String> baselinesAdded = new ArrayList<String>();
        for (String bl : bls) {
            if (this.baselineMemberMap.containsKey(bl)) {
                List<String> members = this.baselineMemberMap.get(bl);
                memberBaselines.addAll(members);
                continue;
            }
            cleartoolArgs.add(bl);
            baselinesAdded.add(bl);
        }
        if (!baselinesAdded.isEmpty()) {
            CommandResult r = this.ctProvider.executeGetResult(feedback, cleartoolArgs);
            List<String> output = r.getStdOutList();
            Iterator<String> outputIter = output.iterator();
            Iterator baselineIter = baselinesAdded.iterator();
            while (outputIter.hasNext() && baselineIter.hasNext()) {
                String members = outputIter.next();
                String interestingBaseline = (String)baselineIter.next();
                List<String> baselines = CommandResult.splitStdOutList(Collections.singletonList(members));
                ArrayList<String> actualBaselines = new ArrayList<String>();
                for (String baseline : baselines) {
                    if (baseline.equals(EMPTY_STRING)) continue;
                    String fqBaseline = baseline;
                    if (!ObjSelUtils.isFullyQualifiedSelector(baseline)) {
                        fqBaseline = ObjSelUtils.formatSelector("baseline", baseline);
                    }
                    memberBaselines.add(fqBaseline);
                    actualBaselines.add(fqBaseline);
                }
                this.baselineMemberMap.put(interestingBaseline, actualBaselines);
            }
        }
        return memberBaselines;
    }

    public List<String> getAllLabelTypes(String vobtag, String baseCcSubVobCompName, List<String> allbaseCcSubVobCompNames, SrvcFeedback feedback) throws WvcmException {
        List<String> allLabelTypes = null;
        ArrayList<String> cleartoolArgs = new ArrayList<String>(Arrays.asList(LSTYPE, _KIND, "lbtype", _FMT));
        StringBuffer formatOptions = new StringBuffer(FMT_XN);
        String attribute = null;
        PropertyRequestItem.PropertyRequest pr = feedback.getPropertyRequestForResult();
        if (pr != null) {
            Map prMap = pr.toMap();
            for (PropertyNameList.PropertyName propertyName : prMap.keySet()) {
                if (!"com.ibm.team.importer".equals(propertyName.getNamespace()) || (attribute = propertyName.getName()) == null || attribute.equals(EMPTY_STRING)) continue;
                String attributeSelector = attribute;
                if (!ObjSelUtils.isFullyQualifiedSelector(attributeSelector)) {
                    attributeSelector = ObjSelUtils.formatSelector("attype", attributeSelector);
                }
                try {
                    this.validateAndLockType(attributeSelector, false, feedback);
                }
                catch (WvcmException e) {
                    throw new WvcmException(NLS.bind((String)Messages.CCaseLib_ERROR_INVALID_ATTRIBUTE, (Object)attributeSelector), WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
                }
                formatOptions.append(FMT_ATTRIBUTE_PREFIX);
                String attributeName = ObjSelUtils.getObjSelName(attributeSelector);
                formatOptions.append(attributeName);
                formatOptions.append(FMT_ATTRIBUTE_SUFFIX);
                break;
            }
        }
        formatOptions.append(FMT_NEWLINE);
        cleartoolArgs.add(formatOptions.toString());
        cleartoolArgs.add(_INVOB);
        cleartoolArgs.add(vobtag);
        List<String> labelTypesInfo = this.ctProvider.executeGetValues(feedback, cleartoolArgs);
        allLabelTypes = this.getSortedLabelTypes(baseCcSubVobCompName, allbaseCcSubVobCompNames, labelTypesInfo);
        ArrayList<String> userLabelTypes = new ArrayList<String>(allLabelTypes.size());
        ArrayList<String> labelTypesWithAttribute = new ArrayList<String>();
        for (String labelType : allLabelTypes) {
            String[] labelAttribute = labelType.split(LITERAL_VERTICAL_BAR_PATTERN);
            if (labelAttribute.length >= 1) {
                String type = labelAttribute[0];
                String typeName = ObjSelUtils.getObjSelName(type);
                if (this.isPredefinedLabelType(typeName)) continue;
                userLabelTypes.add(type);
                if (labelAttribute.length != 2) continue;
                labelTypesWithAttribute.add(labelType);
                continue;
            }
            if (attribute == null) continue;
            StringBuffer exceptionMessage = new StringBuffer(String.format("Label Type output contains no tokens separated by '|'.\nExpected at least 1 token in the output.\nParsed line:\n%s\n", "Vob:\n%s\n", labelType, vobtag));
            throw new IllegalStateException(exceptionMessage.toString());
        }
        if (attribute != null) {
            if (this.allObjectsWithAttribute.containsKey(attribute)) {
                List<String> existingBaselinesWithAttribute = this.allObjectsWithAttribute.get(attribute);
                existingBaselinesWithAttribute.addAll(labelTypesWithAttribute);
                this.allObjectsWithAttribute.put(attribute, existingBaselinesWithAttribute);
            } else {
                this.allObjectsWithAttribute.put(attribute, labelTypesWithAttribute);
            }
        }
        return userLabelTypes;
    }

    public List<String> getSortedLabelTypes(String baseCcSubVobCompName, List<String> allbaseCcSubVobCompNames, List<String> allLabelTypes) throws WvcmException {
        ArrayList<LabelAttribute> allLabeledAttributes = new ArrayList<LabelAttribute>(allLabelTypes.size());
        for (String labelAttribute : allLabelTypes) {
            LabelAttribute labelAttribute2 = LabelAttribute.validateLabelAttributeInfo(baseCcSubVobCompName, allbaseCcSubVobCompNames, labelAttribute);
            allLabeledAttributes.add(labelAttribute2);
        }
        Collections.sort(allLabeledAttributes, new LabelTypeComparator());
        ArrayList<String> sortedLabelTypes = new ArrayList<String>(allLabelTypes.size());
        for (LabelAttribute labelAttribute : allLabeledAttributes) {
            if (labelAttribute.getValue() <= -1) continue;
            sortedLabelTypes.add(labelAttribute.getLabelAttribute());
        }
        return sortedLabelTypes;
    }

    public List<String> findNewVersionsForImporter(String searchRoot, String oldLabelType, String newLabelType, SrvcFeedback feedback) throws WvcmException {
        ArrayList<String> findArgs = new ArrayList<String>();
        findArgs.add(FIND);
        findArgs.add(searchRoot);
        findArgs.add(_ALL);
        findArgs.add(_VERSION);
        String oldLabelName = ObjSelUtils.getObjSelName(oldLabelType);
        String newLabelName = ObjSelUtils.getObjSelName(newLabelType);
        String labelQuery = "{lbtype(" + newLabelName + ')' + AMPAMP + QUERY_NOT_LABEL_TYPE + oldLabelName + ')' + '}';
        findArgs.add(labelQuery);
        findArgs.add(_PRINT);
        return this.ctProvider.executeGetValues(feedback, findArgs);
    }

    public Map<String, Boolean> getLockStatus(List<String> objSels, SrvcFeedback feedback) throws WvcmException {
        HashMap<String, Boolean> lockStatusMap = new HashMap<String, Boolean>(objSels.size());
        List<String> cleartoolArgs = Arrays.asList(DESCRIBE, _FMT, "%[locked]p\\n");
        List<String> lockStatuses = this.executeBatched(feedback, cleartoolArgs, objSels);
        Iterator<String> statusIterator = lockStatuses.iterator();
        for (String objSel : objSels) {
            Boolean status = Boolean.FALSE;
            String lockStatus = statusIterator.next();
            if (lockStatus.equals(LOCKED)) {
                status = Boolean.TRUE;
            }
            lockStatusMap.put(objSel, status);
        }
        return lockStatusMap;
    }

    private String getProjectModel(String projectSel, SrvcFeedback feedback) throws WvcmException {
        return this.ctProvider.execute(feedback, LSPROJECT, _FMT, FMT_MODEL_P, projectSel);
    }

    public boolean isSingleStreamProject(String projectSel, SrvcFeedback feedback) throws WvcmException {
        boolean isSingleStream = false;
        String model = this.getProjectModel(projectSel, feedback);
        if (model.equals("SIMPLE")) {
            isSingleStream = true;
        }
        return isSingleStream;
    }

    public boolean rebaseInProgress(String streamSel, SrvcFeedback feedback) throws WvcmException {
        String dumpResult = this.ctProvider.execute(feedback, DUMP, streamSel);
        return dumpResult.contains(UCM_REBASE_PVAR);
    }

    public String getObjKind(String objSel, SrvcFeedback feedback) throws WvcmException {
        String mtype = this.mtypeByObject.get(null, objSel);
        if (mtype == null) {
            CommandResult r = this.ctProvider.executeGetResult(feedback, DESCRIBE, _FMT, FMT_MTYPE, objSel);
            mtype = r.getStdOut();
            if (mtype != null && mtype.length() != 0) {
                this.mtypeByObject.put(null, objSel, mtype);
            } else {
                r.assertSuccess(new CommandResult.ResultBehaviorFlags(CommandResult.ResultBehaviorFlags.Kind.IGNORE_NO_VIEW_INFO));
            }
        }
        return mtype;
    }

    public boolean containingVobHasBaseCcSubVobComponentAttype(String parentPathname, SrvcFeedback feedback) throws WvcmException {
        String attypeSpec = String.format("attype:%s@%s", BASE_CC_SUBVOB_COMPONENT_ATTYPE, parentPathname);
        CommandResult cmdResult = this.ctProvider.executeGetResult(feedback, DESCRIBE, _SHORT, attypeSpec);
        return cmdResult.getStat() == 0;
    }

    public String getClearCaseVersion(SrvcFeedback feedback) throws WvcmException {
        String lines = this.ctProvider.execute(feedback, _VERSION);
        if (lines != null) {
            Matcher matcher = CONSECUTIVE_LINE_BREAKS.matcher(lines);
            lines = matcher.replaceAll("\n");
        }
        return lines;
    }

    public String getClrtxtPath(SrvcFeedback feedback, String controllableResourcePath) throws WvcmException {
        CommandResult res = this.ctProvider.executeCommand(feedback, null, Arrays.asList(CommandProvider.MVFSSTORAGE, controllableResourcePath), Collections.EMPTY_LIST);
        CommandResult.ResultBehaviorFlags ignoreFlags = new CommandResult.ResultBehaviorFlags(CommandResult.ResultBehaviorFlags.Kind.IGNORE_NO_VIEW_INFO);
        res.assertSuccess(ignoreFlags);
        return res.getStdOut().trim();
    }

    public String lookupVersionActivityName(String versionName, SrvcFeedback feedback) throws WvcmException {
        String result = this.ctProvider.execute(feedback, DESCRIBE, _FMT, FMT_ACTIVITY_P, versionName);
        return result;
    }

    public Map<String, String> getActivitiesUniversalSelectors(Collection<String> activityNames, SrvcFeedback feedback) throws WvcmException {
        int count = activityNames.size();
        HashMap<String, String> results = new HashMap<String, String>(count);
        String format = "%Xn|%[universal_selector]p\\n";
        List<String> info = this.executeBatched(feedback, Arrays.asList(LSACTIVITY, _FMT, format), new ArrayList<String>(activityNames));
        for (String line : info) {
            String[] nameAndUSel = line.split(LITERAL_VERTICAL_BAR_PATTERN);
            String activitySelector = nameAndUSel[0];
            String name = ObjSelUtils.formatSelectorNoKind(activitySelector);
            results.put(name, nameAndUSel[1]);
        }
        return results;
    }

    public LinkedHashMap<String, List<String>> getAllCompositeBaselines(String streamSelector, String compositeComponentSelector, SrvcFeedback feedback) throws WvcmException {
        List<String> selectors = Arrays.asList(_STREAM, streamSelector, _COMPONENT, compositeComponentSelector);
        return this.getAllCompositeBaselines(selectors, feedback);
    }

    public LinkedHashMap<String, List<String>> getAllCompositeBaselines(List<String> selectors, SrvcFeedback feedback) throws WvcmException {
        String formatDirective = CommonUtils.myToString(SPACE, Arrays.asList(FMT_UNIVERSAL_SELECTOR_P, FMT_DEPENDS_ON_CXP, FMT_NEWLINE), false);
        ArrayList<String> cleartoolArgs = new ArrayList<String>(Arrays.asList(LSBL, _FMT, formatDirective));
        cleartoolArgs.addAll(selectors);
        List<String> lines = this.ctProvider.executeGetValues(feedback, cleartoolArgs);
        LinkedHashMap<String, List<String>> results = new LinkedHashMap<String, List<String>>();
        for (String line : lines) {
            String[] parts = line.replace(CommonUtils.COMMA, EMPTY_STRING).split(SPACE);
            if (parts.length <= 2) continue;
            ArrayList<String> partsList = new ArrayList<String>(Arrays.asList(parts));
            String key = (String)partsList.remove(0);
            List<String> memberBaselineUSels = this.executeBatched(feedback, Arrays.asList(LSBL, _FMT, "%[universal_selector]p\\n"), partsList);
            results.put(key, memberBaselineUSels);
        }
        return results;
    }

    public String getCreationStreamSel(String baselineSelector, SrvcFeedback feedback) throws WvcmException {
        String streamName = this.ctProvider.execute(feedback, DESCRIBE, _FMT, FMT_BL_STREAM, baselineSelector);
        return ObjSelUtils.formatSelector(FLEVEL7_MTYPE, streamName, ObjSelUtils.getObjSelVobSel(baselineSelector));
    }

    public List<String> getVersionTreeAllLines(String pname, SrvcFeedback feedback) throws WvcmException {
        Path path = new Path(pname);
        IPath parentPath = path.removeLastSegments(1);
        return this.ctProvider.executeGetValues(feedback, parentPath.toOSString(), new CommandResult.ResultBehaviorFlags(new CommandResult.ResultBehaviorFlags.Kind[0]), LSVTREE, _ALL, path.lastSegment());
    }

    public VersionHistoryEntry getVersionHistoryEntryForAVersion(String pname, boolean findActivities, SrvcFeedback feedback) throws WvcmException {
        List<VersionHistoryEntry> results = this.getVersionHistoryEntries(pname, findActivities, new String[]{DESCRIBE}, feedback);
        Assert.isTrue((results != null && results.size() == 1 ? 1 : 0) != 0, (String)"Version History Entry for a describe command has to be 1");
        return results.get(0);
    }

    public List<VersionHistoryEntry> getVersionHistoryEntries(String pname, boolean findActivities, SrvcFeedback feedback) throws WvcmException {
        return this.getVersionHistoryEntries(pname, findActivities, new String[]{LSHISTORY, _NCO}, feedback);
    }

    private List<VersionHistoryEntry> getVersionHistoryEntries(String pname, boolean findActivities, String[] ctSubCommands, SrvcFeedback feedback) throws WvcmException {
        Path path = new Path(pname);
        IPath parentPath = path.removeLastSegments(1);
        String changeSetCommentFormat = CTInitArgUtils.getChangeSetCommentFormatOption(this.ctInitArgs);
        String firstPart = findActivities ? VERSION_HISTORY_FMT_W_ACT_FIRST_PART : VERSION_HISTORY_FMT_FIRST_PART;
        String format = changeSetCommentFormat == null ? String.valueOf(firstPart) + FMT_VERSION_NAME + SPACE + CommonUtils.COLON + SPACE + FMT_NC + VERSION_HISTORY_FMT_LAST_PART : String.valueOf(firstPart) + changeSetCommentFormat + VERSION_HISTORY_FMT_LAST_PART;
        ArrayList<String> ctArgs = new ArrayList<String>(Arrays.asList(ctSubCommands));
        ctArgs.add(_FMT);
        ctArgs.add(format);
        ctArgs.add(path.lastSegment());
        List<String> lines = this.ctProvider.executeGetValues(feedback, parentPath.toOSString(), new CommandResult.ResultBehaviorFlags(feedback, CommandResult.ResultBehaviorFlags.Kind.WARN_VOB_NOT_FOUND, CommandResult.ResultBehaviorFlags.Kind.WARN_NTTYPE_SID_NOT_SUPPORTED), ctArgs.toArray(new String[0]));
        List<VersionHistoryEntry> results = this.getVersionHistoryEntries(lines, findActivities);
        return results;
    }

    public List<VersionHistoryEntry> getVersionHistoryEntries(List<String> lines, boolean activities) throws WvcmException {
        int count = lines.size();
        ArrayList<VersionHistoryEntry> results = new ArrayList<VersionHistoryEntry>(count);
        int maxParts = activities ? 9 : 8;
        int i = 0;
        while (i < count) {
            String line = lines.get(i);
            String[] parts = line.split(LITERAL_VERTICAL_BAR_PATTERN, maxParts + 1);
            if (parts.length < maxParts) {
                throw new IllegalStateException(NLS.bind((String)"Could not parse into {0} or more parts, only {1}.  line: {2}", Arrays.asList(maxParts, parts.length, line)));
            }
            String[] comment = new String[1];
            i = this.getComment(i, parts[maxParts], lines, comment);
            String mtype = parts[0];
            if (mtype.equals("branch")) {
                if (parts[maxParts - 2].equals(OBSOLETE)) {
                    VersionHistoryEntry e = new VersionHistoryEntry(mtype, parts[1], parts[2], parts[3], parts[4], parts[5], activities ? parts[6] : EMPTY_STRING, null, comment[0]);
                    results.add(e);
                }
            } else if (mtype.endsWith("version")) {
                if ("version".equals(mtype)) {
                    mtype = "version";
                } else if ("directory version".equals(mtype)) {
                    mtype = "directory version";
                } else if ("derived object version".equals(mtype)) {
                    mtype = "derived object version";
                }
                List<String> merges = CCaseLib.parseMerges(parts[maxParts - 1]);
                int j = 1;
                while (j < maxParts - 1) {
                    parts[j] = String.valueOf(parts[j].toCharArray());
                    ++j;
                }
                VersionHistoryEntry e = new VersionHistoryEntry(mtype, parts[1], parts[2], parts[3], parts[4], parts[5], activities ? parts[6] : EMPTY_STRING, merges, comment[0]);
                results.add(e);
            }
            ++i;
        }
        return results;
    }

    public List<String> getHistorySince(String elemUSel, String since, SrvcFeedback feedback) throws WvcmException {
        String format = "%m|%o\n";
        return this.ctProvider.executeGetValues(feedback, null, new CommandResult.ResultBehaviorFlags(feedback, CommandResult.ResultBehaviorFlags.Kind.WARN_VOB_NOT_FOUND, CommandResult.ResultBehaviorFlags.Kind.WARN_NTTYPE_SID_NOT_SUPPORTED), LSHISTORY, _NCO, _FMT, format, _SINCE, since, elemUSel);
    }

    public static List<String> parseMerges(String mergesString) {
        ArrayList<String> results = new ArrayList<String>();
        Matcher m = MERGE_PATTERN.matcher(mergesString);
        while (m.find()) {
            String arrowInfo = m.group(1);
            if (!arrowInfo.contains(MERGE_INTO_ARROW)) continue;
            Path svPath = new Path(m.group(2));
            results.add(svPath.toPortableString());
        }
        return results;
    }

    public Map<String, String> getBranchTypesByLockState(String vobTag, List<String> brtypeNames, boolean isObsolete, SrvcFeedback feedback) throws WvcmException {
        ArrayList<String> brtypeObjSels = new ArrayList<String>(brtypeNames.size());
        for (String brtypeName : brtypeNames) {
            brtypeObjSels.add(ObjSelUtils.formatSelector("brtype", brtypeName, vobTag));
        }
        return this.getObjectsByLockState(brtypeObjSels, isObsolete, feedback);
    }

    private Map<String, String> getStreamsByLockState(List<String> streamSelectors, boolean isObsolete, SrvcFeedback feedback) throws WvcmException {
        return this.getObjectsByLockState(streamSelectors, isObsolete, feedback);
    }

    private Map<String, String> getObjectsByLockState(List<String> objSels, boolean isObsolete, SrvcFeedback feedback) throws WvcmException {
        HashMap<String, String> objTypes = new HashMap<String, String>();
        ArrayList<String> cleartoolArgs = new ArrayList<String>(Arrays.asList(DESCRIBE, _FMT, BRANCH_TYPE_FMT));
        List<String> lines = this.executeBatched(feedback, null, new CommandResult.ResultBehaviorFlags(feedback, CommandResult.ResultBehaviorFlags.Kind.WARN_VOB_NOT_FOUND, CommandResult.ResultBehaviorFlags.Kind.TROUBLE_FINDING_GLOBAL_DEFINITION), cleartoolArgs, objSels);
        int count = lines.size();
        int i = 0;
        while (i < count) {
            String line = lines.get(i);
            String[] parts = line.split(LITERAL_VERTICAL_BAR_PATTERN);
            if (isObsolete && parts[2].equals(OBSOLETE) || !isObsolete && !parts[2].equals(OBSOLETE)) {
                objTypes.put(parts[0], parts[1]);
            }
            ++i;
        }
        return objTypes;
    }

    public Map<String, String> getStreamSelectors(String vobTag, List<String> brtypeNames, SrvcFeedback feedback) throws WvcmException {
        ArrayList<String> brtypeObjSels = new ArrayList<String>(brtypeNames.size());
        for (String brtypeName : brtypeNames) {
            brtypeObjSels.add(ObjSelUtils.formatSelector("brtype", brtypeName, vobTag));
        }
        ArrayList<String> cleartoolArgs = new ArrayList<String>(Arrays.asList(DESCRIBE));
        List<String> lines = this.executeBatched(feedback, null, new CommandResult.ResultBehaviorFlags(feedback, CommandResult.ResultBehaviorFlags.Kind.WARN_VOB_NOT_FOUND, CommandResult.ResultBehaviorFlags.Kind.TROUBLE_FINDING_GLOBAL_DEFINITION), cleartoolArgs, brtypeObjSels);
        HashMap<String, String> streamSelToBrTypeMap = new HashMap<String, String>();
        String brType = null;
        for (String line : lines) {
            Matcher brTypeM = brTypePtn.matcher(line);
            if (brTypeM.find()) {
                brType = brTypeM.group(1);
                continue;
            }
            Matcher streamM = streamPtn.matcher(line);
            if (!streamM.find()) continue;
            String streamSelector = streamM.group(1);
            streamSelToBrTypeMap.put(streamSelector, brType);
        }
        return streamSelToBrTypeMap;
    }

    private void printObjects(Set<String> objNames, String msgFmt, SrvcFeedback feedback) {
        StringBuffer sb = new StringBuffer();
        for (String objName : objNames) {
            sb.append(objName);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        feedback.notifyActive(NLS.bind((String)msgFmt, (Object)sb.toString()));
    }

    public Set<String> getObsoleteBranchTypes(String vobTag, Set<String> brtypeNames, SrvcFeedback feedback) throws WvcmException {
        Set<String> _branchTypeCache = this._branchTypeAllCache.keySet();
        if (!_branchTypeCache.containsAll(brtypeNames)) {
            Map<String, String> streamSelToBrTypeMap;
            ArrayList<String> subBrtypeNames = new ArrayList<String>();
            for (String brtypeName : brtypeNames) {
                if (this._branchTypeAllCache.containsKey(brtypeName)) continue;
                subBrtypeNames.add(brtypeName);
            }
            Map<String, String> obsoleteBranchTypes = this.getBranchTypesByLockState(vobTag, subBrtypeNames, true, feedback);
            for (String subBrtypeName : subBrtypeNames) {
                this._branchTypeAllCache.put(subBrtypeName, obsoleteBranchTypes.keySet().contains(subBrtypeName));
            }
            if (!obsoleteBranchTypes.isEmpty()) {
                this.printObjects(obsoleteBranchTypes.keySet(), Messages.CCaseLib_INFO_VERSIONS_EXIST_ON_OBSOLETE_BRANCH_TYPES, feedback);
            }
            if (!(streamSelToBrTypeMap = this.getStreamSelectors(vobTag, subBrtypeNames, feedback)).isEmpty()) {
                ArrayList<String> streamSelectors = new ArrayList<String>(streamSelToBrTypeMap.keySet());
                Map<String, String> obsoleteStreamInfo = this.getStreamsByLockState(streamSelectors, true, feedback);
                Set<String> obsoleteStreamNames = obsoleteStreamInfo.keySet();
                if (!obsoleteStreamNames.isEmpty()) {
                    this.printObjects(obsoleteStreamNames, Messages.CCaseLib_INFO_VERSIONS_EXIST_ON_OBSOLETE_STREAMS, feedback);
                }
                for (Map.Entry<String, String> entry : streamSelToBrTypeMap.entrySet()) {
                    String streamUSel = entry.getKey();
                    String streamName = ObjSelUtils.getObjSelName(streamUSel);
                    if (!obsoleteStreamNames.contains(streamName)) continue;
                    String brType = streamSelToBrTypeMap.get(streamUSel);
                    this._branchTypeAllCache.put(brType, true);
                }
            }
        }
        HashSet<String> _obsoleteBranchTypeCache = new HashSet<String>();
        for (String brtypeName : brtypeNames) {
            Boolean isObsolete = this._branchTypeAllCache.get(brtypeName);
            if (!isObsolete.booleanValue()) continue;
            _obsoleteBranchTypeCache.add(brtypeName);
        }
        return _obsoleteBranchTypeCache;
    }

    public void clearObsoleteBranchTypes() throws WvcmException {
        this._branchTypeAllCache.clear();
    }

    private class Cache {
        private final Map<String, String> cache = new HashMap<String, String>();

        Cache() {
        }

        private List<String> get(String keyPrefix, List<String> keys) {
            ArrayList<String> result = new ArrayList<String>(keys.size());
            if (CCaseLib.this.cachingEnabled) {
                for (String key : keys) {
                    String realKey;
                    String string = realKey = keyPrefix == null ? key : String.valueOf(keyPrefix) + key;
                    if (!this.cache.containsKey(realKey)) {
                        result.clear();
                        break;
                    }
                    result.add(this.cache.get(realKey));
                }
            }
            return result;
        }

        private String get(String keyPrefix, String key) {
            if (!CCaseLib.this.cachingEnabled) {
                return null;
            }
            if (keyPrefix == null) {
                return this.cache.get(key);
            }
            return this.cache.get(String.valueOf(keyPrefix) + key);
        }

        private void put(String keyPrefix, List<String> keys, List<String> values) {
            if (CCaseLib.this.cachingEnabled) {
                Iterator<String> it = keys.iterator();
                for (String value : values) {
                    if (!it.hasNext()) {
                        throw new IllegalArgumentException("Number of keys does not match number of values");
                    }
                    String key = it.next();
                    if (keyPrefix == null) {
                        this.cache.put(key, value);
                        continue;
                    }
                    this.cache.put(String.valueOf(keyPrefix) + key, value);
                }
            }
        }

        private void put(String keyPrefix, String key, String value) {
            if (value == null) {
                throw new IllegalArgumentException("Attempt to cache null value");
            }
            if (CCaseLib.this.cachingEnabled) {
                if (keyPrefix == null) {
                    this.cache.put(key, value);
                } else {
                    this.cache.put(String.valueOf(keyPrefix) + key, value);
                }
            }
        }

        private boolean containsKey(String keyPrefix, String key) {
            boolean contains = false;
            if (CCaseLib.this.cachingEnabled) {
                String searchKey = key;
                if (keyPrefix != null) {
                    searchKey = String.valueOf(keyPrefix) + key;
                }
                if (this.cache.containsKey(searchKey)) {
                    contains = true;
                }
            }
            return contains;
        }
    }

    public static class InvisiblePathname {
        private final String basePathSegment;
        private final String[] leafNames;
        private final String[] tempLeafNames;
        private final String[] versionExts;
        private int visibleIndex = 0;

        public InvisiblePathname(String pathname, String delimiter) {
            pathname = CommonUtils.canonicalizePathname(pathname);
            String basePathSegment = pathname.substring(0, pathname.indexOf(CCaseLib.AT_AT));
            int separatorPos = basePathSegment.lastIndexOf(CommonUtils.FWDSLASH);
            this.basePathSegment = basePathSegment.substring(0, separatorPos);
            pathname = pathname.substring(separatorPos + 1);
            pathname = pathname.replace(CCaseLib.AT_AT, new String());
            ArrayList<String> leafNamesList = new ArrayList<String>();
            ArrayList<String> versionExtsList = new ArrayList<String>();
            String[] segments = pathname.split(CommonUtils.FWDSLASH);
            String versionExt = null;
            int i = segments.length - 1;
            while (i >= 0) {
                String segment = segments[i];
                String newPath = String.valueOf(CommonUtils.FWDSLASH) + segment;
                String string = versionExt = versionExt != null ? String.valueOf(newPath) + versionExt : newPath;
                if (delimiter.equals(segment)) {
                    versionExtsList.add(0, versionExt.toString());
                    leafNamesList.add(0, segments[--i]);
                    versionExt = null;
                }
                --i;
            }
            this.leafNames = leafNamesList.toArray(new String[0]);
            this.versionExts = versionExtsList.toArray(new String[0]);
            this.tempLeafNames = new String[leafNamesList.size()];
            assert (this.leafNames.length == this.versionExts.length);
        }

        public void makeChildVisible() {
            ++this.visibleIndex;
        }

        public boolean hasDescendant() {
            return this.visibleIndex < this.leafNames.length;
        }

        public boolean isLast() {
            return this.visibleIndex == this.leafNames.length - 1;
        }

        public String visiblePathname() {
            return this.visiblePathname(this.visibleIndex);
        }

        public String parentPathname() {
            return this.visibleIndex > 0 ? this.visiblePathname(this.visibleIndex - 1) : new String();
        }

        private String visiblePathname(int upUntil) {
            String path = this.basePathSegment;
            int i = 0;
            while (i <= upUntil) {
                path = String.valueOf(path) + CommonUtils.FWDSLASH + this.leafName(i);
                ++i;
            }
            return path.toString();
        }

        public String originalPathname() {
            StringBuilder buf = new StringBuilder(this.basePathSegment);
            int i = 0;
            while (i <= this.visibleIndex) {
                buf.append(CommonUtils.FWDSLASH).append(this.leafNames[i]).append(CCaseLib.AT_AT);
                buf.append(this.versionExts[i]);
                ++i;
            }
            return buf.toString();
        }

        public String leafName() {
            return this.leafName(this.visibleIndex);
        }

        private String leafName(int i) {
            return this.tempLeafNames[i] != null ? this.tempLeafNames[i] : this.leafNames[i];
        }

        public void assignUniqueLeafName() {
            this.tempLeafNames[this.visibleIndex] = CommonUtils.uniquifier(false);
        }
    }

    private static class LabelAttribute {
        private final String labelAttribute;
        private final int value;

        private LabelAttribute(String labelAndAttribute, int value) {
            this.labelAttribute = labelAndAttribute;
            this.value = value;
        }

        public static LabelAttribute validateLabelAttributeInfo(String baseCcSubVobCompName, List<String> allBaseCcSubVobCompNames, String labelAndAttribute) throws WvcmException {
            String[] tokens = labelAndAttribute.split(CCaseLib.LITERAL_VERTICAL_BAR_PATTERN);
            String labelTypeName = null;
            int attributeValue = -1;
            if (tokens.length == 2 && tokens[1].length() > 0) {
                labelTypeName = tokens[0];
                String token = LabelAttribute.getDecodedAttrValue(tokens[1]);
                if (baseCcSubVobCompName != null) {
                    String[] values = token.split(SEMICOLON);
                    boolean foundAtSign = false;
                    String[] stringArray = values;
                    int n = values.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String v = stringArray[n2];
                        String[] split = v.split(ATSIGN);
                        if (split.length > 2) {
                            throw new WvcmException(NLS.bind((String)Messages.CCaseLib_ERROR_INVALID_ATTRIBUTE_VALUE, (Object)v, (Object)labelTypeName), WvcmException.ReasonCode.FORBIDDEN);
                        }
                        if (split.length > 1) {
                            foundAtSign = true;
                            String name = split[1];
                            if (baseCcSubVobCompName.equals(name) && attributeValue < 0) {
                                String valueString = split[0];
                                attributeValue = LabelAttribute.lookupIntValue(valueString, labelTypeName);
                            } else if (!allBaseCcSubVobCompNames.contains(name)) {
                                throw new WvcmException(NLS.bind((String)Messages.CCaseLib_ERROR_UNRECOGNIZED_SUBVOB_COMP_NAME, (Object)name, (Object)labelTypeName), WvcmException.ReasonCode.FORBIDDEN);
                            }
                        }
                        ++n2;
                    }
                    if (!foundAtSign) {
                        attributeValue = LabelAttribute.lookupIntValue(token, labelTypeName);
                    }
                } else {
                    attributeValue = LabelAttribute.lookupIntValue(token, labelTypeName);
                }
            }
            return new LabelAttribute(labelAndAttribute, attributeValue);
        }

        private int getValue() {
            return this.value;
        }

        private String getLabelAttribute() {
            return this.labelAttribute;
        }

        private static String getDecodedAttrValue(String token) {
            int valLength = token.length();
            boolean leadingQuote = token.charAt(0) == '\"';
            boolean trailingQuote = token.charAt(valLength - 1) == '\"';
            String value = token.substring(leadingQuote ? 1 : 0, trailingQuote ? valLength - 1 : valLength);
            try {
                String result = URLDecoder.decode(value, CCaseLib.UTF_8);
                return result;
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("Unexpected UnsupportedEncodingException decoding characters with UTF-8");
            }
        }

        private static int lookupIntValue(String token, String labelTypeName) throws WvcmException {
            int attributeValue = -1;
            try {
                attributeValue = Integer.parseInt(token);
                if (attributeValue < 0) {
                    throw new WvcmException(NLS.bind((String)Messages.CCaseLib_ERROR_INVALID_ATTRIBUTE_VALUE, (Object)token, (Object)labelTypeName), WvcmException.ReasonCode.FORBIDDEN);
                }
            }
            catch (NumberFormatException nfe) {
                throw new WvcmException(NLS.bind((String)Messages.CCaseLib_ERROR_INVALID_ATTRIBUTE_VALUE, (Object)token, (Object)labelTypeName), WvcmException.ReasonCode.FORBIDDEN);
            }
            return attributeValue;
        }
    }

    private class LabelTypeComparator
    implements Comparator<LabelAttribute> {
        private LabelTypeComparator() {
        }

        @Override
        public int compare(LabelAttribute thisObject, LabelAttribute otherObject) {
            int otherValue;
            int thisValue = thisObject.getValue();
            if (thisValue > (otherValue = otherObject.getValue())) {
                return 1;
            }
            if (thisValue < otherValue) {
                return -1;
            }
            return 0;
        }
    }

    class TempVisiblePath {
        private final String viewTag;
        private final String parentPath;
        private final String leafName;
        private final boolean restoreOnlyLeaf;

        TempVisiblePath(String viewTag, String parentPath, String leafName, boolean restoreOnlyLeaf) {
            this.viewTag = viewTag;
            this.parentPath = parentPath;
            this.leafName = leafName;
            this.restoreOnlyLeaf = restoreOnlyLeaf;
        }

        public void restore(String delimiter, SrvcFeedback feedback) throws WvcmException {
            if (this.restoreOnlyLeaf) {
                CCaseLib.this.removeName(this.parentPath, this.leafName, feedback);
            } else {
                this.restoreAll(delimiter, feedback);
            }
        }

        private void restoreAll(String delimiter, SrvcFeedback feedback) throws WvcmException {
            CCaseLib.this.uncheckout(this.parentPath, feedback);
            String xName = CCaseLib.this.getExtendedName(this.viewTag, this.parentPath, feedback);
            String branchName = null;
            if (xName.endsWith("\\0")) {
                branchName = xName.substring(0, xName.lastIndexOf("\\0"));
            } else if (xName.endsWith("/0")) {
                branchName = xName.substring(0, xName.lastIndexOf("/0"));
            }
            if (branchName != null && !branchName.matches(".*@@[\\\\/]" + delimiter + "$")) {
                CCaseLib.this.removeBranch(branchName, feedback);
            }
        }
    }

    public static class VersionHistoryEntry {
        public final String mtype;
        public final String universalSelector;
        public final String creationDate;
        public final String groupUser;
        public final String versionName;
        public final String predVersionName;
        public final String activityName;
        public final List<String> merges;
        public final String comment;

        public VersionHistoryEntry(String mtype, String universalSelector, String versionName, String predVersionName, String creationDate, String groupUser, String activityName, List<String> merges, String comment) {
            this.mtype = mtype;
            this.universalSelector = universalSelector;
            this.creationDate = creationDate;
            this.groupUser = groupUser;
            this.versionName = versionName;
            this.predVersionName = predVersionName;
            this.activityName = activityName;
            this.merges = merges;
            this.comment = comment;
        }
    }
}

