/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iant.types;

import com.ibm.iant.types.INameEntry;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Reference;

public class IPatternSet
extends DataType
implements Cloneable {
    private Vector includeList = new Vector();
    private Vector excludeList = new Vector();

    public void setRefid(Reference r) throws BuildException {
        if (!this.includeList.isEmpty() || !this.excludeList.isEmpty()) {
            throw this.tooManyAttributes();
        }
        this.log("[DataType] Refid --> " + r.toString(), 2);
        super.setRefid(r);
    }

    public INameEntry createInclude() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        return this.addPatternToList(this.includeList);
    }

    public INameEntry createExclude() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        return this.addPatternToList(this.excludeList);
    }

    private INameEntry addPatternToList(Vector list) {
        INameEntry result = this.createINameEntry();
        list.addElement(result);
        return result;
    }

    protected INameEntry createINameEntry() {
        return new INameEntry();
    }

    public String[] getIncludePatterns(Project p) {
        if (this.isReference()) {
            return this.getRef(p).getIncludePatterns(p);
        }
        return this.makeArray(this.includeList, p);
    }

    public String[] getExcludePatterns(Project p) {
        if (this.isReference()) {
            return this.getRef(p).getExcludePatterns(p);
        }
        return this.makeArray(this.excludeList, p);
    }

    public boolean hasPatterns(Project p) {
        if (this.isReference()) {
            return this.getRef(p).hasPatterns(p);
        }
        return this.includeList.size() > 0 || this.excludeList.size() > 0;
    }

    private IPatternSet getRef(Project p) {
        return (IPatternSet)this.getCheckedRef(p);
    }

    private String[] makeArray(Vector list, Project p) {
        if (list.size() == 0) {
            return null;
        }
        Vector<String> tmpNames = new Vector<String>();
        Enumeration e = list.elements();
        while (e.hasMoreElements()) {
            INameEntry ne = (INameEntry)((Object)e.nextElement());
            String pattern = ne.evalName(p);
            if (pattern == null || pattern.length() <= 0) continue;
            tmpNames.addElement(pattern);
        }
        Object[] result = new String[tmpNames.size()];
        tmpNames.copyInto(result);
        return result;
    }

    public String toString() {
        return "IPatternSet{ includes: " + this.includeList + " excludes: " + this.excludeList + " }";
    }

    public Object clone() {
        try {
            IPatternSet ps = (IPatternSet)super.clone();
            ps.includeList = (Vector)this.includeList.clone();
            ps.excludeList = (Vector)this.excludeList.clone();
            return ps;
        }
        catch (CloneNotSupportedException e) {
            this.log(e.toString(), 0);
            throw new BuildException((Throwable)e);
        }
    }
}

