/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.iant.types;

import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;

public class INameEntry
extends DataType {
    public static final String WILDCARD = "*";
    private String name = "*";
    private String ifCond;
    private String unlessCond;

    public void setName(String name) {
        this.name = name;
        INameEntry.logNameParam(this.getProject(), "[INameEntry] name --> " + name);
    }

    public void setIf(String cond) {
        this.ifCond = cond;
        INameEntry.logNameParam(this.getProject(), "[INameEntry] if --> " + cond);
    }

    public void setUnless(String cond) {
        this.unlessCond = cond;
        INameEntry.logNameParam(this.getProject(), "[INameEntry] unless  --> " + cond);
    }

    public String getName() {
        return this.name;
    }

    public String evalName(Project p) {
        return this.valid(p) ? this.getPatternString() : null;
    }

    protected String getPatternString() {
        return this.getName();
    }

    private boolean valid(Project p) {
        if (this.ifCond != null && p.getProperty(this.ifCond) == null) {
            return false;
        }
        return this.unlessCond == null || p.getProperty(this.unlessCond) == null;
    }

    protected String conditionToString() {
        StringBuffer buf = new StringBuffer();
        if (this.ifCond != null || this.unlessCond != null) {
            buf.append(":");
            String connector = "";
            if (this.ifCond != null) {
                buf.append("if->");
                buf.append(this.ifCond);
                connector = ";";
            }
            if (this.unlessCond != null) {
                buf.append(connector);
                buf.append("unless->");
                buf.append(this.unlessCond);
            }
        }
        return buf.toString();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getPatternString());
        buf.append(this.conditionToString());
        return buf.toString();
    }

    public static void logNameParam(Project project, String msg) {
        if (project != null) {
            project.log(msg, 4);
        }
    }
}

